/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.lib.graphics;

import com.cisco.nm.esper.lib.graphics.ClipShape;
import com.cisco.nm.esper.lib.graphics.Line;
import java.awt.Rectangle;

public class RectClip
extends Rectangle
implements ClipShape {
    public RectClip() {
        this(0, 0, 0, 0);
    }

    public RectClip(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public int getX1() {
        return this.x;
    }

    public int getX2() {
        return this.x + this.width;
    }

    public int getY1() {
        return this.y;
    }

    public int getY2() {
        return this.y + this.height;
    }

    public boolean contains(int n, int n2) {
        return this.getX1() <= n && n <= this.getX2() && this.getY1() <= n2 && n2 <= this.getY2();
    }

    public Line clip(Line line) {
        if (line == null) {
            return null;
        }
        if (!this.contains(line.getX1(), line.getY1())) {
            return line;
        }
        if (this.contains(line.getX2(), line.getY2())) {
            return null;
        }
        if (line.isHorizontal()) {
            if (line.getX2() < this.getX1()) {
                line.setFirstPoint(this.getX1(), line.getY1());
            } else if (line.getX2() > this.getX2()) {
                line.setFirstPoint(this.getX2(), line.getY1());
            }
        } else if (line.isVertical()) {
            if (line.getY2() < this.getY1()) {
                line.setFirstPoint(line.getX1(), this.getY1());
            } else if (line.getY2() > this.getY2()) {
                line.setFirstPoint(line.getX1(), this.getY2());
            }
        } else {
            double d = line.getX1();
            double d2 = line.getX2();
            double d3 = line.getY1();
            double d4 = line.getY2();
            if (d2 < (double)this.getX1()) {
                d4 = d3 + (d4 - d3) / (d2 - d) * ((double)this.getX1() - d);
                d2 = this.getX1();
            } else if (d2 > (double)this.getX2()) {
                d4 = d3 + (d4 - d3) / (d2 - d) * ((double)this.getX2() - d);
                d2 = this.getX2();
            }
            if (d4 < (double)this.getY1()) {
                d2 = d + (d2 - d) / (d4 - d3) * ((double)this.getY1() - d3);
                d4 = this.getY1();
            } else if (d4 > (double)this.getY2()) {
                d2 = d + (d2 - d) / (d4 - d3) * ((double)this.getY2() - d3);
                d4 = this.getY2();
            }
            line.setFirstPoint((int)Math.round(d2), (int)Math.round(d4));
        }
        return line;
    }
}

