/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.lib.graphics;

import com.cisco.nm.esper.lib.ObjectPool;
import com.cisco.nm.lib.Debug;
import java.awt.Rectangle;

public class RectPool
implements ObjectPool {
    public static final RectPool INSTANCE = new RectPool();
    public static final int DEFAULT_CAPACITY = 8;
    private Rectangle[] pool;
    private int size;

    public RectPool() {
        this(8);
    }

    public RectPool(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Unable to allocate a pool of capacity ".concat(String.valueOf(String.valueOf(n))));
        }
        this.pool = new Rectangle[n];
        this.size = 0;
    }

    public Object checkOut() {
        return this.checkRectOut();
    }

    public void checkIn(Object object) {
        this.checkRectIn((Rectangle)object);
    }

    public Rectangle checkRectOut() {
        Rectangle rectangle;
        if (this.size > 0) {
            --this.size;
            rectangle = this.pool[this.size];
            this.pool[this.size] = null;
        } else {
            rectangle = this.createRect();
        }
        return rectangle;
    }

    public void checkRectIn(Rectangle rectangle) {
        if (this.size >= this.pool.length) {
            Rectangle[] rectangleArray = new Rectangle[this.size + 5];
            System.arraycopy(this.pool, 0, rectangleArray, 0, this.size);
            this.pool = rectangleArray;
        }
        this.pool[this.size++] = rectangle;
    }

    public Rectangle createRect() {
        Debug.println("Creating rectangle");
        return new Rectangle();
    }

    static {
        DEFAULT_CAPACITY = 8;
    }
}

