/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model;

import com.cisco.nm.EsperStrings;
import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.BaseObjectPainter;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.GraphMember;
import com.cisco.nm.esper.model.GraphPoint;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.event.ObjectChangeManager;
import com.cisco.nm.esper.model.palette.BendPalette;
import com.cisco.nm.esper.model.palette.Palette;
import com.cisco.nm.esper.shape.FixedPoint2D;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;

public class Bend
extends GraphPoint {
    private Edge owner;
    private BendPalette palette;
    private static Map resources;

    public Bend() {
        this(0.0, 0.0);
    }

    public Bend(double d, double d2) {
        this.placeAt(d, d2);
        this.resize(5.0, 5.0);
    }

    public static Object getClassResource(String string) {
        if (resources == null) {
            return null;
        }
        return resources.get(string);
    }

    public static Object putClassResource(String string, Object object) {
        if (object == null) {
            if (resources == null) {
                return null;
            }
            return resources.remove(string);
        }
        if (resources == null) {
            resources = new HashMap(17, 0.85f);
        }
        return resources.put(string, object);
    }

    public static boolean hasClassResource(String string) {
        return resources != null && resources.containsKey(string);
    }

    public Object getResource(String string) {
        String string2 = String.valueOf(String.valueOf(this.hashCode())).concat(String.valueOf(String.valueOf(string)));
        if (Bend.hasClassResource(string2)) {
            return Bend.getClassResource(string2);
        }
        return Bend.getClassResource(string);
    }

    public Object putResource(String string, Object object) {
        return Bend.putClassResource(String.valueOf(String.valueOf(this.hashCode())).concat(String.valueOf(String.valueOf(string))), object);
    }

    public boolean hasResource(String string) {
        return Bend.hasClassResource(string) || Bend.hasClassResource(String.valueOf(String.valueOf(this.hashCode())).concat(String.valueOf(String.valueOf(string))));
    }

    public Edge getOwner() {
        return this.owner;
    }

    public BaseObject getContainer() {
        return this.getOwner();
    }

    protected void setOwner(Edge edge) {
        if (this.owner != edge) {
            this.firePropertyChanging("owner");
            this.owner = edge;
            this.firePropertyChanged("owner");
        }
    }

    public GraphMember.Type getType() {
        return GraphMember.BEND;
    }

    public final int getClassCode() {
        return 8;
    }

    public void setCenter(FixedPoint2D fixedPoint2D) {
        this.setCenter(fixedPoint2D.getX(), fixedPoint2D.getY());
    }

    public void setCenter(double d, double d2) {
        if (d != this.getX() || d2 != this.getY()) {
            this.firePropertyChanging("location");
            this.placeAt(d, d2);
            if (this.isOwned()) {
                this.getOwner().onInnerPointMoved(true);
            }
            this.firePropertyChanged("location");
        }
    }

    public void setX(double d) {
        this.setCenter(d, this.getY());
    }

    public void setY(double d) {
        this.setCenter(this.getX(), d);
    }

    public void setBendPalette(BendPalette bendPalette) {
        if (!BaseObject.equal(this.palette, bendPalette)) {
            this.firePropertyChanging("palette");
            this.palette = bendPalette;
            this.firePropertyChanged("palette");
        }
    }

    public BendPalette getBendPalette() {
        return this.palette == null ? BendPalette.INSTANCE : this.palette;
    }

    public boolean isPaletteSet() {
        return this.palette != null;
    }

    public Palette getPalette() {
        return this.getBendPalette();
    }

    public void setPalette(Palette palette) {
        this.setBendPalette((BendPalette)palette);
    }

    public Color getStrokeColor() {
        if (this.isDragged()) {
            return this.getBendPalette().getGhostedStrokeColor();
        }
        if (this.isSelected()) {
            return this.getBendPalette().getSelectedStrokeColor();
        }
        return this.getBendPalette().getPlainStrokeColor();
    }

    public Color getFillColor() {
        if (this.isSelected()) {
            return this.getBendPalette().getSelectedFillColor();
        }
        return this.getBendPalette().getPlainFillColor();
    }

    public boolean isStroked() {
        return this.getBendPalette().isStroked();
    }

    public boolean isFilled() {
        return this.getBendPalette().isFilled();
    }

    public int getStrokeWidth() {
        return this.getBendPalette().getStrokeWidth();
    }

    public void paint(BaseObject baseObject, Graphics graphics, Transform transform) {
        if (baseObject instanceof Bend && baseObject.isVisible() && baseObject.isSelected() && !baseObject.isDragged()) {
            int n = transform.xToDevice(baseObject.getLeft());
            int n2 = transform.xToDevice(baseObject.getRight());
            int n3 = transform.yToDevice(baseObject.getTop());
            int n4 = transform.yToDevice(baseObject.getBottom());
            Bend bend = (Bend)baseObject;
            graphics.setColor(bend.getFillColor());
            graphics.fillRect(n, n3, n2 - n + 1, n4 - n3 + 1);
        }
    }

    public ObjectChangeManager getObjectChangeManager() {
        return this.isOwned() ? this.getOwner().getObjectChangeManager() : null;
    }

    protected void onInsert(Edge edge) {
        this.setOwner(edge);
        this.setOwned(true);
    }

    protected void onRemove(Edge edge) {
        this.setOwned(false);
        this.setOwner(null);
    }

    protected void moveTo(double d, double d2) {
        if (d != this.getCenterX() || d2 != this.getCenterY()) {
            this.placeAt(d, d2);
            if (this.isOwned()) {
                this.getOwner().onInnerPointMoved(false);
            }
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf(EsperStrings.string(51))).concat(String.valueOf(String.valueOf(this.hashCode())));
    }

    public Object clone() {
        Bend bend = (Bend)super.clone();
        bend.owner = null;
        return bend;
    }

    public void setBendPainter(BaseObjectPainter baseObjectPainter) {
        this.setPainter(baseObjectPainter);
    }

    public void setLocation(FixedPoint2D fixedPoint2D) {
        this.setCenter(fixedPoint2D.getX(), fixedPoint2D.getY());
    }

    public void setLocation(double d, double d2) {
        this.setCenter(d, d2);
    }
}

