/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model;

import com.cisco.nm.EsperStrings;
import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.BaseObjectPainter;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.GraphMember;
import com.cisco.nm.esper.model.GraphPoint;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.event.ObjectChangeManager;
import com.cisco.nm.esper.model.palette.ConnectorPalette;
import com.cisco.nm.esper.model.palette.Palette;
import com.cisco.nm.lib.algs.EmptyIterator;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Connector
extends GraphPoint {
    private double constX;
    private double constY;
    private double relX;
    private double relY;
    private Node owner;
    private List edges;
    private ConnectorPalette palette;
    private static Map resources;

    public Connector() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public Connector(double d, double d2, double d3, double d4) {
        this.constX = d;
        this.constY = d3;
        this.relX = d2;
        this.relY = d4;
        this.resize(4.0, 4.0);
        this.correctBounds();
    }

    public static Object getClassResource(String string) {
        if (resources == null) {
            return null;
        }
        return resources.get(string);
    }

    public static Object putClassResource(String string, Object object) {
        if (object == null) {
            if (resources == null) {
                return null;
            }
            return resources.remove(string);
        }
        if (resources == null) {
            resources = new HashMap(17, 0.85f);
        }
        return resources.put(string, object);
    }

    public static boolean hasClassResource(String string) {
        return resources != null && resources.containsKey(string);
    }

    public Object getResource(String string) {
        String string2 = String.valueOf(String.valueOf(this.hashCode())).concat(String.valueOf(String.valueOf(string)));
        if (Connector.hasClassResource(string2)) {
            return Connector.getClassResource(string2);
        }
        return Connector.getClassResource(string);
    }

    public Object putResource(String string, Object object) {
        return Connector.putClassResource(String.valueOf(String.valueOf(this.hashCode())).concat(String.valueOf(String.valueOf(string))), object);
    }

    public boolean hasResource(String string) {
        return Connector.hasClassResource(string) || Connector.hasClassResource(String.valueOf(String.valueOf(this.hashCode())).concat(String.valueOf(String.valueOf(string))));
    }

    public Node getOwner() {
        return this.owner;
    }

    public BaseObject getContainer() {
        return this.getOwner();
    }

    protected void setOwner(Node node) {
        if (this.owner != node) {
            this.firePropertyChanging("owner");
            this.owner = node;
            this.firePropertyChanged("owner");
        }
    }

    public GraphMember.Type getType() {
        return GraphMember.CONNECTOR;
    }

    public final int getClassCode() {
        return 16;
    }

    public ConnectorPalette getConnectorPalette() {
        return this.palette == null ? ConnectorPalette.INSTANCE : this.palette;
    }

    public void setConnectorPalette(ConnectorPalette connectorPalette) {
        if (!BaseObject.equal(this.palette, connectorPalette)) {
            this.firePropertyChanging("palette");
            this.palette = connectorPalette;
            this.firePropertyChanged("palette");
        }
    }

    public boolean isPaletteSet() {
        return this.palette != null;
    }

    public Palette getPalette() {
        return this.getConnectorPalette();
    }

    public void setPalette(Palette palette) {
        this.setConnectorPalette((ConnectorPalette)palette);
    }

    public Color getStrokeColor() {
        if (this.isDragged()) {
            return this.getConnectorPalette().getGhostedStrokeColor();
        }
        if (this.isSelected()) {
            return this.getConnectorPalette().getSelectedStrokeColor();
        }
        return this.getConnectorPalette().getPlainStrokeColor();
    }

    public Color getFillColor() {
        return this.getConnectorPalette().getPlainFillColor();
    }

    public boolean isStroked() {
        return this.getConnectorPalette().isStroked();
    }

    public boolean isFilled() {
        return this.getConnectorPalette().isFilled();
    }

    public int getStrokeWidth() {
        return this.getConnectorPalette().getStrokeWidth();
    }

    public void paint(BaseObject baseObject, Graphics graphics, Transform transform) {
        if (baseObject instanceof Connector && baseObject.isVisible()) {
            int n = transform.xToDevice(baseObject.getLeft());
            int n2 = transform.xToDevice(baseObject.getRight());
            int n3 = transform.yToDevice(baseObject.getTop());
            int n4 = transform.yToDevice(baseObject.getBottom());
            graphics.setColor(this.getStrokeColor());
            graphics.drawLine(n, n3, n2, n4);
            graphics.drawLine(n, n4, n2, n3);
        }
    }

    public double getConstantOffsetX() {
        return this.constX;
    }

    public double getConstantOffsetY() {
        return this.constY;
    }

    public double getRelativeOffsetX() {
        return this.relX;
    }

    public double getRelativeOffsetY() {
        return this.relY;
    }

    public void setOffsets(double d, double d2, double d3, double d4) {
        if (d != this.constX || d3 != this.constY || d2 != this.relX || d4 != this.relY) {
            this.firePropertyChanging("offsets");
            this.constX = d;
            this.relX = d2;
            this.constY = d3;
            this.relY = d4;
            this.correctBounds();
            this.notifyLocationChanged();
            this.firePropertyChanged("offsets");
        }
    }

    protected void correctBounds() {
        double d = this.constX;
        if (this.isOwned()) {
            d += this.getOwner().getIconCenterX() + this.relX * this.getOwner().getIconWidth();
        }
        double d2 = this.constY;
        if (this.isOwned()) {
            d2 += this.getOwner().getIconCenterY() + this.relY * this.getOwner().getIconHeight();
        }
        this.placeAt(d, d2);
    }

    protected void onInsert(Node node) {
        this.setOwner(node);
        this.setOwned(true);
        this.correctBounds();
    }

    protected void onRemove(Node node) {
        while (this.edges.size() > 0) {
            Edge edge = (Edge)this.edges.get(0);
            if (edge.getSourceConnector() == this) {
                edge.setSourceConnector(null);
            }
            if (edge.getTargetConnector() != this) continue;
            edge.setTargetConnector(null);
        }
        this.setOwned(false);
        this.setOwner(null);
    }

    protected void onAttach(Edge edge) {
        if (this.edges == null) {
            this.edges = new LinkedList();
        }
        this.edges.add(edge);
    }

    protected void onDetach(Edge edge) {
        if (this.edges == null || this.edges.size() <= 0) {
            EsperStrings.illegalArgument(26);
        }
        if (!this.edges.remove(edge)) {
            EsperStrings.illegalArgument(26);
        }
    }

    public Iterator edges() {
        return this.edges == null || this.edges.size() <= 0 ? EmptyIterator.INSTANCE : this.edges.iterator();
    }

    protected void notifyLocationChanged() {
        if (this.isOwned()) {
            Iterator iterator = this.edges();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                if (edge.getSourceNode() == this.getOwner()) {
                    edge.onSourcePointMoved(true);
                    continue;
                }
                if (edge.getTargetNode() != this.getOwner()) continue;
                edge.onTargetPointMoved(true);
            }
        }
    }

    public ObjectChangeManager getObjectChangeManager() {
        return this.isOwned() ? this.getOwner().getObjectChangeManager() : null;
    }

    public String toString() {
        return String.valueOf(String.valueOf(EsperStrings.string(52))).concat(String.valueOf(String.valueOf(this.hashCode())));
    }

    public Object clone() {
        Connector connector = (Connector)super.clone();
        connector.edges = null;
        connector.owner = null;
        return connector;
    }

    public void setConectorPainter(BaseObjectPainter baseObjectPainter) {
        this.setPainter(baseObjectPainter);
    }
}

