/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model;

import com.cisco.nm.EsperStrings;
import com.cisco.nm.esper.lib.OwnedLinkedList;
import com.cisco.nm.esper.lib.OwnedList;
import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.BaseObjectPainter;
import com.cisco.nm.esper.model.Bend;
import com.cisco.nm.esper.model.BendList;
import com.cisco.nm.esper.model.Connector;
import com.cisco.nm.esper.model.EdgeLabel;
import com.cisco.nm.esper.model.EdgeLabelList;
import com.cisco.nm.esper.model.EdgeOwnedList;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.GraphMember;
import com.cisco.nm.esper.model.GraphObject;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.palette.EdgePalette;
import com.cisco.nm.esper.model.palette.Palette;
import com.cisco.nm.esper.shape.FixedPoint2D;
import com.cisco.nm.esper.shape.Point2D;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Edge
extends GraphObject {
    public static final int LOOSE = 0;
    public static final int BOUND = 1;
    public static final int INNERGRAPH = 1;
    public static final int INTERGRAPH = 2;
    public static final int EXTERNAL = 3;
    private static final int BOUND_BIT = 32;
    private static final int INTERGRAPH_BIT = 64;
    protected static final int HIGH_BIT = 64;
    private double weight;
    private Node srcNode;
    private Node trgNode;
    private Connector srcCnn;
    private Connector trgCnn;
    private Point2D srcPoint = new Point2D.Double();
    private Point2D trgPoint = new Point2D.Double();
    private EdgeOwnedList labels;
    private EdgeOwnedList bends;
    private EdgePalette palette;
    private static Map resources;

    public Edge() {
        this(null, null, null);
    }

    public Edge(String string) {
        this(null, null, string);
    }

    public Edge(Node node, Node node2) {
        this(node, node2, null);
    }

    public Edge(Node node, Node node2, String string) {
        super(string);
        this.setBitOff(32);
        this.setBitOff(64);
        this.setSourceNode(node);
        this.setTargetNode(node2);
    }

    public static Object getClassResource(String string) {
        if (resources == null) {
            return null;
        }
        return resources.get(string);
    }

    public static Object putClassResource(String string, Object object) {
        if (object == null) {
            if (resources == null) {
                return null;
            }
            return resources.remove(string);
        }
        if (resources == null) {
            resources = new HashMap(17, 0.85f);
        }
        return resources.put(string, object);
    }

    public static boolean hasClassResource(String string) {
        return resources != null && resources.containsKey(string);
    }

    public Object getResource(String string) {
        String string2 = String.valueOf(String.valueOf(this.hashCode())).concat(String.valueOf(String.valueOf(string)));
        if (Edge.hasClassResource(string2)) {
            return Edge.getClassResource(string2);
        }
        return Edge.getClassResource(string);
    }

    public Object putResource(String string, Object object) {
        return Edge.putClassResource(String.valueOf(String.valueOf(this.hashCode())).concat(String.valueOf(String.valueOf(string))), object);
    }

    public boolean hasResource(String string) {
        return Edge.hasClassResource(string) || Edge.hasClassResource(String.valueOf(String.valueOf(this.hashCode())).concat(String.valueOf(String.valueOf(string))));
    }

    public GraphMember.Type getType() {
        return GraphMember.EDGE;
    }

    public final int getClassCode() {
        return 2;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double d) {
        if (d != this.weight) {
            this.firePropertyChanging("weight");
            this.weight = d;
            this.firePropertyChanged("weight");
        }
    }

    public int getState() {
        if (this.isBound()) {
            return this.isIntergraph() ? 2 : 1;
        }
        return 0;
    }

    public boolean isBound() {
        return this.isBitOn(32);
    }

    protected void setBound(boolean bl) {
        if (bl != this.isBitOn(32)) {
            this.firePropertyChanging("state");
            if (bl) {
                this.setBitOn(32);
                this.getOwner().onChildBoundsGained(this);
            } else {
                this.setBitOff(32);
                this.getOwner().onChildBoundsLost(this);
            }
            this.firePropertyChanged("state");
        }
    }

    public boolean isInnergraph() {
        return this.isBound() && !this.isIntergraph();
    }

    public boolean isIntergraph() {
        return this.isBitOn(64);
    }

    protected void setIntergraph(boolean bl) {
        if (bl != this.isBitOn(64)) {
            this.setBit(64, bl);
        }
    }

    public Node getSourceNode() {
        return this.srcNode;
    }

    public void setSourceNode(Node node) {
        if (!BaseObject.equal(this.srcNode, node)) {
            this.firePropertyChanging("sourceNode");
            if (this.srcNode != null) {
                this.updateExternal(this.srcNode, false);
                this.srcNode.onDetachOutEdge(this);
            }
            this.srcNode = node;
            if (this.srcNode == null) {
                if (this.isBound()) {
                    int n = this.isIntergraph() ? 2 : 1;
                    this.setIntergraph(false);
                    this.setBound(false);
                    this.trgNode.onInEdgeDisconnected(this);
                    this.getOwner().onConnectivityChanged(this, n);
                }
            } else {
                this.srcNode.onAttachOutEdge(this);
                this.updateExternal(this.srcNode, true);
                if (!this.isBound() && this.isProperlyOwned() && this.trgNode != null && this.trgNode.isOwned()) {
                    this.setBound(true);
                    this.setIntergraph(this.getOwner() != this.srcNode.getOwner() || this.getOwner() != this.trgNode.getOwner());
                    this.srcNode.onOutEdgeConnected(this);
                    this.trgNode.onInEdgeConnected(this);
                    this.getOwner().onConnectivityChanged(this, 0);
                }
            }
            this.onSourcePointMoved(true);
            this.firePropertyChanged("sourceNode");
        }
    }

    public Node getTargetNode() {
        return this.trgNode;
    }

    public void setTargetNode(Node node) {
        if (!BaseObject.equal(this.trgNode, node)) {
            this.firePropertyChanging("targetNode");
            if (this.trgNode != null) {
                this.updateExternal(this.trgNode, false);
                this.trgNode.onDetachInEdge(this);
            }
            this.trgNode = node;
            if (this.trgNode == null) {
                if (this.isBound()) {
                    int n = this.isIntergraph() ? 2 : 1;
                    this.setIntergraph(false);
                    this.setBound(false);
                    this.srcNode.onOutEdgeDisconnected(this);
                    this.getOwner().onConnectivityChanged(this, n);
                }
            } else {
                this.trgNode.onAttachInEdge(this);
                if (this.getOwner() != null && this.trgNode.getOwner() != null && this.getOwner() != this.trgNode.getOwner()) {
                    this.trgNode.getOwner().onAttachExternal(this);
                }
                if (!this.isBound() && this.isProperlyOwned() && this.srcNode != null && this.srcNode.isOwned()) {
                    this.setBound(true);
                    this.setIntergraph(this.getOwner() != this.srcNode.getOwner() || this.getOwner() != this.trgNode.getOwner());
                    this.srcNode.onOutEdgeConnected(this);
                    this.trgNode.onInEdgeConnected(this);
                    this.getOwner().onConnectivityChanged(this, 0);
                }
            }
            this.onTargetPointMoved(true);
            this.firePropertyChanged("targetNode");
        }
    }

    public void detach() {
        this.setSourceNode(null);
        this.setTargetNode(null);
    }

    protected void onInsert(Graph graph) {
        BaseObject baseObject;
        super.onInsert(graph);
        this.updateExternal(this.srcNode, true);
        this.updateExternal(this.trgNode, true);
        if (this.isProperlyOwned() && this.srcNode != null && this.srcNode.isOwned() && this.trgNode != null && this.trgNode.isOwned()) {
            this.setBound(true);
            this.setIntergraph(this.getOwner() != this.srcNode.getOwner() || this.getOwner() != this.trgNode.getOwner());
            this.srcNode.onOutEdgeConnected(this);
            this.trgNode.onInEdgeConnected(this);
        }
        graph.onEdgeLabelCountChanged(this.labels().size());
        graph.onEdgeBendCountChanged(this.bends().size());
        Iterator iterator = this.labels().iterator();
        while (iterator.hasNext()) {
            baseObject = (EdgeLabel)iterator.next();
            if (!baseObject.isSelected()) continue;
            graph.getSelection().add(baseObject);
        }
        iterator = this.bends().iterator();
        while (iterator.hasNext()) {
            baseObject = (Bend)iterator.next();
            if (!baseObject.isSelected()) continue;
            graph.getSelection().add(baseObject);
        }
    }

    protected void onRemove(Graph graph) {
        BaseObject baseObject;
        Iterator iterator = this.bends().iterator();
        while (iterator.hasNext()) {
            baseObject = (Bend)iterator.next();
            if (!baseObject.isSelected()) continue;
            graph.getSelection().remove(baseObject);
        }
        iterator = this.labels().iterator();
        while (iterator.hasNext()) {
            baseObject = (EdgeLabel)iterator.next();
            if (!baseObject.isSelected()) continue;
            graph.getSelection().remove(baseObject);
        }
        graph.onEdgeLabelCountChanged(-this.labels().size());
        graph.onEdgeBendCountChanged(-this.bends().size());
        this.updateExternal(this.srcNode, false);
        this.updateExternal(this.trgNode, false);
        if (this.isBound()) {
            this.setIntergraph(false);
            this.setBound(false);
            this.srcNode.onOutEdgeDisconnected(this);
            this.trgNode.onInEdgeDisconnected(this);
        }
        super.onRemove(graph);
    }

    protected void onSourceInserted() {
        this.updateExternal(this.srcNode, true);
        if (this.isProperlyOwned() && this.trgNode != null && this.trgNode.isOwned()) {
            this.affix();
            this.trgNode.onInEdgeConnected(this);
        }
    }

    protected void onTargetInserted() {
        this.updateExternal(this.trgNode, true);
        if (this.isProperlyOwned() && this.srcNode != null && this.srcNode.isOwned()) {
            this.affix();
            this.srcNode.onOutEdgeConnected(this);
        }
    }

    private void affix() {
        this.setBound(true);
        this.setIntergraph(this.getOwner() != this.srcNode.getOwner() || this.getOwner() != this.trgNode.getOwner());
        this.getOwner().onConnectivityChanged(this, 0);
    }

    protected void onSourceRemoved() {
        this.updateExternal(this.srcNode, false);
        if (this.isBound()) {
            this.loosen();
            this.trgNode.onInEdgeDisconnected(this);
        }
    }

    protected void onTargetRemoved() {
        this.updateExternal(this.trgNode, false);
        if (this.isBound()) {
            this.loosen();
            this.srcNode.onOutEdgeDisconnected(this);
        }
    }

    private void loosen() {
        int n = this.isIntergraph() ? 2 : 1;
        this.setIntergraph(false);
        this.setBound(false);
        this.getOwner().onConnectivityChanged(this, n);
    }

    protected void onGraphRemoved(Graph graph) {
        if (this.isIntergraph() && this.getOwner().getDepth() < graph.getDepth()) {
            this.setBound(false);
            this.setIntergraph(false);
            this.srcNode.onOutEdgeDisconnected(this);
            this.trgNode.onInEdgeDisconnected(this);
            this.getOwner().onConnectivityChanged(this, 2);
        }
    }

    protected void onGraphInserted(Graph graph) {
        if (this.srcNode != null && this.srcNode.isOwned() && this.trgNode != null && this.trgNode.isOwned() && this.isProperlyOwned()) {
            this.setBound(true);
            this.setIntergraph(true);
            this.srcNode.onOutEdgeConnected(this);
            this.trgNode.onInEdgeConnected(this);
            this.getOwner().onConnectivityChanged(this, 0);
        }
    }

    protected void onDetachSource(Node node) {
        if (node == null || node != this.srcNode) {
            EsperStrings.illegalArgument(22);
        }
        this.firePropertyChanging("sourceNode");
        this.updateExternal(this.srcNode, false);
        if (this.isBound()) {
            int n = this.isIntergraph() ? 2 : 1;
            this.setIntergraph(false);
            this.setBound(false);
            this.trgNode.onInEdgeDisconnected(this);
            this.getOwner().onConnectivityChanged(this, n);
        }
        this.srcNode = null;
        this.firePropertyChanged("sourceNode");
    }

    protected void onDetachTarget(Node node) {
        if (node == null || node != this.trgNode) {
            EsperStrings.illegalArgument(23);
        }
        this.firePropertyChanging("targetNode");
        this.updateExternal(this.trgNode, false);
        if (this.isBound()) {
            int n = this.isIntergraph() ? 2 : 1;
            this.setIntergraph(false);
            this.setBound(false);
            this.srcNode.onOutEdgeDisconnected(this);
            this.getOwner().onConnectivityChanged(this, n);
        }
        this.trgNode = null;
        this.firePropertyChanged("targetNode");
    }

    public double length() {
        double d;
        double d2;
        double d3 = 0.0;
        double d4 = this.getSourceX();
        double d5 = this.getSourceY();
        Iterator iterator = this.bends().iterator();
        while (iterator.hasNext()) {
            Bend bend = (Bend)iterator.next();
            d2 = d4;
            d = d5;
            d4 = bend.getCenterX();
            d5 = bend.getCenterY();
            d3 += Math.sqrt((d4 - d2) * (d4 - d2) + (d5 - d) * (d5 - d));
        }
        d2 = this.getTargetX();
        d = this.getTargetY();
        return d3 + Math.sqrt((d2 - d4) * (d2 - d4) + (d - d5) * (d - d5));
    }

    public Iterator points() {
        return new PointIter(this);
    }

    public Connector getSourceConnector() {
        return this.srcCnn;
    }

    public Connector getTargetConnector() {
        return this.trgCnn;
    }

    public void setSourceConnector(Connector connector) {
        if (!(connector == null || connector.isOwned() && connector.getOwner() == this.getSourceNode())) {
            EsperStrings.illegalArgument(24);
        }
        if (!BaseObject.equal(this.srcCnn, connector)) {
            this.firePropertyChanging("sourceConnector");
            if (this.srcCnn != null) {
                this.srcCnn.onDetach(this);
            }
            this.srcCnn = connector;
            if (this.srcCnn != null) {
                this.srcCnn.onAttach(this);
            }
            this.onSourcePointMoved(true);
            this.firePropertyChanged("sourceConnector");
        }
    }

    public void setTargetConnector(Connector connector) {
        if (!(connector == null || connector.isOwned() && connector.getOwner() == this.getTargetNode())) {
            EsperStrings.illegalArgument(25);
        }
        if (!BaseObject.equal(this.trgCnn, connector)) {
            this.firePropertyChanging("targetConnector");
            if (this.trgCnn != null) {
                this.trgCnn.onDetach(this);
            }
            this.trgCnn = connector;
            if (this.trgCnn != null) {
                this.trgCnn.onAttach(this);
            }
            this.onTargetPointMoved(true);
            this.firePropertyChanged("targetConnector");
        }
    }

    public FixedPoint2D getSourcePoint() {
        return this.srcPoint;
    }

    public double getSourceX() {
        return this.srcPoint.getX();
    }

    public double getSourceY() {
        return this.srcPoint.getY();
    }

    public FixedPoint2D getTargetPoint() {
        return this.trgPoint;
    }

    public double getTargetX() {
        return this.trgPoint.getX();
    }

    public double getTargetY() {
        return this.trgPoint.getY();
    }

    protected void onSourcePointMoved(boolean bl) {
        Node node = this.getSourceNode();
        if (node != null) {
            Object object;
            int n;
            double d;
            double d2;
            Connector connector = this.getSourceConnector();
            if (connector == null) {
                d2 = node.getIconCenterX();
                d = node.getIconCenterY();
            } else {
                d2 = connector.getX();
                d = connector.getY();
            }
            if (this.isIntergraph()) {
                n = Integer.MAX_VALUE;
                if (this.isOwned()) {
                    n = Math.min(n, this.getOwner().getDepth());
                }
                if (node.isOwned()) {
                    n = Math.min(n, node.getOwner().getDepth());
                    object = node.getOwner();
                    while (((Graph)object).getDepth() >= n) {
                        if (!((Graph)object).isExpanded()) {
                            d2 = ((Graph)object).getCenterX();
                            d = ((Graph)object).getCenterY();
                        }
                        if (!((BaseObject)object).isOwned()) break;
                        object = ((GraphObject)object).getOwner();
                    }
                }
            }
            if (!this.isDragged()) {
                // empty if block
            }
            if (d2 != this.srcPoint.getX() || d != this.srcPoint.getY()) {
                if (bl) {
                    this.firePropertyChanging("sourcePoint");
                }
                n = this.srcPoint.getX() <= this.getLeft() || this.srcPoint.getX() >= this.getRight() || this.srcPoint.getY() <= this.getBottom() || this.srcPoint.getY() >= this.getTop() || !this.contains(d2, d) ? 1 : 0;
                this.srcPoint.setLocation(d2, d);
                if (bl) {
                    this.firePropertyChanged("sourcePoint");
                }
                object = this.labels().iterator();
                while (object.hasNext()) {
                    if (!((EdgeLabel)object.next()).correctBounds()) continue;
                    n = 1;
                }
                if (n != 0) {
                    this.updateBounds(bl);
                }
            }
        }
    }

    protected void onTargetPointMoved(boolean bl) {
        Node node = this.getTargetNode();
        if (node != null) {
            Object object;
            int n;
            double d;
            double d2;
            Connector connector = this.getTargetConnector();
            if (connector == null) {
                d2 = node.getIconCenterX();
                d = node.getIconCenterY();
            } else {
                d2 = connector.getX();
                d = connector.getY();
            }
            if (this.isIntergraph()) {
                n = Integer.MAX_VALUE;
                if (this.isOwned()) {
                    n = Math.min(n, this.getOwner().getDepth());
                }
                if (node.isOwned()) {
                    n = Math.min(n, node.getOwner().getDepth());
                    object = node.getOwner();
                    while (((Graph)object).getDepth() >= n) {
                        if (!((Graph)object).isExpanded()) {
                            d2 = ((Graph)object).getCenterX();
                            d = ((Graph)object).getCenterY();
                        }
                        if (!((BaseObject)object).isOwned()) break;
                        object = ((GraphObject)object).getOwner();
                    }
                }
            }
            if (d2 != this.trgPoint.getX() || d != this.trgPoint.getY()) {
                if (bl) {
                    this.firePropertyChanging("targetPoint");
                }
                n = this.trgPoint.getX() <= this.getLeft() || this.trgPoint.getX() >= this.getRight() || this.trgPoint.getY() <= this.getBottom() || this.trgPoint.getY() >= this.getTop() || !this.contains(d2, d) ? 1 : 0;
                this.trgPoint.setLocation(d2, d);
                if (bl) {
                    this.firePropertyChanged("targetPoint");
                }
                object = this.labels().iterator();
                while (object.hasNext()) {
                    if (!((EdgeLabel)object.next()).correctBounds()) continue;
                    n = 1;
                }
                if (n != 0) {
                    this.updateBounds(bl);
                }
            }
        }
    }

    protected void onInnerPointMoved(boolean bl) {
        Iterator iterator = this.labels().iterator();
        while (iterator.hasNext()) {
            ((EdgeLabel)iterator.next()).correctBounds();
        }
        this.updateBounds(bl);
    }

    public void updateBounds() {
        this.updateBounds(true);
    }

    protected void updateBounds(boolean bl) {
        BaseObject baseObject;
        double d;
        double d2;
        double d3;
        double d4;
        if (this.getSourceX() < this.getTargetX()) {
            d4 = this.getSourceX();
            d3 = this.getTargetX();
        } else {
            d4 = this.getTargetX();
            d3 = this.getSourceX();
        }
        if (this.getSourceY() < this.getTargetY()) {
            d2 = this.getSourceY();
            d = this.getTargetY();
        } else {
            d2 = this.getTargetY();
            d = this.getSourceY();
        }
        Iterator iterator = this.bends().iterator();
        while (iterator.hasNext()) {
            baseObject = (Bend)iterator.next();
            if (baseObject.getLeft() < d4) {
                d4 = baseObject.getLeft();
            }
            if (baseObject.getRight() > d3) {
                d3 = baseObject.getRight();
            }
            if (baseObject.getBottom() < d2) {
                d2 = baseObject.getBottom();
            }
            if (!(baseObject.getTop() > d)) continue;
            d = baseObject.getTop();
        }
        iterator = this.labels().iterator();
        while (iterator.hasNext()) {
            baseObject = (EdgeLabel)iterator.next();
            if (baseObject.getLeft() < d4) {
                d4 = baseObject.getLeft();
            }
            if (baseObject.getRight() > d3) {
                d3 = baseObject.getRight();
            }
            if (baseObject.getBottom() < d2) {
                d2 = baseObject.getBottom();
            }
            if (!(baseObject.getTop() > d)) continue;
            d = baseObject.getTop();
        }
        if (bl) {
            this.setBounds(d4, d2, d3, d);
        } else {
            this.reshape(d4, d2, d3, d);
        }
    }

    protected EdgeOwnedList getBendList() {
        return this.bends;
    }

    protected void setBendList(EdgeOwnedList edgeOwnedList) {
        if (this.bends != null) {
            Iterator iterator = this.bends.iterator();
            while (iterator.hasNext()) {
                edgeOwnedList.add((Bend)iterator.next());
            }
            this.bends.setOwner(null);
            this.bends.clear();
        }
        this.bends = edgeOwnedList;
        this.bends.setOwner(this);
    }

    public Bend insert(Bend bend) {
        return this.insert(this.bends().size(), bend);
    }

    public Bend insert(int n, Bend bend) {
        if (bend == null || bend.isOwned()) {
            EsperStrings.illegalArgument(11);
        }
        if (this.bends == null) {
            this.setBendList(new BendList());
        }
        this.fireChildInserting(bend);
        bend.onInsert(this);
        this.bends.add(n, bend);
        this.onInnerPointMoved(true);
        if (this.isOwned()) {
            this.getOwner().onEdgeBendCountChanged(1);
            if (bend.isSelected()) {
                this.getOwner().getSelection().add(bend);
            }
        }
        this.fireChildInserted(bend);
        return bend;
    }

    public void remove(Bend bend) {
        if (bend == null || !bend.isOwned() || bend.getOwner() != this) {
            EsperStrings.illegalArgument(13);
        }
        this.fireChildRemoving(bend);
        this.bends.remove(bend);
        bend.onRemove(this);
        this.onInnerPointMoved(true);
        if (this.isOwned()) {
            this.getOwner().onEdgeBendCountChanged(-1);
            if (bend.isSelected()) {
                this.getOwner().getSelection().remove(bend);
            }
        }
        this.fireChildRemoved(bend);
    }

    public OwnedList bends() {
        return this.bends == null ? OwnedList.EMPTY : this.bends;
    }

    protected EdgeOwnedList getLabelList() {
        return this.labels;
    }

    protected void setLabelList(EdgeOwnedList edgeOwnedList) {
        if (this.labels != null) {
            Iterator iterator = this.labels.iterator();
            while (iterator.hasNext()) {
                edgeOwnedList.add((EdgeLabel)iterator.next());
            }
            this.labels.setOwner(null);
            this.labels.clear();
        }
        this.labels = edgeOwnedList;
        this.labels.setOwner(this);
    }

    public EdgeLabel insert(EdgeLabel edgeLabel) {
        if (edgeLabel == null || edgeLabel.isOwned()) {
            EsperStrings.illegalArgument(12);
        }
        if (this.labels == null) {
            this.setLabelList(new EdgeLabelList());
        }
        this.fireChildInserting(edgeLabel);
        edgeLabel.onInsert(this);
        this.labels.add(edgeLabel);
        if (this.isOwned()) {
            this.getOwner().onEdgeLabelCountChanged(1);
            if (edgeLabel.isSelected()) {
                this.getOwner().getSelection().add(edgeLabel);
            }
        }
        this.fireChildInserted(edgeLabel);
        return edgeLabel;
    }

    public void remove(EdgeLabel edgeLabel) {
        if (edgeLabel == null || !edgeLabel.isOwned() || edgeLabel.getOwner() != this) {
            EsperStrings.illegalArgument(14);
        }
        this.fireChildRemoving(edgeLabel);
        this.labels.remove(edgeLabel);
        edgeLabel.onRemove(this);
        if (this.isOwned()) {
            this.getOwner().onEdgeLabelCountChanged(-1);
            if (edgeLabel.isSelected()) {
                this.getOwner().getSelection().remove(edgeLabel);
            }
        }
        this.fireChildRemoved(edgeLabel);
    }

    public OwnedList labels() {
        return this.labels == null ? OwnedList.EMPTY : this.labels;
    }

    protected void attachToClones(Edge edge) {
        Node node;
        Node node2;
        Connector connector;
        if (edge == null || edge.getUtilityObject() != this) {
            throw new InternalError(EsperStrings.string(15));
        }
        Node node3 = edge.getSourceNode();
        if (node3 != null) {
            this.setSourceNode((Node)node3.getUtilityObject());
        }
        if ((node3 = edge.getTargetNode()) != null) {
            this.setTargetNode((Node)node3.getUtilityObject());
        }
        if ((connector = edge.getSourceConnector()) != null) {
            node2 = edge.getSourceNode();
            node = this.getSourceNode();
            this.setSourceConnector((Connector)node.connectors().get(node2.connectors().indexOf(connector)));
        }
        if ((connector = edge.getTargetConnector()) != null) {
            node2 = edge.getTargetNode();
            node = this.getTargetNode();
            this.setTargetConnector((Connector)node.connectors().get(node2.connectors().indexOf(connector)));
        }
    }

    public EdgePalette getEdgePalette() {
        return this.palette == null ? EdgePalette.INSTANCE : this.palette;
    }

    public void setEdgePalette(EdgePalette edgePalette) {
        if (!BaseObject.equal(this.palette, edgePalette)) {
            this.firePropertyChanging("palette");
            this.palette = edgePalette;
            this.firePropertyChanged("palette");
        }
    }

    public boolean isPaletteSet() {
        return this.palette != null;
    }

    public Palette getPalette() {
        return this.getEdgePalette();
    }

    public void setPalette(Palette palette) {
        this.setEdgePalette((EdgePalette)palette);
    }

    public Color getStrokeColor() {
        int n = this.getState();
        if (this.isDragged()) {
            return this.getEdgePalette().getDraggedStrokeColor(n);
        }
        if (this.isSelected()) {
            return this.getEdgePalette().getSelectedStrokeColor(n);
        }
        return this.getEdgePalette().getPlainStrokeColor(n);
    }

    public int getStrokeWidth() {
        return this.getEdgePalette().getStrokeWidth(this.getState());
    }

    public int getArrowWidth() {
        return this.getEdgePalette().getArrowWidth(this.getState());
    }

    public int getArrowHeight() {
        return this.getEdgePalette().getArrowHeight(this.getState());
    }

    public int getArrowType() {
        return this.getEdgePalette().getArrowType(this.getState());
    }

    public float[] getPattern() {
        return this.getEdgePalette().getPattern(this.getState());
    }

    public int getLineJoins() {
        return this.getEdgePalette().getLineJoins();
    }

    public void paint(BaseObject baseObject, Graphics graphics, Transform transform) {
        if (baseObject.isVisible() && baseObject instanceof Edge) {
            Edge edge = (Edge)baseObject;
            graphics.setColor(Color.black);
            graphics.drawLine(transform.xToDevice(edge.getSourceX()), transform.yToDevice(edge.getSourceY()), transform.xToDevice(edge.getTargetX()), transform.yToDevice(edge.getTargetY()));
        }
    }

    public Object clone() {
        Iterator iterator;
        OwnedLinkedList ownedLinkedList;
        Edge edge = (Edge)super.clone();
        edge.srcNode = null;
        edge.trgNode = null;
        edge.setBitOff(32);
        edge.setBitOff(64);
        edge.srcPoint = (Point2D)this.srcPoint.clone();
        edge.trgPoint = (Point2D)this.trgPoint.clone();
        edge.srcCnn = null;
        edge.trgCnn = null;
        edge.bends = null;
        edge.labels = null;
        if (this.bends != null) {
            ownedLinkedList = (BendList)this.bends.clone();
            ((BendList)ownedLinkedList).clear();
            edge.setBendList((EdgeOwnedList)((Object)ownedLinkedList));
            iterator = this.bends().iterator();
            while (iterator.hasNext()) {
                edge.insert((Bend)((Bend)iterator.next()).clone());
            }
        }
        if (this.labels != null) {
            ownedLinkedList = (EdgeLabelList)this.labels.clone();
            ((EdgeLabelList)ownedLinkedList).clear();
            edge.setLabelList((EdgeOwnedList)((Object)ownedLinkedList));
            iterator = this.labels().iterator();
            while (iterator.hasNext()) {
                edge.insert((EdgeLabel)((EdgeLabel)iterator.next()).clone());
            }
        }
        return edge;
    }

    public String toString() {
        if (this.getText() != null) {
            return this.getText();
        }
        if (this.getSourceNode() != null && this.getTargetNode() != null) {
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getSourceNode()))).append(" : ").append(this.getTargetNode())));
        }
        return String.valueOf(String.valueOf(EsperStrings.string(53))).concat(String.valueOf(String.valueOf(this.hashCode())));
    }

    public static Graph getProperOwner(Node node, Node node2) {
        Graph graph;
        if (node == null || !node.isOwned() || node2 == null || !node2.isOwned()) {
            return null;
        }
        Graph graph2 = node.getOwner();
        if (graph2 == (graph = node2.getOwner())) {
            return graph2;
        }
        int n = Math.min(graph2.getDepth(), graph.getDepth());
        while (graph2.getDepth() > n && graph2.isOwned()) {
            graph2 = graph2.getOwner();
        }
        while (graph.getDepth() > n && graph.isOwned()) {
            graph = graph.getOwner();
        }
        if (graph.getDepth() != graph2.getDepth()) {
            return null;
        }
        while (graph != graph2 && graph.isOwned() && graph2.isOwned()) {
            graph = graph.getOwner();
            graph2 = graph2.getOwner();
        }
        return graph2 == graph ? graph2 : null;
    }

    private boolean isProperlyOwned() {
        if (!this.isOwned()) {
            return false;
        }
        return Edge.getProperOwner(this.srcNode, this.trgNode) == this.getOwner();
    }

    private void updateExternal(Node node, boolean bl) {
        if (node != null && node.getOwner() != null && this.getOwner() != null && this.getOwner() != node.getOwner()) {
            if (bl) {
                node.getOwner().onAttachExternal(this);
            } else {
                node.getOwner().onDetachExternal(this);
            }
        }
    }

    public void setEdgePainter(BaseObjectPainter baseObjectPainter) {
        this.setPainter(baseObjectPainter);
    }

    static {
        LOOSE = 0;
        BOUND = 1;
        INNERGRAPH = 1;
        INTERGRAPH = 2;
        EXTERNAL = 3;
        BOUND_BIT = 32;
        INTERGRAPH_BIT = 64;
        HIGH_BIT = 64;
    }

    private static class PointIter
    implements Iterator {
        private int where = 0;
        private Iterator iter;
        private Edge edge;

        public PointIter(Edge edge) {
            this.edge = edge;
        }

        public boolean hasNext() {
            return this.where != -1;
        }

        public Object next() {
            if (this.where == 0) {
                if (this.edge.bends().size() > 0) {
                    this.iter = this.edge.bends().iterator();
                    this.where = 1;
                } else {
                    this.where = 2;
                }
                return this.edge.getSourcePoint();
            }
            if (this.where == 1) {
                Bend bend = (Bend)this.iter.next();
                if (!this.iter.hasNext()) {
                    this.where = 2;
                }
                return bend;
            }
            if (this.where == 2) {
                this.where = -1;
                return this.edge.getTargetPoint();
            }
            throw new NoSuchElementException(EsperStrings.string(16));
        }

        public void remove() {
            throw new UnsupportedOperationException(EsperStrings.string(17));
        }
    }
}

