/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model;

import com.cisco.nm.EsperStrings;
import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.BaseObjectPainter;
import com.cisco.nm.esper.model.Bend;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.GraphMember;
import com.cisco.nm.esper.model.TextDecoration;
import com.cisco.nm.esper.model.event.ObjectChangeManager;
import com.cisco.nm.esper.model.palette.EdgeLabelPalette;
import com.cisco.nm.esper.model.palette.LabelPalette;
import com.cisco.nm.esper.model.palette.Palette;
import com.cisco.nm.esper.shape.FixedPoint2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EdgeLabel
extends TextDecoration {
    private double dist = 0.5;
    private double xOff;
    private double yOff;
    private Edge owner;
    private LabelPalette palette;
    private static Map resources;

    public EdgeLabel() {
        this((String)null);
    }

    public EdgeLabel(String string) {
        super(string);
        if (this.getWidth() == 0.0 && this.getHeight() == 0.0) {
            this.resize(40.0, 20.0);
        }
    }

    public static Object getClassResource(String string) {
        if (resources == null) {
            return null;
        }
        return resources.get(string);
    }

    public static Object putClassResource(String string, Object object) {
        if (object == null) {
            if (resources == null) {
                return null;
            }
            return resources.remove(string);
        }
        if (resources == null) {
            resources = new HashMap(17, 0.85f);
        }
        return resources.put(string, object);
    }

    public static boolean hasClassResource(String string) {
        return resources != null && resources.containsKey(string);
    }

    public Object getResource(String string) {
        String string2 = String.valueOf(String.valueOf(this.hashCode())).concat(String.valueOf(String.valueOf(string)));
        if (EdgeLabel.hasClassResource(string2)) {
            return EdgeLabel.getClassResource(string2);
        }
        return EdgeLabel.getClassResource(string);
    }

    public Object putResource(String string, Object object) {
        return EdgeLabel.putClassResource(String.valueOf(String.valueOf(this.hashCode())).concat(String.valueOf(String.valueOf(string))), object);
    }

    public boolean hasResource(String string) {
        return EdgeLabel.hasClassResource(string) || EdgeLabel.hasClassResource(String.valueOf(String.valueOf(this.hashCode())).concat(String.valueOf(String.valueOf(string))));
    }

    public Edge getOwner() {
        return this.owner;
    }

    public BaseObject getContainer() {
        return this.getOwner();
    }

    protected void setOwner(Edge edge) {
        if (this.owner != edge) {
            this.firePropertyChanging("owner");
            this.owner = edge;
            this.firePropertyChanged("owner");
        }
    }

    public GraphMember.Type getType() {
        return GraphMember.EDGE_LABEL;
    }

    public final int getClassCode() {
        return 64;
    }

    public LabelPalette getLabelPalette() {
        return this.palette == null ? EdgeLabelPalette.INSTANCE : this.palette;
    }

    public void setLabelPalette(LabelPalette labelPalette) {
        this.firePropertyChanging("palette");
        this.palette = labelPalette;
        this.getPainter().init(this);
        this.firePropertyChanged("palette");
    }

    public boolean isPaletteSet() {
        return this.palette != null;
    }

    public Palette getPalette() {
        return this.getLabelPalette();
    }

    public void setPalette(Palette palette) {
        this.setLabelPalette((LabelPalette)palette);
    }

    public Color getStrokeColor() {
        if (this.isDragged()) {
            return this.getLabelPalette().getGhostedStrokeColor();
        }
        if (this.isSelected()) {
            return this.getLabelPalette().getSelectedStrokeColor();
        }
        return this.getLabelPalette().getPlainStrokeColor();
    }

    public Color getFillColor() {
        if (this.isSelected()) {
            return this.getLabelPalette().getSelectedFillColor();
        }
        return this.getLabelPalette().getPlainFillColor();
    }

    public Color getTextColor() {
        if (this.isSelected()) {
            return this.getLabelPalette().getSelectedTextColor();
        }
        return this.getLabelPalette().getPlainTextColor();
    }

    public Font getFont() {
        return this.getLabelPalette().getFont();
    }

    public Insets getInsets() {
        return this.getLabelPalette().getInsets();
    }

    public int getTextAlignment() {
        return this.getLabelPalette().getTextAlignment();
    }

    public boolean isStroked() {
        return this.getLabelPalette().isStroked();
    }

    public boolean isFilled() {
        return this.getLabelPalette().isFilled();
    }

    public int getStrokeWidth() {
        return this.getLabelPalette().getStrokeWidth();
    }

    protected void onInsert(Edge edge) {
        this.setOwner(edge);
        this.setOwned(true);
        this.correctBounds();
        edge.onChildBoundsGained(this);
    }

    protected void onRemove(Edge edge) {
        edge.onChildBoundsLost(this);
        this.setOwned(false);
        this.setOwner(null);
    }

    public ObjectChangeManager getObjectChangeManager() {
        return this.isOwned() ? this.getOwner().getObjectChangeManager() : null;
    }

    public double getDistanceFromSource() {
        return this.dist;
    }

    public double getOffsetX() {
        return this.xOff;
    }

    public double getOffsetY() {
        return this.yOff;
    }

    public double getAttachmentY() {
        double d = 0.0;
        if (this.isOwned()) {
            Edge edge = this.getOwner();
            if (this.getDistanceFromSource() <= 0.0) {
                d = edge.getSourceY();
            } else if (this.getDistanceFromSource() >= 1.0) {
                d = edge.getTargetY();
            } else {
                double d2;
                double d3;
                double d4 = edge.getSourceX();
                double d5 = edge.getSourceY();
                double d6 = d4;
                double d7 = d5;
                double d8 = 0.0;
                Iterator iterator = edge.bends().iterator();
                for (d3 = edge.length() * this.getDistanceFromSource(); iterator.hasNext() && d3 > 0.0; d3 -= d8) {
                    d6 = d4;
                    d7 = d5;
                    Bend bend = (Bend)iterator.next();
                    d4 = bend.getCenterX();
                    d5 = bend.getCenterY();
                    d8 = Math.sqrt((d4 - d6) * (d4 - d6) + (d5 - d7) * (d5 - d7));
                }
                if (d3 <= 0.0) {
                    d3 += d8;
                } else {
                    d6 = d4;
                    d7 = d5;
                    d4 = edge.getTargetX();
                    d5 = edge.getTargetY();
                    d8 = Math.sqrt((d4 - d6) * (d4 - d6) + (d5 - d7) * (d5 - d7));
                }
                double d9 = d2 = d8 > 0.0 ? d3 / d8 : 0.0;
                d = d2 <= 0.0 ? d7 : (d2 >= 1.0 ? d5 : d7 + d2 * (d5 - d7));
            }
        }
        return d;
    }

    public double getAttachmentX() {
        double d = 0.0;
        if (this.isOwned()) {
            Edge edge = this.getOwner();
            if (this.getDistanceFromSource() <= 0.0) {
                d = edge.getSourceX();
            } else if (this.getDistanceFromSource() >= 1.0) {
                d = edge.getTargetX();
            } else {
                double d2;
                double d3;
                double d4 = edge.getSourceX();
                double d5 = edge.getSourceY();
                double d6 = d4;
                double d7 = d5;
                double d8 = 0.0;
                Iterator iterator = edge.bends().iterator();
                for (d3 = edge.length() * this.getDistanceFromSource(); iterator.hasNext() && d3 > 0.0; d3 -= d8) {
                    d6 = d4;
                    d7 = d5;
                    Bend bend = (Bend)iterator.next();
                    d4 = bend.getCenterX();
                    d5 = bend.getCenterY();
                    d8 = Math.sqrt((d4 - d6) * (d4 - d6) + (d5 - d7) * (d5 - d7));
                }
                if (d3 <= 0.0) {
                    d3 += d8;
                } else {
                    d6 = d4;
                    d7 = d5;
                    d4 = edge.getTargetX();
                    d5 = edge.getTargetY();
                    d8 = Math.sqrt((d4 - d6) * (d4 - d6) + (d5 - d7) * (d5 - d7));
                }
                double d9 = d2 = d8 > 0.0 ? d3 / d8 : 0.0;
                d = d2 <= 0.0 ? d6 : (d2 >= 1.0 ? d4 : d6 + d2 * (d4 - d6));
            }
        }
        return d;
    }

    public void setDistanceFromSource(double d) {
        if (d != this.dist) {
            this.firePropertyChanging("distanceFromSource");
            this.dist = d;
            if (this.isOwned()) {
                double d2 = this.getAttachmentX() + this.getOffsetX();
                double d3 = this.getAttachmentY() + this.getOffsetY();
                if (d2 != this.getCenterX() || d3 != this.getCenterY()) {
                    int n = this.getOwner().getContactSides(this);
                    this.placeAt(d2, d3);
                    this.getOwner().onChildBoundsAltered(n, this);
                }
            }
            this.firePropertyChanged("distanceFromSource");
        }
    }

    public void setOffsetX(double d) {
        double d2 = d - this.xOff;
        if (d2 != 0.0) {
            this.firePropertyChanging("offsetX");
            this.xOff = d;
            if (this.isOwned()) {
                int n = this.getOwner().getContactSides(this);
                this.translate(d2, 0.0);
                this.getOwner().onChildBoundsAltered(n, this);
            }
            this.firePropertyChanged("offsetX");
        }
    }

    public void setOffsetY(double d) {
        double d2 = d - this.yOff;
        if (d2 != 0.0) {
            this.firePropertyChanging("offsetY");
            this.yOff = d;
            if (this.isOwned()) {
                int n = this.getOwner().getContactSides(this);
                this.translate(0.0, d2);
                this.getOwner().onChildBoundsAltered(n, this);
            }
            this.firePropertyChanged("offsetY");
        }
    }

    public void setSize(double d, double d2) {
        if (d != this.getWidth() || d2 != this.getHeight()) {
            this.firePropertyChanging("bounds");
            if (!this.isOwned()) {
                this.resize(d, d2);
            } else {
                int n = this.getOwner().getContactSides(this);
                this.resize(d, d2);
                this.getOwner().onChildBoundsAltered(n, this);
            }
            this.firePropertyChanged("bounds");
        }
    }

    public void setCenter(FixedPoint2D fixedPoint2D) {
        this.setCenter(fixedPoint2D.getX(), fixedPoint2D.getY());
    }

    public void setCenter(double d, double d2) {
        if (d != this.getCenterX() || d2 != this.getCenterY()) {
            this.firePropertyChanging("bounds");
            if (!this.isOwned()) {
                this.moveTo(d, d2);
            } else {
                int n = this.getOwner().getContactSides(this);
                this.moveTo(d, d2);
                this.getOwner().onChildBoundsAltered(n, this);
            }
            this.firePropertyChanged("bounds");
        }
    }

    protected void moveTo(double d, double d2) {
        if (d != this.getCenterX() || d2 != this.getCenterY()) {
            this.placeAt(d, d2);
            if (this.isOwned()) {
                Edge edge = this.getOwner();
                double d3 = edge.getSourceX();
                double d4 = edge.getSourceY();
                double d5 = Double.POSITIVE_INFINITY;
                double d6 = d3;
                double d7 = d4;
                double d8 = 0.0;
                double d9 = 0.0;
                Iterator iterator = edge.bends().iterator();
                boolean bl = true;
                while (bl) {
                    double d10;
                    double d11;
                    double d12;
                    double d13 = d3;
                    double d14 = d4;
                    if (iterator.hasNext()) {
                        Bend bend = (Bend)iterator.next();
                        d3 = bend.getCenterX();
                        d4 = bend.getCenterY();
                    } else {
                        d3 = edge.getTargetX();
                        d4 = edge.getTargetY();
                        bl = false;
                    }
                    double d15 = d3 - d13;
                    double d16 = d4 - d14;
                    double d17 = d15 * d15 + d16 * d16;
                    double d18 = d12 = d17 == 0.0 ? 0.0 : ((d - d13) * d15 + (d2 - d14) * d16) / d17;
                    if (d12 <= 0.0) {
                        d12 = 0.0;
                        d11 = d13;
                        d10 = d14;
                    } else if (d12 >= 1.0) {
                        d12 = 1.0;
                        d11 = d3;
                        d10 = d4;
                    } else {
                        d11 = d13 + d12 * d15;
                        d10 = d14 + d12 * d16;
                    }
                    d17 = Math.sqrt(d17);
                    double d19 = d12 * d17;
                    double d20 = Math.sqrt((d - d11) * (d - d11) + (d2 - d10) * (d2 - d10));
                    if (d20 < d5) {
                        d5 = d20;
                        d6 = d11;
                        d7 = d10;
                        d9 = d8 + d19;
                    }
                    d8 += d17;
                }
                this.dist = d9 <= 0.0 ? 0.0 : Math.min(1.0, d9 / d8);
                this.xOff = d - d6;
                this.yOff = d2 - d7;
            }
        }
    }

    public void updateBounds() {
    }

    protected boolean correctBounds() {
        double d = this.getAttachmentX() + this.getOffsetX();
        double d2 = this.getAttachmentY() + this.getOffsetY();
        if (d == this.getCenterX() && d2 == this.getCenterY()) {
            return false;
        }
        this.placeAt(d, d2);
        return true;
    }

    public Object clone() {
        EdgeLabel edgeLabel = (EdgeLabel)super.clone();
        edgeLabel.owner = null;
        return edgeLabel;
    }

    public String toString() {
        return this.getText() != null ? this.getText() : String.valueOf(String.valueOf(EsperStrings.string(54))).concat(String.valueOf(String.valueOf(this.hashCode())));
    }

    public void setLabelPainter(BaseObjectPainter baseObjectPainter) {
        this.setPainter(baseObjectPainter);
    }
}

