/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model;

import com.cisco.nm.EsperStrings;
import com.cisco.nm.esper.model.BaseObjectPainter;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.palette.Palette;
import com.cisco.nm.esper.shape.Bounds;
import java.awt.Graphics;
import java.awt.Rectangle;

public interface GraphMember {
    public static final Type GRAPH = new Type(EsperStrings.string(55));
    public static final Type EDGE = new Type(EsperStrings.string(53));
    public static final Type NODE = new Type(EsperStrings.string(56));
    public static final Type BEND = new Type(EsperStrings.string(51));
    public static final Type EDGE_LABEL = new Type(EsperStrings.string(54));
    public static final Type NODE_LABEL = new Type(EsperStrings.string(57));
    public static final Type CONNECTOR = new Type(EsperStrings.string(52));

    public void paint(Graphics var1, Transform var2);

    public boolean intersects(Rectangle var1, Transform var2);

    public Rectangle getPaintBounds(Transform var1, Rectangle var2);

    public int getHitCode(int var1, int var2, Transform var3);

    public BaseObjectPainter getPainter();

    public void setPainter(BaseObjectPainter var1);

    public boolean isPainterSet();

    public Palette getPalette();

    public void setPalette(Palette var1);

    public boolean isSelected();

    public boolean isDragged();

    public boolean isVisible();

    public void setSelected(boolean var1);

    public void setDragged(boolean var1);

    public void setVisible(boolean var1);

    public double getLeft();

    public double getRight();

    public double getBottom();

    public double getTop();

    public double getCenterX();

    public double getCenterY();

    public Bounds getBounds();

    public Bounds getBounds(Bounds var1);

    public void updateBounds();

    public Object getResource(String var1);

    public boolean isOwned();

    public Type getType();

    public Object getParent();

    public String getText();

    public void setText(String var1);

    public static class Type {
        private String desc;
        private Type parent;

        public Type(String string) {
            if (string == null) {
                EsperStrings.illegalArgument(40);
            }
            this.desc = string;
            this.parent = null;
        }

        public Type(Type type, String string) {
            this(string);
            if (type == null) {
                EsperStrings.illegalArgument(41);
            }
            this.parent = type;
        }

        public Type getSuperType() {
            return this.parent;
        }

        public boolean isInstanceOf(Type type) {
            if (type == null) {
                return false;
            }
            if (type == this) {
                return true;
            }
            for (Type type2 = this.getSuperType(); type2 != null; type2 = type2.getSuperType()) {
                if (type2 != type) continue;
                return true;
            }
            return false;
        }

        public String getDescriptor() {
            return this.desc;
        }

        public String toString() {
            if (this.getSuperType() == null) {
                return this.desc;
            }
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getSuperType().toString()))).append("/").append(this.getDescriptor())));
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (!(object instanceof Type)) {
                bl = false;
            } else {
                Type type = (Type)object;
                bl = !type.desc.equals(this.desc) ? false : (this.getSuperType() != null ? this.getSuperType().equals(type.getSuperType()) : type.getSuperType() == null);
            }
            return bl;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

