/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model;

import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.shape.Bounds;

public class ResizeControl {
    public static final int IDLE = 1;
    public static final int ACTIVE = 2;
    private int state = 1;
    private Node node;
    private int grip;
    private double offX;
    private double offY;
    private double startX;
    private double startY;
    private Bounds original;
    private double minWidth;
    private double minHeight;

    public ResizeControl() {
        this.setMinimumSize(1.0, 1.0);
    }

    public void setMinimumSize(double d, double d2) {
        this.minWidth = Math.max(0.0, d);
        this.minHeight = Math.max(0.0, d2);
    }

    public void init(Node node, int n) {
        this.grip = n;
        this.node = node;
        this.original = node.getIconBounds();
    }

    public synchronized void onStartAt(double d, double d2) {
        if (this.state == 1) {
            this.startX = d;
            this.startY = d2;
            this.state = 2;
            this.offY = 0.0;
            this.offX = 0.0;
            switch (this.grip) {
                case 7: {
                    this.offX = this.original.getRight() - d;
                }
                case 8: {
                    this.offY = this.original.getTop() - d2;
                    break;
                }
                case 6: {
                    this.offY = this.original.getTop() - d2;
                }
                case 10: {
                    this.offX = this.original.getLeft() - d;
                    break;
                }
                case 4: {
                    this.offX = this.original.getLeft() - d;
                }
                case 9: {
                    this.offY = this.original.getBottom() - d2;
                    break;
                }
                case 5: {
                    this.offY = this.original.getBottom() - d2;
                }
                case 11: {
                    this.offX = this.original.getRight() - d;
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal resize type.");
                }
            }
        }
    }

    public synchronized void onDragTo(double d, double d2) {
        if (this.state == 2) {
            d += this.offX;
            d2 += this.offY;
            double d3 = this.node.getLeft();
            double d4 = this.node.getRight();
            double d5 = this.node.getTop();
            double d6 = this.node.getBottom();
            switch (this.grip) {
                case 7: {
                    d4 = d <= d3 + this.minWidth ? d3 + this.minWidth : d;
                }
                case 8: {
                    d5 = d2 <= d6 + this.minHeight ? d6 + this.minHeight : d2;
                    break;
                }
                case 5: {
                    d6 = d2 >= d5 - this.minHeight ? d5 - this.minHeight : d2;
                }
                case 11: {
                    d4 = d <= d3 + this.minWidth ? d3 + this.minWidth : d;
                    break;
                }
                case 4: {
                    d3 = d >= d4 - this.minWidth ? d4 - this.minWidth : d;
                }
                case 9: {
                    d6 = d2 >= d5 - this.minHeight ? d5 - this.minHeight : d2;
                    break;
                }
                case 6: {
                    d5 = d2 <= d6 + this.minHeight ? d6 + this.minHeight : d2;
                }
                case 10: {
                    d3 = d >= d4 - this.minWidth ? d4 - this.minWidth : d;
                    break;
                }
                default: {
                    throw new InternalError(Integer.toString(this.grip));
                }
            }
            this.node.stretch(d3, d6, d4, d5);
        }
    }

    public synchronized void onDropAt(double d, double d2) {
        if (this.state == 2) {
            this.onDragTo(d, d2);
            this.node.updateBounds();
            this.state = 1;
        }
    }

    public synchronized void onCancel() {
        if (this.state == 2) {
            this.node.stretch(this.original.getLeft(), this.original.getBottom(), this.original.getRight(), this.original.getTop());
            this.state = 1;
        }
    }

    private void check(int n) {
        if (n < 4 || n > 11) {
            throw new IllegalArgumentException("Invalid side specification ".concat(String.valueOf(String.valueOf(n))));
        }
    }

    static {
        IDLE = 1;
        ACTIVE = 2;
    }
}

