/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model;

import com.cisco.nm.esper.lib.OwnedArrayList;
import com.cisco.nm.esper.lib.OwnedList;
import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.Bend;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.EdgeLabel;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.GraphObject;
import com.cisco.nm.esper.model.GraphSubset;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.NodeLabel;
import java.util.Iterator;

public class Selection
implements Cloneable,
GraphSubset {
    public static final int NODES = 1;
    public static final int EDGES = 2;
    public static final int GRAPHS = 4;
    public static final int NODE_LABELS = 8;
    public static final int EDGE_LABELS = 16;
    public static final int BENDS = 32;
    public static final int ALL = 63;
    private Graph owner;
    private OwnedArrayList nodes;
    private OwnedArrayList edges;
    private OwnedArrayList bends;
    private OwnedArrayList nodeLabels;
    private OwnedArrayList edgeLabels;
    private OwnedArrayList graphs;

    public Selection() {
        this(null);
    }

    public Selection(Graph graph) {
        this.setOwner(graph);
        this.bends = new OwnedArrayList();
        this.edges = new OwnedArrayList();
        this.edgeLabels = new OwnedArrayList();
        this.nodes = new OwnedArrayList();
        this.nodeLabels = new OwnedArrayList();
        this.graphs = new OwnedArrayList();
    }

    public Graph getOwner() {
        return this.owner;
    }

    protected void setOwner(Graph graph) {
        this.owner = graph;
    }

    public boolean isEmpty() {
        return this.nodes().size() <= 0 && this.edges().size() <= 0 && this.graphs().size() <= 0 && this.edgeLabels().size() <= 0 && this.nodeLabels().size() <= 0 && this.bends().size() <= 0;
    }

    public OwnedList nodes() {
        return this.nodes;
    }

    public OwnedList edges() {
        return this.edges;
    }

    public OwnedList edgeLabels() {
        return this.edgeLabels;
    }

    public OwnedList nodeLabels() {
        return this.nodeLabels;
    }

    public OwnedList bends() {
        return this.bends;
    }

    public OwnedList graphs() {
        return this.graphs;
    }

    public boolean select(int n) {
        BaseObject baseObject;
        Iterator iterator;
        GraphObject graphObject;
        Iterator iterator2;
        boolean bl = false;
        if ((n & 1) != 0) {
            iterator2 = this.owner.nodes().iterator();
            while (iterator2.hasNext()) {
                graphObject = (Node)iterator2.next();
                if (graphObject.isSelected()) continue;
                graphObject.setSelected(true);
                bl = true;
            }
        }
        if ((n & 2) != 0) {
            iterator2 = this.owner.edges().iterator();
            while (iterator2.hasNext()) {
                graphObject = (Edge)iterator2.next();
                if (graphObject.isSelected()) continue;
                graphObject.setSelected(true);
                bl = true;
            }
        }
        if ((n & 4) != 0) {
            iterator2 = this.owner.graphs().iterator();
            while (iterator2.hasNext()) {
                graphObject = (Graph)iterator2.next();
                if (graphObject.isSelected()) continue;
                graphObject.setSelected(true);
                bl = true;
            }
        }
        if ((n & 0x10) != 0 && this.owner.getEdgeLabelCount() > 0) {
            iterator2 = this.owner.edges().iterator();
            while (iterator2.hasNext()) {
                graphObject = (Edge)iterator2.next();
                iterator = ((Edge)graphObject).labels().iterator();
                while (iterator.hasNext()) {
                    baseObject = (EdgeLabel)iterator.next();
                    if (baseObject.isSelected()) continue;
                    baseObject.setSelected(true);
                    bl = true;
                }
            }
        }
        if ((n & 8) != 0 && this.owner.getNodeLabelCount() > 0) {
            iterator2 = this.owner.nodes().iterator();
            while (iterator2.hasNext()) {
                graphObject = (Node)iterator2.next();
                iterator = ((Node)graphObject).labels().iterator();
                while (iterator.hasNext()) {
                    baseObject = (NodeLabel)iterator.next();
                    if (baseObject.isSelected()) continue;
                    baseObject.setSelected(true);
                    bl = true;
                }
            }
        }
        if ((n & 0x20) != 0 && this.owner.getBendCount() > 0) {
            iterator2 = this.owner.edges().iterator();
            while (iterator2.hasNext()) {
                graphObject = (Edge)iterator2.next();
                iterator = ((Edge)graphObject).bends().iterator();
                while (iterator.hasNext()) {
                    baseObject = (Bend)iterator.next();
                    if (baseObject.isSelected()) continue;
                    baseObject.setSelected(true);
                    bl = true;
                }
            }
        }
        return bl;
    }

    public void clear() {
        int n;
        for (n = this.nodes.size() - 1; n >= 0; --n) {
            ((Node)this.nodes.get(n)).setSelected(false);
        }
        for (n = this.edges.size() - 1; n >= 0; --n) {
            ((Edge)this.edges.get(n)).setSelected(false);
        }
        for (n = this.graphs.size() - 1; n >= 0; --n) {
            ((Graph)this.graphs.get(n)).setSelected(false);
        }
        for (n = this.edgeLabels.size() - 1; n >= 0; --n) {
            ((EdgeLabel)this.edgeLabels.get(n)).setSelected(false);
        }
        for (n = this.nodeLabels.size() - 1; n >= 0; --n) {
            ((NodeLabel)this.nodeLabels.get(n)).setSelected(false);
        }
        for (n = this.bends.size() - 1; n >= 0; --n) {
            ((Bend)this.bends.get(n)).setSelected(false);
        }
    }

    protected void onChange(BaseObject baseObject) {
        if (baseObject.isSelected()) {
            this.add(baseObject);
        } else {
            this.remove(baseObject);
        }
    }

    protected void remove(BaseObject baseObject) {
        this.getListOf(baseObject).remove(baseObject);
    }

    protected void add(BaseObject baseObject) {
        this.getListOf(baseObject).add(baseObject);
    }

    protected OwnedArrayList getListOf(BaseObject baseObject) {
        OwnedArrayList ownedArrayList = null;
        switch (baseObject.getClassCode()) {
            case 1: {
                ownedArrayList = this.nodes;
                break;
            }
            case 2: {
                ownedArrayList = this.edges;
                break;
            }
            case 4: {
                ownedArrayList = this.graphs;
                break;
            }
            case 64: {
                ownedArrayList = this.edgeLabels;
                break;
            }
            case 32: {
                ownedArrayList = this.nodeLabels;
                break;
            }
            case 8: {
                ownedArrayList = this.bends;
            }
        }
        return ownedArrayList;
    }

    static {
        NODES = 1;
        EDGES = 2;
        GRAPHS = 4;
        NODE_LABELS = 8;
        EDGE_LABELS = 16;
        BENDS = 32;
        ALL = 63;
    }
}

