/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model;

import com.cisco.nm.esper.model.palette.GridPalette;
import com.cisco.nm.esper.model.palette.Palette;
import java.awt.Color;

public class Transform
extends com.cisco.nm.esper.shape.Transform {
    private GridPalette palette;
    private boolean scaled = true;

    public double xToWorld(int n) {
        double d = super.xToWorld(n);
        if (this.isGridEnabled()) {
            d = this.getNearestGridX(d);
        }
        return d;
    }

    public double yToWorld(int n) {
        double d = super.yToWorld(n);
        if (this.isGridEnabled()) {
            d = this.getNearestGridY(d);
        }
        return d;
    }

    public void setGridPalette(GridPalette gridPalette) {
        this.palette = gridPalette;
    }

    public GridPalette getGridPalette() {
        return this.palette == null ? GridPalette.INSTANCE : this.palette;
    }

    public boolean isPaletteSet() {
        return this.palette != null;
    }

    public Palette getPalette() {
        return this.getGridPalette();
    }

    public void setPalette(Palette palette) {
        this.setGridPalette((GridPalette)palette);
    }

    public double getNearestGridX(double d) {
        double d2 = this.getHorizontalStep();
        double d3 = d % d2;
        if (d3 < 0.0) {
            return -2.0 * d3 > d2 ? d - d3 - d2 : d - d3;
        }
        return 2.0 * d3 >= d2 ? d - d3 + d2 : d - d3;
    }

    public double getNearestGridY(double d) {
        double d2 = this.getVerticalStep();
        double d3 = d % d2;
        if (d3 < 0.0) {
            return -2.0 * d3 > d2 ? d - d3 - d2 : d - d3;
        }
        return 2.0 * d3 >= d2 ? d - d3 + d2 : d - d3;
    }

    public int getHorizontalStep() {
        return this.getGridPalette().getHorizontalStep();
    }

    public int getVerticalStep() {
        return this.getGridPalette().getVerticalStep();
    }

    public Color getMinorDotColor() {
        return this.getGridPalette().getMinorDotColor();
    }

    public Color getMajorDotColor() {
        return this.getGridPalette().getMajorDotColor();
    }

    public Color getCrossMarkColor() {
        return this.getGridPalette().getCrossMarkColor();
    }

    public boolean isGridEnabled() {
        return this.getGridPalette().isEnabled();
    }

    public boolean isForegroundScaled() {
        return this.scaled;
    }

    public void setForegroundScaled(boolean bl) {
        this.scaled = bl;
    }
}

