/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model.palette;

import com.cisco.nm.EsperStrings;
import com.cisco.nm.esper.model.palette.Palette;
import com.cisco.nm.lib.winkit.RichColor;
import java.awt.Color;

public class EdgePalette
extends Palette {
    public static final EdgePalette INSTANCE = new EdgePalette();
    public static final int NO_ARROW = 0;
    public static final int SOURCE_ARROW = 1;
    public static final int TARGET_ARROW = 2;
    public static final int SOURCE_AND_TARGET_ARROW = 3;
    public static final int MIN_SELECTOR = 0;
    public static final int LOOSE = 0;
    public static final int INNERGRAPH = 1;
    public static final int INTERGRAPH = 2;
    public static final int MAX_SELECTOR = 2;
    private Color[] plainClr = new Color[]{Color.orange, Color.black, RichColor.navy};
    private Color[] selectedClr = new Color[]{Color.red, Color.blue, RichColor.darkgreen};
    private Color[] outlineClr = new Color[]{Color.lightGray, Color.gray, Color.gray};
    private int[] thickness = new int[]{1, 1, 1};
    private int[] arrowWidth = new int[]{5, 5, 5};
    private int[] arrowHeight = new int[]{6, 6, 6};
    private int[] arrowType = new int[]{2, 2, 2};
    private float[][] pattern = new float[][]{null, null, null};
    private int joins = 0;
    private static Editor editor;

    public EdgePalette() {
        this(null);
    }

    public EdgePalette(String string) {
        super(string);
    }

    public static Editor getEditor() {
        return editor;
    }

    public static void setEditor(Editor editor) {
        EdgePalette.editor = editor;
    }

    public Color getPlainStrokeColor(int n) {
        this.checkSelector(n);
        return this.plainClr[n];
    }

    public Color getSelectedStrokeColor(int n) {
        this.checkSelector(n);
        return this.selectedClr[n];
    }

    public Color getDraggedStrokeColor(int n) {
        this.checkSelector(n);
        return this.outlineClr[n];
    }

    public int getStrokeWidth(int n) {
        this.checkSelector(n);
        return this.thickness[n];
    }

    public int getArrowWidth(int n) {
        this.checkSelector(n);
        return this.arrowWidth[n];
    }

    public int getArrowHeight(int n) {
        this.checkSelector(n);
        return this.arrowHeight[n];
    }

    public int getArrowType(int n) {
        this.checkSelector(n);
        return this.arrowType[n];
    }

    public float[] getPattern(int n) {
        this.checkSelector(n);
        return this.pattern[n];
    }

    public void setPlainStrokeColor(int n, Color color) {
        this.checkSelector(n);
        this.plainClr[n] = color;
    }

    public void setSelectedStrokeColor(int n, Color color) {
        this.checkSelector(n);
        this.selectedClr[n] = color;
    }

    public void setDraggedStrokeColor(int n, Color color) {
        this.checkSelector(n);
        this.outlineClr[n] = color;
    }

    public void setStrokeWidth(int n, int n2) {
        this.checkSelector(n);
        this.thickness[n] = n2;
    }

    public void setArrowWidth(int n, int n2) {
        this.checkSelector(n);
        this.arrowWidth[n] = n2;
    }

    public void setArrowHeight(int n, int n2) {
        this.checkSelector(n);
        this.arrowHeight[n] = n2;
    }

    public void setArrowType(int n, int n2) {
        this.checkSelector(n);
        this.arrowType[n] = n2 & 3;
    }

    public void setPattern(int n, float[] fArray) {
        this.checkSelector(n);
        if (fArray == null || fArray.length <= 1) {
            this.pattern[n] = null;
        } else {
            this.pattern[n] = new float[fArray.length];
            System.arraycopy(fArray, 0, this.pattern[n], 0, fArray.length);
        }
    }

    public int getLineJoins() {
        return this.joins;
    }

    public void setLineJoins(int n) {
        if (n != 2 && n != 0 && n != 1) {
            EsperStrings.illegalArgument(9, n);
        }
        this.joins = n;
    }

    public void copy(Palette palette) {
        if (palette instanceof EdgePalette) {
            EdgePalette edgePalette = (EdgePalette)palette;
            for (int i = 0; i <= 2; ++i) {
                this.setArrowHeight(i, edgePalette.getArrowHeight(i));
                this.setArrowType(i, edgePalette.getArrowType(i));
                this.setArrowWidth(i, edgePalette.getArrowWidth(i));
                this.setDraggedStrokeColor(i, edgePalette.getDraggedStrokeColor(i));
                this.setPlainStrokeColor(i, edgePalette.getPlainStrokeColor(i));
                this.setSelectedStrokeColor(i, edgePalette.getSelectedStrokeColor(i));
                this.setStrokeWidth(i, edgePalette.getStrokeWidth(i));
                this.setPattern(i, edgePalette.getPattern(i));
            }
            this.setLineJoins(edgePalette.getLineJoins());
        }
    }

    private void checkSelector(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Illegal edge state selector: ".concat(String.valueOf(String.valueOf(n))));
        }
    }

    static {
        NO_ARROW = 0;
        SOURCE_ARROW = 1;
        TARGET_ARROW = 2;
        SOURCE_AND_TARGET_ARROW = 3;
        MIN_SELECTOR = 0;
        LOOSE = 0;
        INNERGRAPH = 1;
        INTERGRAPH = 2;
        MAX_SELECTOR = 2;
    }

    public static interface Editor {
        public boolean edit(EdgePalette var1);
    }
}

