/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model.palette;

import com.cisco.nm.esper.model.palette.Palette;
import com.cisco.nm.esper.model.palette.TextPalette;
import com.cisco.nm.lib.winkit.RichColor;
import java.awt.Color;

public class GraphPalette
extends TextPalette {
    public static final GraphPalette INSTANCE = new GraphPalette();
    private static Editor editor;
    private Color cllpsStroke = new Color(0x666699);
    private Color cllpsFill = RichColor.skyblue;
    private Color plainBorderColor = Color.black;
    private Color selectedBorderColor = RichColor.green;
    private Color activeBorderColor = Color.red;

    public GraphPalette() {
        this(null);
    }

    public GraphPalette(String string) {
        super(string);
        this.setFilled(true);
        this.setStroked(true);
        this.setStrokeWidth(2);
        this.setPlainStrokeColor(new Color(0x6666CC));
        this.setPlainFillColor(RichColor.ivory);
        this.setSelectedFillColor(RichColor.ivory);
    }

    public static Editor getEditor() {
        return editor;
    }

    public static void setEditor(Editor editor) {
        GraphPalette.editor = editor;
    }

    public Color getPlainBorderColor() {
        return this.plainBorderColor;
    }

    public void setPlainBorderColor(Color color) {
        this.plainBorderColor = color;
    }

    public Color getSelectedBorderColor() {
        return this.selectedBorderColor;
    }

    public void setSelectedBorderColor(Color color) {
        this.selectedBorderColor = color;
    }

    public Color getActiveBorderColor() {
        return this.activeBorderColor;
    }

    public void setActiveBorderColor(Color color) {
        this.activeBorderColor = color;
    }

    public Color getCollapsedFillColor() {
        return this.cllpsFill;
    }

    public Color getCollapsedStrokeColor() {
        return this.cllpsStroke;
    }

    public void setCollapsedFillColor(Color color) {
        this.cllpsFill = color;
    }

    public void setCollapsedStrokeColor(Color color) {
        this.cllpsStroke = color;
    }

    public void copy(Palette palette) {
        if (palette instanceof GraphPalette) {
            GraphPalette graphPalette = (GraphPalette)palette;
            this.setCollapsedFillColor(graphPalette.getCollapsedFillColor());
            this.setCollapsedStrokeColor(graphPalette.getCollapsedStrokeColor());
            this.setPlainBorderColor(graphPalette.getPlainBorderColor());
            this.setActiveBorderColor(graphPalette.getActiveBorderColor());
            this.setSelectedBorderColor(graphPalette.getSelectedBorderColor());
        }
        super.copy(palette);
    }

    public static interface Editor {
        public boolean edit(GraphPalette var1);
    }
}

