/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model.palette;

import com.cisco.nm.EsperStrings;
import com.cisco.nm.esper.model.palette.AreaPalette;
import com.cisco.nm.esper.model.palette.Palette;
import com.cisco.nm.lib.winkit.RichColor;
import java.awt.Color;
import java.awt.Font;

public class TextPalette
extends AreaPalette {
    public static final int LEFT = 0;
    public static final int RIGHT = 2;
    public static final int CENTER = 1;
    private Font _font;
    private Color _plnTxtClr;
    private Color _selTxtClr;
    private int justification;
    private boolean annotated;

    public TextPalette() {
        this(null);
    }

    public TextPalette(String string) {
        super(string);
        this.setTextAlignment(1);
        this.setPlainTextColor(RichColor.navy);
        this.setSelectedTextColor(RichColor.navy);
        this.setSelectedFillColor(new Color(0x9999CC));
        this.setFont(new Font("serif", 0, 11));
    }

    public Font getFont() {
        return this._font;
    }

    public void setFont(Font font) {
        this._font = font;
    }

    public Color getPlainTextColor() {
        return this._plnTxtClr;
    }

    public void setPlainTextColor(Color color) {
        this._plnTxtClr = color;
    }

    public Color getSelectedTextColor() {
        return this._selTxtClr;
    }

    public void setSelectedTextColor(Color color) {
        this._selTxtClr = color;
    }

    public int getTextAlignment() {
        return this.justification;
    }

    public void setTextAlignment(int n) {
        if (n != 1 && n != 0 && n != 2) {
            EsperStrings.illegalArgument(10, n);
        }
        this.justification = n;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    public void setAnnotated(boolean bl) {
        this.annotated = bl;
    }

    public void copy(Palette palette) {
        if (palette instanceof TextPalette) {
            TextPalette textPalette = (TextPalette)palette;
            this.setFont(textPalette.getFont());
            this.setSelectedTextColor(textPalette.getSelectedTextColor());
            this.setPlainTextColor(textPalette.getPlainTextColor());
            this.setTextAlignment(textPalette.getTextAlignment());
            this.setAnnotated(textPalette.isAnnotated());
        }
        super.copy(palette);
    }

    static {
        LEFT = 0;
        RIGHT = 2;
        CENTER = 1;
    }
}

