/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model.ui;

import com.cisco.nm.esper.lib.FontRepository;
import com.cisco.nm.esper.lib.graphics.Geometry;
import com.cisco.nm.esper.lib.graphics.Line;
import com.cisco.nm.esper.lib.graphics.LinePool;
import com.cisco.nm.esper.lib.graphics.PointPool;
import com.cisco.nm.esper.lib.graphics.RectPool;
import com.cisco.nm.esper.lib.graphics.StrokePool;
import com.cisco.nm.esper.model.EdgeLabel;
import com.cisco.nm.esper.model.TextDecoration;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.ui.AbstractEdgeLabelPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;

public class DefaultEdgeLabelPainter
extends AbstractEdgeLabelPainter {
    public static final DefaultEdgeLabelPainter INSTANCE = new DefaultEdgeLabelPainter();

    protected void paintOutline(Graphics graphics, EdgeLabel edgeLabel, Transform transform) {
        Line line = LinePool.INSTANCE.checkLineOut();
        Rectangle rectangle = RectPool.INSTANCE.checkRectOut();
        Point point = PointPool.INSTANCE.checkPointOut();
        this.getBounds(edgeLabel, transform, rectangle);
        if (edgeLabel.getOwner() != null) {
            line.setLastPoint(transform.xToDevice(edgeLabel.getAttachmentX()), transform.yToDevice(edgeLabel.getAttachmentY()));
            line.setFirstPoint(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            Point point2 = Geometry.intersection(line, rectangle, point);
            graphics.setColor(edgeLabel.getStrokeColor());
            if (point2 != null) {
                line.setFirstPoint(point2.x, point2.y);
                graphics.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2());
                int n = edgeLabel.getOwner().getStrokeWidth();
                if (transform.isForegroundScaled()) {
                    n = Math.max(1, transform.widthToDevice(n));
                }
                graphics.fillRect(line.getX2() - (n += 2) / 2, line.getY2() - n / 2, n, n);
            }
        }
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        LinePool.INSTANCE.checkLineIn(line);
        RectPool.INSTANCE.checkRectIn(rectangle);
        PointPool.INSTANCE.checkPointIn(point);
    }

    protected void paintDetail(Graphics2D graphics2D, EdgeLabel edgeLabel, Transform transform) {
        Font font = edgeLabel.getFont();
        if (transform.isForegroundScaled()) {
            font = FontRepository.INSTANCE.getScaleFont(font, transform.getScaleX());
        }
        edgeLabel.updateTextMetrics(font == null ? null : graphics2D.getFontMetrics(font), transform.getScaleX());
        Stroke stroke = graphics2D.getStroke();
        Rectangle rectangle = this.getBounds(edgeLabel, transform, RectPool.INSTANCE.checkRectOut());
        if (font == null) {
            Color color = edgeLabel.getTextColor();
            graphics2D.setColor(new Color(Math.min(color.getRed() + 192, 255), Math.min(color.getGreen() + 192, 255), Math.min(color.getBlue() + 192, 255)));
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            graphics2D.setFont(font);
            int n = 0;
            if (edgeLabel.getStrokeWidth() > 0 && edgeLabel.isStroked()) {
                n = edgeLabel.getStrokeWidth();
                if (transform.isForegroundScaled() && n > 0) {
                    n = Math.max(1, transform.widthToDevice(n));
                }
            }
            if (edgeLabel.isStroked()) {
                int n2 = -(n / 2);
                rectangle.grow(n2, n2);
                graphics2D.setStroke(StrokePool.INSTANCE.getStroke(n));
                graphics2D.setColor(edgeLabel.getStrokeColor());
                graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                rectangle.grow(-n - n2, -n - n2);
            } else {
                rectangle.x += edgeLabel.getInsets().left;
                rectangle.y += edgeLabel.getInsets().top;
                rectangle.width -= edgeLabel.getInsets().left + edgeLabel.getInsets().right;
                rectangle.height -= edgeLabel.getInsets().top + edgeLabel.getInsets().bottom;
                rectangle.grow(-n, -n);
            }
            if (edgeLabel.isFilled() || edgeLabel.isSelected()) {
                graphics2D.setColor(edgeLabel.getFillColor());
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
            }
            graphics2D.setColor(edgeLabel.getTextColor());
            if (edgeLabel.isStroked()) {
                rectangle.x += edgeLabel.getInsets().left;
            }
            TextDecoration.TextMetrics textMetrics = edgeLabel.getTextMetrics();
            TextDecoration.LineMetrics[] lineMetricsArray = textMetrics.line;
            for (int i = 0; i < lineMetricsArray.length; ++i) {
                String string = edgeLabel.getFragment(i);
                int n3 = lineMetricsArray[i].width;
                int n4 = rectangle.x;
                if (edgeLabel.getTextAlignment() == 1) {
                    n4 += (rectangle.width - n3) / 2;
                } else if (edgeLabel.getTextAlignment() == 2) {
                    n4 += rectangle.width - n3;
                }
                graphics2D.drawString(string, n4, rectangle.y + textMetrics.ascent);
                rectangle.y += textMetrics.advance;
            }
        }
        RectPool.INSTANCE.checkRectIn(rectangle);
        graphics2D.setStroke(stroke);
    }
}

