/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model.ui;

import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.ui.AbstractGraphPainter;
import com.cisco.nm.esper.model.ui.CollapsedGraphPainter;
import com.cisco.nm.esper.model.ui.ExpandedGraphPainter;
import com.cisco.nm.esper.model.ui.IconGraphPainter;
import com.cisco.nm.esper.model.ui.SilhuetteGraphPainter;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class DefaultGraphPainter
extends AbstractGraphPainter {
    public static final DefaultGraphPainter INSTANCE = new DefaultGraphPainter();
    private ExpandedGraphPainter expanded;
    private CollapsedGraphPainter collapsed;

    public DefaultGraphPainter() {
        this(null, null);
    }

    public DefaultGraphPainter(ExpandedGraphPainter expandedGraphPainter) {
        this(expandedGraphPainter, null);
    }

    public DefaultGraphPainter(CollapsedGraphPainter collapsedGraphPainter) {
        this(null, collapsedGraphPainter);
    }

    public DefaultGraphPainter(ExpandedGraphPainter expandedGraphPainter, CollapsedGraphPainter collapsedGraphPainter) {
        this.expanded = expandedGraphPainter;
        this.collapsed = collapsedGraphPainter;
    }

    protected void paintDetail(Graphics2D graphics2D, Graph graph, Transform transform) {
        if (graph.isExpanded()) {
            this.getExpandedPainter().paintDetail(graphics2D, graph, transform);
        } else {
            this.getCollapsedPainter().paintDetail(graphics2D, graph, transform);
        }
    }

    public ExpandedGraphPainter getExpandedPainter() {
        return this.expanded == null ? SilhuetteGraphPainter.INSTANCE : this.expanded;
    }

    public CollapsedGraphPainter getCollapsedPainter() {
        return this.collapsed == null ? IconGraphPainter.INSTANCE : this.collapsed;
    }

    public void setExpandedPainter(ExpandedGraphPainter expandedGraphPainter) {
        this.expanded = expandedGraphPainter;
    }

    public void setCollapsedPainter(CollapsedGraphPainter collapsedGraphPainter) {
        this.collapsed = collapsedGraphPainter;
    }

    public Rectangle getBounds(Graph graph, Transform transform, Rectangle rectangle) {
        return graph.isExpanded() ? this.getExpandedPainter().getBounds(graph, transform, rectangle) : this.getCollapsedPainter().getBounds(graph, transform, rectangle);
    }

    public boolean intersects(Graph graph, Rectangle rectangle, Transform transform) {
        return graph.isExpanded() ? this.getExpandedPainter().intersects(graph, rectangle, transform) : this.getCollapsedPainter().intersects(graph, rectangle, transform);
    }

    public int getHitCode(Graph graph, int n, int n2, Transform transform) {
        return graph.isExpanded() ? this.getExpandedPainter().getOnGraphLocation(n, n2, graph, transform) : this.getCollapsedPainter().getOnGraphLocation(n, n2, graph, transform);
    }
}

