/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model.ui;

import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.ui.CollapsedGraphPainter;
import com.cisco.nm.esper.model.ui.IconNodePainter;
import com.cisco.nm.lib.Debug;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class IconGraphPainter
extends CollapsedGraphPainter
implements ImageObserver {
    public static final IconGraphPainter INSTANCE = new IconGraphPainter();
    public static final String ICON_NAME = "Cloud.gif";
    private static final MediaTracker tracker;
    private static final int NULL_WIDTH = 64;
    private static final int NULL_HEIGHT = 36;
    private Image image;

    public IconGraphPainter() {
        this.load();
    }

    public Image getIcon() {
        return this.image;
    }

    protected void paintDetail(Graphics2D graphics2D, Graph graph, Transform transform) {
        Image image = this.getIcon();
        int n = transform.xToDevice(graph.getCenterX());
        int n2 = transform.yToDevice(graph.getCenterY());
        if (image == null) {
            graphics2D.setColor(Color.red);
            graphics2D.drawRect(n - 32, n2 - 18, 64, 36);
            graphics2D.drawLine(n - 32, n2 - 18, n + 32, n2 + 18);
            graphics2D.drawLine(n - 32, n2 + 18, n + 32, n2 - 18);
        } else {
            int n3 = image.getWidth(this);
            int n4 = image.getHeight(this);
            if (transform.isForegroundScaled()) {
                n3 = transform.widthToDevice(n3);
                n4 = transform.heightToDevice(n4);
            }
            graphics2D.drawImage(image, n - n3 / 2, n2 - n4 / 2, n3, n4, this);
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0x20) == 0;
    }

    public void init(BaseObject baseObject) {
        if (baseObject instanceof Graph) {
            Graph graph = (Graph)baseObject;
            if (this.image == null) {
                graph.setIconSize(64.0, 36.0);
            } else {
                graph.setIconSize(this.image.getWidth(this), this.image.getHeight(this));
            }
        }
    }

    private void load() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(ICON_NAME);
            if (inputStream == null) {
                Debug.println(5, "Icon Cloud.gif not found");
            } else {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[512];
                while ((n = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                inputStream.close();
                this.image = Toolkit.getDefaultToolkit().createImage(byteArrayOutputStream.toByteArray());
                IconNodePainter.loadImage(this.image);
            }
        }
        catch (IOException iOException) {
            Debug.println(5, "Exception caught while loading graph icon");
            Debug.println(iOException);
        }
    }

    static {
        ICON_NAME = ICON_NAME;
        tracker = new MediaTracker(new Panel());
        NULL_WIDTH = 64;
        NULL_HEIGHT = 36;
    }
}

