/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model.ui;

import com.cisco.nm.esper.lib.graphics.RectPool;
import com.cisco.nm.esper.lib.graphics.StrokePool;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.ui.AbstractNodePainter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;

public class IconNodePainter
extends AbstractNodePainter
implements ImageObserver {
    private static final MediaTracker tracker = new MediaTracker(new Panel());
    private int imgWidth;
    private int imgHeight;
    private Image image;
    private Object source;

    public IconNodePainter() {
        this((Image)null);
    }

    public IconNodePainter(String string) {
        this(Toolkit.getDefaultToolkit().getImage(string));
        this.setImageSource(string);
    }

    public IconNodePainter(URL uRL) {
        this(Toolkit.getDefaultToolkit().getImage(uRL));
        this.setImageSource(uRL);
    }

    public IconNodePainter(Image image) {
        this.setImage(image);
    }

    public void setImage(Image image) {
        Object object;
        this.image = image;
        if (this.image != null && (object = image.getProperty("comment", this)) instanceof String) {
            this.setImageSource(object);
        }
        if ((IconNodePainter.loadImage(this.image) & 8) == 0) {
            this.imgHeight = 0;
            this.imgWidth = 0;
        } else {
            this.imgWidth = this.image.getWidth(this);
            this.imgHeight = this.image.getHeight(this);
        }
    }

    public void setImage(String string) {
        this.setImage(Toolkit.getDefaultToolkit().getImage(string));
        this.setImageSource(string);
    }

    public void setImage(URL uRL) {
        this.setImage(Toolkit.getDefaultToolkit().getImage(uRL));
        this.setImageSource(uRL);
    }

    public Image getImage(Node node) {
        return this.image;
    }

    public int getImageWidth() {
        return this.imgWidth;
    }

    public int getImageHeight() {
        return this.imgHeight;
    }

    public Object getImageSource() {
        return this.source;
    }

    public void setImageSource(Object object) {
        this.source = object;
    }

    public void init(Node node) {
        if (node != null && this.getImage(node) != null) {
            node.setIconSize(this.getImageWidth(), this.getImageHeight());
        }
    }

    protected void paintDetail(Graphics2D graphics2D, Node node, Transform transform) {
        Image image;
        Rectangle rectangle = RectPool.INSTANCE.checkRectOut();
        Stroke stroke = graphics2D.getStroke();
        this.getBounds(node, transform, rectangle);
        int n = Math.max(1, transform.widthToDevice(node.getStrokeWidth()));
        if (node.isFilled()) {
            graphics2D.setColor(node.getFillColor());
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        }
        if ((image = this.getImage(node)) != null) {
            int n2 = this.getImageWidth();
            int n3 = this.getImageHeight();
            if (transform.isForegroundScaled()) {
                n2 = transform.widthToDevice(n2);
                n3 = transform.heightToDevice(n3);
            }
            graphics2D.drawImage(image, rectangle.x + (rectangle.width - n2) / 2, rectangle.y + (rectangle.height - n3) / 2, n2, n3, this);
        }
        if (node.isSelected()) {
            rectangle.grow(-n / 2, -n / 2);
            graphics2D.setColor(node.getCornerColor());
            graphics2D.setStroke(StrokePool.INSTANCE.getStroke(n));
            this.paintCorners(graphics2D, rectangle);
        }
        graphics2D.setStroke(stroke);
        RectPool.INSTANCE.checkRectIn(rectangle);
    }

    public Rectangle getBounds(Node node, Transform transform, Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        if (this.getImage(node) == null) {
            super.getBounds(node, transform, rectangle);
        } else {
            rectangle.width = this.getImageWidth();
            rectangle.height = this.getImageHeight();
            if (transform.isForegroundScaled()) {
                rectangle.width = transform.widthToDevice(rectangle.width);
                rectangle.height = transform.heightToDevice(rectangle.height);
            }
            rectangle.x = transform.xToDevice(node.getIconCenterX()) - rectangle.width / 2;
            rectangle.y = transform.yToDevice(node.getIconCenterY()) - rectangle.height / 2;
        }
        return rectangle;
    }

    public int getHitCode(Node node, int n, int n2, Transform transform) {
        Rectangle rectangle = this.getBounds(node, transform, RectPool.INSTANCE.checkRectOut());
        int n3 = rectangle.contains(n, n2) ? 12 : -1;
        RectPool.INSTANCE.checkRectIn(rectangle);
        return n3;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0x20) == 0;
    }

    public static int loadImage(Image image) {
        if (image == null) {
            return 4;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0, 5000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace(System.err);
            }
            int n = tracker.statusID(0, false);
            tracker.removeImage(image, 0);
            int n2 = n;
            return n2;
        }
    }
}

