/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.overview;

import com.cisco.nm.esper.overview.NewViewTool;
import com.cisco.nm.esper.overview.OverviewCanvasTool;
import com.cisco.nm.esper.overview.ResizeViewTool;
import com.cisco.nm.esper.shape.BoundsDouble;
import java.awt.Cursor;
import java.awt.event.MouseEvent;

public class DefaultOverviewTool
extends OverviewCanvasTool {
    private static final int DRAG = 256;
    private static final int RESIZE = 512;
    private static final int NEWVIEW = 768;
    private double diffX;
    private double diffY;
    private int x;
    private int y;
    private int mode;

    public int getMouseX() {
        return this.x;
    }

    public int getMouseY() {
        return this.y;
    }

    public void setMouseX(int n) {
        this.x = n;
    }

    public void setMouseY(int n) {
        this.y = n;
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.getOverviewCanvas().getCursorType(n, n2);
        if (n3 == 13) {
            this.setMode(256);
            this.diffX = this.getWorldX(n) - this.getOverviewCanvas().getViewBounds().getCenterX();
            this.diffY = this.getWorldY(n2) - this.getOverviewCanvas().getViewBounds().getCenterY();
        } else {
            this.setMouseX(n);
            this.setMouseY(n2);
            if (n3 == 0) {
                this.diffX = 0.0;
                this.diffY = 0.0;
                this.setMode(768);
            } else {
                this.setMode(512 + n3);
            }
        }
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.getMode() == 256) {
            this.getOverviewCanvas().setViewBoundsCenter(this.getWorldX(n) - this.diffX, this.getWorldY(n2) - this.diffY);
            this.getOverviewCanvas().repaint();
        } else if (this.getMode() == 512) {
            this.setChildTool(new ResizeViewTool(this.getModeFlags(), this.getWorldX(this.getMouseX()), this.getWorldY(this.getMouseY())));
        } else if (this.getMode() == 768 && (Math.abs(n - this.getMouseX()) >= 10 || Math.abs(n2 - this.getMouseY()) >= 10)) {
            this.setChildTool(new NewViewTool(this.getMouseX(), this.getMouseY(), n, n2));
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        double d = this.getWorldX(mouseEvent.getX()) - this.diffX;
        double d2 = this.getWorldY(mouseEvent.getY()) - this.diffY;
        if (this.getMode() == 768 && this.getOverviewCanvas().getViewBounds().outcode(d, d2) != 0 || this.getMode() == 256) {
            this.getOverviewCanvas().getGraphComponent().centerInWindow(new BoundsDouble(d - 1.0, d2 - 1.0, d + 1.0, d2 + 1.0), true);
            this.getOverviewCanvas().setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
        this.getOverviewCanvas().setCursor(Cursor.getPredefinedCursor(this.getOverviewCanvas().getCursorType(mouseEvent.getX(), mouseEvent.getY())));
    }

    private void setMode(int n) {
        this.mode = n;
    }

    private int getMode() {
        return this.mode & 0xF00;
    }

    public int getModeFlags() {
        return this.mode & 0xFF;
    }

    static {
        DRAG = 256;
        RESIZE = 512;
        NEWVIEW = 768;
    }
}

