/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.shape;

import com.cisco.nm.esper.shape.Bounds;
import com.cisco.nm.esper.shape.FixedBounds;
import com.cisco.nm.esper.shape.FixedBoundsDouble;
import com.cisco.nm.esper.shape.FixedPoint2D;

public class BoundsDouble
extends FixedBoundsDouble
implements Bounds {
    public BoundsDouble() {
    }

    public BoundsDouble(double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
    }

    public BoundsDouble(FixedBounds fixedBounds) {
        super(fixedBounds);
    }

    public Bounds getBounds() {
        return this;
    }

    public Bounds getBounds(Bounds bounds) {
        if (bounds == null) {
            bounds = (Bounds)this.clone();
        } else {
            bounds.setBounds(this);
        }
        return bounds;
    }

    public void grow(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Double.toString(d));
        }
        if (d != 1.0) {
            this.setSize(this.getWidth() * d, this.getHeight() * d);
        }
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.minX = d;
        this.maxX = d3;
        this.minY = d2;
        this.maxY = d4;
    }

    public void setBounds(FixedBounds fixedBounds) {
        this.setBounds(fixedBounds.getLeft(), fixedBounds.getBottom(), fixedBounds.getRight(), fixedBounds.getTop());
    }

    public void setLeft(double d) {
        this.setBounds(d, this.getBottom(), this.getRight(), this.getTop());
    }

    public void setRight(double d) {
        this.setBounds(this.getLeft(), this.getBottom(), d, this.getTop());
    }

    public void setBottom(double d) {
        this.setBounds(this.getLeft(), d, this.getRight(), this.getTop());
    }

    public void setTop(double d) {
        this.setBounds(this.getLeft(), this.getBottom(), this.getRight(), d);
    }

    public void setSize(double d, double d2) {
        double d3 = this.getLeft() + this.getRight();
        double d4 = this.getTop() + this.getBottom();
        this.setBounds((d3 - d) / 2.0, (d4 - d2) / 2.0, (d3 + d) / 2.0, (d4 + d2) / 2.0);
    }

    public void setCenter(FixedPoint2D fixedPoint2D) {
        this.setCenter(fixedPoint2D.getX(), fixedPoint2D.getY());
    }

    public void setCenter(double d, double d2) {
        double d3 = d - this.getCenterX();
        double d4 = d2 - this.getCenterY();
        this.setBounds(this.getLeft() + d3, this.getBottom() + d4, this.getRight() + d3, this.getTop() + d4);
    }

    public void translate(double d, double d2) {
        this.setBounds(this.getLeft() + d, this.getBottom() + d2, this.getRight() + d, this.getTop() + d2);
    }

    public void merge(FixedPoint2D fixedPoint2D) {
        this.merge(fixedPoint2D.getX(), fixedPoint2D.getY());
    }

    public void merge(double d, double d2) {
        if (d < this.getLeft()) {
            this.setLeft(d);
        } else if (d > this.getRight()) {
            this.setRight(d);
        }
        if (d2 < this.getBottom()) {
            this.setBottom(d2);
        } else if (d2 > this.getTop()) {
            this.setTop(d2);
        }
    }

    public void merge(FixedBounds fixedBounds) {
        this.merge(fixedBounds.getLeft(), fixedBounds.getBottom());
        this.merge(fixedBounds.getRight(), fixedBounds.getTop());
    }
}

