/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.shape;

import com.cisco.nm.esper.shape.FixedPoint2D;

public abstract class Point2D
extends java.awt.geom.Point2D
implements FixedPoint2D {
    private static boolean single = false;

    public static Point2D getInstance() {
        return Point2D.getInstance(Point2D.isDoublePrecisionUsed());
    }

    public static Point2D getInstance(boolean bl) {
        if (bl) {
            return new Double();
        }
        return new Float();
    }

    public static void setUseSinglePrecision(boolean bl) {
        single = bl;
    }

    public static void setUseDoublePrecision(boolean bl) {
        single = !bl;
    }

    public static boolean isSinglePrecisionUsed() {
        return single;
    }

    public static boolean isDoublePrecisionUsed() {
        return !single;
    }

    public abstract boolean isSinglePrecision();

    public abstract boolean isDoublePrecision();

    public void setLocation(FixedPoint2D fixedPoint2D) {
        this.setLocation(fixedPoint2D.getX(), fixedPoint2D.getY());
    }

    public void moveBy(double d, double d2) {
        this.setLocation(this.getX() + d, this.getY() + d2);
    }

    public void setX(double d) {
        this.setLocation(d, this.getY());
    }

    public void setY(double d) {
        this.setLocation(this.getX(), d);
    }

    public static boolean colinear(double d, double d2, double d3, double d4, double d5, double d6) {
        return (d5 - d) * (d4 - d2) == (d6 - d2) * (d3 - d);
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getX()))).append(", ").append(this.getY())));
    }

    public static class Double
    extends Point2D {
        private double x;
        private double y;

        public Double() {
            this(0.0, 0.0);
        }

        public Double(FixedPoint2D fixedPoint2D) {
            this(fixedPoint2D.getX(), fixedPoint2D.getY());
        }

        public Double(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public final boolean isSinglePrecision() {
            return false;
        }

        public final boolean isDoublePrecision() {
            return true;
        }
    }

    public static class Float
    extends Point2D {
        private float x;
        private float y;

        public Float() {
            this(0.0f, 0.0f);
        }

        public Float(FixedPoint2D fixedPoint2D) {
            this((float)fixedPoint2D.getX(), (float)fixedPoint2D.getY());
        }

        public Float(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double d, double d2) {
            this.x = (float)d;
            this.y = (float)d2;
        }

        public final boolean isSinglePrecision() {
            return true;
        }

        public final boolean isDoublePrecision() {
            return false;
        }
    }
}

