/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.shape;

import com.cisco.nm.esper.shape.Bounds;
import com.cisco.nm.esper.shape.BoundsDouble;
import com.cisco.nm.esper.shape.FixedBounds;
import com.cisco.nm.esper.shape.FixedPoint2D;
import com.cisco.nm.esper.shape.Point2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;

public class Transform
implements Cloneable,
Serializable {
    private double xOff = 0.0;
    private double yOff = 0.0;
    private double xScl = 1.0;
    private double yScl = -1.0;
    private int scaleID;

    public int xToDevice(double d) {
        return (int)StrictMath.floor(0.5 + this.getScaleX() * d + this.getOffsetX());
    }

    public int yToDevice(double d) {
        return (int)StrictMath.floor(0.5 + this.getScaleY() * d + this.getOffsetY());
    }

    public Point pointToDevice(FixedPoint2D fixedPoint2D) {
        return this.pointToDevice(fixedPoint2D.getX(), fixedPoint2D.getY());
    }

    public Point pointToDevice(double d, double d2) {
        return new Point(this.xToDevice(d), this.yToDevice(d2));
    }

    public Rectangle boundsToDevice(FixedBounds fixedBounds) {
        return this.boundsToDevice(fixedBounds.getLeft(), fixedBounds.getBottom(), fixedBounds.getRight(), fixedBounds.getTop());
    }

    public Rectangle boundsToDevice(double d, double d2, double d3, double d4) {
        Rectangle rectangle = new Rectangle();
        rectangle.x = this.xToDevice(d);
        rectangle.y = this.yToDevice(d4);
        rectangle.width = this.xToDevice(d3) - rectangle.x;
        rectangle.height = this.yToDevice(d2) - rectangle.y;
        return rectangle;
    }

    public int heightToDevice(double d) {
        return Math.abs((int)Math.round(this.getScaleY() * d));
    }

    public int widthToDevice(double d) {
        return Math.abs((int)Math.round(this.getScaleX() * d));
    }

    public double xToWorld(int n) {
        return ((double)n - this.getOffsetX()) / this.getScaleX();
    }

    public double yToWorld(int n) {
        return ((double)n - this.getOffsetY()) / this.getScaleY();
    }

    public Point2D pointToWorld(Point point) {
        return this.pointToWorld(point.x, point.y);
    }

    public Point2D pointToWorld(int n, int n2) {
        Point2D point2D = Point2D.getInstance();
        point2D.setLocation(this.xToWorld(n), this.yToWorld(n2));
        return point2D;
    }

    public Bounds boundsToWorld(Rectangle rectangle) {
        return this.boundsToWorld(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Bounds boundsToWorld(int n, int n2, int n3, int n4) {
        double d = this.xToWorld(n);
        double d2 = this.xToWorld(n + n3);
        double d3 = this.yToWorld(n2 + n4);
        double d4 = this.yToWorld(n2);
        return new BoundsDouble(Math.min(d, d2), Math.min(d3, d4), Math.max(d, d2), Math.max(d3, d4));
    }

    public double heightToWorld(int n) {
        return Math.abs((double)n / this.getScaleY());
    }

    public double widthToWorld(int n) {
        return Math.abs((double)n / this.getScaleX());
    }

    public Transform setScaleX(double d) {
        if (this.xScl != d) {
            this.xScl = d;
            ++this.scaleID;
        }
        return this;
    }

    public double getScaleX() {
        return this.xScl;
    }

    public Transform setScaleY(double d) {
        if (this.yScl != d) {
            this.yScl = d;
            ++this.scaleID;
        }
        return this;
    }

    public double getScaleY() {
        return this.yScl;
    }

    public Transform setOffsetX(double d) {
        this.xOff = d;
        return this;
    }

    public Transform setOffsetY(double d) {
        this.yOff = d;
        return this;
    }

    public double getOffsetX() {
        return this.xOff;
    }

    public double getOffsetY() {
        return this.yOff;
    }

    public int getScaleID() {
        return this.scaleID;
    }

    public static Transform prepend(Transform transform) {
        Transform transform2 = new Transform();
        return transform2;
    }

    public static Transform append(Transform transform) {
        Transform transform2 = new Transform();
        return transform2;
    }
}

