/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.tool;

import com.cisco.nm.EsperStrings;
import com.cisco.nm.esper.tool.Tool;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public abstract class StatusedTool
extends Tool {
    private String sttsText;
    private Vector textListeners;

    protected synchronized void terminate() {
        if (this.textListeners != null) {
            this.textListeners.removeAllElements();
            this.textListeners = null;
        }
        super.terminate();
    }

    public String getStatusText() {
        return this.sttsText;
    }

    public void setStatusText(String string) {
        if (this.sttsText == null && string != null || this.sttsText != null && !this.sttsText.equals(string)) {
            this.sttsText = string;
            this.fireTextChangedEvent(this.sttsText);
        }
    }

    protected void fireTextChangedEvent(String string) {
        if (this.isActivated() && this.getTextListenerCount() > 0) {
            TextEvent textEvent = new TextEvent(this, 900);
            Vector vector = this.textListeners;
            synchronized (vector) {
                for (int i = 0; i < this.getTextListenerCount(); ++i) {
                    this.getTextListener(i).textValueChanged(textEvent);
                }
            }
        }
    }

    public void addTextListener(TextListener textListener) {
        if (textListener != null) {
            if (this.textListeners == null) {
                this.textListeners = new Vector(5, 5);
            }
            this.textListeners.addElement(textListener);
        }
    }

    public void removeTextListener(TextListener textListener) {
        if (textListener != null && this.textListeners != null) {
            this.textListeners.removeElement(textListener);
            if (this.textListeners.size() <= 0) {
                this.textListeners = null;
            }
        }
    }

    public int getTextListenerCount() {
        return this.textListeners == null ? 0 : this.textListeners.size();
    }

    public TextListener getTextListener(int n) {
        if (this.textListeners == null) {
            throw new IndexOutOfBoundsException(EsperStrings.string(5));
        }
        return (TextListener)this.textListeners.elementAt(n);
    }
}

