/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.tool;

import com.cisco.nm.esper.tool.ToolEquipped;
import com.cisco.nm.lib.Debug;
import java.awt.Graphics;
import java.util.Vector;

public abstract class Tool {
    public static final int CREATED = 0;
    public static final int ACTIVATED = 1;
    public static final int SUSPENDED = 2;
    public static final int TERMINATED = 3;
    private ToolEquipped _owner;
    private int _state;
    private boolean painted;
    private Tool child;
    private Tool parent;
    private Vector _toolListeners;

    public Tool() {
        this.setState(0);
        this.setPainted(true);
    }

    protected synchronized void activate(ToolEquipped toolEquipped) throws Exception {
        if (toolEquipped == null) {
            throw new IllegalArgumentException("Unable to activate a tool on a null component");
        }
        if (this.isActivated() || this.isSuspended()) {
            throw new IllegalStateException("Tool.activate invoked on an active or suspended tool");
        }
        this.setOwner(toolEquipped);
        if (this.getParentTool() != null) {
            this.getParentTool().suspend();
            this.fireToolEvent(this.getParentTool(), 16);
        }
        this.fireToolEvent(this, 33);
        toolEquipped.asContainer().requestFocus();
        this.setState(1);
        Debug.println(String.valueOf(String.valueOf(this.getName())).concat(" activated"));
    }

    protected synchronized void suspend() {
        if (!this.isActivated()) {
            throw new IllegalStateException("Tool.suspend invoked on a non-active tool");
        }
        this.fireToolEvent(this, 17);
        this.setState(2);
        Debug.println(String.valueOf(String.valueOf(this.getName())).concat(" suspended"));
    }

    protected synchronized void resume() {
        if (!this.isSuspended()) {
            throw new IllegalStateException("Tool.resume invoked on a non-suspended tool");
        }
        if (this.getChildTool() != null) {
            this.setChildTool(null);
        }
        this.fireToolEvent(this, 49);
        this.setState(1);
        this.getOwner().asContainer().requestFocus();
        Debug.println(String.valueOf(String.valueOf(this.getName())).concat(" resumed"));
    }

    protected synchronized void terminate() {
        if (this.isTerminated()) {
            throw new IllegalStateException("Tool.terminate invoked on a terminated tool.");
        }
        if (this.getChildTool() != null) {
            this.setChildTool(null);
        }
        this.fireToolEvent(this, 65);
        this.setOwner(null);
        this.setParentTool(null);
        this.setState(3);
        Debug.println(String.valueOf(String.valueOf(this.getName())).concat(" terminated"));
    }

    public synchronized void abort() {
    }

    public synchronized void deactivate() {
        Tool tool = this.getParentTool();
        if (tool != null) {
            tool.resume();
            tool.fireToolEvent(tool, 48);
        } else if (this.getOwner() != null) {
            this.getOwner().setTool(null);
        }
    }

    public void paint(Graphics graphics) {
    }

    public boolean isCreated() {
        return this.getState() == 0;
    }

    public boolean isActivated() {
        return this.getState() == 1;
    }

    public boolean isSuspended() {
        return this.getState() == 2;
    }

    public boolean isTerminated() {
        return this.getState() == 3;
    }

    protected void setOwner(ToolEquipped toolEquipped) {
        this._owner = toolEquipped;
    }

    public ToolEquipped getOwner() {
        return this._owner;
    }

    protected void setPainted(boolean bl) {
        this.painted = bl;
    }

    public boolean isPainted() {
        return this.painted;
    }

    protected void setState(int n) {
        this._state = n;
    }

    public int getState() {
        return this._state;
    }

    public void setChildTool(Tool tool) {
        if (this.child != null) {
            this.child.terminate();
            this.fireToolEvent(this.child, 64);
        }
        this.child = tool;
        try {
            if (this.child != null) {
                this.child.setParentTool(this);
                this.child.activate(this.getOwner());
                if (this.child != null) {
                    this.fireToolEvent(this.child, 32);
                }
            }
        }
        catch (Exception exception) {
            Debug.println(5, String.valueOf(String.valueOf(new StringBuffer("Unable to activate ").append(tool.getName()).append(" due to ").append(exception.getMessage()))));
            Debug.println(exception);
            this.child.deactivate();
        }
    }

    public Tool getChildTool() {
        return this.child;
    }

    protected void setParentTool(Tool tool) {
        this.parent = tool;
    }

    public Tool getParentTool() {
        return this.parent;
    }

    public Tool getActiveTool() {
        return this.getChildTool() != null ? this.getChildTool().getActiveTool() : this;
    }

    public String getName() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
    }

    public void fireToolEvent(Tool tool, int n) {
        if (this.getParentTool() != null) {
            this.getParentTool().fireToolEvent(tool, n);
        } else if (this.getOwner() != null) {
            this.getOwner().fireToolEvent(tool, n);
        }
    }

    static {
        CREATED = 0;
        ACTIVATED = 1;
        SUSPENDED = 2;
        TERMINATED = 3;
    }
}

