/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.lib.winkit;

import com.cisco.nm.lib.winkit.Border;
import com.cisco.nm.lib.winkit.PlainContainer;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;

public class BasicContainer
extends PlainContainer {
    Border border;

    public BasicContainer() {
        this((Border)null);
    }

    public BasicContainer(Border border) {
        this.setBackground(SystemColor.control);
        this.setBorder(border);
    }

    public void setBorder(Border border) {
        if (border != this.border) {
            this.border = border;
            if (this.isValid()) {
                this.invalidate();
            }
            this.repaint();
        }
    }

    public Border getBorder() {
        return this.border;
    }

    public Insets getInsets(Insets insets) {
        if (this.getBorder() != null) {
            return this.getBorder().getBorderInsets(this, insets == null ? new Insets(0, 0, 0, 0) : insets);
        }
        return super.getInsets(insets);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.isShowing()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(this.getForeground());
        }
        if (this.getBorder() != null) {
            this.getBorder().paint(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(graphics);
    }
}

