/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.lib.winkit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

public abstract class Border
implements Cloneable {
    public void paint(Component component, Graphics graphics, Rectangle rectangle) {
        this.paint(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public abstract void paint(Component var1, Graphics var2, int var3, int var4, int var5, int var6);

    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
    }

    public abstract Insets getBorderInsets(Component var1, Insets var2);

    public static class Titled
    extends Border {
        String titleText;
        Color titleColor;
        Font font;
        Border border;

        public Titled() {
            this(null);
        }

        public Titled(String string) {
            this.setTitle(string);
            this.setTitleFont(new Font("dialog", 0, 11));
            this.setTitleColor(new Color(128));
            this.setBorder(new Solid());
        }

        public Border getBorder() {
            return this.border;
        }

        public String getTitle() {
            return this.titleText;
        }

        public Color getTitleColor() {
            return this.titleColor;
        }

        public Font getTitleFont() {
            return this.font;
        }

        public void setTitleColor(Color color) {
            this.titleColor = color;
        }

        public void setTitle(String string) {
            this.titleText = string;
        }

        public void setTitleFont(Font font) {
            this.font = font;
        }

        public void setBorder(Border border) {
            this.border = border;
        }

        public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            int n5;
            graphics.translate(n, n2);
            graphics.setFont(this.getTitleFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (this.getBorder() != null) {
                n5 = this.getTitle() == null ? 0 : fontMetrics.getHeight() / 2;
                this.getBorder().paint(component, graphics, n, n5, n3, n4 - n5);
            }
            if (this.getTitle() != null) {
                n5 = Math.max(n3 / 20, 1);
                int n6 = fontMetrics.getMaxAscent();
                graphics.setColor(component.getBackground());
                graphics.fillRect(n5 - 1, 0, fontMetrics.stringWidth(this.getTitle()) + 2, fontMetrics.getHeight());
                graphics.setColor(this.getTitleColor());
                graphics.drawString(this.getTitle(), n5, n6);
            }
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (this.getBorder() == null) {
                insets.top = 0;
                insets.bottom = 0;
                insets.right = 0;
                insets.left = 0;
            } else {
                this.getBorder().getBorderInsets(component, insets);
            }
            if (this.getTitle() != null) {
                FontMetrics fontMetrics = component.getFontMetrics(this.getTitleFont());
                insets.top = Math.max(insets.top, fontMetrics.getHeight());
            }
            return insets;
        }
    }

    public static class Double
    extends Border {
        Color color = Color.black;
        int width = 1;

        public Double() {
            this(1);
        }

        public Double(int n) {
            this.setWidth(n);
        }

        public void setLineColor(Color color) {
            this.color = color;
        }

        public Color getLineColor() {
            return this.color;
        }

        public void setWidth(int n) {
            this.width = n;
        }

        public int getWidth() {
            return this.width;
        }

        public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            int n5;
            graphics.translate(n, n2);
            graphics.setColor(this.getLineColor());
            --n3;
            --n4;
            for (n5 = 0; n5 < this.getWidth(); ++n5) {
                graphics.drawRect(n5, n5, n3, n4);
                n3 -= 2;
                n4 -= 2;
            }
            n5 = 2 * this.getWidth();
            n3 -= n5;
            n4 -= n5;
            for (int i = 0; i < this.getWidth(); ++i) {
                graphics.drawRect(n5 + i, n5 + i, n3, n4);
                n3 -= 2;
                n4 -= 2;
            }
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = insets.bottom = 3 * this.getWidth();
            insets.right = insets.bottom;
            insets.left = insets.bottom;
            return insets;
        }
    }

    public static class Solid
    extends Border {
        Color color = Color.black;
        int width = 1;

        public Solid() {
            this(1);
        }

        public Solid(int n) {
            this.setWidth(n);
        }

        public void setLineColor(Color color) {
            this.color = color;
        }

        public Color getLineColor() {
            return this.color;
        }

        public void setWidth(int n) {
            this.width = n;
        }

        public int getWidth() {
            return this.width;
        }

        public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(this.getLineColor());
            --n3;
            --n4;
            for (int i = 0; i < this.getWidth(); ++i) {
                graphics.drawRect(i, i, n3 - 2 * i, n4 - 2 * i);
            }
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = insets.top = this.getWidth();
            insets.right = insets.top;
            insets.left = insets.top;
            return insets;
        }
    }

    public static class Etched
    extends Border {
        Color color;

        public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            Color color = this.getBorderColor();
            if (color == null) {
                color = component.getBackground();
            }
            graphics.setColor(color.darker());
            graphics.drawRect(0, 0, n3 - 2, n4 - 2);
            graphics.setColor(color.brighter());
            graphics.drawLine(1, n4 - 3, 1, 1);
            graphics.drawLine(1, 1, n3 - 3, 1);
            graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 2;
            insets.bottom = 2;
            insets.right = 2;
            insets.left = 2;
            return insets;
        }

        public Color getBorderColor() {
            return this.color;
        }

        public void setBorderColor(Color color) {
            this.color = color;
        }
    }

    public static class Page
    extends Border {
        public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, n3 - 3, n4 - 3);
            graphics.setColor(Color.darkGray);
            graphics.fillRect(n3 - 2, 2, 2, n4 - 2);
            graphics.fillRect(2, n4 - 2, n3 - 2, 2);
            graphics.setColor(Color.lightGray);
            graphics.fillRect(0, n4 - 2, 2, 2);
            graphics.fillRect(n3 - 2, 0, 2, 2);
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 1;
            insets.left = 1;
            insets.bottom = 3;
            insets.right = 3;
            return insets;
        }
    }
}

