/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelForwardedTCPIP;
import com.jcraft.jsch.ChannelSession;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.ChannelSubsystem;
import com.jcraft.jsch.ChannelX11;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.RequestSignal;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Vector;

public abstract class Channel
implements Runnable {
    static int index = 0;
    private static Vector pool = new Vector();
    int id;
    int recipient = -1;
    byte[] type = "foo".getBytes();
    int lwsize_max;
    int lwsize = this.lwsize_max = 0x100000;
    int lmpsize = 16384;
    int rwsize = 0;
    int rmpsize = 0;
    IO io = null;
    Thread thread = null;
    boolean eof_local = false;
    boolean eof_remote = false;
    boolean close = false;
    boolean connected = false;
    int exitstatus = -1;
    int reply = 0;
    Session session;

    static Channel getChannel(String type) {
        if (type.equals("session")) {
            return new ChannelSession();
        }
        if (type.equals("shell")) {
            return new ChannelShell();
        }
        if (type.equals("exec")) {
            return new ChannelExec();
        }
        if (type.equals("x11")) {
            return new ChannelX11();
        }
        if (type.equals("direct-tcpip")) {
            return new ChannelDirectTCPIP();
        }
        if (type.equals("forwarded-tcpip")) {
            return new ChannelForwardedTCPIP();
        }
        if (type.equals("sftp")) {
            return new ChannelSftp();
        }
        if (type.equals("subsystem")) {
            return new ChannelSubsystem();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Channel getChannel(int id, Session session) {
        Vector vector = pool;
        synchronized (vector) {
            for (int i = 0; i < pool.size(); ++i) {
                Channel c = (Channel)pool.elementAt(i);
                if (c.id != id || c.session != session) continue;
                return c;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void del(Channel c) {
        Vector vector = pool;
        synchronized (vector) {
            pool.removeElement(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Channel() {
        Vector vector = pool;
        synchronized (vector) {
            this.id = index++;
            pool.addElement(this);
        }
    }

    void setRecipient(int foo) {
        this.recipient = foo;
    }

    int getRecipient() {
        return this.recipient;
    }

    void init() {
    }

    public void connect() throws JSchException {
        block8: {
            if (!this.session.isConnected()) {
                throw new JSchException("session is down");
            }
            try {
                int retry;
                Buffer buf = new Buffer(100);
                Packet packet = new Packet(buf);
                packet.reset();
                buf.putByte((byte)90);
                buf.putString(this.type);
                buf.putInt(this.id);
                buf.putInt(this.lwsize);
                buf.putInt(this.lmpsize);
                this.session.write(packet);
                for (retry = 1000; this.getRecipient() == -1 && this.session.isConnected() && retry > 0; --retry) {
                    try {
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                }
                if (!this.session.isConnected()) {
                    throw new JSchException("session is down");
                }
                if (retry == 0) {
                    throw new JSchException("channel is not opened.");
                }
                this.start();
                this.connected = true;
            }
            catch (Exception e) {
                if (!(e instanceof JSchException)) break block8;
                throw (JSchException)e;
            }
        }
    }

    public void setXForwarding(boolean foo) {
    }

    public void start() throws JSchException {
    }

    public boolean isEOF() {
        return this.eof_remote;
    }

    void getData(Buffer buf) {
        this.setRecipient(buf.getInt());
        this.setRemoteWindowSize(buf.getInt());
        this.setRemotePacketSize(buf.getInt());
    }

    public void setInputStream(InputStream in) {
        this.io.setInputStream(in, false);
    }

    public void setInputStream(InputStream in, boolean dontclose) {
        this.io.setInputStream(in, dontclose);
    }

    public void setOutputStream(OutputStream out) {
        this.io.setOutputStream(out, false);
    }

    public void setOutputStream(OutputStream out, boolean dontclose) {
        this.io.setOutputStream(out, dontclose);
    }

    public void setExtOutputStream(OutputStream out) {
        this.io.setExtOutputStream(out, false);
    }

    public void setExtOutputStream(OutputStream out, boolean dontclose) {
        this.io.setExtOutputStream(out, dontclose);
    }

    public InputStream getInputStream() throws IOException {
        MyPipedInputStream in = new MyPipedInputStream(32768);
        this.io.setOutputStream(new PassiveOutputStream(in), false);
        return in;
    }

    public InputStream getExtInputStream() throws IOException {
        MyPipedInputStream in = new MyPipedInputStream(32768);
        this.io.setExtOutputStream(new PassiveOutputStream(in), false);
        return in;
    }

    public OutputStream getOutputStream() throws IOException {
        PipedOutputStream out = new PipedOutputStream();
        this.io.setInputStream(new PassiveInputStream(out, 32768), false);
        return out;
    }

    void setLocalWindowSizeMax(int foo) {
        this.lwsize_max = foo;
    }

    void setLocalWindowSize(int foo) {
        this.lwsize = foo;
    }

    void setLocalPacketSize(int foo) {
        this.lmpsize = foo;
    }

    synchronized void setRemoteWindowSize(int foo) {
        this.rwsize = foo;
    }

    synchronized void addRemoteWindowSize(int foo) {
        this.rwsize += foo;
    }

    void setRemotePacketSize(int foo) {
        this.rmpsize = foo;
    }

    @Override
    public void run() {
    }

    void write(byte[] foo) throws IOException {
        this.write(foo, 0, foo.length);
    }

    void write(byte[] foo, int s, int l) throws IOException {
        if (this.io.out != null) {
            this.io.put(foo, s, l);
        }
    }

    void write_ext(byte[] foo, int s, int l) throws IOException {
        if (this.io.out_ext != null) {
            this.io.put_ext(foo, s, l);
        }
    }

    void eof_remote() throws IOException {
        this.eof_remote = true;
        if (this.io.out != null) {
            this.io.out.close();
            this.io.out = null;
        }
    }

    void eof() {
        if (this.close) {
            return;
        }
        if (this.eof_local) {
            return;
        }
        this.eof_local = true;
        try {
            Buffer buf = new Buffer(100);
            Packet packet = new Packet(buf);
            packet.reset();
            buf.putByte((byte)96);
            buf.putInt(this.getRecipient());
            this.session.write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void close() {
        if (this.close) {
            return;
        }
        this.close = true;
        try {
            Buffer buf = new Buffer(100);
            Packet packet = new Packet(buf);
            packet.reset();
            buf.putByte((byte)97);
            buf.putInt(this.getRecipient());
            this.session.write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        return this.close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disconnect(Session session) {
        Channel[] channels = null;
        int count = 0;
        Vector vector = pool;
        synchronized (vector) {
            channels = new Channel[pool.size()];
            for (int i = 0; i < pool.size(); ++i) {
                try {
                    Channel c = (Channel)pool.elementAt(i);
                    if (c.session != session) continue;
                    channels[count++] = c;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        for (int i = 0; i < count; ++i) {
            channels[i].disconnect();
        }
    }

    public void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
        this.session = null;
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        this.close();
        this.thread = null;
        try {
            if (this.io != null) {
                this.io.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.io = null;
        Channel.del(this);
    }

    public boolean isConnected() {
        if (this.session != null) {
            return this.session.isConnected() && this.connected;
        }
        return false;
    }

    public void sendSignal(String foo) throws Exception {
        RequestSignal request = new RequestSignal();
        request.setSignal(foo);
        request.request(this.session, this);
    }

    void setExitStatus(int foo) {
        this.exitstatus = foo;
    }

    public int getExitStatus() {
        return this.exitstatus;
    }

    void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public int getId() {
        return this.id;
    }

    class PassiveOutputStream
    extends PipedOutputStream {
        PassiveOutputStream(PipedInputStream in) throws IOException {
            super(in);
        }
    }

    class PassiveInputStream
    extends MyPipedInputStream {
        PipedOutputStream out;

        PassiveInputStream(PipedOutputStream out, int size) throws IOException {
            super(out, size);
            this.out = out;
        }

        PassiveInputStream(PipedOutputStream out) throws IOException {
            super(out);
            this.out = out;
        }

        @Override
        public void close() throws IOException {
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
        }
    }

    class MyPipedInputStream
    extends PipedInputStream {
        MyPipedInputStream() throws IOException {
        }

        MyPipedInputStream(int size) throws IOException {
            this.buffer = new byte[size];
        }

        MyPipedInputStream(PipedOutputStream out) throws IOException {
            super(out);
        }

        MyPipedInputStream(PipedOutputStream out, int size) throws IOException {
            super(out);
            this.buffer = new byte[size];
        }
    }
}

