/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdFile;
import org.jrobin.core.RrdInt;
import org.jrobin.core.RrdLong;
import org.jrobin.core.RrdString;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Util;
import org.jrobin.core.XmlReader;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Header
implements RrdUpdater {
    static final String SIGNATURE = "RRD, version 1";
    static final String SIGNATURE_MULTI = "RRD, version 2";
    static final String RRDTOOL_VERSION = "0001";
    static final String RRDTOOL_MULTI_VERSION = "0002";
    private RrdDb parentDb;
    boolean _multiRrd = true;
    private RrdString signature;
    private RrdLong step;
    private RrdInt dsCount;
    private RrdInt arcCount;
    private RrdLong lastUpdateTime;

    Header(RrdDb parentDb) throws IOException {
        this.parentDb = parentDb;
        this.signature = new RrdString(this);
        if (this.signature.get().equals(SIGNATURE)) {
            this._multiRrd = false;
        }
        this.step = new RrdLong(this);
        this.dsCount = new RrdInt(this);
        this.arcCount = new RrdInt(this);
        this.lastUpdateTime = new RrdLong(this);
    }

    Header(RrdDb parentDb, RrdDef rrdDef) throws IOException, RrdException {
        this.parentDb = parentDb;
        this.signature = new RrdString(SIGNATURE_MULTI, this);
        this.step = new RrdLong(rrdDef.getStep(), this);
        this.dsCount = new RrdInt(rrdDef.getDsCount(), this);
        this.arcCount = new RrdInt(rrdDef.getArcCount(), this);
        this.lastUpdateTime = new RrdLong(rrdDef.getStartTime(), this);
        if (this.signature.get().equals(SIGNATURE)) {
            this._multiRrd = false;
        }
    }

    Header(RrdDb parentDb, XmlReader reader) throws IOException, RrdException {
        this.parentDb = parentDb;
        String version = reader.getVersion();
        if (!version.equals(RRDTOOL_VERSION) && !version.equals(RRDTOOL_MULTI_VERSION)) {
            throw new RrdException("expected version " + version);
        }
        this.signature = new RrdString(SIGNATURE_MULTI, this);
        this.step = new RrdLong(reader.getStep(), this);
        this.dsCount = new RrdInt(reader.getDsCount(), this);
        this.arcCount = new RrdInt(reader.getArcCount(), this);
        this.lastUpdateTime = new RrdLong(reader.getLastUpdateTime(), this);
    }

    public String getSignature() throws IOException {
        return this.signature.get();
    }

    public long getLastUpdateTime() throws IOException {
        return this.lastUpdateTime.get();
    }

    public long getStep() throws IOException {
        return this.step.get();
    }

    public int getDsCount() throws IOException {
        return this.dsCount.get();
    }

    public int getArcCount() throws IOException {
        return this.arcCount.get();
    }

    void setLastUpdateTime(long lastUpdateTime) throws IOException {
        this.lastUpdateTime.set(lastUpdateTime);
    }

    String dump() throws IOException {
        return "== HEADER ==\nsignature:" + this.getSignature() + " lastUpdateTime:" + this.getLastUpdateTime() + " step:" + this.getStep() + " dsCount:" + this.getDsCount() + " arcCount:" + this.getArcCount() + "\n";
    }

    @Override
    public RrdFile getRrdFile() {
        return this.parentDb.getRrdFile();
    }

    void appendXml(Element parent) throws IOException {
        Document doc = parent.getOwnerDocument();
        Element versionElem = doc.createElement("version");
        versionElem.appendChild(doc.createTextNode(RRDTOOL_VERSION));
        Element stepElem = doc.createElement("step");
        stepElem.appendChild(doc.createTextNode("" + this.step.get()));
        Comment stepComment = doc.createComment("Seconds");
        Element lastElem = doc.createElement("lastupdate");
        lastElem.appendChild(doc.createTextNode("" + this.lastUpdateTime.get()));
        Comment lastComment = doc.createComment("" + Util.getDate(this.lastUpdateTime.get()));
        parent.appendChild(versionElem);
        parent.appendChild(stepComment);
        parent.appendChild(stepElem);
        parent.appendChild(lastComment);
        parent.appendChild(lastElem);
    }

    public boolean isMultiRrd() {
        return this._multiRrd;
    }
}

