/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.io.IOException;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.RrdTimeSeries;
import org.jrobin.graph.ValueCollection;

public abstract class Source {
    public static final int MAX = 0;
    public static final int MIN = 1;
    public static final int LAST = 2;
    public static final int AVERAGE = 3;
    protected String name = "";
    private double min;
    private double max;
    private double last;
    private double sum;
    private int count;
    private RrdTimeSeries series;

    Source() {
        this.reset();
    }

    Source(String name) {
        this();
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    abstract void setInterval(long var1, long var3) throws RrdException, IOException;

    abstract double getValue(long var1, ValueCollection var3) throws RrdException;

    double getValueInternal(long timestamp, ValueCollection values) throws RrdException {
        double value = this.getValue(timestamp, values);
        this.series.add(timestamp, value);
        this.aggregate(value);
        values.add(this.name, value);
        return value;
    }

    void setIntervalInternal(long startTime, long endTime) throws RrdException, IOException {
        this.setInterval(startTime, endTime);
        this.reset();
    }

    private void aggregate(double value) {
        this.min = Util.min(this.min, value);
        this.max = Util.max(this.max, value);
        this.last = value;
        if (!Double.isNaN(value)) {
            this.sum += value;
            ++this.count;
        }
    }

    private void reset() {
        this.min = Double.NaN;
        this.max = Double.NaN;
        this.last = Double.NaN;
        this.sum = 0.0;
        this.count = 0;
        this.series = new RrdTimeSeries(this.name);
    }

    public double getAggregate(int consolFun) {
        switch (consolFun) {
            case 0: {
                return this.max;
            }
            case 1: {
                return this.min;
            }
            case 2: {
                return this.last;
            }
            case 3: {
                if (this.count <= 0) break;
                return this.sum / (double)this.count;
            }
        }
        return Double.NaN;
    }

    RrdTimeSeries getSeries() {
        return this.series;
    }
}

