/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.inspector;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.jrobin.core.Archive;
import org.jrobin.core.Robin;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.inspector.InspectorModel;

class DataTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"timestamp", "date", "value"};
    private File file;
    private Object[][] values;
    private int dsIndex = -1;
    private int arcIndex = -1;

    DataTableModel() {
    }

    @Override
    public int getRowCount() {
        if (this.values == null) {
            return 0;
        }
        return this.values.length;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.values == null) {
            return "--";
        }
        return this.values[rowIndex][columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    void setFile(File newFile) {
        this.file = newFile;
        this.setIndex(-1, -1);
    }

    void setIndex(int newDsIndex, int newArcIndex) {
        if (this.dsIndex != newDsIndex || this.arcIndex != newArcIndex) {
            this.dsIndex = newDsIndex;
            this.arcIndex = newArcIndex;
            this.values = null;
            if (this.dsIndex >= 0 && this.arcIndex >= 0) {
                try {
                    RrdDb rrd = new RrdDb(this.file.getAbsolutePath());
                    Archive arc = rrd.getArchive(this.arcIndex);
                    Robin robin = arc.getRobin(this.dsIndex);
                    long start = arc.getStartTime(rrd.getDatasource(this.dsIndex));
                    long step = arc.getArcStep();
                    double[] robinValues = robin.getValues();
                    this.values = new Object[robinValues.length][];
                    for (int i = 0; i < robinValues.length; ++i) {
                        long timestamp = start + (long)i * step;
                        String date = new Date(timestamp * 1000L).toString();
                        String value = InspectorModel.formatDouble(robinValues[i]);
                        this.values[i] = new Object[]{"" + timestamp, date, value};
                    }
                    rrd.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (RrdException e) {
                    e.printStackTrace();
                }
            }
            this.fireTableDataChanged();
        }
    }
}

