/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.expression;

import com.jidesoft.thirdparty.prefuse.data.Schema;
import com.jidesoft.thirdparty.prefuse.data.Tuple;
import com.jidesoft.thirdparty.prefuse.data.expression.BinaryExpression;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.Predicate;
import com.jidesoft.thirdparty.prefuse.util.TypeLib;
import com.jidesoft.thirdparty.prefuse.util.collections.DefaultLiteralComparator;
import com.jidesoft.thirdparty.prefuse.util.collections.LiteralComparator;
import java.util.Comparator;

public class ComparisonPredicate
extends BinaryExpression
implements Predicate {
    public static final int LT = 0;
    public static final int GT = 1;
    public static final int EQ = 2;
    public static final int NEQ = 3;
    public static final int LTEQ = 4;
    public static final int GTEQ = 5;
    private Comparator m_cmp;

    public ComparisonPredicate(int n2, Expression expression, Expression expression2) {
        this(n2, expression, expression2, DefaultLiteralComparator.getInstance());
    }

    public ComparisonPredicate(int n2, Expression expression, Expression expression2, Comparator comparator) {
        super(n2, 0, 5, expression, expression2);
        this.m_cmp = comparator;
    }

    public Comparator getComparator() {
        return this.m_cmp;
    }

    public Class getType(Schema schema) {
        return Boolean.TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBoolean(Tuple tuple) {
        Class clazz = this.m_left.getType(tuple.getSchema());
        Class clazz2 = this.m_right.getType(tuple.getSchema());
        int n2 = 0;
        if (TypeLib.isNumericType(clazz) && TypeLib.isNumericType(clazz2)) {
            Class clazz3 = TypeLib.getNumericType(clazz, clazz2);
            if (clazz3 == Integer.TYPE) {
                int n3 = this.m_left.getInt(tuple);
                int n4 = this.m_right.getInt(tuple);
                n2 = ((LiteralComparator)this.m_cmp).compare(n3, n4);
            } else if (clazz3 == Long.TYPE) {
                long l2 = this.m_left.getLong(tuple);
                long l3 = this.m_right.getLong(tuple);
                n2 = ((LiteralComparator)this.m_cmp).compare(l2, l3);
            } else if (clazz3 == Float.TYPE) {
                float f2 = this.m_left.getFloat(tuple);
                float f3 = this.m_right.getFloat(tuple);
                n2 = ((LiteralComparator)this.m_cmp).compare(f2, f3);
            } else {
                if (clazz3 != Double.TYPE) throw new IllegalStateException();
                double d2 = this.m_left.getDouble(tuple);
                double d3 = this.m_right.getDouble(tuple);
                n2 = ((LiteralComparator)this.m_cmp).compare(d2, d3);
            }
        } else {
            n2 = this.m_cmp.compare(this.m_left.get(tuple), this.m_right.get(tuple));
        }
        switch (this.m_op) {
            case 0: {
                if (n2 != -1) return false;
                return true;
            }
            case 1: {
                if (n2 != 1) return false;
                return true;
            }
            case 2: {
                if (n2 != 0) return false;
                return true;
            }
            case 3: {
                if (n2 == 0) return false;
                return true;
            }
            case 4: {
                if (n2 > 0) return false;
                return true;
            }
            case 5: {
                if (n2 < 0) return false;
                return true;
            }
        }
        throw new IllegalStateException("Unknown operation.");
    }

    public Object get(Tuple tuple) {
        return this.getBoolean(tuple) ? Boolean.TRUE : Boolean.FALSE;
    }

    public String toString() {
        String string = "?";
        switch (this.m_op) {
            case 0: {
                string = "<";
                break;
            }
            case 1: {
                string = ">";
                break;
            }
            case 2: {
                string = "=";
                break;
            }
            case 3: {
                string = "!=";
                break;
            }
            case 4: {
                string = "<=";
                break;
            }
            case 5: {
                string = ">=";
            }
        }
        return this.m_left.toString() + ' ' + string + ' ' + this.m_right.toString();
    }
}

