/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.expression;

import com.jidesoft.thirdparty.prefuse.data.Schema;
import com.jidesoft.thirdparty.prefuse.data.Tuple;
import com.jidesoft.thirdparty.prefuse.data.expression.Literal;
import com.jidesoft.thirdparty.prefuse.util.TypeLib;

public class NumericLiteral
extends Literal {
    private final Number m_number;
    private final Class m_type;

    public NumericLiteral(int n2) {
        this.m_number = new Integer(n2);
        this.m_type = Integer.TYPE;
    }

    public NumericLiteral(long l2) {
        this.m_number = new Long(l2);
        this.m_type = Long.TYPE;
    }

    public NumericLiteral(float f2) {
        this.m_number = new Float(f2);
        this.m_type = Float.TYPE;
    }

    public NumericLiteral(double d2) {
        this.m_number = new Double(d2);
        this.m_type = Double.TYPE;
    }

    public NumericLiteral(Object object) {
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("Invalid type!");
        }
        this.m_number = (Number)object;
        this.m_type = TypeLib.getPrimitiveType(this.m_number.getClass());
    }

    public Class getType(Schema schema) {
        return this.m_type;
    }

    public Object get(Tuple tuple) {
        return this.m_number;
    }

    public int getInt(Tuple tuple) {
        return this.m_number.intValue();
    }

    public long getLong(Tuple tuple) {
        return this.m_number.longValue();
    }

    public float getFloat(Tuple tuple) {
        return this.m_number.floatValue();
    }

    public double getDouble(Tuple tuple) {
        return this.m_number.doubleValue();
    }

    public String toString() {
        return this.m_number.toString();
    }
}

