/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.tuple;

import com.jidesoft.thirdparty.prefuse.data.Schema;
import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.Tuple;
import com.jidesoft.thirdparty.prefuse.data.event.TupleSetListener;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.Predicate;
import com.jidesoft.thirdparty.prefuse.data.tuple.TupleSet;
import com.jidesoft.thirdparty.prefuse.data.util.FilterIteratorFactory;
import com.jidesoft.thirdparty.prefuse.util.collections.CopyOnWriteArrayList;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class AbstractTupleSet
implements TupleSet {
    private CopyOnWriteArrayList m_tupleListeners;
    private HashMap m_props;
    private SwingPropertyChangeSupport m_propSupport;

    public Iterator tuples(Predicate predicate) {
        if (predicate == null) {
            return this.tuples();
        }
        return FilterIteratorFactory.tuples(this, predicate);
    }

    public void addTupleSetListener(TupleSetListener tupleSetListener) {
        if (this.m_tupleListeners == null) {
            this.m_tupleListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_tupleListeners.contains(tupleSetListener)) {
            this.m_tupleListeners.add(tupleSetListener);
        }
    }

    public void removeTupleSetListener(TupleSetListener tupleSetListener) {
        if (this.m_tupleListeners != null) {
            this.m_tupleListeners.remove(tupleSetListener);
        }
    }

    protected void fireTupleEvent(Table table, int n2, int n3, int n4) {
        if (this.m_tupleListeners != null && this.m_tupleListeners.size() > 0) {
            Object[] objectArray = this.m_tupleListeners.getArray();
            Tuple[] tupleArray = new Tuple[n3 - n2 + 1];
            int n5 = 0;
            int n6 = n2;
            while (n6 <= n3) {
                tupleArray[n5] = table.getTuple(n6);
                ++n6;
                ++n5;
            }
            for (n5 = 0; n5 < objectArray.length; ++n5) {
                TupleSetListener tupleSetListener = (TupleSetListener)objectArray[n5];
                if (n4 == 1) {
                    tupleSetListener.tupleSetChanged(this, tupleArray, EMPTY_ARRAY);
                    continue;
                }
                tupleSetListener.tupleSetChanged(this, EMPTY_ARRAY, tupleArray);
            }
        }
    }

    protected void fireTupleEvent(Tuple tuple, int n2) {
        if (this.m_tupleListeners != null && this.m_tupleListeners.size() > 0) {
            Object[] objectArray = this.m_tupleListeners.getArray();
            Tuple[] tupleArray = new Tuple[]{tuple};
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                TupleSetListener tupleSetListener = (TupleSetListener)objectArray[i2];
                if (n2 == 1) {
                    tupleSetListener.tupleSetChanged(this, tupleArray, EMPTY_ARRAY);
                    continue;
                }
                tupleSetListener.tupleSetChanged(this, EMPTY_ARRAY, tupleArray);
            }
        }
    }

    protected void fireTupleEvent(Tuple[] tupleArray, Tuple[] tupleArray2) {
        if (this.m_tupleListeners != null && this.m_tupleListeners.size() > 0) {
            Object[] objectArray = this.m_tupleListeners.getArray();
            tupleArray = tupleArray == null ? EMPTY_ARRAY : tupleArray;
            tupleArray2 = tupleArray2 == null ? EMPTY_ARRAY : tupleArray2;
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                TupleSetListener tupleSetListener = (TupleSetListener)objectArray[i2];
                tupleSetListener.tupleSetChanged(this, tupleArray, tupleArray2);
            }
        }
    }

    public boolean isAddColumnSupported() {
        return false;
    }

    public void addColumns(Schema schema) {
        if (this.isAddColumnSupported()) {
            for (int i2 = 0; i2 < schema.getColumnCount(); ++i2) {
                try {
                    this.addColumn(schema.getColumnName(i2), schema.getColumnType(i2), schema.getDefault(i2));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void addColumn(String string, Class clazz, Object object) {
        throw new UnsupportedOperationException();
    }

    public void addColumn(String string, Class clazz) {
        throw new UnsupportedOperationException();
    }

    public void addColumn(String string, Expression expression) {
        throw new UnsupportedOperationException();
    }

    public void addColumn(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.m_propSupport == null) {
            this.m_propSupport = new SwingPropertyChangeSupport(this);
        }
        this.m_propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.m_propSupport == null) {
            this.m_propSupport = new SwingPropertyChangeSupport(this);
        }
        this.m_propSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.m_propSupport == null) {
            return;
        }
        this.m_propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.m_propSupport == null) {
            return;
        }
        this.m_propSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void putClientProperty(String string, Object object) {
        Object object2 = null;
        if (this.m_props == null && object == null) {
            return;
        }
        if (object == null) {
            object2 = this.m_props.remove(string);
        } else {
            if (this.m_props == null) {
                this.m_props = new HashMap(2);
            }
            object2 = this.m_props.put(string, object);
        }
        if (this.m_propSupport != null) {
            this.m_propSupport.firePropertyChange(string, object2, object);
        }
    }

    public Object getClientProperty(String string) {
        return this.m_props == null ? null : this.m_props.get(string);
    }
}

