/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.tuple;

import com.jidesoft.thirdparty.prefuse.data.Schema;
import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.Tuple;
import java.util.Date;

public class TableTuple
implements Tuple {
    protected Table m_table;
    protected int m_row;

    protected void init(Table table, int n2) {
        this.m_table = table;
        this.m_row = this.m_table.isValidRow(n2) ? n2 : -1;
    }

    public Schema getSchema() {
        return this.m_table.getSchema();
    }

    public Table getTable() {
        return this.m_table;
    }

    public int getRow() {
        return this.m_row;
    }

    public boolean isValid() {
        return this.m_row != -1;
    }

    void invalidate() {
        this.m_row = -1;
    }

    private void validityCheck() {
        if (this.m_row == -1) {
            throw new IllegalStateException("This tuple is no longer valid. It has been deleted from its table");
        }
    }

    public Class getColumnType(String string) {
        return this.m_table.getColumnType(string);
    }

    public Class getColumnType(int n2) {
        return this.m_table.getColumnType(n2);
    }

    public int getColumnIndex(String string) {
        return this.m_table.getColumnNumber(string);
    }

    public int getColumnCount() {
        return this.m_table.getColumnCount();
    }

    public String getColumnName(int n2) {
        return this.m_table.getColumnName(n2);
    }

    public boolean canGet(String string, Class clazz) {
        return this.m_table.canGet(string, clazz);
    }

    public boolean canSet(String string, Class clazz) {
        return this.m_table.canSet(string, clazz);
    }

    public final Object get(String string) {
        this.validityCheck();
        return this.m_table.get(this.m_row, string);
    }

    public final void set(String string, Object object) {
        this.validityCheck();
        this.m_table.set(this.m_row, string, object);
    }

    public final Object getValueAt(int n2) {
        this.validityCheck();
        return this.m_table.getValueAt(this.m_row, n2);
    }

    public final void setValueAt(int n2, Object object) {
        this.validityCheck();
        this.m_table.setValueAt(this.m_row, n2, object);
    }

    public Object getDefault(String string) {
        this.validityCheck();
        return this.m_table.getDefault(string);
    }

    public void revertToDefault(String string) {
        this.validityCheck();
        this.m_table.revertToDefault(this.m_row, string);
    }

    public final boolean canGetInt(String string) {
        return this.m_table.canGetInt(string);
    }

    public final boolean canSetInt(String string) {
        return this.m_table.canSetInt(string);
    }

    public final int getInt(String string) {
        this.validityCheck();
        return this.m_table.getInt(this.m_row, string);
    }

    public final void setInt(String string, int n2) {
        this.validityCheck();
        this.m_table.setInt(this.m_row, string, n2);
    }

    public final boolean canGetLong(String string) {
        return this.m_table.canGetLong(string);
    }

    public final boolean canSetLong(String string) {
        return this.m_table.canSetLong(string);
    }

    public final long getLong(String string) {
        this.validityCheck();
        return this.m_table.getLong(this.m_row, string);
    }

    public final void setLong(String string, long l2) {
        this.validityCheck();
        this.m_table.setLong(this.m_row, string, l2);
    }

    public final boolean canGetFloat(String string) {
        return this.m_table.canGetFloat(string);
    }

    public final boolean canSetFloat(String string) {
        return this.m_table.canSetFloat(string);
    }

    public final float getFloat(String string) {
        this.validityCheck();
        return this.m_table.getFloat(this.m_row, string);
    }

    public final void setFloat(String string, float f2) {
        this.validityCheck();
        this.m_table.setFloat(this.m_row, string, f2);
    }

    public final boolean canGetDouble(String string) {
        return this.m_table.canGetDouble(string);
    }

    public final boolean canSetDouble(String string) {
        return this.m_table.canSetDouble(string);
    }

    public final double getDouble(String string) {
        this.validityCheck();
        return this.m_table.getDouble(this.m_row, string);
    }

    public final void setDouble(String string, double d2) {
        this.validityCheck();
        this.m_table.setDouble(this.m_row, string, d2);
    }

    public final boolean canGetBoolean(String string) {
        return this.m_table.canGetBoolean(string);
    }

    public final boolean canSetBoolean(String string) {
        return this.m_table.canSetBoolean(string);
    }

    public final boolean getBoolean(String string) {
        this.validityCheck();
        return this.m_table.getBoolean(this.m_row, string);
    }

    public final void setBoolean(String string, boolean bl) {
        this.validityCheck();
        this.m_table.setBoolean(this.m_row, string, bl);
    }

    public final boolean canGetString(String string) {
        return this.m_table.canGetString(string);
    }

    public final boolean canSetString(String string) {
        return this.m_table.canSetString(string);
    }

    public final String getString(String string) {
        this.validityCheck();
        return this.m_table.getString(this.m_row, string);
    }

    public final void setString(String string, String string2) {
        this.validityCheck();
        this.m_table.setString(this.m_row, string, string2);
    }

    public final boolean canGetDate(String string) {
        return this.m_table.canGetDate(string);
    }

    public final boolean canSetDate(String string) {
        return this.m_table.canSetDate(string);
    }

    public final Date getDate(String string) {
        this.validityCheck();
        return this.m_table.getDate(this.m_row, string);
    }

    public final void setDate(String string, Date date) {
        this.validityCheck();
        this.m_table.setDate(this.m_row, string, date);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Tuple[");
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            if (i2 > 0) {
                stringBuffer.append(',');
            }
            try {
                stringBuffer.append(this.getValueAt(i2).toString());
                continue;
            }
            catch (Exception exception) {
                stringBuffer.append("?");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

