/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.util;

import java.util.Arrays;

public class MathLib {
    public static final double TWO_PI = Math.PI * 2;
    public static final double LOG10 = Math.log(10.0);
    public static final double LOG2 = Math.log(2.0);

    private MathLib() {
    }

    public static double log2(double d2) {
        return Math.log(d2) / LOG2;
    }

    public static double log10(double d2) {
        return Math.log(d2) / LOG10;
    }

    public static double safeLog10(double d2) {
        boolean bl;
        boolean bl2 = bl = d2 < 0.0;
        if (bl) {
            d2 = -d2;
        }
        if (d2 < 10.0) {
            d2 += (10.0 - d2) / 10.0;
        }
        d2 = Math.log(d2) / LOG10;
        return bl ? -d2 : d2;
    }

    public static double safeSqrt(double d2) {
        return d2 < 0.0 ? -Math.sqrt(-d2) : Math.sqrt(d2);
    }

    public static double interp(int n2, double d2, double[] dArray) {
        switch (n2) {
            case 0: {
                return MathLib.linearInterp(d2, dArray[0], dArray[dArray.length - 1]);
            }
            case 1: {
                return MathLib.logInterp(d2, dArray[0], dArray[dArray.length - 1]);
            }
            case 2: {
                return MathLib.sqrtInterp(d2, dArray[0], dArray[dArray.length - 1]);
            }
            case 3: {
                return MathLib.quantile(d2, dArray);
            }
        }
        throw new IllegalArgumentException("Unrecognized scale value: " + n2);
    }

    public static double linearInterp(double d2, double d3, double d4) {
        double d5 = d4 - d3;
        if (d5 == 0.0) {
            return 0.0;
        }
        return (d2 - d3) / d5;
    }

    public static double logInterp(double d2, double d3, double d4) {
        double d5 = MathLib.safeLog10(d3);
        double d6 = MathLib.safeLog10(d4) - d5;
        if (d6 == 0.0) {
            return 0.0;
        }
        return (MathLib.safeLog10(d2) - d5) / d6;
    }

    public static double sqrtInterp(double d2, double d3, double d4) {
        double d5 = MathLib.safeSqrt(d3);
        double d6 = MathLib.safeSqrt(d4) - d5;
        if (d6 == 0.0) {
            return 0.0;
        }
        return (MathLib.safeSqrt(d2) - d5) / d6;
    }

    public static double[] quantiles(int n2, double[] dArray) {
        dArray = (double[])dArray.clone();
        Arrays.sort(dArray);
        double[] dArray2 = new double[n2 + 1];
        for (int i2 = 0; i2 <= n2; ++i2) {
            dArray2[i2] = dArray[(dArray.length - 1) * i2 / n2];
        }
        return dArray2;
    }

    public static double quantile(double d2, double[] dArray) {
        int n2 = 1;
        int n3 = dArray.length;
        int n4 = n3 / 2;
        while (n2 < n3 && dArray[n4] != d2) {
            if (dArray[n4] < d2) {
                n2 = n4 + 1;
            } else {
                n3 = n4;
            }
            n4 = n2 + (n3 - n2) / 2;
        }
        return (double)n4 / (double)(dArray.length - 1);
    }
}

