/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.util.collections;

import com.jidesoft.thirdparty.prefuse.util.collections.AbstractTreeMap;
import com.jidesoft.thirdparty.prefuse.util.collections.DoubleIntSortedMap;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIterator;
import com.jidesoft.thirdparty.prefuse.util.collections.LiteralComparator;
import com.jidesoft.thirdparty.prefuse.util.collections.LiteralIterator;

public class DoubleIntTreeMap
extends AbstractTreeMap
implements DoubleIntSortedMap {
    private DoubleEntry dummy = new DoubleEntry(Double.MIN_VALUE, Integer.MAX_VALUE, NIL, 0);

    public DoubleIntTreeMap() {
        this(null, false);
    }

    public DoubleIntTreeMap(boolean bl) {
        this(null, bl);
    }

    public DoubleIntTreeMap(LiteralComparator literalComparator) {
        this(literalComparator, false);
    }

    public DoubleIntTreeMap(LiteralComparator literalComparator, boolean bl) {
        super(literalComparator, bl);
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = NIL;
    }

    public boolean containsKey(double d2) {
        return this.find(d2, 0) != NIL;
    }

    public int get(double d2) {
        AbstractTreeMap.Entry entry = this.find(d2, 0);
        return entry == NIL ? Integer.MIN_VALUE : entry.val;
    }

    public int put(double d2, int n2) {
        AbstractTreeMap.Entry entry = this.root;
        this.lastOrder = 0;
        if (entry == NIL) {
            this.incrementSize(true);
            this.root = new DoubleEntry(d2, n2, NIL, this.lastOrder);
            return Integer.MIN_VALUE;
        }
        this.dummy.key = d2;
        this.dummy.order = Integer.MAX_VALUE;
        while (true) {
            int n3;
            if ((n3 = this.compare(this.dummy, entry)) == 0) {
                return entry.setValue(n2);
            }
            if (n3 < 0) {
                if (entry.left != NIL) {
                    entry = entry.left;
                    continue;
                }
                this.incrementSize(this.lastOrder == 0);
                entry.left = new DoubleEntry(d2, n2, entry, this.lastOrder);
                this.fixUpInsert(entry.left);
                return Integer.MIN_VALUE;
            }
            if (entry.right == NIL) break;
            entry = entry.right;
        }
        this.incrementSize(this.lastOrder == 0);
        entry.right = new DoubleEntry(d2, n2, entry, this.lastOrder);
        this.fixUpInsert(entry.right);
        return Integer.MIN_VALUE;
    }

    public int remove(double d2) {
        AbstractTreeMap.Entry entry = this.allowDuplicates ? this.findPredecessor(d2, Integer.MAX_VALUE) : this.find(d2, 0);
        if (entry == NIL) {
            return Integer.MIN_VALUE;
        }
        int n2 = entry.val;
        this.remove(entry);
        return n2;
    }

    public int remove(double d2, int n2) {
        AbstractTreeMap.Entry entry = this.findCeiling(d2, 0);
        if (entry != NIL && entry.getDoubleKey() != d2) {
            entry = this.successor(entry);
        }
        if (entry == NIL || entry.getDoubleKey() != d2) {
            return Integer.MIN_VALUE;
        }
        while (entry.val != n2 && entry != NIL) {
            entry = this.successor(entry);
        }
        if (entry == NIL) {
            return Integer.MIN_VALUE;
        }
        this.remove(entry);
        return n2;
    }

    public double firstKey() {
        return this.minimum(this.root).getDoubleKey();
    }

    public double lastKey() {
        return this.maximum(this.root).getDoubleKey();
    }

    public LiteralIterator keyIterator() {
        return new KeyIterator();
    }

    public LiteralIterator keyRangeIterator(double d2, boolean bl, double d3, boolean bl2) {
        AbstractTreeMap.Entry entry;
        AbstractTreeMap.Entry entry2;
        if (this.cmp.compare(d2, d3) <= 0) {
            entry2 = this.findCeiling(d2, bl ? 0 : Integer.MAX_VALUE);
            entry = this.findCeiling(d3, bl2 ? Integer.MAX_VALUE : 0);
        } else {
            entry2 = this.findCeiling(d2, bl ? Integer.MAX_VALUE : 0);
            entry2 = this.predecessor(entry2);
            entry = this.findCeiling(d3, bl2 ? 0 : Integer.MAX_VALUE);
            entry = this.predecessor(entry);
        }
        return new KeyIterator(entry2, entry);
    }

    public IntIterator valueRangeIterator(double d2, boolean bl, double d3, boolean bl2) {
        return new AbstractTreeMap.ValueIterator((AbstractTreeMap.EntryIterator)this.keyRangeIterator(d2, bl, d3, bl2));
    }

    protected int compare(AbstractTreeMap.Entry entry, AbstractTreeMap.Entry entry2) {
        int n2 = this.cmp.compare(entry.getDoubleKey(), entry2.getDoubleKey());
        if (this.allowDuplicates && n2 == 0) {
            n2 = entry.order < entry2.order ? -1 : (entry.order > entry2.order ? 1 : 0);
            this.lastOrder = 1 + (n2 < 0 ? entry.order : entry2.order);
        }
        return n2;
    }

    private AbstractTreeMap.Entry find(double d2, int n2) {
        this.dummy.key = d2;
        this.dummy.order = n2;
        AbstractTreeMap.Entry entry = this.find(this.dummy);
        return entry;
    }

    private AbstractTreeMap.Entry findPredecessor(double d2, int n2) {
        this.dummy.key = d2;
        this.dummy.order = n2;
        AbstractTreeMap.Entry entry = this.findPredecessor(this.dummy);
        return entry;
    }

    private AbstractTreeMap.Entry findCeiling(double d2, int n2) {
        this.dummy.key = d2;
        this.dummy.order = n2;
        AbstractTreeMap.Entry entry = this.findCeiling(this.dummy);
        return entry;
    }

    private class KeyIterator
    extends AbstractTreeMap.KeyIterator {
        public KeyIterator() {
        }

        public KeyIterator(AbstractTreeMap.Entry entry, AbstractTreeMap.Entry entry2) {
            super(entry, entry2);
        }

        public boolean isDoubleSupported() {
            return true;
        }

        public double nextDouble() {
            return this.nextEntry().getDoubleKey();
        }
    }

    static class DoubleEntry
    extends AbstractTreeMap.Entry {
        double key;

        public DoubleEntry(double d2, int n2) {
            super(n2);
            this.key = d2;
        }

        public DoubleEntry(double d2, int n2, AbstractTreeMap.Entry entry, int n3) {
            super(n2, entry, n3);
            this.key = d2;
        }

        public double getDoubleKey() {
            return this.key;
        }

        public Object getKey() {
            return new Double(this.key);
        }

        public boolean keyEquals(AbstractTreeMap.Entry entry) {
            return entry instanceof DoubleEntry && this.key == ((DoubleEntry)entry).key;
        }

        public boolean equals(Object object) {
            if (!(object instanceof DoubleEntry)) {
                return false;
            }
            DoubleEntry doubleEntry = (DoubleEntry)object;
            return this.key == doubleEntry.key && this.val == doubleEntry.val;
        }

        public int hashCode() {
            long l2 = Double.doubleToLongBits(this.key);
            int n2 = (int)(l2 ^ l2 >>> 32);
            int n3 = this.val;
            return n2 ^ n3 ^ this.order;
        }

        public String toString() {
            return this.key + "=" + this.val;
        }

        public void copyFields(AbstractTreeMap.Entry entry) {
            super.copyFields(entry);
            this.key = entry.getDoubleKey();
        }
    }
}

