/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.hierarchical;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.IlvGraphLayoutGrapherProperty;
import ilog.views.graphlayout.IlvGraphLayoutLinkProperty;
import ilog.views.graphlayout.IlvGraphLayoutNodeProperty;
import ilog.views.graphlayout.IlvGraphLayoutReport;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.IlvInappropriateLinkException;
import ilog.views.graphlayout.hierarchical.BuildLevelsAlgorithm;
import ilog.views.graphlayout.hierarchical.BuildRelPosNetsAlgorithm;
import ilog.views.graphlayout.hierarchical.CalcLevelingAlgorithm;
import ilog.views.graphlayout.hierarchical.ConstraintManager;
import ilog.views.graphlayout.hierarchical.CrossRedSwimLaneAlgorithm;
import ilog.views.graphlayout.hierarchical.CrossingReductionAlgorithm;
import ilog.views.graphlayout.hierarchical.CrossingReductionSwapAlgorithm;
import ilog.views.graphlayout.hierarchical.EastWestExpansionAlgorithm;
import ilog.views.graphlayout.hierarchical.EastWestLinkRemovalAlgorithm;
import ilog.views.graphlayout.hierarchical.EastWestLinkRoutingAlgorithm;
import ilog.views.graphlayout.hierarchical.ForkPointAlgorithm;
import ilog.views.graphlayout.hierarchical.HGraph;
import ilog.views.graphlayout.hierarchical.HGraphAlgorithm;
import ilog.views.graphlayout.hierarchical.HLevelAlgApplicator;
import ilog.views.graphlayout.hierarchical.HLevelAlgorithm;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalConstraint;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalLayoutGrapherProperty;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalLayoutLinkProperty;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalLayoutNodeProperty;
import ilog.views.graphlayout.hierarchical.NodePlacementAlgorithm;
import ilog.views.graphlayout.hierarchical.OptimizeLinksAlgorithm;
import ilog.views.graphlayout.hierarchical.OrthLinkRepositionAlgorithm;
import ilog.views.graphlayout.hierarchical.OrthRoutingAlgorithm;
import ilog.views.graphlayout.hierarchical.PolyLinkRepositionAlgorithm;
import ilog.views.graphlayout.hierarchical.SortAdjByCoordAlgorithm;
import ilog.views.graphlayout.hierarchical.SortAdjacenciesAlgorithm;
import ilog.views.graphlayout.hierarchical.StraightenChainAlgorithm;
import ilog.views.graphlayout.hierarchical.SwimLanePlacementAlgorithm;
import ilog.views.graphlayout.internalutil.LayoutParametersUtil;
import ilog.views.graphlayout.internalutil.LayoutUtil;
import ilog.views.graphlayout.internalutil.PercCompleteController;
import java.util.Enumeration;
import java.util.Vector;

public class IlvHierarchicalLayout
extends IlvGraphLayout {
    private static final String a = "LinkPriority";
    private static final String b = "LinkStyle";
    private static final String c = "FromPortIndex";
    private static final String d = "ToPortIndex";
    private static final String e = "FromPortSide";
    private static final String f = "ToPortSide";
    private static final String g = "SpecLevelIndex";
    private static final String h = "CalcLevelIndex";
    private static final String i = "SpecPositionIndex";
    private static final String j = "CalcPositionIndex";
    private static final String k = "NodePortNumber";
    private static final String l = "NodeConstraint0_";
    private static final String m = "NodeConstraint1_";
    private static final String n = "NodeConstraint2_";
    private static final String o = "IncrementalExpandNodeBox";
    private static final String p = "IncrementalMark";
    private static final String q = "IncrementalMovementMode";
    private static final String r = "OriginPointMode";
    private static final String s = "DestinationPointMode";
    private static final Boolean t = Boolean.TRUE;
    public static final int NO_RESHAPE_STYLE = 0;
    public static final int STRAIGHT_LINE_STYLE = 1;
    public static final int ORTHOGONAL_STYLE = 2;
    public static final int POLYLINE_STYLE = 3;
    public static final int MIXED_STYLE = 99;
    public static final int AUTOMATIC_PINS = 0;
    public static final int CENTERED_PINS = 1;
    public static final int CLIPPED_PINS = 2;
    public static final int EVENLY_SPACED_PINS = 3;
    public static final int EAST = 6;
    public static final int WEST = 7;
    public static final int NORTH = 8;
    public static final int SOUTH = 9;
    public static final int UNSPECIFIED = -1;
    public static final int FREE_MODE = 0;
    public static final int FIXED_MODE = 3;
    public static final int FIXED_IN_X_MODE = 1;
    public static final int FIXED_IN_Y_MODE = 2;
    public static final int MIXED_MODE = 99;
    static final int u = 3;
    private int v;
    static final int w = 0;
    private int x;
    static final boolean y = false;
    private boolean z;
    static final boolean aa = false;
    private boolean ab;
    static final float ac = 10.0f;
    private float ad;
    private float ae;
    static final int af = 0;
    static final int ag = 0;
    private int ah;
    private int ai;
    static final int aj = 2;
    private int ak;
    static final int al = 16;
    private int am;
    static final float an = 40.0f;
    private float ao;
    static final float ap = 40.0f;
    private float aq;
    static final float ar = 15.0f;
    private float as;
    static final float at = 15.0f;
    private float au;
    static final float av = 20.0f;
    private float aw;
    static final float ax = 20.0f;
    private float ay;
    static final float az = 90.0f;
    private float a0;
    static final boolean a1 = false;
    private boolean a2;
    static final boolean a3 = false;
    private boolean a4;
    static final boolean a5 = false;
    private boolean a6;
    static final boolean a7 = false;
    private boolean a8;
    static final boolean a9 = true;
    private boolean ba;
    static final float bb = 70.0f;
    private float bc;
    static final float bd = 20.0f;
    private float be;
    static final int bf = 0;
    private int bg;
    static final float bh = 0.0f;
    private float bi;
    private float bj;
    static final boolean bk = true;
    private boolean bl;
    static final boolean bm = true;
    private boolean bn;
    static final boolean bo = false;
    private boolean bp;
    static final boolean bq = true;
    private boolean br;
    static final boolean bs = true;
    private boolean bt;
    static final boolean bu = true;
    private boolean bv;
    static final int bw = 5;
    private int bx;
    static final boolean by = true;
    private boolean bz;
    static final IlvPoint b0 = null;
    private IlvPoint b1;
    private boolean b2;
    private boolean b3;
    private boolean b4;
    private PercCompleteController b5;
    private ConstraintManager b6;
    private boolean b7 = false;
    private boolean b8;
    private boolean b9;
    private boolean ca;
    private boolean cb;
    private int cc;

    public IlvHierarchicalLayout() {
    }

    public IlvHierarchicalLayout(IlvHierarchicalLayout ilvHierarchicalLayout) {
        super(ilvHierarchicalLayout);
    }

    protected void init() {
        super.init();
        this.v = 3;
        this.x = 0;
        this.z = false;
        this.ab = false;
        this.ad = 10.0f;
        this.ae = 10.0f;
        this.ah = 0;
        this.ai = 0;
        this.ak = 2;
        this.am = 16;
        this.ao = 40.0f;
        this.aq = 40.0f;
        this.as = 15.0f;
        this.au = 15.0f;
        this.aw = 20.0f;
        this.ay = 20.0f;
        this.a0 = 90.0f;
        this.a2 = false;
        this.a4 = false;
        this.a6 = false;
        this.a8 = false;
        this.ba = true;
        this.bc = 70.0f;
        this.be = 20.0f;
        this.bg = 0;
        this.bi = 0.0f;
        this.bj = 0.0f;
        this.bl = true;
        this.bn = true;
        this.bp = false;
        this.br = true;
        this.bt = true;
        this.bv = true;
        this.bx = 5;
        this.bz = true;
        this.b1 = b0;
        this.b3 = true;
        this.b6 = new ConstraintManager();
        super.setAllowedTime(100000000L);
    }

    public IlvGraphLayout copy() {
        return new IlvHierarchicalLayout(this);
    }

    public void copyParameters(IlvGraphLayout ilvGraphLayout) {
        super.copyParameters(ilvGraphLayout);
        if (ilvGraphLayout instanceof IlvHierarchicalLayout) {
            IlvHierarchicalLayout ilvHierarchicalLayout = (IlvHierarchicalLayout)ilvGraphLayout;
            this.setGlobalLinkStyle(ilvHierarchicalLayout.getGlobalLinkStyle());
            this.setConnectorStyle(ilvHierarchicalLayout.getConnectorStyle());
            this.setFromFork(ilvHierarchicalLayout.isFromFork());
            this.setToFork(ilvHierarchicalLayout.isToFork());
            this.setMinForkSegmentLength(ilvHierarchicalLayout.getMinForkSegmentLength());
            this.setPreferredForkAxisLength(ilvHierarchicalLayout.getPreferredForkAxisLength());
            this.setGlobalOriginPointMode(ilvHierarchicalLayout.getGlobalOriginPointMode());
            this.setGlobalDestinationPointMode(ilvHierarchicalLayout.getGlobalDestinationPointMode());
            this.setFlowDirection(ilvHierarchicalLayout.getFlowDirection());
            this.setLevelJustification(ilvHierarchicalLayout.getLevelJustification());
            this.setHorizontalNodeOffset(ilvHierarchicalLayout.getHorizontalNodeOffset());
            this.setVerticalNodeOffset(ilvHierarchicalLayout.getVerticalNodeOffset());
            this.setHorizontalLinkOffset(ilvHierarchicalLayout.getHorizontalLinkOffset());
            this.setVerticalLinkOffset(ilvHierarchicalLayout.getVerticalLinkOffset());
            this.setHorizontalNodeLinkOffset(ilvHierarchicalLayout.getHorizontalNodeLinkOffset());
            this.setVerticalNodeLinkOffset(ilvHierarchicalLayout.getVerticalNodeLinkOffset());
            this.setMaxInterLevelApertureAngle(ilvHierarchicalLayout.getMaxInterLevelApertureAngle());
            this.setLinkWidthUsed(ilvHierarchicalLayout.isLinkWidthUsed());
            this.setMinStartSegmentLength(ilvHierarchicalLayout.getMinStartSegmentLength());
            this.setMinEndSegmentLength(ilvHierarchicalLayout.getMinEndSegmentLength());
            this.setIncrementalMode(ilvHierarchicalLayout.isIncrementalMode());
            this.setCrossingReductionDuringIncremental(ilvHierarchicalLayout.isCrossingReductionDuringIncremental());
            this.setLongLinkCrossingReductionDuringIncremental(ilvHierarchicalLayout.isLongLinkCrossingReductionDuringIncremental());
            this.setIncrementalAbsoluteLevelPositioning(ilvHierarchicalLayout.isIncrementalAbsoluteLevelPositioning());
            this.setIncrementalAbsoluteLevelPositionTendency(ilvHierarchicalLayout.getIncrementalAbsoluteLevelPositionTendency());
            this.setIncrementalAbsoluteLevelPositionRange(ilvHierarchicalLayout.getIncrementalAbsoluteLevelPositionRange());
            this.setGlobalIncrementalNodeMovementMode(ilvHierarchicalLayout.getGlobalIncrementalNodeMovementMode());
            this.setPolylineLinkOverlapReductionEnabled(ilvHierarchicalLayout.isPolylineLinkOverlapReductionEnabled());
            this.setNeighborLinksAligned(ilvHierarchicalLayout.isNeighborLinksAligned());
            this.setIntergraphConnectivityMode(ilvHierarchicalLayout.isIntergraphConnectivityMode());
            this.setLinkStraighteningEnabled(ilvHierarchicalLayout.isLinkStraighteningEnabled());
            this.setBacktrackCrossingReductionEnabled(ilvHierarchicalLayout.isBacktrackCrossingReductionEnabled());
            this.setMedianCrossingValueEnabled(ilvHierarchicalLayout.isMedianCrossingValueEnabled());
            this.setNumberOfLinkCrossingSweeps(ilvHierarchicalLayout.getNumberOfLinkCrossingSweeps());
            this.setLinkCrossingFineTuningEnabled(ilvHierarchicalLayout.isLinkCrossingFineTuningEnabled());
        }
    }

    protected void beforeLayout(boolean bl) {
        super.beforeLayout(bl);
        this.validateConstraints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void layout(boolean bl) throws IlvGraphLayoutException, IlvInappropriateLinkException {
        this.b4 = false;
        this.b3 = true;
        this.b2 = false;
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        IlvGraphLayoutReport ilvGraphLayoutReport = this.getLayoutReport();
        this.checkAppropriateLinks();
        HGraph hGraph = new HGraph(this);
        this.b5 = hGraph.a7();
        this.b5.setStepEstimation(17);
        this.callLayoutStepPerformedIfNeeded();
        this.a(hGraph);
        hGraph.a(ilvGraphModel, this);
        if (hGraph.l() > 0) {
            ConstraintManager constraintManager = this.e();
            try {
                if (this.isIntergraphConnectivityMode()) {
                    hGraph.i();
                }
                HGraphAlgorithm hGraphAlgorithm = null;
                HLevelAlgorithm hLevelAlgorithm = null;
                CalcLevelingAlgorithm calcLevelingAlgorithm = null;
                if (this.f()) {
                    calcLevelingAlgorithm = new CalcLevelingAlgorithm(hGraph, constraintManager);
                    calcLevelingAlgorithm.run();
                    if (calcLevelingAlgorithm.needFirstBypassLevel()) {
                        hGraph.a5();
                    }
                    this.callLayoutStepPerformedIfNeeded();
                }
                if (this.f()) {
                    hGraphAlgorithm = new BuildLevelsAlgorithm(hGraph);
                    calcLevelingAlgorithm.a();
                    calcLevelingAlgorithm = null;
                    hGraphAlgorithm.run();
                    hGraphAlgorithm.a();
                }
                if (this.f()) {
                    hGraphAlgorithm = new BuildRelPosNetsAlgorithm(hGraph, constraintManager);
                    hGraphAlgorithm.run();
                    hGraphAlgorithm.a();
                }
                if (this.f()) {
                    hGraphAlgorithm = new CrossingReductionAlgorithm(hGraph);
                    hGraphAlgorithm.run();
                    hGraphAlgorithm.a();
                }
                if (this.f() && hGraph.af()) {
                    hGraphAlgorithm = new CrossRedSwimLaneAlgorithm(hGraph);
                    hGraphAlgorithm.run();
                    hGraphAlgorithm.a();
                }
                if (this.f() && this.isLinkCrossingFineTuningEnabled()) {
                    hLevelAlgorithm = new CrossingReductionSwapAlgorithm();
                    hGraphAlgorithm = new HLevelAlgApplicator(hGraph, hLevelAlgorithm, false);
                    hGraphAlgorithm.run();
                    hGraphAlgorithm.a();
                }
                if (this.f() && hGraph.a0()) {
                    hGraphAlgorithm = new EastWestExpansionAlgorithm(hGraph);
                    hGraphAlgorithm.run();
                    hGraphAlgorithm.a();
                } else {
                    this.b5.startStep(hGraph.ap, 1);
                }
                hGraph.j();
                if (this.f()) {
                    this.b5.startStep(1.0f, hGraph.o() - 1);
                    hLevelAlgorithm = new EastWestLinkRemovalAlgorithm();
                    hGraphAlgorithm = new HLevelAlgApplicator(hGraph, hLevelAlgorithm, false);
                    hGraphAlgorithm.run();
                    hGraphAlgorithm.a();
                    hGraph.c();
                }
                SwimLanePlacementAlgorithm swimLanePlacementAlgorithm = new SwimLanePlacementAlgorithm(hGraph);
                if (this.f()) {
                    hGraphAlgorithm = new NodePlacementAlgorithm(hGraph, swimLanePlacementAlgorithm);
                    hGraphAlgorithm.run();
                    hGraphAlgorithm.a();
                }
                if (this.f()) {
                    hGraphAlgorithm = new SortAdjacenciesAlgorithm(hGraph);
                    hGraphAlgorithm.run();
                    hGraphAlgorithm.a();
                }
                if (this.f()) {
                    hGraph.as().run();
                    swimLanePlacementAlgorithm.setUseConnectionPoints(true);
                }
                if (this.isLinkStraighteningEnabled() && this.f()) {
                    swimLanePlacementAlgorithm.calcSwimLaneBorders(false);
                    swimLanePlacementAlgorithm.calcSwimLaneBounds();
                    if (hGraph.af()) {
                        hGraph.al();
                    }
                    hGraphAlgorithm = new StraightenChainAlgorithm(hGraph, true);
                    hGraphAlgorithm.run();
                    hGraphAlgorithm.a();
                    if (hGraph.af()) {
                        hGraph.al();
                    }
                }
                if (this.f()) {
                    hGraphAlgorithm = new SortAdjByCoordAlgorithm(hGraph);
                    hGraphAlgorithm.run();
                    hGraphAlgorithm.a();
                }
                if (hGraph.az() && this.f()) {
                    ForkPointAlgorithm forkPointAlgorithm = new ForkPointAlgorithm(hGraph);
                    forkPointAlgorithm.run();
                    forkPointAlgorithm.d();
                    swimLanePlacementAlgorithm.calcSwimLaneBorders(false);
                    swimLanePlacementAlgorithm.calcSwimLaneBounds();
                    this.b5.startStep(hGraph.au, hGraph.o() - 1);
                    if (hGraph.af()) {
                        hGraph.al();
                    }
                    hLevelAlgorithm = new OrthLinkRepositionAlgorithm(hGraph);
                    hGraphAlgorithm = new HLevelAlgApplicator(hGraph, hLevelAlgorithm, false);
                    hGraphAlgorithm.run();
                    hGraphAlgorithm.a();
                    hLevelAlgorithm.a();
                    if (hGraph.af()) {
                        hGraph.al();
                    }
                    if (hGraph.af()) {
                        swimLanePlacementAlgorithm.calcFinalSwimLaneBounds();
                        forkPointAlgorithm.d();
                        forkPointAlgorithm.run();
                        forkPointAlgorithm.d();
                    }
                    hGraphAlgorithm = new OrthRoutingAlgorithm(hGraph);
                    hGraphAlgorithm.run();
                    hGraphAlgorithm.a();
                    forkPointAlgorithm.d();
                    forkPointAlgorithm.e();
                    forkPointAlgorithm.a();
                } else if (this.b5 != null) {
                    this.b5.startStep(hGraph.au, 1);
                    this.b5.startStep(hGraph.av, 1);
                    swimLanePlacementAlgorithm.calcFinalSwimLaneBounds();
                }
                swimLanePlacementAlgorithm.a();
                if (this.f() && this.isPolylineLinkOverlapReductionEnabled()) {
                    this.b5.startStep(hGraph.ax, hGraph.o() - 1);
                    hLevelAlgorithm = new PolyLinkRepositionAlgorithm();
                    hGraphAlgorithm = new HLevelAlgApplicator(hGraph, hLevelAlgorithm, false);
                    hGraphAlgorithm.run();
                    hGraphAlgorithm.a();
                    hLevelAlgorithm.a();
                }
                if (this.f()) {
                    hGraphAlgorithm = new OptimizeLinksAlgorithm(hGraph);
                    hGraphAlgorithm.run();
                    hGraphAlgorithm.a();
                }
                if (this.f()) {
                    hGraph.as().fixEastWestPorts();
                }
                if (this.f()) {
                    hGraphAlgorithm = new EastWestLinkRoutingAlgorithm(hGraph);
                    hGraphAlgorithm.run();
                    hGraphAlgorithm.a();
                }
                if (this.f()) {
                    hGraph.ad();
                }
            }
            finally {
                constraintManager.b(hGraph);
            }
        }
        this.b2 = true;
        this.b3 = false;
        hGraph.a(bl);
        hGraph.a();
        if (this.isIncrementalMode()) {
            this.c();
        }
        this.increasePercentageComplete(100);
        this.layoutStepPerformed();
        if (this.b4) {
            ilvGraphLayoutReport.setCode(7);
        } else {
            ilvGraphLayoutReport.setCode(5);
        }
        this.b3 = true;
    }

    public final boolean supportsPreserveFixedNodes() {
        return true;
    }

    public final boolean supportsPreserveFixedLinks() {
        return true;
    }

    public final boolean supportsAllowedTime() {
        return true;
    }

    public boolean supportsStopImmediately() {
        return true;
    }

    public boolean stopImmediately() {
        if (this.isStoppedImmediately()) {
            return true;
        }
        if (!this.b3) {
            return false;
        }
        return super.stopImmediately();
    }

    public final boolean supportsPercentageComplete() {
        return true;
    }

    public final boolean supportsLayoutOfConnectedComponents() {
        return true;
    }

    public boolean supportsLinkConnectionBox() {
        return true;
    }

    public boolean supportsLinkClipping() {
        return true;
    }

    public boolean supportsSaveParametersToNamedProperties() {
        return true;
    }

    public final void setFlowDirection(int n) {
        if (n != 1 && n != 2 && n != 4 && n != 8) {
            throw new IllegalArgumentException("unsupported flow direction option: " + n);
        }
        if (n != this.ak) {
            this.setParametersUpToDate(false);
        }
        this.ak = n;
    }

    public final int getFlowDirection() {
        if (this.isUseDefaultParameters()) {
            return 2;
        }
        return this.ak;
    }

    public final void setLevelJustification(int n) {
        if (n != 1 && n != 2 && n != 4 && n != 8 && n != 16) {
            throw new IllegalArgumentException("unsupported level justification option: " + n);
        }
        if (n != this.am) {
            this.setParametersUpToDate(false);
        }
        this.am = n;
    }

    public final int getLevelJustification() {
        if (this.isUseDefaultParameters()) {
            return 16;
        }
        return this.am;
    }

    public final void setConnectorStyle(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("unsupported style option: " + n);
        }
        if (n != this.x) {
            this.setParametersUpToDate(false);
        }
        this.x = n;
    }

    public final int getConnectorStyle() {
        if (this.isUseDefaultParameters()) {
            return 0;
        }
        return this.x;
    }

    public final void setFromFork(boolean bl) {
        if (this.z != bl) {
            this.setParametersUpToDate(false);
        }
        this.z = bl;
    }

    public final boolean isFromFork() {
        if (this.isUseDefaultParameters()) {
            return false;
        }
        return this.z;
    }

    public final void setToFork(boolean bl) {
        if (this.ab != bl) {
            this.setParametersUpToDate(false);
        }
        this.ab = bl;
    }

    public final boolean isToFork() {
        if (this.isUseDefaultParameters()) {
            return false;
        }
        return this.ab;
    }

    public void setMinForkSegmentLength(float f) {
        if (this.ad != f) {
            this.setParametersUpToDate(false);
        }
        this.ad = f;
    }

    public final float getMinForkSegmentLength() {
        if (this.isUseDefaultParameters()) {
            return 10.0f;
        }
        return this.ad;
    }

    public void setPreferredForkAxisLength(float f) {
        if (this.ae != f) {
            this.setParametersUpToDate(false);
        }
        this.ae = f;
    }

    public final float getPreferredForkAxisLength() {
        if (this.isUseDefaultParameters()) {
            return 10.0f;
        }
        return this.ae;
    }

    public final void setGlobalLinkStyle(int n) {
        if (n != 3 && n != 2 && n != 1 && n != 99 && n != 0) {
            throw new IllegalArgumentException("unsupported style option: " + n);
        }
        if (n != this.v) {
            this.setParametersUpToDate(false);
        }
        this.v = n;
    }

    public final int getGlobalLinkStyle() {
        if (this.isUseDefaultParameters()) {
            return 3;
        }
        return this.v;
    }

    public final void setLinkStyle(Object object, int n) {
        if (n != 3 && n != 2 && n != 1 && n != 0) {
            throw new IllegalArgumentException("unsupported style option: " + n);
        }
        LayoutParametersUtil.SetLinkParameter((IlvGraphLayout)this, object, b, n, 3);
    }

    public final int getLinkStyle(Object object) {
        return LayoutParametersUtil.GetLinkParameter((IlvGraphLayout)this, object, b, 3);
    }

    public final void setHorizontalNodeOffset(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("negative horizontal node offset: " + f);
        }
        if (f != this.ao) {
            this.setParametersUpToDate(false);
        }
        this.ao = f;
    }

    public final float getHorizontalNodeOffset() {
        if (this.isUseDefaultParameters()) {
            return 40.0f;
        }
        return this.ao;
    }

    public final void setVerticalNodeOffset(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("negative vertical node offset: " + f);
        }
        if (f != this.aq) {
            this.setParametersUpToDate(false);
        }
        this.aq = f;
    }

    public final float getVerticalNodeOffset() {
        if (this.isUseDefaultParameters()) {
            return 40.0f;
        }
        return this.aq;
    }

    public final void setHorizontalLinkOffset(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("negative horizontal link offset: " + f);
        }
        if (f != this.as) {
            this.setParametersUpToDate(false);
        }
        this.as = f;
    }

    public final float getHorizontalLinkOffset() {
        if (this.isUseDefaultParameters()) {
            return 15.0f;
        }
        return this.as;
    }

    public final void setVerticalLinkOffset(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("negative vertical link offset: " + f);
        }
        if (f != this.au) {
            this.setParametersUpToDate(false);
        }
        this.au = f;
    }

    public final float getVerticalLinkOffset() {
        if (this.isUseDefaultParameters()) {
            return 15.0f;
        }
        return this.au;
    }

    public final void setHorizontalNodeLinkOffset(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("negative horizontal node link offset: " + f);
        }
        if (f != this.aw) {
            this.setParametersUpToDate(false);
        }
        this.aw = f;
    }

    public final float getHorizontalNodeLinkOffset() {
        if (this.isUseDefaultParameters()) {
            return 20.0f;
        }
        return this.aw;
    }

    public final void setVerticalNodeLinkOffset(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("negative vertical node link offset: " + f);
        }
        if (f != this.ay) {
            this.setParametersUpToDate(false);
        }
        this.ay = f;
    }

    public final float getVerticalNodeLinkOffset() {
        if (this.isUseDefaultParameters()) {
            return 20.0f;
        }
        return this.ay;
    }

    public final void setMaxInterLevelApertureAngle(float f) {
        if (f < 10.0f || f > 90.0f) {
            throw new IllegalArgumentException("aperture angle must be between 10 and 90");
        }
        if (f != this.a0) {
            this.setParametersUpToDate(false);
        }
        this.a0 = f;
    }

    public final float getMaxInterLevelApertureAngle() {
        if (this.isUseDefaultParameters()) {
            return 90.0f;
        }
        return this.a0;
    }

    public final void setLinkWidthUsed(boolean bl) {
        if (bl != this.a2) {
            this.setParametersUpToDate(false);
        }
        this.a2 = bl;
    }

    public final boolean isLinkWidthUsed() {
        if (this.isUseDefaultParameters()) {
            return false;
        }
        return this.a2;
    }

    public final void setMinStartSegmentLength(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Negative minimal start segment length: " + f);
        }
        if (f != this.bi) {
            this.setParametersUpToDate(false);
        }
        this.bi = f;
    }

    public final float getMinStartSegmentLength() {
        if (this.isUseDefaultParameters()) {
            return 0.0f;
        }
        return this.bi;
    }

    public final void setMinEndSegmentLength(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Negative minimal end segment length: " + f);
        }
        if (f != this.bj) {
            this.setParametersUpToDate(false);
        }
        this.bj = f;
    }

    public final float getMinEndSegmentLength() {
        if (this.isUseDefaultParameters()) {
            return 0.0f;
        }
        return this.bj;
    }

    public final void setPosition(IlvPoint ilvPoint) {
        if (ilvPoint != null && this.b1 != null && !ilvPoint.equals((Object)this.b1)) {
            this.setParametersUpToDate(false);
        }
        if (ilvPoint == null && this.b1 != null) {
            this.setParametersUpToDate(false);
        }
        if (ilvPoint != null && this.b1 == null) {
            this.setParametersUpToDate(false);
        }
        this.b1 = ilvPoint == null ? null : new IlvPoint(ilvPoint);
    }

    public final IlvPoint getPosition() {
        if (this.isUseDefaultParameters()) {
            return b0;
        }
        return this.b1 != null ? new IlvPoint(this.b1) : null;
    }

    public final void setLinkPriority(Object object, float f) {
        if (f > 10000.0f) {
            f = 10000.0f;
        }
        LayoutParametersUtil.SetLinkParameter((IlvGraphLayout)this, object, a, f, 1.0f);
    }

    public final float getLinkPriority(Object object) {
        return LayoutParametersUtil.GetLinkParameter((IlvGraphLayout)this, object, a, 1.0f);
    }

    public final void setFromPortIndex(Object object, int n) {
        if (n < 0) {
            n = -1;
        }
        LayoutParametersUtil.SetLinkParameter((IlvGraphLayout)this, object, c, n, -1);
    }

    public final int getFromPortIndex(Object object) {
        return LayoutParametersUtil.GetLinkParameter((IlvGraphLayout)this, object, c, -1);
    }

    public final void setToPortIndex(Object object, int n) {
        if (n < 0) {
            n = -1;
        }
        LayoutParametersUtil.SetLinkParameter((IlvGraphLayout)this, object, d, n, -1);
    }

    public final int getToPortIndex(Object object) {
        return LayoutParametersUtil.GetLinkParameter((IlvGraphLayout)this, object, d, -1);
    }

    public final void setFromPortSide(Object object, int n) {
        if (n == 0) {
            n = -1;
        }
        LayoutParametersUtil.SetLinkParameter((IlvGraphLayout)this, object, e, n, -1);
    }

    public final int getFromPortSide(Object object) {
        return LayoutParametersUtil.GetLinkParameter((IlvGraphLayout)this, object, e, -1);
    }

    public final void setToPortSide(Object object, int n) {
        if (n == 0) {
            n = -1;
        }
        LayoutParametersUtil.SetLinkParameter((IlvGraphLayout)this, object, f, n, -1);
    }

    public final int getToPortSide(Object object) {
        return LayoutParametersUtil.GetLinkParameter((IlvGraphLayout)this, object, f, -1);
    }

    public final void setNumberOfPorts(Object object, int n, int n2) {
        if (n != 6 && n != 7 && n != 8 && n != 9) {
            throw new IllegalArgumentException("unsupported side option: " + n);
        }
        int n3 = this.getNumberOfPorts(object, n);
        int[] nArray = this.a(object);
        if (nArray == null) {
            nArray = new int[4];
            nArray[3] = -1;
            nArray[2] = -1;
            nArray[1] = -1;
            nArray[0] = -1;
        }
        switch (n) {
            case 6: {
                nArray[1] = n2;
                break;
            }
            case 7: {
                nArray[3] = n2;
                break;
            }
            case 8: {
                nArray[0] = n2;
                break;
            }
            case 9: {
                nArray[2] = n2;
            }
        }
        if (nArray[0] < 0 && nArray[1] < 0 && nArray[2] < 0 && nArray[3] < 0) {
            nArray = null;
        }
        LayoutParametersUtil.SetNodeProperty(this, object, "The input node", true, k, nArray);
        if (n3 != this.getNumberOfPorts(object, n)) {
            this.setParametersUpToDate(false);
        }
    }

    public final int getNumberOfPorts(Object object, int n) {
        if (n != 6 && n != 7 && n != 8 && n != 9) {
            throw new IllegalArgumentException("unsupported side option: " + n);
        }
        if (this.isUseDefaultParameters()) {
            return -1;
        }
        int[] nArray = this.a(object);
        if (nArray != null) {
            switch (n) {
                case 6: {
                    return nArray[1];
                }
                case 7: {
                    return nArray[3];
                }
                case 8: {
                    return nArray[0];
                }
                case 9: {
                    return nArray[2];
                }
            }
        }
        return -1;
    }

    public final void setEastNumberOfPorts(Object object, int n) {
        this.setNumberOfPorts(object, 6, n);
    }

    public final int getEastNumberOfPorts(Object object) {
        return this.getNumberOfPorts(object, 6);
    }

    public final void setWestNumberOfPorts(Object object, int n) {
        this.setNumberOfPorts(object, 7, n);
    }

    public final int getWestNumberOfPorts(Object object) {
        return this.getNumberOfPorts(object, 7);
    }

    public final void setNorthNumberOfPorts(Object object, int n) {
        this.setNumberOfPorts(object, 8, n);
    }

    public final int getNorthNumberOfPorts(Object object) {
        return this.getNumberOfPorts(object, 8);
    }

    public final void setSouthNumberOfPorts(Object object, int n) {
        this.setNumberOfPorts(object, 9, n);
    }

    public final int getSouthNumberOfPorts(Object object) {
        return this.getNumberOfPorts(object, 9);
    }

    final int[] a(Object object) {
        return (int[])LayoutParametersUtil.GetNodeProperty(this, object, k);
    }

    public final void setSpecNodeLevelIndex(Object object, int n) {
        if (n < 0) {
            n = -1;
        }
        LayoutParametersUtil.SetNodeParameter((IlvGraphLayout)this, object, g, n, -1);
    }

    public final int getSpecNodeLevelIndex(Object object) {
        return LayoutParametersUtil.GetNodeParameter((IlvGraphLayout)this, object, g, -1);
    }

    public final int getCalcNodeLevelIndex(Object object) {
        Integer n = (Integer)LayoutParametersUtil.GetNodeProperty(this, object, h);
        if (n != null) {
            return n;
        }
        return -1;
    }

    final void a(Object object, int n) {
        LayoutParametersUtil.SetNodeProperty(this, object, null, false, h, new Integer(n));
    }

    public final void setSpecNodePositionIndex(Object object, int n) {
        if (n < 0) {
            n = -1;
        }
        LayoutParametersUtil.SetNodeParameter((IlvGraphLayout)this, object, i, n, -1);
    }

    public final int getSpecNodePositionIndex(Object object) {
        return LayoutParametersUtil.GetNodeParameter((IlvGraphLayout)this, object, i, -1);
    }

    public final int getCalcNodePositionIndex(Object object) {
        Integer n = (Integer)LayoutParametersUtil.GetNodeProperty(this, object, j);
        if (n != null) {
            return n;
        }
        return -1;
    }

    final void b(Object object, int n) {
        LayoutParametersUtil.SetNodeProperty(this, object, null, false, j, new Integer(n));
    }

    public final void setGlobalOriginPointMode(int n) {
        if (n != 0 && n != 3 && n != 99) {
            throw new IllegalArgumentException("Unsupported mode: " + n);
        }
        if (n != this.ah) {
            this.setParametersUpToDate(false);
        }
        this.ah = n;
    }

    public final int getGlobalOriginPointMode() {
        return this.isUseDefaultParameters() ? 0 : this.ah;
    }

    public final void setGlobalDestinationPointMode(int n) {
        if (n != 0 && n != 3 && n != 99) {
            throw new IllegalArgumentException("Unsupported mode: " + n);
        }
        if (n != this.ai) {
            this.setParametersUpToDate(false);
        }
        this.ai = n;
    }

    public final int getGlobalDestinationPointMode() {
        return this.isUseDefaultParameters() ? 0 : this.ai;
    }

    public final void setOriginPointMode(Object object, int n) {
        if (n != 0 && n != 3) {
            throw new IllegalArgumentException("Unsupported mode: " + n);
        }
        LayoutParametersUtil.SetLinkParameter((IlvGraphLayout)this, object, r, n, 0);
    }

    public int getOriginPointMode(Object object) {
        return LayoutParametersUtil.GetLinkParameter((IlvGraphLayout)this, object, r, 0);
    }

    public final void setDestinationPointMode(Object object, int n) {
        if (n != 0 && n != 3) {
            throw new IllegalArgumentException("Unsupported mode: " + n);
        }
        LayoutParametersUtil.SetLinkParameter((IlvGraphLayout)this, object, s, n, 0);
    }

    public int getDestinationPointMode(Object object) {
        return LayoutParametersUtil.GetLinkParameter((IlvGraphLayout)this, object, s, 0);
    }

    public final void setIncrementalMode(boolean bl) {
        if (bl != this.a4) {
            this.setParametersUpToDate(false);
        }
        this.a4 = bl;
    }

    public final boolean isIncrementalMode() {
        return this.isUseDefaultParameters() ? false : this.a4;
    }

    public final void markForIncremental(Object object) {
        LayoutParametersUtil.SetNodeOrLinkProperty(this, object, "The input node or link", true, true, p, t);
    }

    final void c() {
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        if (ilvGraphModel != null) {
            Enumeration enumeration = ilvGraphModel.getNodesAndLinks();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                LayoutParametersUtil.SetNodeOrLinkProperty(this, e, null, false, false, p, null);
            }
        }
    }

    final boolean b(Object object) {
        return LayoutParametersUtil.GetNodeOrLinkProperty(this, object, p) != null;
    }

    public final void setCrossingReductionDuringIncremental(boolean bl) {
        if (bl != this.a6) {
            this.setParametersUpToDate(false);
        }
        this.a6 = bl;
    }

    public final boolean isCrossingReductionDuringIncremental() {
        if (this.isUseDefaultParameters()) {
            return false;
        }
        return this.a6;
    }

    public final void setLongLinkCrossingReductionDuringIncremental(boolean bl) {
        if (bl != this.a8) {
            this.setParametersUpToDate(false);
        }
        this.a8 = bl;
    }

    public final boolean isLongLinkCrossingReductionDuringIncremental() {
        if (this.isUseDefaultParameters()) {
            return false;
        }
        return this.a8;
    }

    public final void setIncrementalAbsoluteLevelPositioning(boolean bl) {
        if (bl != this.ba) {
            this.setParametersUpToDate(false);
        }
        this.ba = bl;
    }

    public final boolean isIncrementalAbsoluteLevelPositioning() {
        if (this.isUseDefaultParameters()) {
            return true;
        }
        return this.ba;
    }

    public final void setIncrementalAbsoluteLevelPositionTendency(float f) {
        block5: {
            block4: {
                if (f < 0.0f) break block4;
                if (!(f > 100.0f)) break block5;
            }
            throw new IllegalArgumentException("illegal percentage value: " + f);
        }
        if (f != this.bc) {
            this.setParametersUpToDate(false);
        }
        this.bc = f;
    }

    public final float getIncrementalAbsoluteLevelPositionTendency() {
        if (this.isUseDefaultParameters()) {
            return 70.0f;
        }
        return this.bc;
    }

    public final void setIncrementalAbsoluteLevelPositionRange(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("illegal negative range: " + f);
        }
        if (f != this.be) {
            this.setParametersUpToDate(false);
        }
        this.be = f;
    }

    public final float getIncrementalAbsoluteLevelPositionRange() {
        if (this.isUseDefaultParameters()) {
            return 20.0f;
        }
        return this.be;
    }

    public final void setIncrementalNodeBoxForExpand(Object object, IlvRect ilvRect) {
        LayoutParametersUtil.SetNodeProperty(this, object, "The input node", true, o, ilvRect);
    }

    public final IlvRect getIncrementalNodeBoxForExpand(Object object) {
        return (IlvRect)LayoutParametersUtil.GetNodeProperty(this, object, o);
    }

    final void d() {
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        if (ilvGraphModel != null) {
            Enumeration enumeration = ilvGraphModel.getNodes();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                LayoutParametersUtil.SetNodeProperty(this, e, null, false, o, null);
            }
        }
    }

    public final void setGlobalIncrementalNodeMovementMode(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 99) {
            throw new IllegalArgumentException("unsupported mode: " + n);
        }
        if (n != this.bg) {
            this.setParametersUpToDate(false);
        }
        this.bg = n;
    }

    public final int getGlobalIncrementalNodeMovementMode() {
        return this.isUseDefaultParameters() ? 0 : this.bg;
    }

    public final void setIncrementalNodeMovementMode(Object object, int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("unsupported mode: " + n);
        }
        LayoutParametersUtil.SetNodeParameter((IlvGraphLayout)this, object, q, n, 0);
    }

    public final int getIncrementalNodeMovementMode(Object object) {
        return LayoutParametersUtil.GetNodeParameter((IlvGraphLayout)this, object, q, 0);
    }

    final ConstraintManager e() {
        return this.b6;
    }

    final void a(ConstraintManager constraintManager) {
        this.b6 = constraintManager != null ? constraintManager : new ConstraintManager();
    }

    public final void addConstraint(IlvHierarchicalConstraint ilvHierarchicalConstraint) {
        this.e().a(ilvHierarchicalConstraint);
        this.setParametersUpToDate(false);
    }

    public final void removeAllConstraints() {
        this.a((ConstraintManager)null);
        this.setParametersUpToDate(false);
    }

    public final void removeConstraint(IlvHierarchicalConstraint ilvHierarchicalConstraint) {
        this.e().b(ilvHierarchicalConstraint);
        this.setParametersUpToDate(false);
    }

    public final void removeConstraint() {
        this.e().c((IlvHierarchicalConstraint)null);
        this.setParametersUpToDate(false);
    }

    public final int getNumberOfConstraints() {
        return this.e().d();
    }

    public final Enumeration getConstraints() {
        return this.e().e();
    }

    public final void validateConstraints() {
        int n = this.getNumberOfConstraints();
        if (n == 0) {
            return;
        }
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        if (ilvGraphModel == null || ilvGraphModel.getNodesCount() == 0) {
            this.removeAllConstraints();
            this.setParametersUpToDate(false);
        } else {
            this.e().b(ilvGraphModel);
            this.e().a(ilvGraphModel);
            if (n != this.getNumberOfConstraints()) {
                this.setParametersUpToDate(false);
            }
        }
    }

    public int getNumberOfNodeGroups() {
        return this.e().b();
    }

    public Enumeration getNodeGroups() {
        return this.e().c();
    }

    final void a(Object object, int n, Object object2) {
        String string;
        switch (n) {
            case 0: {
                string = l;
                break;
            }
            case 1: {
                string = m;
                break;
            }
            default: {
                string = n;
            }
        }
        Vector<Object> vector = (Vector<Object>)LayoutParametersUtil.GetNodeProperty(this, object, string);
        if (vector == null) {
            vector = new Vector<Object>(2, 2);
            LayoutParametersUtil.SetNodeProperty(this, object, null, false, string, vector);
        }
        vector.addElement(object2);
    }

    final Vector c(Object object, int n) {
        String string;
        switch (n) {
            case 0: {
                string = l;
                break;
            }
            case 1: {
                string = m;
                break;
            }
            default: {
                string = n;
            }
        }
        Vector vector = (Vector)LayoutParametersUtil.GetNodeProperty(this, object, string);
        LayoutParametersUtil.SetNodeProperty(this, object, null, false, string, null);
        return vector;
    }

    public final void setPolylineLinkOverlapReductionEnabled(boolean bl) {
        if (bl != this.bl) {
            this.setParametersUpToDate(false);
        }
        this.bl = bl;
    }

    public final boolean isPolylineLinkOverlapReductionEnabled() {
        return this.isUseDefaultParameters() ? true : this.bl;
    }

    public final void setNeighborLinksAligned(boolean bl) {
        if (bl != this.bn) {
            this.setParametersUpToDate(false);
        }
        this.bn = bl;
    }

    public final boolean isNeighborLinksAligned() {
        if (this.isUseDefaultParameters()) {
            return true;
        }
        return this.bn;
    }

    public final void setIntergraphConnectivityMode(boolean bl) {
        if (bl != this.bp) {
            this.setParametersUpToDate(false);
        }
        this.bp = bl;
    }

    public final boolean isIntergraphConnectivityMode() {
        return this.isUseDefaultParameters() ? false : this.bp;
    }

    public final void setLinkStraighteningEnabled(boolean bl) {
        if (bl != this.br) {
            this.setParametersUpToDate(false);
        }
        this.br = bl;
    }

    public final boolean isLinkStraighteningEnabled() {
        return this.isUseDefaultParameters() ? true : this.br;
    }

    public final void setBacktrackCrossingReductionEnabled(boolean bl) {
        if (bl != this.bt) {
            this.setParametersUpToDate(false);
        }
        this.bt = bl;
    }

    public final boolean isBacktrackCrossingReductionEnabled() {
        if (this.isUseDefaultParameters()) {
            return true;
        }
        return this.bt;
    }

    public final void setMedianCrossingValueEnabled(boolean bl) {
        if (bl != this.bv) {
            this.setParametersUpToDate(false);
        }
        this.bv = bl;
    }

    public final boolean isMedianCrossingValueEnabled() {
        if (this.isUseDefaultParameters()) {
            return true;
        }
        return this.bv;
    }

    public final void setNumberOfLinkCrossingSweeps(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n != this.bx) {
            this.setParametersUpToDate(false);
        }
        this.bx = n;
    }

    public final int getNumberOfLinkCrossingSweeps() {
        return this.isUseDefaultParameters() ? 5 : this.bx;
    }

    public final void setLinkCrossingFineTuningEnabled(boolean bl) {
        if (bl != this.bz) {
            this.setParametersUpToDate(false);
        }
        this.bz = bl;
    }

    public final boolean isLinkCrossingFineTuningEnabled() {
        if (this.isUseDefaultParameters()) {
            return true;
        }
        return this.bz;
    }

    public final void setQuickAndUgly(boolean bl) {
        if (bl != this.b7) {
            if (bl) {
                this.b8 = this.isLinkStraighteningEnabled();
                this.b9 = this.isBacktrackCrossingReductionEnabled();
                this.ca = this.isMedianCrossingValueEnabled();
                this.cc = this.getNumberOfLinkCrossingSweeps();
                this.cb = this.isLinkCrossingFineTuningEnabled();
                this.setLinkStraighteningEnabled(false);
                this.setBacktrackCrossingReductionEnabled(false);
                this.setMedianCrossingValueEnabled(false);
                this.setNumberOfLinkCrossingSweeps(1);
                this.setLinkCrossingFineTuningEnabled(false);
            } else {
                this.setLinkStraighteningEnabled(this.b8);
                this.setBacktrackCrossingReductionEnabled(this.b9);
                this.setMedianCrossingValueEnabled(this.ca);
                this.setNumberOfLinkCrossingSweeps(this.cc);
                this.setLinkCrossingFineTuningEnabled(this.cb);
            }
            this.b7 = bl;
        }
    }

    protected IlvGraphLayoutGrapherProperty createLayoutGrapherProperty(String string, boolean bl) {
        return new IlvHierarchicalLayoutGrapherProperty(string, this, bl);
    }

    protected IlvGraphLayoutNodeProperty createLayoutNodeProperty(String string, IlvGraphic ilvGraphic, boolean bl) {
        return new IlvHierarchicalLayoutNodeProperty(string, this, ilvGraphic, bl);
    }

    protected IlvGraphLayoutLinkProperty createLayoutLinkProperty(String string, IlvGraphic ilvGraphic, boolean bl) {
        return new IlvHierarchicalLayoutLinkProperty(string, this, ilvGraphic, bl);
    }

    public synchronized void detach() {
        this.removeAllConstraints();
        super.detach();
    }

    public void cleanNode(IlvGraphModel ilvGraphModel, Object object) {
        super.cleanNode(ilvGraphModel, object);
    }

    public void cleanLink(IlvGraphModel ilvGraphModel, Object object) {
        super.cleanLink(ilvGraphModel, object);
    }

    private void a(HGraph hGraph) {
        int n = 1;
        int n2 = 0;
        switch (this.getFlowDirection()) {
            case 1: {
                hGraph.f(2);
                n = -1;
                n2 = 0;
                break;
            }
            case 2: {
                hGraph.f(0);
                n2 = 0;
                break;
            }
            case 4: {
                hGraph.f(3);
                n = -1;
                n2 = 1;
                break;
            }
            case 8: {
                hGraph.f(1);
                n2 = 1;
            }
        }
        switch (this.getLevelJustification()) {
            case 16: {
                hGraph.g(0);
                break;
            }
            case 1: {
                hGraph.g(-1 * n);
                break;
            }
            case 2: {
                hGraph.g(1 * n);
                break;
            }
            case 4: {
                hGraph.g(-1 * n);
                break;
            }
            case 8: {
                hGraph.g(1 * n);
            }
        }
        switch (this.getGlobalLinkStyle()) {
            case 3: {
                hGraph.i(99);
                break;
            }
            case 2: {
                hGraph.i(100);
                break;
            }
            case 99: {
                hGraph.i(98);
                break;
            }
            case 1: {
                hGraph.i(101);
                break;
            }
            default: {
                hGraph.i(102);
            }
        }
        switch (this.getConnectorStyle()) {
            case 1: {
                hGraph.h(99);
                break;
            }
            case 2: {
                hGraph.h(100);
                break;
            }
            case 3: {
                hGraph.h(101);
                break;
            }
            default: {
                if (this.getGlobalLinkStyle() == 2) {
                    hGraph.h(101);
                    break;
                }
                if (this.getGlobalLinkStyle() == 99) {
                    hGraph.h(100);
                    break;
                }
                if (this.getGlobalLinkStyle() == 1) {
                    hGraph.h(99);
                    break;
                }
                hGraph.h(100);
            }
        }
        hGraph.b(this.isIncrementalMode());
        hGraph.c(this.isCrossingReductionDuringIncremental());
        hGraph.d(this.isLongLinkCrossingReductionDuringIncremental());
        hGraph.e(this.isIncrementalAbsoluteLevelPositioning());
        hGraph.a(0, this.getHorizontalNodeOffset());
        hGraph.c(0, this.getHorizontalLinkOffset());
        hGraph.b(0, this.getHorizontalNodeLinkOffset());
        hGraph.a(1, this.getVerticalNodeOffset());
        hGraph.c(1, this.getVerticalLinkOffset());
        hGraph.b(1, this.getVerticalNodeLinkOffset());
        float f = 1.01f * this.getMinStartSegmentLength();
        if (hGraph.k(n2) < f) {
            hGraph.b(n2, f);
        }
        f = 1.01f * this.getMinEndSegmentLength();
        if (hGraph.k(n2) < f) {
            hGraph.b(n2, f);
        }
    }

    public int checkAppropriateLink(Object object) {
        int n = this.getGlobalLinkStyle();
        if (n == 0) {
            return 0;
        }
        if (n == 99 && this.getLinkStyle(object) == 0) {
            return 0;
        }
        int n2 = 0;
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        if (ilvGraphModel.isLinkCheckEnabled() && !ilvGraphModel.isReshapeableLink(object, false)) {
            n2 |= 2;
        }
        if (ilvGraphModel.isConnectionPointCheckEnabled()) {
            if (!this.c(object) && !ilvGraphModel.hasMoveableConnectionPoint(object, true)) {
                n2 |= 4;
            }
            if (!this.d(object) && !ilvGraphModel.hasMoveableConnectionPoint(object, false)) {
                n2 |= 4;
            }
        }
        return n2;
    }

    boolean c(Object object) {
        switch (this.getGlobalOriginPointMode()) {
            case 0: {
                return this.getGraphModel().hasPinnedConnectionPoint(object, true);
            }
            case 3: {
                return true;
            }
            case 99: {
                return this.getOriginPointMode(object) == 3 ? true : this.getGraphModel().hasPinnedConnectionPoint(object, true);
            }
        }
        throw new RuntimeException("unsupported mode: " + this.getGlobalOriginPointMode());
    }

    boolean d(Object object) {
        switch (this.getGlobalDestinationPointMode()) {
            case 0: {
                return this.getGraphModel().hasPinnedConnectionPoint(object, false);
            }
            case 3: {
                return true;
            }
            case 99: {
                return this.getDestinationPointMode(object) == 3 ? true : this.getGraphModel().hasPinnedConnectionPoint(object, false);
            }
        }
        throw new RuntimeException("unsupported mode: " + this.getGlobalDestinationPointMode());
    }

    public IlvGraphicVector getMovingNodes() {
        return LayoutUtil.getDefaultMovingNodes(this.getGraphModel());
    }

    public void layoutStepPerformed() {
        if (this.b5 != null) {
            this.b5.notifyPercentageComplete(this);
        }
        super.layoutStepPerformed();
    }

    final boolean f() {
        if (!this.b4) {
            this.b4 = this.isLayoutTimeElapsed() || this.isStoppedImmediately();
        }
        return !this.b4;
    }
}

