/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.hypergraph;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.hypergraph.IlvHyperEdge;
import ilog.views.hypergraph.IlvHyperEdgeEnd;
import ilog.views.hypergraph.edgeconnector.IlvHyperEdgeConnector;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;

public class IlvDefaultHyperEdgeEnd
implements IlvHyperEdgeEnd {
    private IlvHyperEdge a;
    private IlvGraphic b;
    private double c;
    private double d;
    private boolean e;
    private transient boolean f;

    protected IlvDefaultHyperEdgeEnd(IlvHyperEdge ilvHyperEdge, IlvGraphic ilvGraphic) {
        this.a = ilvHyperEdge;
        this.b = ilvGraphic;
        this.e = false;
        this.f = false;
    }

    public IlvDefaultHyperEdgeEnd(IlvInputStream ilvInputStream) throws IlvReadFileException {
        this.a = IlvHyperEdge.j;
        this.b = ilvInputStream.readObject("node");
        this.c = ilvInputStream.readDouble("x");
        this.d = ilvInputStream.readDouble("y");
        this.e = ilvInputStream.readBoolean("absolute");
        IlvHyperEdgeConnector ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetLocal(this);
        if (ilvHyperEdgeConnector != null) {
            ilvHyperEdgeConnector.actOnRead(this, ilvInputStream);
        }
        this.a(ilvInputStream);
        this.a = null;
    }

    private void a(IlvInputStream ilvInputStream) throws IlvReadFileException {
        while (true) {
            IlvHyperEdgeConnector ilvHyperEdgeConnector = null;
            try {
                ilvHyperEdgeConnector = (IlvHyperEdgeConnector)ilvInputStream.readObject("parentConnector");
            }
            catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                return;
            }
            if (ilvHyperEdgeConnector == null) continue;
            ilvHyperEdgeConnector.actOnRead(this, ilvInputStream);
        }
    }

    public IlvHyperEdgeEnd copy() {
        IlvDefaultHyperEdgeEnd ilvDefaultHyperEdgeEnd = new IlvDefaultHyperEdgeEnd(null, this.getNode());
        ilvDefaultHyperEdgeEnd.c = this.c;
        ilvDefaultHyperEdgeEnd.d = this.d;
        ilvDefaultHyperEdgeEnd.e = this.e;
        return ilvDefaultHyperEdgeEnd;
    }

    public IlvHyperEdge getHyperEdge() {
        return this.a;
    }

    public void setHyperEdge(IlvHyperEdge ilvHyperEdge) {
        this.a = ilvHyperEdge;
    }

    public IlvGraphic getNode() {
        return this.b;
    }

    public IlvPoint getPosition(IlvTransformer ilvTransformer, boolean bl) {
        IlvHyperEdgeConnector ilvHyperEdgeConnector;
        if (bl && !this.f && (ilvHyperEdgeConnector = IlvHyperEdgeConnector.Get(this)) != null) {
            return ilvHyperEdgeConnector.getConnectionPoint(this, ilvTransformer);
        }
        if (this.e) {
            ilvHyperEdgeConnector = new IlvPoint((float)this.c, (float)this.d);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.apply((IlvPoint)ilvHyperEdgeConnector);
            }
            return ilvHyperEdgeConnector;
        }
        ilvHyperEdgeConnector = this.a.getEndNodeBoundingBox(this.b, ilvTransformer);
        return new IlvPoint((float)((double)((IlvRect)ilvHyperEdgeConnector).x + (0.5 + this.c * 0.5) * (double)((IlvRect)ilvHyperEdgeConnector).width), (float)((double)((IlvRect)ilvHyperEdgeConnector).y + (0.5 + this.d * 0.5) * (double)((IlvRect)ilvHyperEdgeConnector).height));
    }

    public void setPosition(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        if (this.e) {
            IlvPoint ilvPoint2 = ilvPoint;
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvPoint2 = new IlvPoint(ilvPoint);
                ilvTransformer.inverse(ilvPoint2);
            }
            this.c = ilvPoint2.x;
            this.d = ilvPoint2.y;
        } else {
            IlvRect ilvRect = this.a.getEndNodeBoundingBox(this.b, ilvTransformer);
            this.c = ((double)(ilvPoint.x - ilvRect.x) - 0.5 * (double)ilvRect.width) / (0.5 * (double)ilvRect.width);
            this.d = ((double)(ilvPoint.y - ilvRect.y) - 0.5 * (double)ilvRect.height) / (0.5 * (double)ilvRect.height);
        }
        if (this.a != null) {
            this.a.clearBoundingBoxCache();
        } else {
            this.positionChanged();
        }
    }

    public void setDragging(boolean bl) {
        this.f = bl;
    }

    public boolean isDragging() {
        return this.f;
    }

    public boolean zoomable() {
        if (this.getNode() != null && !this.getNode().zoomable()) {
            return false;
        }
        IlvHyperEdgeConnector ilvHyperEdgeConnector = IlvHyperEdgeConnector.Get(this);
        if (ilvHyperEdgeConnector != null) {
            return ilvHyperEdgeConnector.connectionsZoomable();
        }
        return this.e;
    }

    public void setAbsolutePositioning(boolean bl) {
        this.e = bl;
        if (this.a != null) {
            this.a.b();
        }
    }

    public boolean isAbsolutePositioning() {
        return this.e;
    }

    public void positionChanged() {
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        ilvOutputStream.write("node", this.b);
        ilvOutputStream.write("x", this.c);
        ilvOutputStream.write("y", this.d);
        ilvOutputStream.write("absolute", this.e);
        IlvHyperEdgeConnector ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetLocal(this);
        if (ilvHyperEdgeConnector != null) {
            ilvHyperEdgeConnector.actOnWrite(this, ilvOutputStream);
        }
        if (ilvHyperEdgeConnector == null || ilvHyperEdgeConnector.getOwner() == this.getNode() && this.getNode() != null) {
            this.a(ilvOutputStream);
        }
    }

    private void a(IlvOutputStream ilvOutputStream) throws IOException {
        if (this.getHyperEdge() == null) {
            return;
        }
        IlvGraphicBag ilvGraphicBag = this.getHyperEdge().getGraphicBag();
        for (IlvGraphic ilvGraphic = (IlvGraphic)this.getNode().getGraphicBag(); ilvGraphic != null && ilvGraphic != ilvGraphicBag; ilvGraphic = (IlvGraphic)ilvGraphic.getGraphicBag()) {
            IlvHyperEdgeConnector ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetAttached(ilvGraphic);
            if (ilvHyperEdgeConnector == null) continue;
            ilvOutputStream.write("parentConnector", (IlvGraphic)ilvHyperEdgeConnector);
            ilvHyperEdgeConnector.actOnWrite(this, ilvOutputStream);
        }
    }
}

