/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.hypergraph;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.hypergraph.IlvDefaultHyperEdgeEnd;
import ilog.views.hypergraph.IlvHyperEdge;
import ilog.views.hypergraph.IlvHyperEdgeEnd;
import ilog.views.hypergraph.IlvHyperGrapher;
import ilog.views.hypergraph.IlvSegmentedHyperEdgeSelection;
import ilog.views.hypergraph.internal.IlvGeometryUtil;
import ilog.views.hypergraph.internal.IlvHyperGrapherUtil;
import ilog.views.hypergraph.undo.IlvGraphicEdit;
import ilog.views.hypergraph.undo.IlvOrderedCompoundEdit;
import ilog.views.hypergraph.undo.IlvPropertiesEdit;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.util.collections.IlvCollections;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class IlvSegmentedHyperEdge
extends IlvHyperEdge {
    private ArrayList a;
    private Paint b;
    private boolean c = false;
    static final IlvHyperEdgeEnd[] d = new IlvHyperEdgeEnd[0];
    static final Segment[] e = new Segment[0];
    private static final String f = "IlvSegmentedHyperEdgeEndsMap__".intern();

    public IlvSegmentedHyperEdge() {
    }

    public IlvSegmentedHyperEdge(IlvGraphicVector ilvGraphicVector, IlvGraphicVector ilvGraphicVector2) {
        super(ilvGraphicVector, ilvGraphicVector2);
    }

    public IlvSegmentedHyperEdge(IlvSegmentedHyperEdge ilvSegmentedHyperEdge) {
        super(ilvSegmentedHyperEdge);
        this.b = ilvSegmentedHyperEdge.b;
        this.c = ilvSegmentedHyperEdge.c;
        this.b(ilvSegmentedHyperEdge);
    }

    private void b(IlvSegmentedHyperEdge ilvSegmentedHyperEdge) {
        if (ilvSegmentedHyperEdge.a != null) {
            Object object;
            Segment segment;
            int n;
            HashMap hashMap = IlvSegmentedHyperEdge.a((IlvHyperEdge)ilvSegmentedHyperEdge);
            HashMap<Segment, Segment> hashMap2 = new HashMap<Segment, Segment>();
            int n2 = ilvSegmentedHyperEdge.getSegmentsCount();
            for (n = 0; n < n2; ++n) {
                segment = (Segment)ilvSegmentedHyperEdge.a.get(n);
                object = segment.getEnds();
                HyperEdgeEnd[] hyperEdgeEndArray = new HyperEdgeEnd[((IlvHyperEdgeEnd[])object).length];
                for (int i = 0; i < ((IlvHyperEdgeEnd[])object).length; ++i) {
                    hyperEdgeEndArray[i] = (HyperEdgeEnd)hashMap.get(object[i]);
                }
                Segment segment2 = segment.a(hyperEdgeEndArray);
                this.a(segment2);
                hashMap2.put(segment, segment2);
            }
            for (n = 0; n < n2; ++n) {
                segment = (Segment)ilvSegmentedHyperEdge.a.get(n);
                object = (Segment)hashMap2.get(segment);
                int n3 = segment.getIncidentSegmentsCount();
                for (int i = 0; i < n3; ++i) {
                    Segment segment3 = segment.getIncidentSegment(i);
                    Segment segment4 = (Segment)hashMap2.get(segment3);
                    if (((Segment)object).isIncident(segment4)) continue;
                    ((Segment)object).a(segment4, false);
                }
                ((Segment)object).f().a((Segment)object, segment.f(), hashMap2);
            }
        }
        IlvSegmentedHyperEdge.b(this);
    }

    public IlvSegmentedHyperEdge(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        Iterator iterator = this.getFromEnds();
        while (iterator.hasNext()) {
            ((HyperEdgeEnd)iterator.next()).a(true);
        }
        iterator = this.getToEnds();
        while (iterator.hasNext()) {
            ((HyperEdgeEnd)iterator.next()).a(false);
        }
        this.setSelectedSegmentsPaint(IlvUtility2D.readPaint((IlvInputStream)ilvInputStream, (String)"selSegmentsPaint", (String)"selSeg"));
        this.setAutoConnect(ilvInputStream.readBoolean("autoconnect"));
        IlvPersistentObject[] ilvPersistentObjectArray = ilvInputStream.readPersistentObjects("segments");
        this.a(ilvPersistentObjectArray, null);
    }

    private void a(IlvPersistentObject[] ilvPersistentObjectArray, HashMap hashMap) {
        SegmentShape segmentShape;
        int n;
        int n2 = ilvPersistentObjectArray.length;
        for (n = 0; n < n2; ++n) {
            segmentShape = (SegmentShape)ilvPersistentObjectArray[n];
            Segment segment = segmentShape.n;
            Segment segment2 = this.a(segmentShape);
            if (hashMap == null || segment == null) continue;
            hashMap.put(segment2, segment);
        }
        for (n = 0; n < n2; ++n) {
            segmentShape = (SegmentShape)ilvPersistentObjectArray[n];
            segmentShape.n.f().a(segmentShape, this.a);
        }
    }

    private IlvPersistentObject[] c() {
        HashMap<Segment, Integer> hashMap = new HashMap<Segment, Integer>();
        int n = this.getSegmentsCount();
        for (int i = 0; i < n; ++i) {
            Segment segment = (Segment)this.a.get(i);
            hashMap.put(segment, new Integer(i));
        }
        IlvPersistentObject[] ilvPersistentObjectArray = new IlvPersistentObject[n];
        for (int i = 0; i < n; ++i) {
            Segment segment = (Segment)this.a.get(i);
            ilvPersistentObjectArray[i] = new SegmentShape(segment, hashMap);
        }
        return ilvPersistentObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap copyShapeFrom(IlvHyperEdge ilvHyperEdge) {
        ArrayList arrayList;
        boolean bl;
        HashMap hashMap = null;
        if (this.getGraphicBag() != null) {
            bl = false;
            for (arrayList = (IlvManager)ilvHyperEdge.getGraphicBag(); arrayList != null; arrayList = arrayList.getParent()) {
                if (arrayList != this.getGraphicBag()) continue;
                bl = true;
            }
            if (!bl) {
                throw new RuntimeException("Edge must be removed from grapher first");
            }
        }
        arrayList = this.a;
        this.a = null;
        bl = this.isAutoConnect();
        this.setAutoConnect(false);
        try {
            hashMap = super.copyShapeFrom(ilvHyperEdge);
            if (!(ilvHyperEdge instanceof IlvSegmentedHyperEdge)) {
                HashMap hashMap2 = hashMap;
                return hashMap2;
            }
            IlvSegmentedHyperEdge ilvSegmentedHyperEdge = (IlvSegmentedHyperEdge)ilvHyperEdge;
            HashMap hashMap3 = IlvHyperGrapherUtil.getInverseMapping(hashMap);
            IlvPersistentObject[] ilvPersistentObjectArray = ilvSegmentedHyperEdge.c();
            int n = ilvPersistentObjectArray.length;
            for (int i = 0; i < n; ++i) {
                SegmentShape segmentShape = (SegmentShape)ilvPersistentObjectArray[i];
                if (segmentShape.g != null) {
                    segmentShape.g = (HyperEdgeEnd)hashMap3.get(segmentShape.g);
                }
                if (segmentShape.h == null) continue;
                segmentShape.h = (HyperEdgeEnd)hashMap3.get(segmentShape.h);
            }
            this.a(ilvPersistentObjectArray, hashMap);
        }
        finally {
            this.setAutoConnect(bl);
            if (arrayList != null) {
                int n = arrayList.size();
                if (this.a == null) {
                    this.a = new ArrayList(n);
                }
                for (int i = 0; i < n; ++i) {
                    this.a.add(arrayList.get(i));
                }
            }
        }
        return hashMap;
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        boolean bl = false;
        if (this.getGraphicBag() != null && this.getGraphicBag() instanceof IlvManager) {
            bl = ((IlvManager)this.getGraphicBag()).isSelected((IlvGraphic)this);
        }
        Paint paint2 = this.getAdaptedStrokePaint(ilvTransformer);
        Paint paint3 = this.getAdaptedSelectedSegmentsPaint(ilvTransformer);
        Paint paint4 = paint2;
        graphics2D.setPaint(paint4);
        float[] fArray = this.getLineStyle();
        float f = this.getLineWidth();
        float f2 = this.getMaximumLineWidth();
        double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        f = IlvStrokeInfo.zoomedLineWidth((float)f, (float)f2, (IlvTransformer)ilvTransformer, (boolean)false);
        fArray = IlvStrokeInfo.zoomedLineStyle((float[])fArray, (float)f, (float)f2, (IlvTransformer)ilvTransformer);
        IlvPoint[] ilvPointArray = new IlvPoint[]{new IlvPoint(), new IlvPoint()};
        int n = this.getSegmentsCount();
        for (int i = 0; i < n; ++i) {
            Segment segment = (Segment)this.a.get(i);
            segment.b(ilvTransformer, ilvPointArray);
            if (segment.isSelected()) {
                if (paint4 != paint3) {
                    graphics2D.setPaint(paint3);
                    paint4 = paint3;
                }
            } else if (paint4 != paint2) {
                graphics2D.setPaint(paint2);
                paint4 = paint2;
            }
            this.a(segment, ilvPointArray, f, fArray, 0.0f, graphics, ilvTransformer);
            IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = segment.getEnds();
            boolean bl2 = true;
            for (int j = 0; j < ilvHyperEdgeEndArray.length; ++j) {
                IlvPoint ilvPoint;
                IlvPoint ilvPoint2;
                HyperEdgeEnd hyperEdgeEnd = (HyperEdgeEnd)ilvHyperEdgeEndArray[j];
                if (hyperEdgeEnd.a()) continue;
                if (bl2) {
                    segment.b(ilvTransformer, ilvPointArray);
                    bl2 = false;
                }
                if ((ilvPoint2 = this.getArrowHeadControlPoint(segment, hyperEdgeEnd, ilvPoint = hyperEdgeEnd.getPosition(ilvTransformer, true), ilvPointArray, ilvTransformer)) == null) continue;
                this.drawArrow(graphics, ilvPoint2, ilvPoint, ilvTransformer);
            }
        }
        graphics2D.setPaint(paint);
    }

    private void a(Segment segment, IlvPoint[] ilvPointArray, float f, float[] fArray, float f2, Graphics graphics, IlvTransformer ilvTransformer) {
        Object object;
        IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = segment.getEnds();
        boolean bl = false;
        for (int i = 0; i < ilvHyperEdgeEndArray.length; ++i) {
            object = (HyperEdgeEnd)ilvHyperEdgeEndArray[i];
            if (((HyperEdgeEnd)object).a()) continue;
            bl = true;
        }
        if (bl) {
            HyperEdgeEnd hyperEdgeEnd;
            int n;
            float f3 = this.getArrowSize(this.a(ilvTransformer, false, false), ilvTransformer);
            object = new int[ilvHyperEdgeEndArray.length];
            for (n = 0; n < ilvHyperEdgeEndArray.length; ++n) {
                hyperEdgeEnd = (HyperEdgeEnd)ilvHyperEdgeEndArray[n];
                if (hyperEdgeEnd.a()) continue;
                IlvPoint ilvPoint = hyperEdgeEnd.getPosition(ilvTransformer, true);
                object[n] = this.a(ilvPoint, ilvPointArray);
            }
            for (n = 0; n < ilvHyperEdgeEndArray.length; ++n) {
                hyperEdgeEnd = (HyperEdgeEnd)ilvHyperEdgeEndArray[n];
                if (hyperEdgeEnd.a()) continue;
                if (object[n] == false) {
                    this.a(ilvPointArray);
                    this.shortenForArrowDraw(ilvPointArray, f3);
                    this.a(ilvPointArray);
                    continue;
                }
                if (object[n] != true) continue;
                this.shortenForArrowDraw(ilvPointArray, f3);
            }
        }
        this.drawLine(ilvPointArray, f, fArray, graphics, ilvTransformer);
    }

    private void a(IlvPoint[] ilvPointArray) {
        IlvPoint ilvPoint = ilvPointArray[0];
        ilvPointArray[0] = ilvPointArray[1];
        ilvPointArray[1] = ilvPoint;
    }

    private int a(IlvPoint ilvPoint, IlvPoint[] ilvPointArray) {
        double d = ilvPoint.x - ilvPointArray[0].x;
        double d2 = ilvPoint.y - ilvPointArray[0].y;
        double d3 = d * d + d2 * d2;
        double d4 = (d = (double)(ilvPoint.x - ilvPointArray[1].x)) * d + (d2 = (double)(ilvPoint.y - ilvPointArray[1].y)) * d2;
        if (d3 < d4) {
            if (d3 < 0.001) {
                return 0;
            }
        } else if (d4 < 0.001) {
            return 1;
        }
        return -1;
    }

    protected void drawLine(IlvPoint[] ilvPointArray, float f, float[] fArray, Graphics graphics, IlvTransformer ilvTransformer) {
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.inverse(ilvPointArray[0]);
            ilvTransformer.inverse(ilvPointArray[1]);
        }
        IlvGraphicUtil.DrawPolyline((Graphics)graphics, (IlvPoint[])ilvPointArray, (int)2, (float)f, (int)2, (int)1, (float[])fArray, (IlvTransformer)ilvTransformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IlvPoint[] getUnclippedSegmentPoints(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvTransformer ilvTransformer) {
        Segment segment;
        IlvPoint[] ilvPointArray = new IlvPoint[2];
        IlvPoint ilvPoint = ilvHyperEdgeEnd.getPosition(ilvTransformer, false);
        ilvPointArray[0] = new IlvPoint(ilvPoint);
        ilvPointArray[1] = new IlvPoint(ilvPoint);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.inverse(ilvPoint);
        }
        if ((segment = this.getEndSegment(ilvHyperEdgeEnd)) != null) {
            boolean bl = segment.f().d();
            try {
                segment.f().a(false);
                segment.f().a(segment, ilvTransformer, ilvPointArray);
                double d = (ilvPointArray[0].x - ilvPoint.x) * (ilvPointArray[0].x - ilvPoint.x) + (ilvPointArray[0].y - ilvPoint.y) * (ilvPointArray[0].y - ilvPoint.y);
                double d2 = (ilvPointArray[1].x - ilvPoint.x) * (ilvPointArray[1].x - ilvPoint.x) + (ilvPointArray[1].y - ilvPoint.y) * (ilvPointArray[1].y - ilvPoint.y);
                if (d2 < d) {
                    ilvPointArray[1] = ilvPointArray[0];
                    ilvPointArray[0] = ilvPoint;
                }
            }
            finally {
                segment.f().a(bl);
            }
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.apply(ilvPointArray[0]);
                ilvTransformer.apply(ilvPointArray[1]);
            }
        }
        return ilvPointArray;
    }

    protected IlvRect calcBoundingBox(IlvTransformer ilvTransformer) {
        int n;
        float f = this.a(ilvTransformer, true, true);
        IlvPoint ilvPoint = this.getCenter(ilvTransformer);
        IlvRect ilvRect = new IlvRect(ilvPoint.x, ilvPoint.y, 1.0E-20f, 1.0E-20f);
        IlvPoint[] ilvPointArray = this.getFromConnectionPoints(ilvTransformer);
        int n2 = ilvPointArray.length;
        for (n = 0; n < n2; ++n) {
            ilvRect.add((Point2D)ilvPointArray[n]);
        }
        ilvPointArray = this.getToConnectionPoints(ilvTransformer);
        n2 = ilvPointArray.length;
        for (n = 0; n < n2; ++n) {
            ilvRect.add((Point2D)ilvPointArray[n]);
        }
        if (n2 < 2) {
            ilvPointArray = new IlvPoint[]{new IlvPoint(), new IlvPoint()};
        }
        n2 = this.getSegmentsCount();
        for (n = 0; n < n2; ++n) {
            Segment segment = (Segment)this.a.get(n);
            segment.b(ilvTransformer, ilvPointArray);
            ilvRect.add(IlvGraphicUtil.PolylineBBox((IlvPoint[])ilvPointArray, (int)2, (float)f, (int)2, (int)1, null));
            IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = segment.getEnds();
            for (int i = 0; i < ilvHyperEdgeEndArray.length; ++i) {
                IlvPoint ilvPoint2;
                IlvPoint ilvPoint3;
                HyperEdgeEnd hyperEdgeEnd = (HyperEdgeEnd)ilvHyperEdgeEndArray[i];
                if (hyperEdgeEnd.a() || (ilvPoint3 = this.getArrowHeadControlPoint(segment, hyperEdgeEnd, ilvPoint2 = hyperEdgeEnd.getPosition(ilvTransformer, true), ilvPointArray, ilvTransformer)) == null) continue;
                ilvRect.add(this.arrowBBox(ilvPoint3, ilvPoint2, ilvTransformer));
            }
        }
        return ilvRect;
    }

    protected void clearBoundingBoxCache() {
        IlvManager ilvManager;
        IlvSelection ilvSelection;
        super.clearBoundingBoxCache();
        if (this.getGraphicBag() instanceof IlvManager && (ilvSelection = (ilvManager = (IlvManager)this.getGraphicBag()).getSelection((IlvGraphic)this)) != null && ilvSelection instanceof IlvSegmentedHyperEdgeSelection) {
            ((IlvSegmentedHyperEdgeSelection)ilvSelection).c();
        }
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        float f = Math.max(1.0f, this.a(ilvTransformer, false, true));
        IlvPoint[] ilvPointArray = new IlvPoint[]{new IlvPoint(), new IlvPoint()};
        int n = this.getSegmentsCount();
        for (int i = 0; i < n; ++i) {
            Segment segment = (Segment)this.a.get(i);
            segment.b(ilvTransformer, ilvPointArray);
            if (!IlvGraphicUtil.PointInPolyline((IlvPoint)ilvPoint2, (IlvPoint[])ilvPointArray, (int)2, (float)f, (int)2, (int)1, null)) continue;
            return true;
        }
        return false;
    }

    protected IlvPoint getArrowHeadControlPoint(Segment segment, HyperEdgeEnd hyperEdgeEnd, IlvPoint ilvPoint, IlvPoint[] ilvPointArray, IlvTransformer ilvTransformer) {
        if (hyperEdgeEnd.a()) {
            return null;
        }
        if (hyperEdgeEnd == null) {
            return null;
        }
        if (ilvPoint.equals((Object)ilvPointArray[0])) {
            return ilvPointArray[1];
        }
        if (ilvPoint.equals((Object)ilvPointArray[1])) {
            return ilvPointArray[0];
        }
        float f = ilvPointArray[0].x - ilvPointArray[1].x;
        float f2 = ilvPointArray[0].y - ilvPointArray[1].y;
        if (f * f > f2 * f2) {
            float f3 = ilvPointArray[0].x - ilvPoint.x;
            float f4 = ilvPointArray[1].x - ilvPoint.x;
            if (f3 == 0.0f) {
                return ilvPointArray[1];
            }
            if (f4 == 0.0f) {
                return ilvPointArray[0];
            }
            if (f3 * f4 < 0.0f) {
                IlvRect ilvRect = hyperEdgeEnd.getNode().boundingBox(ilvTransformer);
                float f5 = ilvRect.x + 0.5f * ilvRect.width;
                float f6 = (ilvPoint.x - f5) * f3;
                if (f6 > 0.0f) {
                    return ilvPointArray[0];
                }
                if (f6 < 0.0f) {
                    return ilvPointArray[1];
                }
            }
            return f3 * f3 > f4 * f4 ? ilvPointArray[0] : ilvPointArray[1];
        }
        float f7 = ilvPointArray[0].y - ilvPoint.y;
        float f8 = ilvPointArray[1].y - ilvPoint.y;
        if (f7 == 0.0f) {
            return ilvPointArray[1];
        }
        if (f8 == 0.0f) {
            return ilvPointArray[0];
        }
        if (f7 * f8 < 0.0f) {
            IlvRect ilvRect = hyperEdgeEnd.getNode().boundingBox(ilvTransformer);
            float f9 = ilvRect.y + 0.5f * ilvRect.height;
            float f10 = (ilvPoint.y - f9) * f7;
            if (f10 > 0.0f) {
                return ilvPointArray[0];
            }
            if (f10 < 0.0f) {
                return ilvPointArray[1];
            }
        }
        return f7 * f7 > f8 * f8 ? ilvPointArray[0] : ilvPointArray[1];
    }

    public IlvSelection makeSelection() {
        return new IlvSegmentedHyperEdgeSelection(this);
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        Segment segment;
        int n;
        if (this.a == null) {
            return;
        }
        if (ilvTransformer == null) {
            return;
        }
        int n2 = this.a.size();
        IlvPoint[] ilvPointArray = new IlvPoint[2 * n2];
        IlvPoint[] ilvPointArray2 = new IlvPoint[]{new IlvPoint(), new IlvPoint()};
        for (n = 0; n < n2; ++n) {
            segment = (Segment)this.a.get(n);
            segment.b(null, ilvPointArray2);
            ilvTransformer.apply(ilvPointArray2[0]);
            ilvTransformer.apply(ilvPointArray2[1]);
            ilvPointArray[2 * n] = new IlvPoint(ilvPointArray2[0]);
            ilvPointArray[2 * n + 1] = new IlvPoint(ilvPointArray2[1]);
        }
        for (n = 0; n < n2; ++n) {
            segment = (Segment)this.a.get(n);
            segment.a(ilvPointArray[2 * n], ilvPointArray[2 * n + 1]);
        }
    }

    protected IlvHyperEdgeEnd createEnd(IlvGraphic ilvGraphic, boolean bl) {
        return new HyperEdgeEnd(this, ilvGraphic, bl);
    }

    private static HashMap a(IlvHyperEdge ilvHyperEdge) {
        HashMap hashMap = (HashMap)ilvHyperEdge.getProperty(f);
        if (hashMap == null) {
            hashMap = new HashMap();
            ilvHyperEdge.setProperty(f, hashMap);
        }
        return hashMap;
    }

    private static void b(IlvHyperEdge ilvHyperEdge) {
        ilvHyperEdge.removeProperty(f);
    }

    private static void b(IlvHyperEdge ilvHyperEdge, IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvHyperEdgeEnd ilvHyperEdgeEnd2) {
        HashMap hashMap = IlvSegmentedHyperEdge.a(ilvHyperEdge);
        hashMap.put(ilvHyperEdgeEnd, ilvHyperEdgeEnd2);
    }

    public Iterator getSegments() {
        if (this.a == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return IlvCollections.unmodifiableIterator(this.a.iterator());
    }

    public int getSegmentsCount() {
        return this.a == null ? 0 : this.a.size();
    }

    public Segment getEndSegment(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        this.a(ilvHyperEdgeEnd);
        HyperEdgeEnd hyperEdgeEnd = (HyperEdgeEnd)ilvHyperEdgeEnd;
        return hyperEdgeEnd.b();
    }

    private void a(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        if (ilvHyperEdgeEnd == null) {
            throw new IllegalArgumentException("end cannot be null");
        }
        if (ilvHyperEdgeEnd.getHyperEdge() != this) {
            throw new IllegalArgumentException("end does not belong to this hyperedge");
        }
    }

    public boolean isSegmentSetComplete() {
        Object object;
        Iterator iterator = this.getFromEnds();
        while (iterator.hasNext()) {
            object = (IlvHyperEdgeEnd)iterator.next();
            if (this.getEndSegment((IlvHyperEdgeEnd)object) != null) continue;
            return false;
        }
        iterator = this.getToEnds();
        while (iterator.hasNext()) {
            object = (IlvHyperEdgeEnd)iterator.next();
            if (this.getEndSegment((IlvHyperEdgeEnd)object) != null) continue;
            return false;
        }
        if (this.getSegmentsCount() == 0) {
            return true;
        }
        object = (Segment)this.a.get(0);
        HashSet hashSet = new HashSet();
        this.a((Segment)object, null, hashSet);
        return hashSet.size() == this.a.size();
    }

    private void a(Segment segment, Segment segment2, HashSet hashSet) {
        if (hashSet.contains(segment)) {
            return;
        }
        hashSet.add(segment);
        int n = segment.getIncidentSegmentsCount();
        for (int i = 0; i < n; ++i) {
            Segment segment3 = segment.getIncidentSegment(i);
            if (segment3 == segment2) continue;
            this.a(segment3, segment, hashSet);
        }
    }

    private void a(Segment segment) {
        if (this.a == null) {
            this.a = new ArrayList();
        }
        this.a.add(segment);
        this.clearBoundingBoxCache();
    }

    public Segment addSegment(IlvHyperEdgeEnd ilvHyperEdgeEnd, double d) {
        this.b(ilvHyperEdgeEnd);
        d = IlvSegmentedHyperEdge.b(d);
        Segment segment = d == 0.0 ? new Segment(true, (HyperEdgeEnd)ilvHyperEdgeEnd) : (d == 90.0 ? new Segment(false, (HyperEdgeEnd)ilvHyperEdgeEnd) : new Segment(d, (HyperEdgeEnd)ilvHyperEdgeEnd));
        this.a(segment);
        return segment;
    }

    public Segment addSegment(IlvHyperEdgeEnd ilvHyperEdgeEnd, float f, float f2, IlvTransformer ilvTransformer) {
        this.b(ilvHyperEdgeEnd);
        IlvPoint ilvPoint = new IlvPoint(f, f2);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.inverse(ilvPoint);
        }
        Segment segment = new Segment(ilvPoint, (HyperEdgeEnd)ilvHyperEdgeEnd);
        this.a(segment);
        return segment;
    }

    public Segment addSegment(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvHyperEdgeEnd ilvHyperEdgeEnd2) {
        this.b(ilvHyperEdgeEnd);
        this.b(ilvHyperEdgeEnd2);
        Segment segment = new Segment((HyperEdgeEnd)ilvHyperEdgeEnd, (HyperEdgeEnd)ilvHyperEdgeEnd2);
        this.a(segment);
        return segment;
    }

    private void b(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        this.a(ilvHyperEdgeEnd);
        HyperEdgeEnd hyperEdgeEnd = (HyperEdgeEnd)ilvHyperEdgeEnd;
        if (hyperEdgeEnd.b() != null) {
            this.removeSegment(hyperEdgeEnd.b());
        }
    }

    public Segment addSegment(Segment segment, double d, float f, float f2, IlvTransformer ilvTransformer) {
        Object object;
        this.g(segment);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            object = new IlvPoint(f, f2);
            ilvTransformer.inverse(object);
            f = object.x;
            f2 = object.y;
        }
        d = IlvSegmentedHyperEdge.b(d);
        if (segment.isVariable()) {
            if (segment.isFullyTerminated()) {
                throw new IllegalArgumentException("Cannot connect a segment with fixed angle to a fully terminated segment with variable angle.");
            }
        } else if (Math.abs(d - IlvSegmentedHyperEdge.b(segment.getAngle())) < 1.0) {
            throw new IllegalArgumentException("Angle colinear to existing segment");
        }
        object = d == 0.0 ? new Segment(true, f2) : (d == 90.0 ? new Segment(false, f) : new Segment(d, f, f2));
        this.a((Segment)object);
        object.a(segment, true);
        return object;
    }

    public Segment addSegment(Segment segment, float f, float f2, IlvTransformer ilvTransformer) {
        return this.addSegment(segment, segment.getAngle() + 90.0, f, f2, ilvTransformer);
    }

    public Segment addSegment(Segment segment, float f, float f2, float f3, float f4, IlvTransformer ilvTransformer) {
        this.g(segment);
        IlvPoint ilvPoint = new IlvPoint(f, f2);
        IlvPoint ilvPoint2 = new IlvPoint(f3, f4);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.inverse(ilvPoint);
            ilvTransformer.inverse(ilvPoint2);
        }
        Segment segment2 = new Segment(ilvPoint, ilvPoint2);
        this.a(segment2);
        segment2.a(segment, true);
        return segment2;
    }

    private Segment a(SegmentShape segmentShape) {
        Segment segment;
        segmentShape.n = segment = new Segment(segmentShape);
        this.a(segment);
        return segment;
    }

    private static double b(double d) {
        while (d < 0.0) {
            d += 180.0;
        }
        while (d >= 180.0) {
            d -= 180.0;
        }
        double d2 = 1.0E-4;
        if (d < d2) {
            return 0.0;
        }
        if (d > 180.0 - d2) {
            return 0.0;
        }
        if (d > 90.0 - d2 && d < 90.0 + d2) {
            return 90.0;
        }
        return d;
    }

    private static boolean b(double d, double d2) {
        return Math.abs((d = IlvSegmentedHyperEdge.b(d)) - (d2 = IlvSegmentedHyperEdge.b(d2))) < 1.0;
    }

    private void b(Segment segment) {
        if (this.a == null) {
            return;
        }
        this.a.remove(segment);
        if (this.a.size() == 0) {
            this.a = null;
        }
        this.clearBoundingBoxCache();
    }

    public Segment[] removeSegment(Segment segment) {
        this.g(segment);
        Segment[] segmentArray = segment.getIncidentSegments();
        segment.c();
        segment.e();
        this.b(segment);
        IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = segment.getEnds();
        for (int i = 0; i < ilvHyperEdgeEndArray.length; ++i) {
            ((HyperEdgeEnd)ilvHyperEdgeEndArray[i]).a((Segment)null);
        }
        return segmentArray;
    }

    public void removeAllSegments() {
        ArrayList arrayList = this.a;
        int n = this.getSegmentsCount();
        this.a = null;
        for (int i = 0; i < n; ++i) {
            Segment segment = (Segment)arrayList.get(i);
            segment.e();
            IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = segment.getEnds();
            for (int j = 0; j < ilvHyperEdgeEndArray.length; ++j) {
                ((HyperEdgeEnd)ilvHyperEdgeEndArray[j]).a((Segment)null);
            }
        }
        this.clearBoundingBoxCache();
    }

    public void removeSegments(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        if (ilvHyperEdgeEnd == null) {
            throw new IllegalArgumentException("The end cannot be null");
        }
        if (ilvHyperEdgeEnd.getHyperEdge() != this) {
            throw new IllegalArgumentException("The end does not belong to this hyperedge");
        }
        HyperEdgeEnd hyperEdgeEnd = (HyperEdgeEnd)ilvHyperEdgeEnd;
        Segment segment = hyperEdgeEnd.b();
        if (segment == null) {
            return;
        }
        IlvPoint[] ilvPointArray = segment.a((IlvTransformer)null, (IlvPoint[])null);
        IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = segment.getEnds();
        double d = segment.getAngle();
        boolean bl = segment.isVariable();
        Segment[] segmentArray = segment.getTerminatingSegments();
        Segment[] segmentArray2 = this.removeSegment(segment);
        if (segmentArray2.length == 0) {
            return;
        }
        IlvHyperEdgeEnd ilvHyperEdgeEnd2 = null;
        IlvPoint ilvPoint = null;
        if (ilvHyperEdgeEndArray.length == 2) {
            if (ilvHyperEdgeEndArray[0] == ilvHyperEdgeEnd) {
                ilvHyperEdgeEnd2 = ilvHyperEdgeEndArray[1];
                ilvPoint = ilvPointArray[1];
            } else {
                ilvHyperEdgeEnd2 = ilvHyperEdgeEndArray[0];
                ilvPoint = ilvPointArray[0];
            }
        }
        if (segmentArray2.length + ilvHyperEdgeEndArray.length - 1 > 1) {
            int n;
            Segment segment2;
            if (!bl) {
                segment2 = this.addSegment(segmentArray2[0], d, ilvPointArray[0].x, ilvPointArray[0].y, null);
            } else {
                segment2 = ilvHyperEdgeEnd2 != null ? this.addSegment(ilvHyperEdgeEnd2, ilvPoint.x, ilvPoint.y, null) : this.addSegment(segmentArray2[0], ilvPointArray[0].x, ilvPointArray[0].y, ilvPointArray[1].x, ilvPointArray[1].y, null);
                for (n = 0; n < segmentArray.length; ++n) {
                    segmentArray[n].a(segment2, true);
                }
            }
            for (n = 0; n < segmentArray2.length; ++n) {
                segmentArray2[n].a(segment2, true);
            }
            return;
        }
        this.f(segmentArray2[0]);
    }

    public boolean connectSegments(Segment segment, Segment segment2) {
        this.g(segment);
        this.g(segment2);
        if (this.isConnected(segment, segment2)) {
            return false;
        }
        segment.a(segment2, true);
        return true;
    }

    public boolean disconnectSegments(Segment segment, Segment segment2) {
        this.g(segment);
        this.g(segment2);
        if (segment == segment2) {
            return true;
        }
        if (segment.isIncident(segment2)) {
            segment.a(segment2);
            return true;
        }
        return this.a(segment, null, segment2);
    }

    private boolean a(Segment segment, Segment segment2, Segment segment3) {
        if (segment == segment3 && segment2 != null) {
            segment.a(segment2);
            return true;
        }
        int n = segment.getIncidentSegmentsCount();
        for (int i = 0; i < n; ++i) {
            Segment segment4 = segment.getIncidentSegment(i);
            if (segment4 == segment2 || !this.a(segment4, segment, segment3)) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected(Segment segment, Segment segment2) {
        if (segment == null || segment2 == null) {
            return false;
        }
        if (segment.getHyperEdge() != segment2.getHyperEdge()) {
            return false;
        }
        if (!segment.d() || !segment2.d()) {
            return false;
        }
        if (segment.getIncidentSegmentsCount() <= segment2.getIncidentSegmentsCount()) {
            return this.b(segment, null, segment2);
        }
        return this.b(segment2, null, segment);
    }

    private boolean b(Segment segment, Segment segment2, Segment segment3) {
        if (segment == segment3) {
            return true;
        }
        int n = segment.getIncidentSegmentsCount();
        for (int i = 0; i < n; ++i) {
            Segment segment4 = segment.getIncidentSegment(i);
            if (segment4 == segment2 || !this.b(segment4, segment, segment3)) continue;
            return true;
        }
        return false;
    }

    public IlvPoint getConnectionPoint(Segment segment, Segment segment2, IlvTransformer ilvTransformer) {
        this.g(segment);
        this.g(segment2);
        return segment.getIntersectionPoint(segment2, ilvTransformer);
    }

    public Segment[] splitSegment(Segment segment, float f, float f2, IlvTransformer ilvTransformer) {
        this.g(segment);
        IlvPoint ilvPoint = new IlvPoint(f, f2);
        IlvPoint ilvPoint2 = new IlvPoint();
        IlvPoint[] ilvPointArray = segment.getPoints(ilvTransformer, null);
        if (this.b(ilvPoint.x, ilvPoint.y, ilvPointArray, ilvPoint2)) {
            boolean bl;
            boolean bl2 = segment.b();
            Object[] objectArray = this.a(segment, ilvTransformer);
            Object[] objectArray2 = this.a(objectArray, ilvPoint2, null, bl2);
            IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = segment.getEnds();
            Object[] objectArray3 = this.a(ilvHyperEdgeEndArray, ilvPoint2, bl2, ilvTransformer);
            IlvHyperEdgeEnd[] ilvHyperEdgeEndArray2 = (IlvHyperEdgeEnd[])objectArray3[0];
            IlvHyperEdgeEnd[] ilvHyperEdgeEndArray3 = (IlvHyperEdgeEnd[])objectArray3[1];
            Object[] objectArray4 = (Object[])objectArray2[0];
            Object[] objectArray5 = (Object[])objectArray2[1];
            Segment[] segmentArray = (Segment[])objectArray4[0];
            Segment[] segmentArray2 = (Segment[])objectArray5[0];
            if (ilvHyperEdgeEndArray.length == 2) {
                bl = true;
            } else {
                bl = true;
                if (ilvHyperEdgeEndArray2.length + segmentArray.length == 0) {
                    bl = false;
                }
                if (ilvHyperEdgeEndArray3.length + segmentArray2.length == 0) {
                    bl = false;
                }
            }
            if (!bl) {
                return null;
            }
            Segment segment2 = null;
            Segment segment3 = null;
            Segment[] segmentArray3 = null;
            if (ilvHyperEdgeEndArray.length == 2) {
                IlvPoint ilvPoint3 = ilvHyperEdgeEndArray[0].getPosition(ilvTransformer, true);
                IlvPoint ilvPoint4 = ilvHyperEdgeEndArray[1].getPosition(ilvTransformer, true);
                this.removeSegment(segment);
                if (bl2) {
                    if (ilvPoint3.x < ilvPoint4.x) {
                        segment2 = this.addSegment(ilvHyperEdgeEndArray[0], 0.0f, 0.0f, ilvTransformer);
                        segment3 = this.addSegment(ilvHyperEdgeEndArray[1], 0.0f, 0.0f, ilvTransformer);
                    } else {
                        segment2 = this.addSegment(ilvHyperEdgeEndArray[1], 0.0f, 0.0f, ilvTransformer);
                        segment3 = this.addSegment(ilvHyperEdgeEndArray[0], 0.0f, 0.0f, ilvTransformer);
                    }
                } else if (ilvPoint3.y < ilvPoint4.y) {
                    segment2 = this.addSegment(ilvHyperEdgeEndArray[0], 0.0f, 0.0f, ilvTransformer);
                    segment3 = this.addSegment(ilvHyperEdgeEndArray[1], 0.0f, 0.0f, ilvTransformer);
                } else {
                    segment2 = this.addSegment(ilvHyperEdgeEndArray[1], 0.0f, 0.0f, ilvTransformer);
                    segment3 = this.addSegment(ilvHyperEdgeEndArray[0], 0.0f, 0.0f, ilvTransformer);
                }
                segment2.a(segment3, true);
                segmentArray3 = new Segment[]{segment2, segment3};
            } else {
                Segment segment4;
                double d = segment.getAngle();
                segment.c();
                if (segment.isVariable()) {
                    Segment segment5 = segment4 = this.addSegment(segment, ilvPoint.x, ilvPoint.y, ilvPoint.x, ilvPoint.y, ilvTransformer);
                    segmentArray3 = new Segment[]{segment4};
                } else {
                    Segment segment6 = this.addSegment(segment, d + 90.0, ilvPoint.x, ilvPoint.y, ilvTransformer);
                    segment4 = this.addSegment(segment6, d, ilvPoint.x, ilvPoint.y, ilvTransformer);
                    segmentArray3 = new Segment[]{segment6, segment4};
                }
                if (ilvHyperEdgeEndArray2.length > 0) {
                    segment2 = segment;
                    segment3 = segment4;
                } else {
                    segment2 = segment4;
                    segment3 = segment;
                }
            }
            this.moveConnectionPoint(segment2, segment3, ilvPoint.x, ilvPoint.y, ilvTransformer);
            this.a(segment2, objectArray4, ilvTransformer);
            this.a(segment3, objectArray5, ilvTransformer);
            return segmentArray3;
        }
        return null;
    }

    public Segment[] splitSegment(Segment segment, Segment segment2, IlvTransformer ilvTransformer) {
        this.g(segment);
        this.g(segment2);
        if (segment.isVariable() != segment2.isVariable()) {
            return null;
        }
        if (segment.isIncident(segment2)) {
            boolean bl;
            boolean bl2 = segment.b();
            IlvPoint ilvPoint = segment.getIntersectionPoint(segment2, ilvTransformer);
            Object[] objectArray = this.a(segment, ilvTransformer);
            Object[] objectArray2 = this.a(objectArray, ilvPoint, segment2, bl2);
            IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = segment.getEnds();
            Object[] objectArray3 = this.a(ilvHyperEdgeEndArray, ilvPoint, bl2, ilvTransformer);
            IlvHyperEdgeEnd[] ilvHyperEdgeEndArray2 = (IlvHyperEdgeEnd[])objectArray3[0];
            IlvHyperEdgeEnd[] ilvHyperEdgeEndArray3 = (IlvHyperEdgeEnd[])objectArray3[1];
            Object[] objectArray4 = (Object[])objectArray2[0];
            Object[] objectArray5 = (Object[])objectArray2[1];
            Segment[] segmentArray = (Segment[])objectArray4[0];
            Segment[] segmentArray2 = (Segment[])objectArray5[0];
            if (ilvHyperEdgeEndArray.length == 2) {
                bl = true;
            } else {
                bl = true;
                if (ilvHyperEdgeEndArray2.length + segmentArray.length == 0) {
                    bl = false;
                }
                if (ilvHyperEdgeEndArray3.length + segmentArray2.length == 0) {
                    bl = false;
                }
            }
            if (!bl) {
                return null;
            }
            Segment segment3 = null;
            Segment segment4 = null;
            Segment[] segmentArray3 = null;
            if (ilvHyperEdgeEndArray.length == 2) {
                IlvPoint ilvPoint2 = ilvHyperEdgeEndArray[0].getPosition(ilvTransformer, true);
                IlvPoint ilvPoint3 = ilvHyperEdgeEndArray[1].getPosition(ilvTransformer, true);
                this.removeSegment(segment);
                if (bl2) {
                    if (ilvPoint2.x < ilvPoint3.x) {
                        segment3 = this.addSegment(ilvHyperEdgeEndArray[0], 0.0f, 0.0f, ilvTransformer);
                        segment4 = this.addSegment(ilvHyperEdgeEndArray[1], 0.0f, 0.0f, ilvTransformer);
                    } else {
                        segment3 = this.addSegment(ilvHyperEdgeEndArray[1], 0.0f, 0.0f, ilvTransformer);
                        segment4 = this.addSegment(ilvHyperEdgeEndArray[0], 0.0f, 0.0f, ilvTransformer);
                    }
                } else if (ilvPoint2.y < ilvPoint3.y) {
                    segment3 = this.addSegment(ilvHyperEdgeEndArray[0], 0.0f, 0.0f, ilvTransformer);
                    segment4 = this.addSegment(ilvHyperEdgeEndArray[1], 0.0f, 0.0f, ilvTransformer);
                } else {
                    segment3 = this.addSegment(ilvHyperEdgeEndArray[1], 0.0f, 0.0f, ilvTransformer);
                    segment4 = this.addSegment(ilvHyperEdgeEndArray[0], 0.0f, 0.0f, ilvTransformer);
                }
                segment3.a(segment2, true);
                segment4.a(segment2, true);
                segmentArray3 = new Segment[]{segment3, segment4};
            } else {
                double d = segment.getAngle();
                segment.c();
                segment.a(segment2, true);
                Segment segment5 = segment.isVariable() ? this.addSegment(segment2, ilvPoint.x, ilvPoint.y, ilvPoint.x, ilvPoint.y, ilvTransformer) : this.addSegment(segment2, d, ilvPoint.x, ilvPoint.y, ilvTransformer);
                if (ilvHyperEdgeEndArray2.length > 0) {
                    segment3 = segment;
                    segment4 = segment5;
                } else {
                    segment3 = segment5;
                    segment4 = segment;
                }
                segmentArray3 = new Segment[]{segment5};
            }
            this.moveConnectionPoint(segment3, segment2, ilvPoint.x, ilvPoint.y, ilvTransformer);
            this.moveConnectionPoint(segment4, segment2, ilvPoint.x, ilvPoint.y, ilvTransformer);
            this.a(segment3, objectArray4, ilvTransformer);
            this.a(segment4, objectArray5, ilvTransformer);
            return segmentArray3;
        }
        return null;
    }

    public Segment[] splitSegment(Segment segment, Segment segment2) {
        return this.splitSegment(segment, segment2, null);
    }

    private Object[] a(Segment segment, IlvTransformer ilvTransformer) {
        int n = segment.getIncidentSegmentsCount();
        Segment[] segmentArray = segment.getIncidentSegments();
        Segment[] segmentArray2 = segment.getTerminatingSegments();
        IlvPoint[] ilvPointArray = new IlvPoint[n];
        for (int i = 0; i < n; ++i) {
            ilvPointArray[i] = segment.getIntersectionPoint(segmentArray[i], ilvTransformer);
        }
        return new Object[]{segmentArray, ilvPointArray, segmentArray2};
    }

    private void a(Segment segment, Object[] objectArray, IlvTransformer ilvTransformer) {
        int n;
        Segment[] segmentArray = (Segment[])objectArray[0];
        IlvPoint[] ilvPointArray = (IlvPoint[])objectArray[1];
        Segment[] segmentArray2 = (Segment[])objectArray[2];
        for (n = 0; n < segmentArray2.length; ++n) {
            this.connectSegments(segmentArray2[n], segment);
        }
        for (n = 0; n < segmentArray.length; ++n) {
            this.connectSegments(segmentArray[n], segment);
            this.moveConnectionPoint(segmentArray[n], segment, ilvPointArray[n].x, ilvPointArray[n].y, ilvTransformer);
        }
    }

    private Object[] a(Object[] objectArray, IlvPoint ilvPoint, Segment segment, boolean bl) {
        int n;
        int n2;
        int n3;
        Segment[] segmentArray = (Segment[])objectArray[0];
        IlvPoint[] ilvPointArray = (IlvPoint[])objectArray[1];
        Segment[] segmentArray2 = (Segment[])objectArray[2];
        boolean[] blArray = new boolean[segmentArray.length];
        boolean[] blArray2 = new boolean[segmentArray2.length];
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < ilvPointArray.length; ++n3) {
            if (segmentArray[n3] == segment) continue;
            if (bl) {
                blArray[n3] = ilvPointArray[n3].x == ilvPoint.x ? n5 > 0 : ilvPointArray[n3].x < ilvPoint.x;
            } else if (ilvPointArray[n3].y == ilvPoint.y) {
                blArray[n3] = n5 > 0;
            } else {
                boolean bl2 = blArray[n3] = ilvPointArray[n3].y < ilvPoint.y;
            }
            if (blArray[n3]) {
                ++n4;
            } else {
                ++n5;
            }
            for (n2 = 0; n2 < segmentArray2.length; ++n2) {
                if (segmentArray[n3] != segmentArray2[n2]) continue;
                blArray2[n2] = blArray[n3];
            }
        }
        n3 = 0;
        n2 = 0;
        for (int i = 0; i < segmentArray2.length; ++i) {
            if (segmentArray2[i] == segment) continue;
            if (blArray2[i]) {
                ++n3;
                continue;
            }
            ++n2;
        }
        Segment[] segmentArray3 = new Segment[n4];
        Segment[] segmentArray4 = new Segment[n5];
        IlvPoint[] ilvPointArray2 = new IlvPoint[n4];
        IlvPoint[] ilvPointArray3 = new IlvPoint[n5];
        Segment[] segmentArray5 = new Segment[n3];
        Segment[] segmentArray6 = new Segment[n2];
        int n6 = 0;
        int n7 = 0;
        for (n = 0; n < segmentArray.length; ++n) {
            if (segmentArray[n] == segment) continue;
            if (blArray[n]) {
                segmentArray3[n6] = segmentArray[n];
                ilvPointArray2[n6] = ilvPointArray[n];
                ++n6;
                continue;
            }
            segmentArray4[n7] = segmentArray[n];
            ilvPointArray3[n7] = ilvPointArray[n];
            ++n7;
        }
        n6 = 0;
        n7 = 0;
        for (n = 0; n < segmentArray2.length; ++n) {
            if (segmentArray2[n] == segment) continue;
            if (blArray2[n]) {
                segmentArray5[n6++] = segmentArray2[n];
                continue;
            }
            segmentArray6[n7++] = segmentArray2[n];
        }
        Object[] objectArray2 = new Object[]{segmentArray3, ilvPointArray2, segmentArray5};
        Object[] objectArray3 = new Object[]{segmentArray4, ilvPointArray3, segmentArray6};
        return new Object[]{objectArray2, objectArray3};
    }

    private Object[] a(IlvHyperEdgeEnd[] ilvHyperEdgeEndArray, IlvPoint ilvPoint, boolean bl, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint2;
        boolean[] blArray = new boolean[ilvHyperEdgeEndArray.length];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < ilvHyperEdgeEndArray.length; ++i) {
            ilvPoint2 = ilvHyperEdgeEndArray[i].getPosition(ilvTransformer, true);
            if (bl) {
                blArray[i] = ilvPoint2.x == ilvPoint.x ? n2 > 0 : ilvPoint2.x < ilvPoint.x;
            } else if (ilvPoint2.y == ilvPoint.y) {
                blArray[i] = n2 > 0;
            } else {
                boolean bl2 = blArray[i] = ilvPoint2.y < ilvPoint.y;
            }
            if (blArray[i]) {
                ++n;
                continue;
            }
            ++n2;
        }
        IlvHyperEdgeEnd[] ilvHyperEdgeEndArray2 = new IlvHyperEdgeEnd[n];
        ilvPoint2 = new IlvHyperEdgeEnd[n2];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < ilvHyperEdgeEndArray.length; ++i) {
            if (blArray[i]) {
                ilvHyperEdgeEndArray2[n3++] = ilvHyperEdgeEndArray[i];
                continue;
            }
            ilvPoint2[n4++] = ilvHyperEdgeEndArray[i];
        }
        return new Object[]{ilvHyperEdgeEndArray2, ilvPoint2};
    }

    public Segment[] parallelSplitSegment(Segment segment, float f, float f2, IlvTransformer ilvTransformer) {
        Segment segment2;
        Segment segment3;
        this.g(segment);
        Object[] objectArray = this.b(segment, ilvTransformer);
        Object[] objectArray2 = (Object[])objectArray[0];
        Object[] objectArray3 = (Object[])objectArray[1];
        int[] nArray = (int[])objectArray[2];
        Segment[] segmentArray = (Segment[])objectArray2[0];
        Segment[] segmentArray2 = (Segment[])objectArray3[0];
        if (segmentArray.length == 0 || segmentArray2.length + nArray[0] == 0) {
            return null;
        }
        boolean bl = false;
        for (int i = 0; i < segmentArray.length; ++i) {
            if (segmentArray[i].endsAt(segment, ilvTransformer)) continue;
            this.splitSegment(segmentArray[i], segment, ilvTransformer);
            bl = true;
        }
        if (bl) {
            objectArray = this.b(segment, ilvTransformer);
            objectArray2 = (Object[])objectArray[0];
            objectArray3 = (Object[])objectArray[1];
            nArray = (int[])objectArray[2];
            segmentArray = (Segment[])objectArray2[0];
            segmentArray2 = (Segment[])objectArray3[0];
        }
        double d = segment.getAngle();
        if (segment.isVariable()) {
            segment3 = this.addSegment(segment, f, f2, f, f2, ilvTransformer);
            segment2 = this.addSegment(segment3, f, f2, f, f2, ilvTransformer);
        } else {
            segment3 = this.addSegment(segment, f, f2, ilvTransformer);
            segment2 = this.addSegment(segment3, d, f, f2, ilvTransformer);
        }
        segment.c();
        segment2.c();
        this.a(segment, objectArray2, ilvTransformer);
        this.a(segment2, objectArray3, ilvTransformer);
        this.connectSegments(segment, segment3);
        this.connectSegments(segment2, segment3);
        this.moveConnectionPoint(segment, segment3, f, f2, ilvTransformer);
        this.moveConnectionPoint(segment2, segment3, f, f2, ilvTransformer);
        if (segment2.getIncidentSegmentsCount() < 2) {
            this.removeSegment(segment2);
            this.removeSegment(segment3);
            return null;
        }
        return new Segment[]{segment3, segment2};
    }

    private Object[] b(Segment segment, IlvTransformer ilvTransformer) {
        int n;
        int n2;
        int n3;
        boolean bl = segment.b();
        Object[] objectArray = this.a(segment, ilvTransformer);
        Segment[] segmentArray = (Segment[])objectArray[0];
        IlvPoint[] ilvPointArray = (IlvPoint[])objectArray[1];
        Segment[] segmentArray2 = (Segment[])objectArray[2];
        boolean[] blArray = new boolean[segmentArray.length];
        boolean[] blArray2 = new boolean[segmentArray2.length];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        IlvPoint[] ilvPointArray2 = null;
        for (n3 = 0; n3 < segmentArray.length; ++n3) {
            if (segmentArray[n3].endsAt(segment, ilvTransformer)) {
                ilvPointArray2 = segmentArray[n3].getPoints(ilvTransformer, ilvPointArray2);
                blArray[n3] = bl ? Math.min(ilvPointArray2[0].y, ilvPointArray2[1].y) < ilvPointArray[n3].y : Math.min(ilvPointArray2[0].x, ilvPointArray2[1].x) < ilvPointArray[n3].x;
            } else {
                blArray[n3] = true;
                ++n6;
            }
            if (blArray[n3]) {
                ++n4;
            } else {
                ++n5;
            }
            for (n2 = 0; n2 < segmentArray2.length; ++n2) {
                if (segmentArray[n3] != segmentArray2[n2]) continue;
                blArray2[n2] = blArray[n3];
            }
        }
        n3 = 0;
        n2 = 0;
        for (int i = 0; i < segmentArray2.length; ++i) {
            if (blArray2[i]) {
                ++n3;
                continue;
            }
            ++n2;
        }
        Segment[] segmentArray3 = new Segment[n4];
        Segment[] segmentArray4 = new Segment[n5];
        IlvPoint[] ilvPointArray3 = new IlvPoint[n4];
        IlvPoint[] ilvPointArray4 = new IlvPoint[n5];
        Segment[] segmentArray5 = new Segment[n3];
        Segment[] segmentArray6 = new Segment[n2];
        int n7 = 0;
        int n8 = 0;
        for (n = 0; n < segmentArray.length; ++n) {
            if (blArray[n]) {
                segmentArray3[n7] = segmentArray[n];
                ilvPointArray3[n7] = ilvPointArray[n];
                ++n7;
                continue;
            }
            segmentArray4[n8] = segmentArray[n];
            ilvPointArray4[n8] = ilvPointArray[n];
            ++n8;
        }
        n7 = 0;
        n8 = 0;
        for (n = 0; n < segmentArray2.length; ++n) {
            if (blArray2[n]) {
                segmentArray5[n7++] = segmentArray2[n];
                continue;
            }
            segmentArray6[n8++] = segmentArray2[n];
        }
        Object[] objectArray2 = new Object[]{segmentArray3, ilvPointArray3, segmentArray5};
        Object[] objectArray3 = new Object[]{segmentArray4, ilvPointArray4, segmentArray6};
        return new Object[]{objectArray2, objectArray3, new int[]{n6}};
    }

    public Segment joinSegments(Segment segment, Segment segment2, IlvTransformer ilvTransformer) {
        this.g(segment);
        this.g(segment2);
        if (segment.isIncident(segment2)) {
            return this.c(segment, segment2, ilvTransformer);
        }
        return this.d(segment, segment2, ilvTransformer);
    }

    public Segment joinSegments(Segment segment, Segment segment2) {
        return this.joinSegments(segment, segment2, null);
    }

    private Segment c(Segment segment, Segment segment2, IlvTransformer ilvTransformer) {
        int n;
        boolean bl = false;
        IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = segment.getEnds();
        IlvHyperEdgeEnd[] ilvHyperEdgeEndArray2 = segment2.getEnds();
        Object[] objectArray = this.a(segment, ilvTransformer);
        Object[] objectArray2 = this.a(segment2, ilvTransformer);
        int n2 = ilvHyperEdgeEndArray.length + ilvHyperEdgeEndArray2.length;
        if (n2 > 2) {
            return null;
        }
        Segment segment3 = null;
        if (segment.isVariable() != segment2.isVariable()) {
            n = 3 - n2;
            if (segment.isVariable()) {
                if (this.d(segment) == 1) {
                    --n;
                }
                if (this.e(segment) == 1) {
                    ++n;
                }
            }
            if (segment2.isVariable()) {
                if (this.d(segment2) == 1) {
                    --n;
                }
                if (this.e(segment2) == 1) {
                    ++n;
                }
            }
            if ((segment3 = this.b(segment, segment2, ilvHyperEdgeEndArray, ilvHyperEdgeEndArray2, n)) != null) {
                bl = segment3.isVariable();
            }
        } else if (segment.isVariable()) {
            n = 2 - n2;
            if (!segment.endsAt(segment2, null) || !segment2.endsAt(segment, null)) {
                ++n;
            }
            segment3 = this.a(segment, segment2, ilvHyperEdgeEndArray, ilvHyperEdgeEndArray2, n);
        } else {
            segment3 = this.a(segment, segment2, ilvHyperEdgeEndArray, ilvHyperEdgeEndArray2);
        }
        if (segment3 != null) {
            Object[] objectArray3 = this.a(objectArray, objectArray2, segment, segment2);
            if (bl) {
                objectArray3 = this.a(objectArray3);
            }
            this.a(segment3, objectArray3, ilvTransformer);
        }
        return segment3;
    }

    private Segment d(Segment segment, Segment segment2, IlvTransformer ilvTransformer) {
        Segment segment3 = this.a(segment, segment2);
        if (segment3 == null) {
            return null;
        }
        boolean bl = false;
        if (segment3.getEnds().length > 0) {
            bl = true;
        }
        if (segment3.getIncidentSegmentsCount() > 2) {
            bl = true;
        }
        IlvPoint ilvPoint = segment3.getIntersectionPoint(segment, ilvTransformer);
        IlvPoint ilvPoint2 = segment3.getIntersectionPoint(segment2, ilvTransformer);
        boolean bl2 = false;
        IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = segment.getEnds();
        IlvHyperEdgeEnd[] ilvHyperEdgeEndArray2 = segment2.getEnds();
        Object[] objectArray = this.a(segment, ilvTransformer);
        Object[] objectArray2 = this.a(segment2, ilvTransformer);
        int n = ilvHyperEdgeEndArray.length + ilvHyperEdgeEndArray2.length;
        if (n > 2) {
            return null;
        }
        int n2 = 2 - n;
        if (segment3.isVariable()) {
            if (bl) {
                ++n2;
            }
        } else {
            ++n2;
            if (!bl) {
                ++n2;
            }
        }
        Segment segment4 = null;
        if (segment.isVariable() != segment2.isVariable()) {
            segment4 = this.b(segment, segment2, ilvHyperEdgeEndArray, ilvHyperEdgeEndArray2, n2);
            if (segment4 != null) {
                bl2 = segment4.isVariable();
            }
        } else {
            segment4 = segment.isVariable() ? this.a(segment, segment2, ilvHyperEdgeEndArray, ilvHyperEdgeEndArray2, n2) : this.a(segment, segment2, ilvHyperEdgeEndArray, ilvHyperEdgeEndArray2);
        }
        if (!bl) {
            this.removeSegment(segment3);
        }
        if (segment4 != null) {
            Object[] objectArray3 = this.a(objectArray, objectArray2, bl ? null : segment3, null);
            if (bl2) {
                objectArray3 = this.a(objectArray3);
            }
            this.a(segment4, objectArray3, ilvTransformer);
            if (bl) {
                this.connectSegments(segment4, segment3);
                this.moveConnectionPoint(segment4, segment3, 0.5f * (ilvPoint.x + ilvPoint2.x), 0.5f * (ilvPoint.y + ilvPoint2.y), ilvTransformer);
                this.c(segment3);
            }
        }
        return segment4;
    }

    private Segment a(Segment segment, Segment segment2, IlvHyperEdgeEnd[] ilvHyperEdgeEndArray, IlvHyperEdgeEnd[] ilvHyperEdgeEndArray2, int n) {
        Segment segment3;
        int n2 = this.d(segment);
        int n3 = this.d(segment2);
        if ((n2 += this.e(segment)) + (n3 += this.e(segment2)) > n) {
            return null;
        }
        if (ilvHyperEdgeEndArray.length == 0) {
            segment3 = segment2;
            this.removeSegment(segment);
            segment3.c();
        } else if (ilvHyperEdgeEndArray2.length == 0) {
            segment3 = segment;
            this.removeSegment(segment2);
            segment3.c();
        } else {
            this.removeSegment(segment);
            this.removeSegment(segment2);
            segment3 = this.addSegment(ilvHyperEdgeEndArray[0], ilvHyperEdgeEndArray2[0]);
        }
        return segment3;
    }

    private Segment a(Segment segment, Segment segment2, IlvHyperEdgeEnd[] ilvHyperEdgeEndArray, IlvHyperEdgeEnd[] ilvHyperEdgeEndArray2) {
        boolean bl;
        int n = ilvHyperEdgeEndArray.length + ilvHyperEdgeEndArray2.length;
        if (n > 1) {
            return null;
        }
        Segment segment3 = ilvHyperEdgeEndArray.length == 0 ? segment2 : segment;
        boolean bl2 = !IlvHyperGrapherUtil.hasColinearIncidentSegments(segment, segment2);
        boolean bl3 = bl = !IlvHyperGrapherUtil.hasColinearIncidentSegments(segment2, segment);
        if (segment3.getEnds().length > 0) {
            if (segment3.getAngle() != segment.getAngle()) {
                bl2 = false;
            }
            if (segment3.getAngle() != segment2.getAngle()) {
                bl = false;
            }
        }
        if (!bl2 && !bl) {
            return null;
        }
        double d = bl2 ? segment.getAngle() : segment2.getAngle();
        this.removeSegment(segment3 == segment ? segment2 : segment);
        segment3.c();
        segment3.a(d);
        return segment3;
    }

    private Segment b(Segment segment, Segment segment2, IlvHyperEdgeEnd[] ilvHyperEdgeEndArray, IlvHyperEdgeEnd[] ilvHyperEdgeEndArray2, int n) {
        Segment segment3;
        int n2;
        if (segment.isVariable()) {
            Segment segment4 = segment;
            segment = segment2;
            segment2 = segment4;
            IlvHyperEdgeEnd[] ilvHyperEdgeEndArray3 = ilvHyperEdgeEndArray;
            ilvHyperEdgeEndArray = ilvHyperEdgeEndArray2;
            ilvHyperEdgeEndArray2 = ilvHyperEdgeEndArray3;
        }
        boolean bl = true;
        boolean bl2 = true;
        int n3 = ilvHyperEdgeEndArray.length + ilvHyperEdgeEndArray2.length;
        if (n3 == 2) {
            bl = false;
        }
        Segment[] segmentArray = segment2.getTerminatingSegments();
        for (n2 = 0; n2 < segmentArray.length; ++n2) {
            if (segmentArray[n2].isVariable() || segmentArray[n2] == segment || !segmentArray[n2].isColinear(segment)) continue;
            bl = false;
        }
        n2 = this.d(segment);
        int n4 = this.d(segment2);
        if (n2 + (n4 += this.e(segment2)) > n) {
            bl2 = false;
        }
        if (!bl && !bl2) {
            return null;
        }
        if (bl && bl2) {
            if (ilvHyperEdgeEndArray.length == 0) {
                segment3 = segment2;
                this.removeSegment(segment);
                segment3.c();
            } else {
                segment3 = segment;
                this.removeSegment(segment2);
                segment3.c();
            }
        } else {
            segment3 = bl ? segment : segment2;
            this.removeSegment(bl ? segment2 : segment);
            if (segment3.getEnds().length < n3) {
                int n5;
                ArrayList<IlvHyperEdgeEnd> arrayList = new ArrayList<IlvHyperEdgeEnd>();
                for (n5 = 0; n5 < ilvHyperEdgeEndArray.length; ++n5) {
                    arrayList.add(ilvHyperEdgeEndArray[n5]);
                }
                for (n5 = 0; n5 < ilvHyperEdgeEndArray2.length; ++n5) {
                    arrayList.add(ilvHyperEdgeEndArray2[n5]);
                }
                n5 = segment3.isVariable() ? 1 : 0;
                double d = segment3.getAngle();
                this.removeSegment(segment3);
                segment3 = n3 == 2 ? this.addSegment((IlvHyperEdgeEnd)arrayList.get(0), (IlvHyperEdgeEnd)arrayList.get(1)) : (n5 != 0 ? this.addSegment((IlvHyperEdgeEnd)arrayList.get(0), 0.0f, 0.0f, null) : this.addSegment((IlvHyperEdgeEnd)arrayList.get(0), d));
            }
            segment3.c();
        }
        return segment3;
    }

    private Segment a(Segment segment, Segment segment2) {
        int n;
        HashSet<Segment> hashSet = new HashSet<Segment>();
        int n2 = segment.getIncidentSegmentsCount();
        for (n = 0; n < n2; ++n) {
            hashSet.add(segment.getIncidentSegment(n));
        }
        n2 = segment2.getIncidentSegmentsCount();
        for (n = 0; n < n2; ++n) {
            if (!hashSet.contains(segment2.getIncidentSegment(n))) continue;
            return segment2.getIncidentSegment(n);
        }
        return null;
    }

    private Object[] a(Object[] objectArray, Object[] objectArray2, Segment segment, Segment segment2) {
        int n;
        int n2;
        int n3;
        Segment[] segmentArray = (Segment[])objectArray[0];
        IlvPoint[] ilvPointArray = (IlvPoint[])objectArray[1];
        Segment[] segmentArray2 = (Segment[])objectArray[2];
        Segment[] segmentArray3 = (Segment[])objectArray2[0];
        IlvPoint[] ilvPointArray2 = (IlvPoint[])objectArray2[1];
        Segment[] segmentArray4 = (Segment[])objectArray2[2];
        int n4 = 0;
        for (n3 = 0; n3 < segmentArray.length; ++n3) {
            if (segmentArray[n3] == segment || segmentArray[n3] == segment2) continue;
            ++n4;
        }
        for (n3 = 0; n3 < segmentArray3.length; ++n3) {
            if (segmentArray3[n3] == segment || segmentArray3[n3] == segment2) continue;
            ++n4;
        }
        n3 = 0;
        for (n2 = 0; n2 < segmentArray2.length; ++n2) {
            if (segmentArray2[n2] == segment || segmentArray2[n2] == segment2) continue;
            ++n3;
        }
        for (n2 = 0; n2 < segmentArray4.length; ++n2) {
            if (segmentArray4[n2] == segment || segmentArray4[n2] == segment2) continue;
            ++n3;
        }
        Segment[] segmentArray5 = new Segment[n4];
        IlvPoint[] ilvPointArray3 = new IlvPoint[n4];
        Segment[] segmentArray6 = new Segment[n3];
        n3 = 0;
        n4 = 0;
        for (n = 0; n < segmentArray.length; ++n) {
            if (segmentArray[n] == segment || segmentArray[n] == segment2) continue;
            segmentArray5[n4] = segmentArray[n];
            ilvPointArray3[n4] = ilvPointArray[n];
            ++n4;
        }
        for (n = 0; n < segmentArray3.length; ++n) {
            if (segmentArray3[n] == segment || segmentArray3[n] == segment2) continue;
            segmentArray5[n4] = segmentArray3[n];
            ilvPointArray3[n4] = ilvPointArray2[n];
            ++n4;
        }
        for (n = 0; n < segmentArray2.length; ++n) {
            if (segmentArray2[n] == segment || segmentArray2[n] == segment2) continue;
            segmentArray6[n3++] = segmentArray2[n];
        }
        for (n = 0; n < segmentArray4.length; ++n) {
            if (segmentArray4[n] == segment || segmentArray4[n] == segment2) continue;
            segmentArray6[n3++] = segmentArray4[n];
        }
        n4 = 0;
        for (n = 0; n < segmentArray6.length; ++n) {
            Segment segment3;
            if (segmentArray6[n].isVariable()) {
                if (!segmentArray6[n].isFullyTerminated()) continue;
                if (n4 != n) {
                    segment3 = segmentArray6[n4];
                    segmentArray6[n4] = segmentArray6[n];
                    segmentArray6[n] = segment3;
                }
                ++n4;
                continue;
            }
            if (n4 != n) {
                segment3 = segmentArray6[n4];
                segmentArray6[n4] = segmentArray6[n];
                segmentArray6[n] = segment3;
            }
            ++n4;
        }
        return new Object[]{segmentArray5, ilvPointArray3, segmentArray6};
    }

    private Object[] a(Object[] objectArray) {
        Segment[] segmentArray = (Segment[])objectArray[0];
        IlvPoint[] ilvPointArray = (IlvPoint[])objectArray[1];
        int n = 0;
        for (int i = 0; i < segmentArray.length; ++i) {
            if (!segmentArray[i].isFullyTerminated() && segmentArray[i].isVariable()) continue;
            ++n;
        }
        Segment[] segmentArray2 = new Segment[n];
        n = 0;
        for (int i = 0; i < segmentArray.length; ++i) {
            if (!segmentArray[i].isFullyTerminated() && segmentArray[i].isVariable()) continue;
            segmentArray2[n++] = segmentArray[i];
        }
        return new Object[]{segmentArray, ilvPointArray, segmentArray2};
    }

    private void c(Segment segment) {
        double d;
        Object object;
        if (!segment.isVariable()) {
            return;
        }
        if (segment.isFullyTerminated()) {
            return;
        }
        IlvPoint[] ilvPointArray = segment.getPoints(null, null);
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        Segment segment2 = null;
        Segment segment3 = null;
        Object object2 = null;
        Object object3 = null;
        int n = segment.getIncidentSegmentsCount();
        for (int i = 0; i < n; ++i) {
            Segment segment4 = segment.getIncidentSegment(i);
            object = segment.getIntersectionPoint(segment4, null);
            d = IlvGeometryUtil.getDistance(object, ilvPointArray[0]);
            if (d < d2) {
                d2 = d;
                segment2 = segment4;
                object2 = object;
            }
            if (!((d = IlvGeometryUtil.getDistance(object, ilvPointArray[1])) < d3)) continue;
            d3 = d;
            segment3 = segment4;
            object3 = object;
        }
        Segment[] segmentArray = segment.getTerminatingSegments();
        for (int i = 0; i < segmentArray.length; ++i) {
            object = segmentArray[i];
            IlvPoint ilvPoint = segment.getIntersectionPoint((Segment)object, null);
            d = IlvGeometryUtil.getDistance(ilvPoint, ilvPointArray[0]);
            if (d <= d2) {
                segment2 = null;
            }
            if (!((d = IlvGeometryUtil.getDistance(ilvPoint, ilvPointArray[1])) <= d3)) continue;
            segment3 = null;
        }
        if (segment2 != null && !segment.endsAt(segment2, null)) {
            segment.a(segment2);
            this.connectSegments(segment, segment2);
            this.moveConnectionPoint(segment, segment2, object2.x, object2.y, null);
        }
        if (segment3 != null && !segment.endsAt(segment3, null)) {
            segment.a(segment3);
            this.connectSegments(segment, segment3);
            this.moveConnectionPoint(segment, segment3, object3.x, object3.y, null);
        }
        if (segment.isFullyTerminated()) {
            return;
        }
        Object[] objectArray = this.a(segment, (IlvTransformer)null);
        segment.c();
        this.a(segment, objectArray, null);
    }

    private int d(Segment segment) {
        int n = 0;
        int n2 = segment.getIncidentSegmentsCount();
        for (int i = 0; i < n2; ++i) {
            Segment segment2 = segment.getIncidentSegment(i);
            if (segment2.isVariable()) continue;
            ++n;
        }
        return n;
    }

    private int e(Segment segment) {
        int n = 0;
        Segment[] segmentArray = segment.getTerminatingSegments();
        for (int i = 0; i < segmentArray.length; ++i) {
            if (!segmentArray[i].isVariable() || segmentArray[i].endsAt(segment, null)) continue;
            ++n;
        }
        return n;
    }

    void a(Segment segment, float f, float f2, IlvTransformer ilvTransformer) {
        this.g(segment);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            IlvPoint ilvPoint = new IlvPoint(f, f2);
            ilvTransformer.inverse(ilvPoint);
            f = ilvPoint.x;
            f2 = ilvPoint.y;
        }
        segment.a(null, f, f2, ilvTransformer);
    }

    public void moveConnectionPoint(Segment segment, Segment segment2, float f, float f2, IlvTransformer ilvTransformer) {
        this.g(segment);
        if (!segment.isVariable() || segment2 != null) {
            this.g(segment2);
        }
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            IlvPoint ilvPoint = new IlvPoint(f, f2);
            ilvTransformer.inverse(ilvPoint);
            f = ilvPoint.x;
            f2 = ilvPoint.y;
        }
        segment.a(segment2, f, f2, ilvTransformer);
        if (segment2 != null) {
            segment2.a(segment, f, f2, ilvTransformer);
        }
    }

    public boolean setSegmentAngle(Segment segment, double d) {
        double d2;
        if (segment.isVariable()) {
            return false;
        }
        for (int i = 0; i < segment.getIncidentSegmentsCount(); ++i) {
            Segment segment2 = segment.getIncidentSegment(i);
            if (segment2.isVariable() || !IlvSegmentedHyperEdge.b(d, d2 = segment2.getAngle())) continue;
            return false;
        }
        double d3 = d / 180.0 * Math.PI;
        d2 = Math.sin(d3);
        double d4 = Math.cos(d3);
        if (Math.abs(d4) <= Math.abs(d2)) {
            segment.a(false);
            segment.b(d4 / d2);
        } else {
            segment.a(true);
            segment.b(d2 / d4);
        }
        return true;
    }

    public void setEndSegmentAngle(IlvHyperEdgeEnd ilvHyperEdgeEnd, double d) {
        int n;
        d = IlvSegmentedHyperEdge.b(d);
        if (ilvHyperEdgeEnd == null) {
            throw new IllegalArgumentException("The end cannot be null");
        }
        if (ilvHyperEdgeEnd.getHyperEdge() != this) {
            throw new IllegalArgumentException("The end does not belong to this hyperedge");
        }
        HyperEdgeEnd hyperEdgeEnd = (HyperEdgeEnd)ilvHyperEdgeEnd;
        Segment segment = hyperEdgeEnd.b();
        if (segment == null) {
            return;
        }
        if (segment.isVariable()) {
            return;
        }
        if (segment.getAngle() == d) {
            return;
        }
        int n2 = segment.getIncidentSegmentsCount();
        Segment[] segmentArray = segment.getIncidentSegments();
        double[] dArray = new double[n2];
        IlvPoint ilvPoint = ilvHyperEdgeEnd.getPosition(null, true);
        for (int i = 0; i < n2; ++i) {
            IlvPoint ilvPoint2 = segment.getIntersectionPoint(segmentArray[i], null);
            dArray[i] = IlvGeometryUtil.getDistance(ilvPoint, ilvPoint2);
        }
        segment.c();
        double d2 = segment.getAngle();
        segment.a(d);
        if (n2 == 0) {
            return;
        }
        boolean bl = false;
        Segment segment2 = null;
        if (segment.b()) {
            bl = true;
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if (segmentArray[i].isVariable()) continue;
                ++n3;
                if (segmentArray[i].getAngle() == d) {
                    segment2 = segmentArray[i];
                    continue;
                }
                bl = false;
            }
            if (n3 != 1) {
                bl = false;
            }
        }
        double d3 = d;
        float f = 1.0f;
        switch (this.getNodeSide(ilvHyperEdgeEnd)) {
            case 1: {
                if (d3 < 1.5707963267948966) {
                    d3 -= Math.PI;
                }
                f = -1.0f;
                break;
            }
            case 2: {
                if (!(d3 > 1.5707963267948966)) break;
                d3 -= Math.PI;
                break;
            }
            case 4: {
                f = -1.0f;
                break;
            }
            case 8: {
                d3 -= Math.PI;
            }
        }
        double d4 = Math.sin(d3);
        double d5 = Math.cos(d3);
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (!segmentArray[n].isVariable()) continue;
            segmentArray[n].a(segment, true);
            this.moveConnectionPoint(segmentArray[n], segment, (float)((double)ilvPoint.x + d5 * dArray[n]), (float)((double)ilvPoint.y - d4 * dArray[n]), null);
            ++n4;
        }
        if (n4 == n2) {
            return;
        }
        if (bl && segment2 != null && segment2.getEnds().length == 0) {
            segmentArray = segment2.getIncidentSegments();
            segment2.c();
            this.removeSegment(segment2);
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].a(segment, true);
            }
        } else {
            Segment segment3 = this.addSegment(segment, d2, ilvPoint.x + f * 20.0f, ilvPoint.y + f * 20.0f, null);
            for (int i = 0; i < segmentArray.length; ++i) {
                if (segmentArray[i].isVariable()) continue;
                segmentArray[i].a(segment3, true);
            }
        }
    }

    private void f(Segment segment) {
        Segment[] segmentArray;
        int n = segment.getIncidentSegmentsCount();
        while (n <= 1 && segment.getEnds().length == 0 && (segmentArray = this.removeSegment(segment)).length != 0) {
            segment = segmentArray[0];
            n = segment.getIncidentSegmentsCount();
        }
        if (segment != null) {
            this.c(segment);
        }
    }

    public int getNodeSide(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        if (ilvHyperEdgeEnd == null) {
            return 1;
        }
        if (ilvHyperEdgeEnd.getNode() == null) {
            return 1;
        }
        IlvPoint ilvPoint = ilvHyperEdgeEnd.getPosition(null, true);
        IlvRect ilvRect = ilvHyperEdgeEnd.getNode().boundingBox(null);
        return IlvGeometryUtil.getSide(ilvRect, ilvPoint);
    }

    public Segment getClosestSegment(float f, float f2, IlvTransformer ilvTransformer) {
        IlvPoint[] ilvPointArray = new IlvPoint[2];
        IlvPoint ilvPoint = new IlvPoint();
        ilvPointArray[0] = new IlvPoint();
        ilvPointArray[1] = new IlvPoint();
        int n = this.getSegmentsCount();
        double d = Double.MAX_VALUE;
        Segment segment = null;
        for (int i = 0; i < n; ++i) {
            Segment segment2 = (Segment)this.a.get(i);
            segment2.b(ilvTransformer, ilvPointArray);
            double d2 = this.a(f, f2, ilvPointArray, ilvPoint);
            if (segment != null && !(d2 < d)) continue;
            d = d2;
            segment = segment2;
        }
        return segment;
    }

    public Segment[] getClosestSegments(float f, float f2, IlvTransformer ilvTransformer, Segment[] segmentArray) {
        Segment segment = null;
        Segment segment2 = null;
        int n = this.getSegmentsCount();
        double d = Double.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            Segment segment3 = (Segment)this.a.get(i);
            int n2 = segment3.getIncidentSegmentsCount();
            for (int j = 0; j < n2; ++j) {
                Segment segment4 = segment3.getIncidentSegment(j);
                if (segment3.hashCode() < segment4.hashCode()) continue;
                IlvPoint ilvPoint = segment3.getIntersectionPoint(segment4, ilvTransformer);
                double d2 = ilvPoint.x - f;
                double d3 = ilvPoint.y - f2;
                double d4 = d2 * d2 + d3 * d3;
                if (!(d4 < d)) continue;
                segment = segment3;
                segment2 = segment4;
                d = d4;
            }
        }
        if (segment == null || segment2 == null) {
            return null;
        }
        if (segmentArray == null || segmentArray.length < 2) {
            segmentArray = new Segment[]{segment, segment2};
        }
        return segmentArray;
    }

    private double a(float f, float f2, IlvPoint[] ilvPointArray, IlvPoint ilvPoint) {
        if (this.b(f, f2, ilvPointArray, ilvPoint)) {
            double d = ilvPoint.x - f;
            double d2 = ilvPoint.y - f2;
            return d * d + d2 * d2;
        }
        double d = ilvPointArray[0].x - f;
        double d3 = ilvPointArray[0].y - f2;
        double d4 = d * d + d3 * d3;
        d = ilvPointArray[1].x - f;
        d3 = ilvPointArray[1].y - f2;
        double d5 = d * d + d3 * d3;
        return Math.min(d4, d5);
    }

    private boolean b(float f, float f2, IlvPoint[] ilvPointArray, IlvPoint ilvPoint) {
        double d = ilvPointArray[1].x - ilvPointArray[0].x;
        double d2 = d * d;
        double d3 = ilvPointArray[1].y - ilvPointArray[0].y;
        double d4 = d3 * d3;
        double d5 = d2 + d4;
        if (d5 < 0.001) {
            ilvPoint.x = (ilvPointArray[1].x + ilvPointArray[0].x) / 2.0f;
            ilvPoint.y = (ilvPointArray[1].y + ilvPointArray[0].y) / 2.0f;
            return true;
        }
        double d6 = ((double)(f - ilvPointArray[0].x) * d + (double)(f2 - ilvPointArray[0].y) * d3) / d5;
        ilvPoint.x = (float)((double)ilvPointArray[0].x + d6 * d);
        ilvPoint.y = (float)((double)ilvPointArray[0].y + d6 * d3);
        return 0.0 <= d6 && d6 <= 1.0;
    }

    public Segment getNearEndSegment(Segment segment) {
        Segment segment2;
        int n;
        int n2;
        this.g(segment);
        if (segment.getEnds().length != 0) {
            return segment;
        }
        int n3 = segment.getIncidentSegmentsCount();
        if (n3 == 0 || n3 > 2) {
            return null;
        }
        Segment segment3 = segment;
        Segment segment4 = segment.getIncidentSegment(0);
        while (segment4 != null) {
            n2 = segment4.getIncidentSegmentsCount();
            n = segment4.getEnds().length;
            if (n != 0) {
                if (n2 + n != 2) break;
                return segment4;
            }
            if (n2 > 2) break;
            segment2 = segment4.getOtherIncidentSegment(segment3);
            segment3 = segment4;
            segment4 = segment2;
        }
        if (n3 == 1) {
            return null;
        }
        segment3 = segment;
        segment4 = segment.getIncidentSegment(1);
        while (segment4 != null) {
            n2 = segment4.getIncidentSegmentsCount();
            n = segment4.getEnds().length;
            if (n != 0) {
                if (n2 + n != 2) break;
                return segment4;
            }
            if (n2 > 2) break;
            segment2 = segment4.getOtherIncidentSegment(segment3);
            segment3 = segment4;
            segment4 = segment2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(Segment segment, boolean bl, boolean bl2) {
        this.g(segment);
        if (this.getGraphicBag() == null) {
            segment.setSelected(bl);
        } else {
            IlvHyperGrapher ilvHyperGrapher = (IlvHyperGrapher)this.getGraphicBag();
            Object object = ilvHyperGrapher.getTreeLock();
            synchronized (object) {
                final boolean bl3 = bl;
                final Segment segment2 = segment;
                ilvHyperGrapher.applyToObject(this, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        segment2.setSelected(bl3);
                    }
                }, null, bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAll(boolean bl) {
        if (this.getGraphicBag() == null) {
            this.b(true);
        } else {
            IlvHyperGrapher ilvHyperGrapher = (IlvHyperGrapher)this.getGraphicBag();
            Object object = ilvHyperGrapher.getTreeLock();
            synchronized (object) {
                ilvHyperGrapher.applyToObject(this, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        IlvSegmentedHyperEdge.this.b(true);
                    }
                }, null, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deSelectAll(boolean bl) {
        if (this.getGraphicBag() == null) {
            this.b(false);
        } else {
            IlvHyperGrapher ilvHyperGrapher = (IlvHyperGrapher)this.getGraphicBag();
            Object object = ilvHyperGrapher.getTreeLock();
            synchronized (object) {
                ilvHyperGrapher.applyToObject(this, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        IlvSegmentedHyperEdge.this.b(false);
                    }
                }, null, bl);
            }
        }
    }

    private void b(boolean bl) {
        int n = this.getSegmentsCount();
        for (int i = 0; i < n; ++i) {
            Segment segment = (Segment)this.a.get(i);
            segment.setSelected(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteSelection(boolean bl) {
        Segment[] segmentArray = this.getSelectedSegments();
        if (segmentArray.length == 0) {
            return false;
        }
        if (this.getGraphicBag() == null) {
            this.a(segmentArray);
        } else {
            IlvHyperGrapher ilvHyperGrapher = (IlvHyperGrapher)this.getGraphicBag();
            Object object = ilvHyperGrapher.getTreeLock();
            synchronized (object) {
                ilvHyperGrapher.applyToObject(this, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        IlvSegmentedHyperEdge.this.a((Segment[])object);
                    }
                }, segmentArray, bl);
            }
        }
        return true;
    }

    private void a(Segment[] segmentArray) {
        this.b(false);
        int n = segmentArray.length;
        for (int i = 0; i < n; ++i) {
            Segment segment;
            if (!segmentArray[i].d() || (segment = this.getNearEndSegment(segmentArray[i])) == null) continue;
            IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = segment.getEnds();
            for (int j = 0; j < ilvHyperEdgeEndArray.length; ++j) {
                IlvHyperEdgeEnd ilvHyperEdgeEnd = ilvHyperEdgeEndArray[j];
                if (this.isFromEnd(ilvHyperEdgeEnd)) {
                    this.removeFrom(ilvHyperEdgeEnd);
                    continue;
                }
                if (!this.isToEnd(ilvHyperEdgeEnd)) continue;
                this.removeTo(ilvHyperEdgeEnd);
            }
        }
    }

    public Segment[] getSelectedSegments() {
        Vector<Segment> vector = new Vector<Segment>();
        int n = this.getSegmentsCount();
        for (int i = 0; i < n; ++i) {
            Segment segment = (Segment)this.a.get(i);
            if (!segment.isSelected()) continue;
            vector.addElement(segment);
        }
        Object[] objectArray = new Segment[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setSelectedSegmentsPaint(Paint paint) {
        this.b = paint.equals(Color.red) ? null : paint;
    }

    public Paint getSelectedSegmentsPaint() {
        if (this.b == null) {
            return Color.red;
        }
        return this.b;
    }

    protected Paint getAdaptedSelectedSegmentsPaint(IlvTransformer ilvTransformer) {
        Paint paint;
        if (this.isPaintAbsolute()) {
            return this.getSelectedSegmentsPaint();
        }
        Object[] objectArray = this.a(ilvTransformer);
        Paint paint2 = paint = objectArray == null ? null : (Paint)objectArray[1];
        if (paint == null) {
            IlvRect ilvRect = this.calcBoundingBox(ilvTransformer);
            objectArray = this.a(ilvRect, ilvTransformer);
            this.a(ilvTransformer, ilvRect, objectArray);
            paint = (Paint)objectArray[1];
        }
        return paint;
    }

    Object[] a(IlvRect ilvRect, IlvTransformer ilvTransformer) {
        Paint paint = this.a(ilvRect, this.getStrokePaint());
        Paint paint2 = this.a(ilvRect, this.getSelectedSegmentsPaint());
        return new Object[]{paint, paint2};
    }

    private void g(Segment segment) {
        if (segment == null) {
            throw new IllegalArgumentException("input segment cannot be null");
        }
        if (!segment.d()) {
            throw new IllegalArgumentException("input segment was already removed from the hyperedge");
        }
        if (segment.getHyperEdge() != this) {
            throw new IllegalArgumentException("input segment does not belong to this hyperedge");
        }
    }

    void a(IlvTransformer ilvTransformer, Vector vector) {
        if (this.a == null) {
            return;
        }
        Segment segment = (Segment)this.a.get(0);
        IlvPoint[] ilvPointArray = new IlvPoint[]{new IlvPoint(), new IlvPoint()};
        segment.b(ilvTransformer, ilvPointArray);
        this.a(segment, ilvPointArray, null, vector, ilvTransformer);
    }

    private void a(Segment segment, IlvPoint[] ilvPointArray, Segment segment2, Vector vector, IlvTransformer ilvTransformer) {
        float f = ilvPointArray[0].x;
        float f2 = ilvPointArray[0].y;
        float f3 = ilvPointArray[1].x;
        float f4 = ilvPointArray[1].y;
        int n = segment.getIncidentSegmentsCount();
        for (int i = 0; i < n; ++i) {
            Segment segment3 = segment.getIncidentSegment(i);
            if (segment3 == segment2) continue;
            segment3.b(ilvTransformer, ilvPointArray);
            IlvPoint ilvPoint = null;
            ilvPoint = f == f3 && f2 == f4 ? new IlvPoint(f, f2) : (ilvPointArray[0].equals((Object)ilvPointArray[1]) ? new IlvPoint(ilvPointArray[0]) : IlvUtil.GetLineIntersection((double)f, (double)f2, (double)f3, (double)f4, (double)ilvPointArray[0].x, (double)ilvPointArray[0].y, (double)ilvPointArray[1].x, (double)ilvPointArray[1].y, null));
            if (ilvPoint != null) {
                vector.addElement(ilvPoint);
            }
            this.a(segment3, ilvPointArray, segment, vector, ilvTransformer);
        }
    }

    public void setAutoConnect(boolean bl) {
        this.c = !bl;
    }

    public boolean isAutoConnect() {
        return !this.c;
    }

    protected void afterAddEnd(IlvHyperEdgeEnd ilvHyperEdgeEnd, boolean bl) {
        if (!this.isAutoConnect()) {
            return;
        }
        Segment segment = this.getSegmentsCount() > 0 ? (Segment)this.getSegments().next() : null;
        IlvPoint ilvPoint = this.getCenter(null);
        Segment segment2 = this.addSegment(ilvHyperEdgeEnd, ilvPoint.x, ilvPoint.y, null);
        if (segment != null) {
            this.connectSegments(segment, segment2);
            this.moveConnectionPoint(segment, segment2, ilvPoint.x, ilvPoint.y, null);
        }
    }

    protected void beforeRemoveEnd(IlvHyperEdgeEnd ilvHyperEdgeEnd, boolean bl) {
        this.removeSegments(ilvHyperEdgeEnd);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        IlvUtility2D.writePaint((IlvOutputStream)ilvOutputStream, (Paint)this.getSelectedSegmentsPaint(), (String)"selSegmentsPaint", (String)"selSeg", (Color)Color.red);
        ilvOutputStream.write("autoconnect", this.isAutoConnect());
        ilvOutputStream.write("segments", this.c());
    }

    public IlvOrderedCompoundEdit beforeDo(String string) {
        IlvOrderedCompoundEdit ilvOrderedCompoundEdit = super.beforeDo(string);
        String[] stringArray = new String[2];
        stringArray[0] = "getSelectedSegmentsPaint";
        stringArray[1] = "isAutoConnect";
        String[] stringArray2 = new String[2];
        stringArray2[0] = "setSelectedSegmentsPaint";
        stringArray2[1] = "setAutoConnect";
        IlvPropertiesEdit ilvPropertiesEdit = new IlvPropertiesEdit(string, IlvSegmentedHyperEdge.class, stringArray, stringArray2);
        ilvPropertiesEdit.before(this);
        ilvOrderedCompoundEdit.addEditNoAbsorb(ilvPropertiesEdit);
        UndoChangeShape undoChangeShape = new UndoChangeShape();
        undoChangeShape.a(this);
        ilvOrderedCompoundEdit.addEditNoAbsorb(undoChangeShape);
        return ilvOrderedCompoundEdit;
    }

    public void afterDo(IlvOrderedCompoundEdit ilvOrderedCompoundEdit) {
        super.afterDo(ilvOrderedCompoundEdit);
        IlvGraphicEdit ilvGraphicEdit = (IlvGraphicEdit)ilvOrderedCompoundEdit.getEdit(5);
        ilvGraphicEdit.after(this);
        UndoChangeShape undoChangeShape = (UndoChangeShape)ilvOrderedCompoundEdit.getEdit(6);
        undoChangeShape.b(this);
        ilvOrderedCompoundEdit.end();
    }

    private static float e(Segment segment, Segment segment2, IlvTransformer ilvTransformer) {
        double d;
        if (segment.b()) {
            return segment.f().b(segment, segment2, ilvTransformer);
        }
        if (segment2.b()) {
            return segment2.f().b(segment2, segment, ilvTransformer);
        }
        float f = segment.a(ilvTransformer);
        float f2 = segment2.a(ilvTransformer);
        double d2 = segment.a();
        if (d2 == (d = segment2.a())) {
            return 0.0f;
        }
        return (float)(((double)f2 * d2 - (double)f * d) / (d2 - d));
    }

    private static float f(Segment segment, Segment segment2, IlvTransformer ilvTransformer) {
        if (!segment.b()) {
            return segment.f().b(segment, segment2, ilvTransformer);
        }
        if (!segment2.b()) {
            return segment2.f().b(segment2, segment, ilvTransformer);
        }
        float f = segment.a(ilvTransformer);
        float f2 = segment2.a(ilvTransformer);
        double d = segment.a();
        double d2 = segment2.a();
        return (float)(((double)f2 * d - (double)f * d2) / (d - d2));
    }

    static float a(IlvPoint[] ilvPointArray, float f, float f2) {
        double d = ilvPointArray[1].x - ilvPointArray[0].x;
        double d2 = ilvPointArray[1].y - ilvPointArray[0].y;
        double d3 = d * d + d2 * d2;
        if (d3 == 0.0) {
            return 0.0f;
        }
        float f3 = (float)((d * (double)(f - ilvPointArray[0].x) + d2 * (double)(f2 - ilvPointArray[0].y)) / d3);
        if (f3 < 0.0f) {
            return 0.0f;
        }
        if (f3 > 1.0f) {
            return 1.0f;
        }
        return f3;
    }

    public static class SegmentShape
    implements IlvPersistentObject {
        int[] a;
        boolean b;
        double c;
        boolean d;
        float e;
        float f;
        HyperEdgeEnd g;
        HyperEdgeEnd h;
        int i;
        int j;
        IlvPoint k;
        IlvPoint l;
        IlvPersistentObject m;
        Segment n;

        SegmentShape(Segment segment, HashMap hashMap) {
            Object object;
            int n;
            this.n = segment;
            SegmentInfo segmentInfo = segment.f();
            this.b = segmentInfo.e();
            this.j = -1;
            this.i = -1;
            int n2 = (Integer)hashMap.get(segment);
            Vector<Integer> vector = new Vector<Integer>();
            int n3 = segmentInfo.j();
            for (n = 0; n < n3; ++n) {
                object = segmentInfo.a(n);
                Integer n4 = (Integer)hashMap.get(object);
                if (n4 <= n2) continue;
                vector.addElement(n4);
            }
            this.a = new int[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                object = (Integer)vector.elementAt(n);
                this.a[n] = (Integer)object;
            }
            this.g = (HyperEdgeEnd)segmentInfo.a();
            this.h = (HyperEdgeEnd)segmentInfo.b();
            segmentInfo.a(this, hashMap);
            if (segment.getExtension() instanceof IlvPersistentObject) {
                this.m = (IlvPersistentObject)segment.getExtension();
            }
        }

        public SegmentShape(IlvInputStream ilvInputStream) throws IlvReadFileException {
            this.j = -1;
            this.i = -1;
            this.h = null;
            this.g = null;
            this.l = null;
            this.k = null;
            try {
                this.b = ilvInputStream.readBoolean("variable");
            }
            catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                // empty catch block
            }
            try {
                this.g = (HyperEdgeEnd)ilvInputStream.readPersistentObject("end1");
            }
            catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                // empty catch block
            }
            try {
                this.h = (HyperEdgeEnd)ilvInputStream.readPersistentObject("end2");
            }
            catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                // empty catch block
            }
            if (this.b) {
                if (this.h == null) {
                    try {
                        this.i = ilvInputStream.readInt("term1");
                    }
                    catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                        // empty catch block
                    }
                    try {
                        this.k = ilvInputStream.readPoint("pos1");
                    }
                    catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                        // empty catch block
                    }
                    try {
                        this.e = ilvInputStream.readFloat("coord1");
                    }
                    catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                        // empty catch block
                    }
                }
                if (this.g == null) {
                    try {
                        this.j = ilvInputStream.readInt("term2");
                    }
                    catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                        // empty catch block
                    }
                    try {
                        this.l = ilvInputStream.readPoint("pos2");
                    }
                    catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                        // empty catch block
                    }
                    try {
                        this.f = ilvInputStream.readFloat("coord2");
                    }
                    catch (IlvFieldNotFoundException ilvFieldNotFoundException) {}
                }
            } else {
                try {
                    this.c = ilvInputStream.readDouble("grad");
                }
                catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                    // empty catch block
                }
                try {
                    this.d = ilvInputStream.readBoolean("horiz");
                }
                catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                    // empty catch block
                }
                try {
                    this.e = ilvInputStream.readFloat("coord");
                }
                catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                    // empty catch block
                }
            }
            try {
                this.a = ilvInputStream.readIntArray("connections");
            }
            catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                // empty catch block
            }
            try {
                this.m = ilvInputStream.readPersistentObject("extension");
            }
            catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                // empty catch block
            }
        }

        public void write(IlvOutputStream ilvOutputStream) throws IOException {
            ilvOutputStream.write("variable", this.b);
            if (this.g != null) {
                ilvOutputStream.write("end1", (IlvPersistentObject)this.g);
            }
            if (this.h != null) {
                ilvOutputStream.write("end2", (IlvPersistentObject)this.h);
            }
            if (this.b) {
                if (this.h == null) {
                    ilvOutputStream.write("term1", this.i);
                    if (this.k != null) {
                        ilvOutputStream.write("pos1", this.k);
                    } else {
                        ilvOutputStream.write("coord1", this.e);
                    }
                }
                if (this.g == null) {
                    ilvOutputStream.write("term2", this.j);
                    if (this.l != null) {
                        ilvOutputStream.write("pos2", this.l);
                    } else {
                        ilvOutputStream.write("coord2", this.f);
                    }
                }
            } else {
                ilvOutputStream.write("grad", this.c);
                ilvOutputStream.write("horiz", this.d);
                ilvOutputStream.write("coord", this.e);
            }
            ilvOutputStream.write("connections", this.a);
            if (this.m != null) {
                ilvOutputStream.write("extension", this.m);
            }
        }
    }

    public static class HyperEdgeEnd
    extends IlvDefaultHyperEdgeEnd {
        private Segment a;
        private boolean b;

        public HyperEdgeEnd(IlvHyperEdge ilvHyperEdge, IlvGraphic ilvGraphic, boolean bl) {
            super(ilvHyperEdge, ilvGraphic);
            this.b = bl;
        }

        public HyperEdgeEnd(IlvInputStream ilvInputStream) throws IlvReadFileException {
            super(ilvInputStream);
        }

        public IlvHyperEdgeEnd copy() {
            HyperEdgeEnd hyperEdgeEnd = new HyperEdgeEnd(null, this.getNode(), this.a());
            this.a(hyperEdgeEnd);
            IlvSegmentedHyperEdge.b(this.getHyperEdge(), this, hyperEdgeEnd);
            return hyperEdgeEnd;
        }

        void a(HyperEdgeEnd hyperEdgeEnd) {
            boolean bl = this.isAbsolutePositioning();
            this.setAbsolutePositioning(true);
            hyperEdgeEnd.setAbsolutePositioning(true);
            hyperEdgeEnd.setPosition(this.getPosition(null, false), null);
            hyperEdgeEnd.setAbsolutePositioning(bl);
            this.setAbsolutePositioning(bl);
        }

        void a(boolean bl) {
            this.b = bl;
        }

        boolean a() {
            return this.b;
        }

        Segment b() {
            return this.a;
        }

        void a(Segment segment) {
            this.a = segment;
        }

        public void positionChanged() {
            if (this.a != null && this.a.f() != null) {
                this.a.f().g();
            }
        }
    }

    final class VariableGradientTwoEndSegmentInfo
    extends VariableGradientSegmentBaseInfo {
        private HyperEdgeEnd a;
        private HyperEdgeEnd b;
        private boolean c;

        VariableGradientTwoEndSegmentInfo(Segment segment, HyperEdgeEnd hyperEdgeEnd, HyperEdgeEnd hyperEdgeEnd2) {
            this.c = true;
            this.h();
            this.a = hyperEdgeEnd;
            this.b = hyperEdgeEnd2;
            if (hyperEdgeEnd != null) {
                hyperEdgeEnd.a(segment);
                hyperEdgeEnd.getHyperEdge().clearBoundingBoxCache();
            }
            if (hyperEdgeEnd2 != null) {
                hyperEdgeEnd2.a(segment);
                hyperEdgeEnd2.getHyperEdge().clearBoundingBoxCache();
            }
        }

        VariableGradientTwoEndSegmentInfo(Segment segment) {
            this.c = true;
            if (!segment.isVariable()) {
                int n = this.j();
                for (int i = 0; i < n; ++i) {
                    Segment segment2 = this.a(i);
                    if (segment2.isVariable()) continue;
                    throw new RuntimeException("Fixed inner segment at variable segment");
                }
            }
            if (segment.f().a() != null) {
                this.a = (HyperEdgeEnd)segment.f().a();
            }
            if (segment.f().b() != null) {
                this.b = (HyperEdgeEnd)segment.f().b();
            }
            this.f(segment);
        }

        SegmentInfo a(Segment segment, HyperEdgeEnd[] hyperEdgeEndArray) {
            return new VariableGradientTwoEndSegmentInfo(segment, hyperEdgeEndArray[0], hyperEdgeEndArray[1]);
        }

        boolean a(Segment segment) {
            return false;
        }

        IlvHyperEdgeEnd a() {
            return this.a;
        }

        IlvHyperEdgeEnd b() {
            return this.b;
        }

        IlvPoint a(Segment segment, IlvTransformer ilvTransformer) {
            IlvPoint ilvPoint = this.a.getPosition(ilvTransformer, this.c);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.inverse(ilvPoint);
            }
            return ilvPoint;
        }

        IlvPoint b(Segment segment, IlvTransformer ilvTransformer) {
            IlvPoint ilvPoint = this.b.getPosition(ilvTransformer, this.c);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.inverse(ilvPoint);
            }
            return ilvPoint;
        }

        void a(Segment segment, Segment segment2, float f, float f2, IlvTransformer ilvTransformer) {
        }

        IlvPoint a(Segment segment, Segment segment2, IlvTransformer ilvTransformer) {
            if (!segment2.isVariable()) {
                throw new RuntimeException("Segment must be variable");
            }
            if (!segment2.f().a(segment)) {
                throw new RuntimeException("Segments don't terminate each other");
            }
            return segment2.f().a(segment2, segment, ilvTransformer);
        }

        float b(Segment segment, Segment segment2, IlvTransformer ilvTransformer) {
            throw new RuntimeException("getCanonicalIntersection of two variable gradient segments");
        }

        boolean c() {
            return true;
        }

        void a(SegmentShape segmentShape, HashMap hashMap) {
        }

        boolean d() {
            return this.c;
        }

        void a(boolean bl) {
            this.c = bl;
        }
    }

    final class VariableGradientOneEndSegmentInfo
    extends VariableGradientSegmentBaseInfo {
        Segment a;
        float b;
        private IlvPoint c;
        private HyperEdgeEnd d;
        private boolean e;

        VariableGradientOneEndSegmentInfo(Segment segment, IlvPoint ilvPoint, float f, HyperEdgeEnd hyperEdgeEnd) {
            this.e = true;
            this.h();
            this.c = ilvPoint;
            if (this.c == null) {
                this.c = new IlvPoint();
            }
            this.b = f;
            this.d = hyperEdgeEnd;
            if (hyperEdgeEnd != null) {
                hyperEdgeEnd.a(segment);
                hyperEdgeEnd.getHyperEdge().clearBoundingBoxCache();
            }
            ((VariableGradientSegmentBaseInfo)this).a = false;
        }

        VariableGradientOneEndSegmentInfo(Segment segment) {
            boolean bl;
            Object object;
            this.e = true;
            IlvPoint[] ilvPointArray = segment.a((IlvTransformer)null, (IlvPoint[])null);
            this.c = ilvPointArray[0];
            if (segment.isVariable()) {
                Object object2;
                object = segment.f();
                if (object instanceof VariableGradientSegmentInfo) {
                    object2 = (VariableGradientSegmentInfo)object;
                    this.a = ((VariableGradientSegmentInfo)object2).a;
                    this.b = ((VariableGradientSegmentInfo)object2).c;
                } else if (object instanceof VariableGradientOneEndSegmentInfo) {
                    object2 = (VariableGradientOneEndSegmentInfo)object;
                    this.a = ((VariableGradientOneEndSegmentInfo)object2).a;
                    this.b = ((VariableGradientOneEndSegmentInfo)object2).b;
                }
                object2 = null;
                float f = Float.MAX_VALUE;
                int n = this.j();
                for (int i = 0; i < n; ++i) {
                    VariableGradientSegmentBaseInfo variableGradientSegmentBaseInfo;
                    float f2;
                    Segment segment2 = this.a(i);
                    if (segment2 == this.a || !segment2.isVariable() || !((f2 = (variableGradientSegmentBaseInfo = (VariableGradientSegmentBaseInfo)segment2.f()).b(segment)) < f)) continue;
                    f = f2;
                    object2 = segment2;
                }
                if (this.a == null) {
                    this.a = object2;
                }
            } else {
                Segment segment3;
                int n;
                object = null;
                float f = -3.4028235E38f;
                int n2 = this.j();
                for (n = 0; n < n2; ++n) {
                    segment3 = this.a(n);
                    float f3 = segment.f().b(segment, segment3, null);
                    if (!(f3 > f) || object != null && !((Segment)object).isVariable() && ((Segment)object).isVariable() != segment3.isVariable()) continue;
                    f = f3;
                    object = segment3;
                }
                this.a = object;
                this.b = object != null && ((Segment)object).b() ? this.c.x : this.c.y;
                for (n = 0; n < n2; ++n) {
                    segment3 = this.a(n);
                    if (segment3 == this.a || segment3.isVariable()) continue;
                    throw new RuntimeException("Fixed inner segment at variable segment");
                }
            }
            boolean bl2 = segment.f().a() != null;
            boolean bl3 = bl = !bl2 && segment.f().b() != null;
            if (segment.f().a() != null) {
                if (bl2) {
                    this.d = (HyperEdgeEnd)segment.f().a();
                } else {
                    ((HyperEdgeEnd)segment.f().a()).a((Segment)null);
                }
            }
            if (segment.f().b() != null) {
                if (bl) {
                    this.d = (HyperEdgeEnd)segment.f().b();
                } else {
                    ((HyperEdgeEnd)segment.f().b()).a((Segment)null);
                }
            }
            this.f(segment);
        }

        SegmentInfo a(Segment segment, HyperEdgeEnd[] hyperEdgeEndArray) {
            return new VariableGradientOneEndSegmentInfo(segment, new IlvPoint(this.c), this.b, hyperEdgeEndArray[0]);
        }

        Segment[] i() {
            int n = 0;
            if (this.a != null) {
                ++n;
            }
            Segment[] segmentArray = new Segment[n];
            n = 0;
            if (this.a != null) {
                segmentArray[n++] = this.a;
            }
            return segmentArray;
        }

        boolean a(Segment segment) {
            return segment == this.a;
        }

        IlvPoint g(Segment segment) {
            if (segment == this.a) {
                return this.c;
            }
            return new IlvPoint();
        }

        boolean f() {
            return this.a != null;
        }

        float b(Segment segment) {
            if (segment == this.a) {
                return this.b;
            }
            return 0.0f;
        }

        IlvHyperEdgeEnd a() {
            return this.d;
        }

        IlvPoint a(Segment segment, IlvTransformer ilvTransformer) {
            this.f(segment, ilvTransformer);
            return this.c;
        }

        private void f(Segment segment, IlvTransformer ilvTransformer) {
            if (this.a != null) {
                if (this.a.isVariable()) {
                    if (!this.a.f().a(segment)) {
                        IlvPoint[] ilvPointArray = this.a.a(ilvTransformer, null);
                        float f = ilvPointArray[1].x - ilvPointArray[0].x;
                        float f2 = ilvPointArray[1].y - ilvPointArray[0].y;
                        this.c.move(ilvPointArray[0].x + this.b * f, ilvPointArray[0].y + this.b * f2);
                    }
                } else {
                    float f = this.b;
                    double d = this.a.a();
                    float f3 = this.a.a(ilvTransformer);
                    if (this.a.b()) {
                        this.c.move(f, (float)((double)f * d + (double)f3));
                    } else {
                        this.c.move((float)((double)f * d + (double)f3), f);
                    }
                }
            }
        }

        IlvPoint b(Segment segment, IlvTransformer ilvTransformer) {
            IlvPoint ilvPoint = this.d.getPosition(ilvTransformer, this.e);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.inverse(ilvPoint);
            }
            return ilvPoint;
        }

        void a(Segment segment, IlvPoint ilvPoint, IlvPoint ilvPoint2) {
            if (this.a != null && this.a.f().a(segment) || !this.a.isVariable()) {
                this.a(segment, this.a, ilvPoint.x, ilvPoint.y, null);
            }
        }

        void a(Segment segment, Segment segment2, float f, float f2, IlvTransformer ilvTransformer) {
            if (segment2 == this.a) {
                if (segment2 == null) {
                    this.c.move(f, f2);
                } else if (segment2.isVariable()) {
                    if (segment2.f().a(segment)) {
                        this.c.move(f, f2);
                    } else {
                        IlvPoint[] ilvPointArray = segment2.a(ilvTransformer, null);
                        this.b = IlvSegmentedHyperEdge.a(ilvPointArray, f, f2);
                    }
                } else {
                    this.b = segment2.b() ? f : f2;
                }
            }
            this.g();
        }

        IlvPoint a(Segment segment, Segment segment2, IlvTransformer ilvTransformer) {
            if (segment2 == this.a) {
                return new IlvPoint(this.a(segment, ilvTransformer));
            }
            if (!segment2.isVariable()) {
                throw new RuntimeException("Segment must be variable");
            }
            if (!segment2.f().a(segment)) {
                throw new RuntimeException("Segments don't terminate each other");
            }
            return segment2.f().a(segment2, segment, ilvTransformer);
        }

        float b(Segment segment, Segment segment2, IlvTransformer ilvTransformer) {
            if (segment2 == this.a) {
                if (segment2.b()) {
                    return this.a((Segment)segment, (IlvTransformer)ilvTransformer).x;
                }
                return this.a((Segment)segment, (IlvTransformer)ilvTransformer).y;
            }
            throw new RuntimeException("getCanonicalIntersection of two variable gradient segments");
        }

        void a(Segment segment, Segment segment2, boolean bl) {
            super.a(segment, segment2, bl);
            if (!segment2.isVariable() && this.a != null) {
                throw new RuntimeException("Cannot connect a fixed angle segment to a fully terminated variable angle segment");
            }
            if (this.a == null) {
                this.a = segment2;
                if (bl && this.a.f().a(segment)) {
                    this.c = this.a.f().g(segment);
                }
                if (bl && !segment2.isVariable()) {
                    this.b = segment2.b() ? this.c.x : this.c.y;
                }
                this.g();
                this.n();
            }
        }

        void i(Segment segment) {
            super.i(segment);
            if (this.a == segment) {
                this.c = new IlvPoint(this.c);
                this.a = null;
                this.g();
            }
        }

        boolean c() {
            return true;
        }

        void a(SegmentShape segmentShape, HashMap hashMap) {
            segmentShape.e = this.b;
            if (this.a != null) {
                Integer n = (Integer)hashMap.get(this.a);
                segmentShape.i = n;
                if (this.a.isVariable() && this.a.f().a(segmentShape.n)) {
                    segmentShape.k = this.c;
                }
            } else {
                segmentShape.k = this.c;
            }
        }

        void a(SegmentShape segmentShape, ArrayList arrayList) {
            super.a(segmentShape, arrayList);
            if (segmentShape.i >= 0) {
                this.a = (Segment)arrayList.get(segmentShape.i);
                if (this.a.f().a(segmentShape.n)) {
                    this.c = this.a.f().g(segmentShape.n);
                }
            } else {
                this.a = null;
            }
        }

        void a(Segment segment, SegmentInfo segmentInfo, HashMap hashMap) {
            VariableGradientSegmentInfo variableGradientSegmentInfo = (VariableGradientSegmentInfo)segmentInfo;
            if (variableGradientSegmentInfo.a != null) {
                this.a = (Segment)hashMap.get(variableGradientSegmentInfo.a);
                if (this.a.f().a(segment)) {
                    this.c = this.a.f().g(segment);
                }
            } else {
                this.a = null;
            }
            if (this.a != null && !this.h(this.a)) {
                throw new RuntimeException("Error during copy");
            }
        }

        boolean d() {
            return this.e;
        }

        void a(boolean bl) {
            this.e = bl;
        }
    }

    final class VariableGradientSegmentInfo
    extends VariableGradientSegmentBaseInfo {
        Segment a;
        Segment b;
        float c;
        float d;
        private IlvPoint e;
        private IlvPoint f;
        private boolean g;

        VariableGradientSegmentInfo(IlvPoint ilvPoint, IlvPoint ilvPoint2, float f, float f2) {
            this.e = ilvPoint;
            this.f = ilvPoint2;
            if (this.e == null) {
                this.e = new IlvPoint();
            }
            if (this.f == null) {
                this.f = new IlvPoint();
            }
            this.c = f;
            this.d = f2;
            this.h();
            ((VariableGradientSegmentBaseInfo)this).a = false;
        }

        VariableGradientSegmentInfo(Segment segment) {
            IlvPoint[] ilvPointArray = segment.a((IlvTransformer)null, (IlvPoint[])null);
            this.e = ilvPointArray[0];
            this.f = ilvPointArray[1];
            if (segment.isVariable()) {
                Object object;
                SegmentInfo segmentInfo = segment.f();
                if (segmentInfo instanceof VariableGradientSegmentInfo) {
                    object = (VariableGradientSegmentInfo)segmentInfo;
                    this.a = ((VariableGradientSegmentInfo)object).a;
                    this.b = ((VariableGradientSegmentInfo)object).b;
                    this.c = ((VariableGradientSegmentInfo)object).c;
                    this.d = ((VariableGradientSegmentInfo)object).d;
                } else if (segmentInfo instanceof VariableGradientOneEndSegmentInfo) {
                    object = (VariableGradientOneEndSegmentInfo)segmentInfo;
                    this.a = ((VariableGradientOneEndSegmentInfo)object).a;
                    this.c = ((VariableGradientOneEndSegmentInfo)object).b;
                }
                object = null;
                Segment segment2 = null;
                float f = Float.MAX_VALUE;
                float f2 = -3.4028235E38f;
                int n = this.j();
                for (int i = 0; i < n; ++i) {
                    Segment segment3 = this.a(i);
                    if (segment3 == this.a || segment3 == this.b || !segment3.isVariable()) continue;
                    VariableGradientSegmentBaseInfo variableGradientSegmentBaseInfo = (VariableGradientSegmentBaseInfo)segment3.f();
                    float f3 = variableGradientSegmentBaseInfo.b(segment);
                    if (f3 < f) {
                        f = f3;
                        object = segment3;
                    }
                    if (!(f3 > f2)) continue;
                    f2 = f3;
                    segment2 = segment3;
                }
                if (this.a == null) {
                    this.a = object;
                }
                if (this.b == null && object != segment2) {
                    this.b = segment2;
                }
            } else {
                Segment segment4;
                int n;
                Segment segment5 = null;
                Segment segment6 = null;
                float f = Float.MAX_VALUE;
                float f4 = -3.4028235E38f;
                int n2 = this.j();
                for (n = 0; n < n2; ++n) {
                    segment4 = this.a(n);
                    float f5 = segment.f().b(segment, segment4, null);
                    if (f5 < f && (segment5 == null || segment5.isVariable() || segment5.isVariable() == segment4.isVariable())) {
                        f = f5;
                        segment5 = segment4;
                    }
                    if (!(f5 > f4) || segment6 != null && !segment6.isVariable() && segment6.isVariable() != segment4.isVariable()) continue;
                    f4 = f5;
                    segment6 = segment4;
                }
                this.a = segment5;
                this.c = segment5 != null && segment5.b() ? this.e.x : this.e.y;
                if (segment5 != segment6) {
                    this.b = segment6;
                    this.d = segment6 != null && segment6.b() ? this.f.x : this.f.y;
                }
                for (n = 0; n < n2; ++n) {
                    segment4 = this.a(n);
                    if (segment4 == this.a || segment4 == this.b || segment4.isVariable()) continue;
                    throw new RuntimeException("Fixed inner segment at variable segment");
                }
            }
            this.f(segment);
            if (segment.f().a() != null) {
                ((HyperEdgeEnd)segment.f().a()).a((Segment)null);
            }
            if (segment.f().b() != null) {
                ((HyperEdgeEnd)segment.f().b()).a((Segment)null);
            }
        }

        SegmentInfo a(Segment segment, HyperEdgeEnd[] hyperEdgeEndArray) {
            return new VariableGradientSegmentInfo(new IlvPoint(this.e), new IlvPoint(this.f), this.c, this.d);
        }

        Segment[] i() {
            int n = 0;
            if (this.a != null) {
                ++n;
            }
            if (this.b != null) {
                ++n;
            }
            Segment[] segmentArray = new Segment[n];
            n = 0;
            if (this.a != null) {
                segmentArray[n++] = this.a;
            }
            if (this.b != null) {
                segmentArray[n++] = this.b;
            }
            return segmentArray;
        }

        boolean a(Segment segment) {
            return segment == this.a || segment == this.b;
        }

        IlvPoint g(Segment segment) {
            if (segment == this.a) {
                return this.e;
            }
            if (segment == this.b) {
                return this.f;
            }
            return new IlvPoint();
        }

        boolean f() {
            if (this.a == null) {
                return false;
            }
            return this.b != null;
        }

        float b(Segment segment) {
            if (segment == this.a) {
                return this.c;
            }
            if (segment == this.b) {
                return this.d;
            }
            return 0.0f;
        }

        IlvPoint a(Segment segment, IlvTransformer ilvTransformer) {
            if (this.c()) {
                this.b(segment, ilvTransformer, null);
            } else if (!((VariableGradientSegmentBaseInfo)this).a) {
                this.e(segment);
            }
            return this.e;
        }

        private IlvPoint[] b(Segment segment, IlvTransformer ilvTransformer, IlvPoint[] ilvPointArray) {
            if (this.a != null) {
                if (this.a.isVariable()) {
                    if (!this.a.f().a(segment)) {
                        ilvPointArray = this.a.a(ilvTransformer, ilvPointArray);
                        float f = ilvPointArray[1].x - ilvPointArray[0].x;
                        float f2 = ilvPointArray[1].y - ilvPointArray[0].y;
                        this.e.move(ilvPointArray[0].x + this.c * f, ilvPointArray[0].y + this.c * f2);
                    }
                } else {
                    float f = this.c;
                    double d = this.a.a();
                    float f3 = this.a.a(ilvTransformer);
                    if (this.a.b()) {
                        this.e.move(f, (float)((double)f * d + (double)f3));
                    } else {
                        this.e.move((float)((double)f * d + (double)f3), f);
                    }
                }
            }
            return ilvPointArray;
        }

        IlvPoint b(Segment segment, IlvTransformer ilvTransformer) {
            if (this.c()) {
                this.c(segment, ilvTransformer, null);
            } else if (!((VariableGradientSegmentBaseInfo)this).a) {
                this.e(segment);
            }
            return this.f;
        }

        private IlvPoint[] c(Segment segment, IlvTransformer ilvTransformer, IlvPoint[] ilvPointArray) {
            if (this.b != null) {
                if (this.b.isVariable()) {
                    if (!this.b.f().a(segment)) {
                        ilvPointArray = this.b.a(ilvTransformer, ilvPointArray);
                        float f = ilvPointArray[1].x - ilvPointArray[0].x;
                        float f2 = ilvPointArray[1].y - ilvPointArray[0].y;
                        this.f.move(ilvPointArray[0].x + this.d * f, ilvPointArray[0].y + this.d * f2);
                    }
                } else {
                    float f = this.d;
                    double d = this.b.a();
                    float f3 = this.b.a(ilvTransformer);
                    if (this.b.b()) {
                        this.f.move(f, (float)((double)f * d + (double)f3));
                    } else {
                        this.f.move((float)((double)f * d + (double)f3), f);
                    }
                }
            }
            return ilvPointArray;
        }

        void a(Segment segment, IlvPoint ilvPoint, IlvPoint ilvPoint2) {
            if (this.a != null && this.a.f().a(segment) || !this.a.isVariable()) {
                this.a(segment, this.a, ilvPoint.x, ilvPoint.y, null);
            }
            if (this.b != null && this.b.f().a(segment) || !this.b.isVariable()) {
                this.a(segment, this.b, ilvPoint2.x, ilvPoint2.y, null);
            }
        }

        void a(Segment segment, Segment segment2, float f, float f2, IlvTransformer ilvTransformer) {
            if (segment2 == this.a) {
                if (segment2 == null) {
                    this.e.move(f, f2);
                } else if (segment2.isVariable()) {
                    if (segment2.f().a(segment)) {
                        this.e.move(f, f2);
                    } else {
                        IlvPoint[] ilvPointArray = segment2.a(ilvTransformer, null);
                        this.c = IlvSegmentedHyperEdge.a(ilvPointArray, f, f2);
                    }
                } else {
                    this.c = segment2.b() ? f : f2;
                }
            } else if (segment2 == this.b) {
                if (segment2 == null) {
                    this.f.move(f, f2);
                } else if (segment2.isVariable()) {
                    if (segment2.f().a(segment)) {
                        this.f.move(f, f2);
                    } else {
                        IlvPoint[] ilvPointArray = segment2.a(ilvTransformer, null);
                        this.d = IlvSegmentedHyperEdge.a(ilvPointArray, f, f2);
                    }
                } else {
                    this.d = segment2.b() ? f : f2;
                }
            }
            this.g();
        }

        IlvPoint a(Segment segment, Segment segment2, IlvTransformer ilvTransformer) {
            if (segment2 == this.a) {
                return new IlvPoint(this.a(segment, ilvTransformer));
            }
            if (segment2 == this.b) {
                return new IlvPoint(this.b(segment, ilvTransformer));
            }
            if (!segment2.isVariable()) {
                throw new RuntimeException("Segment must be variable");
            }
            if (!segment2.f().a(segment)) {
                throw new RuntimeException("Segments don't terminate each other");
            }
            return segment2.f().a(segment2, segment, ilvTransformer);
        }

        float b(Segment segment, Segment segment2, IlvTransformer ilvTransformer) {
            if (segment2 == this.a) {
                if (segment2.b()) {
                    return this.a((Segment)segment, (IlvTransformer)ilvTransformer).x;
                }
                return this.a((Segment)segment, (IlvTransformer)ilvTransformer).y;
            }
            if (segment2 == this.b) {
                if (segment2.b()) {
                    return this.b((Segment)segment, (IlvTransformer)ilvTransformer).x;
                }
                return this.b((Segment)segment, (IlvTransformer)ilvTransformer).y;
            }
            throw new RuntimeException("getCanonicalIntersection of two variable gradient segments");
        }

        void a(Segment segment, Segment segment2, boolean bl) {
            super.a(segment, segment2, bl);
            if (!segment2.isVariable() && this.a != null && this.b != null) {
                throw new RuntimeException("Cannot connect a fixed angle segment to a fully terminated variable angle segment");
            }
            if (this.a == null) {
                this.a = segment2;
                if (bl && this.a.f().a(segment)) {
                    this.e = this.a.f().g(segment);
                }
                if (bl && !segment2.isVariable()) {
                    this.c = segment2.b() ? this.e.x : this.e.y;
                }
                this.g();
                this.n();
            } else if (this.b == null) {
                this.b = segment2;
                if (bl && this.b.f().a(segment)) {
                    this.f = this.b.f().g(segment);
                }
                if (bl && !segment2.isVariable()) {
                    this.d = segment2.b() ? this.f.x : this.f.y;
                }
                this.g();
                this.n();
            }
        }

        void i(Segment segment) {
            super.i(segment);
            if (this.a == segment) {
                this.e = new IlvPoint(this.e);
                this.a = null;
                this.g();
                this.n();
            } else if (this.b == segment) {
                this.f = new IlvPoint(this.f);
                this.b = null;
                this.g();
                this.n();
            }
        }

        void e(Segment segment) {
            IlvPoint[] ilvPointArray = null;
            ilvPointArray = this.b(segment, null, ilvPointArray);
            ilvPointArray = this.c(segment, null, ilvPointArray);
            super.e(segment);
        }

        boolean c() {
            return this.g;
        }

        void n() {
            boolean bl = this.g;
            this.g = false;
            if (this.a != null && this.a.f().c()) {
                this.g = true;
            }
            if (this.b != null && this.b.f().c()) {
                this.g = true;
            }
            if (bl != this.g) {
                int n = this.j();
                for (int i = 0; i < n; ++i) {
                    this.a(i).f().n();
                }
            }
        }

        void a(SegmentShape segmentShape, HashMap hashMap) {
            Integer n;
            segmentShape.e = this.c;
            segmentShape.f = this.d;
            if (this.a != null) {
                n = (Integer)hashMap.get(this.a);
                segmentShape.i = n;
                if (this.a.isVariable() && this.a.f().a(segmentShape.n)) {
                    segmentShape.k = this.e;
                }
            } else {
                segmentShape.k = this.e;
            }
            if (this.b != null) {
                n = (Integer)hashMap.get(this.b);
                segmentShape.j = n;
                if (this.b.isVariable() && this.b.f().a(segmentShape.n)) {
                    segmentShape.l = this.f;
                }
            } else {
                segmentShape.l = this.f;
            }
        }

        void a(SegmentShape segmentShape, ArrayList arrayList) {
            super.a(segmentShape, arrayList);
            if (segmentShape.i >= 0) {
                this.a = (Segment)arrayList.get(segmentShape.i);
                if (this.a.f().a(segmentShape.n)) {
                    this.e = this.a.f().g(segmentShape.n);
                }
            } else {
                this.a = null;
            }
            if (segmentShape.j >= 0) {
                this.b = (Segment)arrayList.get(segmentShape.j);
                if (this.b.f().a(segmentShape.n)) {
                    this.f = this.b.f().g(segmentShape.n);
                }
            } else {
                this.b = null;
            }
        }

        void a(Segment segment, SegmentInfo segmentInfo, HashMap hashMap) {
            VariableGradientSegmentInfo variableGradientSegmentInfo = (VariableGradientSegmentInfo)segmentInfo;
            if (variableGradientSegmentInfo.a != null) {
                this.a = (Segment)hashMap.get(variableGradientSegmentInfo.a);
                if (this.a.f().a(segment)) {
                    this.e = this.a.f().g(segment);
                }
            } else {
                this.a = null;
            }
            if (variableGradientSegmentInfo.b != null) {
                this.b = (Segment)hashMap.get(variableGradientSegmentInfo.b);
                if (this.b.f().a(segment)) {
                    this.f = this.b.f().g(segment);
                }
            } else {
                this.b = null;
            }
            if (this.a != null && !this.h(this.a)) {
                throw new RuntimeException("Error during copy");
            }
            if (this.b != null && !this.h(this.b)) {
                throw new RuntimeException("Error during copy");
            }
        }
    }

    abstract class VariableGradientSegmentBaseInfo
    extends SegmentInfo {
        boolean a;
        boolean b;
        private boolean c;
        private double d;

        VariableGradientSegmentBaseInfo() {
        }

        float b(Segment segment) {
            return 0.0f;
        }

        boolean e() {
            return true;
        }

        boolean f() {
            return true;
        }

        abstract IlvPoint a(Segment var1, IlvTransformer var2);

        abstract IlvPoint b(Segment var1, IlvTransformer var2);

        void a(Segment segment, IlvTransformer ilvTransformer, IlvPoint[] ilvPointArray) {
            IlvPoint ilvPoint = this.a(segment, ilvTransformer);
            ilvPointArray[0].move(ilvPoint.x, ilvPoint.y);
            ilvPoint = this.b(segment, ilvTransformer);
            ilvPointArray[1].move(ilvPoint.x, ilvPoint.y);
        }

        boolean c(Segment segment) {
            if (!this.a) {
                this.e(segment);
            }
            return this.c;
        }

        void b(boolean bl) {
        }

        double d(Segment segment) {
            if (!this.a) {
                this.e(segment);
            }
            return this.d;
        }

        void a(double d) {
        }

        float c(Segment segment, IlvTransformer ilvTransformer) {
            IlvPoint ilvPoint = this.a(segment, ilvTransformer);
            IlvPoint ilvPoint2 = this.a(segment, (IlvTransformer)null);
            IlvPoint ilvPoint3 = this.b(segment, null);
            double d = ilvPoint2.x - ilvPoint3.x;
            double d2 = ilvPoint2.y - ilvPoint3.y;
            if (Math.abs(d2) < Math.abs(d)) {
                if (d == 0.0) {
                    return ilvPoint.y;
                }
                return (float)((double)ilvPoint.y - (double)ilvPoint.x * d2 / d);
            }
            if (d2 == 0.0) {
                return ilvPoint.x;
            }
            return (float)((double)ilvPoint.x - (double)ilvPoint.y * d / d2);
        }

        void a(float f) {
        }

        float d(Segment segment, IlvTransformer ilvTransformer) {
            IlvPoint ilvPoint = this.a(segment, ilvTransformer);
            IlvPoint ilvPoint2 = this.b(segment, ilvTransformer);
            if (this.c(segment)) {
                return Math.min(ilvPoint.x, ilvPoint2.x);
            }
            return Math.min(ilvPoint.y, ilvPoint2.y);
        }

        float e(Segment segment, IlvTransformer ilvTransformer) {
            IlvPoint ilvPoint = this.a(segment, ilvTransformer);
            IlvPoint ilvPoint2 = this.b(segment, ilvTransformer);
            if (this.c(segment)) {
                return Math.max(ilvPoint.x, ilvPoint2.x);
            }
            return Math.max(ilvPoint.y, ilvPoint2.y);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void g() {
            if (this.b) {
                return;
            }
            this.b = true;
            try {
                this.a = false;
                int n = this.j();
                for (int i = 0; i < n; ++i) {
                    this.a(i).f().g();
                }
            }
            finally {
                this.b = false;
            }
        }

        void e(Segment segment) {
            this.a = true;
            IlvPoint ilvPoint = this.a(segment, (IlvTransformer)null);
            IlvPoint ilvPoint2 = this.b(segment, null);
            double d = ilvPoint.x - ilvPoint2.x;
            double d2 = ilvPoint.y - ilvPoint2.y;
            boolean bl = this.c = Math.abs(d2) < Math.abs(d);
            this.d = d == 0.0 && d2 == 0.0 ? 0.0 : (Math.abs(d2) < Math.abs(d) ? d2 / d : d / d2);
        }
    }

    class FixedGradientEndSegmentInfo
    extends FixedGradientSegmentBaseInfo {
        private HyperEdgeEnd a;
        private boolean b;

        FixedGradientEndSegmentInfo(Segment segment, double d, boolean bl, HyperEdgeEnd hyperEdgeEnd) {
            this.b = true;
            this.a(bl, d);
            this.a(segment, hyperEdgeEnd);
        }

        FixedGradientEndSegmentInfo(Segment segment, double d, HyperEdgeEnd hyperEdgeEnd) {
            this.b = true;
            double d2 = d / 180.0 * Math.PI;
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            this.a(d3, d4);
            this.a(segment, hyperEdgeEnd);
        }

        private void a(Segment segment, HyperEdgeEnd hyperEdgeEnd) {
            this.a = hyperEdgeEnd;
            if (hyperEdgeEnd != null) {
                hyperEdgeEnd.a(segment);
                hyperEdgeEnd.getHyperEdge().clearBoundingBoxCache();
            }
        }

        FixedGradientEndSegmentInfo(Segment segment) {
            boolean bl;
            this.b = true;
            boolean bl2 = segment.f().a() != null;
            boolean bl3 = bl = !bl2 && segment.f().b() != null;
            if (segment.f().a() != null) {
                if (bl2) {
                    this.a = (HyperEdgeEnd)segment.f().a();
                } else {
                    ((HyperEdgeEnd)segment.f().a()).a((Segment)null);
                }
            }
            if (segment.f().b() != null) {
                if (bl) {
                    this.a = (HyperEdgeEnd)segment.f().b();
                } else {
                    ((HyperEdgeEnd)segment.f().b()).a((Segment)null);
                }
            }
            this.f(segment);
        }

        SegmentInfo a(Segment segment, HyperEdgeEnd[] hyperEdgeEndArray) {
            return new FixedGradientEndSegmentInfo(segment, this.p(), this.o(), hyperEdgeEndArray[0]);
        }

        IlvHyperEdgeEnd a() {
            return this.a;
        }

        float a(IlvTransformer ilvTransformer) {
            IlvPoint ilvPoint = this.a.getPosition(ilvTransformer, this.b);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.inverse(ilvPoint);
            }
            return this.o() ? (float)((double)ilvPoint.y - (double)ilvPoint.x * this.p()) : (float)((double)ilvPoint.x - (double)ilvPoint.y * this.p());
        }

        float c(Segment segment, IlvTransformer ilvTransformer) {
            return this.a(ilvTransformer);
        }

        void a(float f) {
        }

        boolean c() {
            return true;
        }

        void a(Segment segment, Segment segment2, float f, float f2, IlvTransformer ilvTransformer) {
        }

        float d(Segment segment, IlvTransformer ilvTransformer) {
            float f = super.d(segment, ilvTransformer);
            IlvPoint ilvPoint = this.a.getPosition(ilvTransformer, this.b);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.inverse(ilvPoint);
            }
            float f2 = this.o() ? ilvPoint.x : ilvPoint.y;
            return Math.min(f, f2);
        }

        float e(Segment segment, IlvTransformer ilvTransformer) {
            float f = super.e(segment, ilvTransformer);
            IlvPoint ilvPoint = this.a.getPosition(ilvTransformer, this.b);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.inverse(ilvPoint);
            }
            float f2 = this.o() ? ilvPoint.x : ilvPoint.y;
            return Math.max(f, f2);
        }

        void a(SegmentShape segmentShape, HashMap hashMap) {
            segmentShape.c = this.p();
            segmentShape.d = this.o();
        }

        boolean d() {
            return this.b;
        }

        void a(boolean bl) {
            this.b = bl;
        }
    }

    class FixedGradientSegmentInfo
    extends FixedGradientSegmentBaseInfo {
        private float a;

        FixedGradientSegmentInfo(double d, boolean bl, float f) {
            this.a(bl, d);
            this.a = f;
        }

        FixedGradientSegmentInfo(double d, float f) {
            double d2 = d / 180.0 * Math.PI;
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            this.a(d3, d4);
            this.a = this.o() ? -((float)((double)f / d3)) : (float)((double)f / d4);
        }

        FixedGradientSegmentInfo(double d, float f, float f2) {
            double d2 = d / 180.0 * Math.PI;
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            this.a(d3, d4);
            this.a = this.o() ? (float)((double)f2 - this.p() * (double)f) : (float)((double)f - this.p() * (double)f2);
        }

        FixedGradientSegmentInfo(Segment segment) {
            this.f(segment);
            if (segment.f().a() != null) {
                ((HyperEdgeEnd)segment.f().a()).a((Segment)null);
            }
            if (segment.f().b() != null) {
                ((HyperEdgeEnd)segment.f().b()).a((Segment)null);
            }
        }

        SegmentInfo a(Segment segment, HyperEdgeEnd[] hyperEdgeEndArray) {
            return new FixedGradientSegmentInfo(this.p(), this.o(), this.a((IlvTransformer)null));
        }

        float c(Segment segment, IlvTransformer ilvTransformer) {
            return this.a;
        }

        float a(IlvTransformer ilvTransformer) {
            return this.a;
        }

        void a(float f) {
            this.a = f;
            super.a(f);
        }

        void a(Segment segment, IlvPoint ilvPoint, IlvPoint ilvPoint2) {
            this.a(segment, null, ilvPoint.x, ilvPoint.y, null);
        }

        void a(Segment segment, Segment segment2, float f, float f2, IlvTransformer ilvTransformer) {
            if (this.o()) {
                this.a((float)((double)f2 - this.p() * (double)f));
            } else {
                this.a((float)((double)f - this.p() * (double)f2));
            }
        }

        boolean c() {
            return false;
        }

        void a(SegmentShape segmentShape, HashMap hashMap) {
            segmentShape.c = this.p();
            segmentShape.d = this.o();
            segmentShape.e = this.a;
        }
    }

    abstract class FixedGradientSegmentBaseInfo
    extends SegmentInfo {
        private Segment[] a;
        private double b;
        private float c;
        private float d;
        boolean e;
        private boolean f;
        private boolean g;

        FixedGradientSegmentBaseInfo() {
        }

        void a(boolean bl, double d) {
            super.h();
            this.e = false;
            this.g = false;
            this.f = bl;
            this.b = d;
        }

        void a(double d, double d2) {
            super.h();
            this.e = false;
            this.g = false;
            if (Math.abs(d2) <= Math.abs(d)) {
                this.f = false;
                this.b = d2 / d;
            } else {
                this.f = true;
                this.b = d / d2;
            }
        }

        void f(Segment segment) {
            super.f(segment);
            this.q();
        }

        boolean e() {
            return false;
        }

        void a(Segment segment, Segment segment2, boolean bl) {
            super.a(segment, segment2, bl);
            if (segment2.a() != 0.0 && !segment2.isVariable()) {
                this.g = true;
            }
            this.g();
        }

        void i(Segment segment) {
            super.i(segment);
            this.q();
            this.g();
        }

        private void q() {
            if (this.p() != 0.0) {
                this.g = this.r();
            }
        }

        private boolean r() {
            int n = this.j();
            for (int i = 0; i < n; ++i) {
                Segment segment = this.a(i);
                if (segment.isVariable() || segment.a() == 0.0) continue;
                return true;
            }
            return false;
        }

        void g() {
            this.e = false;
        }

        private void b(Segment segment) {
            Object object;
            int n;
            int n2 = this.j();
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                object = this.a(n).f();
                if (!((SegmentInfo)object).c() || ((SegmentInfo)object).e()) continue;
                ++n3;
            }
            if (n3 == 0) {
                this.a = null;
            } else if (this.a == null) {
                this.a = new Segment[n3];
            } else if (this.a.length != n3) {
                this.a = new Segment[n3];
            }
            this.c = Float.MAX_VALUE;
            this.d = -3.4028235E38f;
            n3 = 0;
            for (n = 0; n < n2; ++n) {
                object = this.a(n);
                SegmentInfo segmentInfo = ((Segment)object).f();
                if (segmentInfo.c() && !segmentInfo.e()) {
                    this.a[n3++] = object;
                    continue;
                }
                float f = this.b(segment, (Segment)object, null);
                if (f < this.c) {
                    this.c = f;
                }
                if (!(f > this.d)) continue;
                this.d = f;
            }
            this.e = true;
        }

        boolean c(Segment segment) {
            return this.f;
        }

        boolean o() {
            return this.f;
        }

        void b(boolean bl) {
            this.f = bl;
            int n = this.j();
            for (int i = 0; i < n; ++i) {
                this.a(i).f().g();
            }
            this.g();
        }

        double d(Segment segment) {
            return this.b;
        }

        double p() {
            return this.b;
        }

        void a(double d) {
            this.b = d;
            int n = this.j();
            for (int i = 0; i < n; ++i) {
                Segment segment = this.a(i);
                SegmentInfo segmentInfo = segment.f();
                if (segmentInfo instanceof FixedGradientSegmentBaseInfo) {
                    ((FixedGradientSegmentBaseInfo)segmentInfo).q();
                }
                segmentInfo.g();
            }
            this.g();
        }

        abstract float a(IlvTransformer var1);

        void a(float f) {
            if (this.g || this.p() != 0.0) {
                this.g();
            }
            int n = this.j();
            for (int i = 0; i < n; ++i) {
                this.a(i).f().g();
            }
        }

        void a(Segment segment, IlvTransformer ilvTransformer, IlvPoint[] ilvPointArray) {
            if (this.o()) {
                float f = this.d(segment, ilvTransformer);
                float f2 = (float)(this.p() * (double)f + (double)this.a(ilvTransformer));
                ilvPointArray[0].move(f, f2);
                f = this.e(segment, ilvTransformer);
                f2 = (float)(this.p() * (double)f + (double)this.a(ilvTransformer));
                ilvPointArray[1].move(f, f2);
            } else {
                float f = this.d(segment, ilvTransformer);
                float f3 = (float)(this.p() * (double)f + (double)this.a(ilvTransformer));
                ilvPointArray[0].move(f3, f);
                f = this.e(segment, ilvTransformer);
                f3 = (float)(this.p() * (double)f + (double)this.a(ilvTransformer));
                ilvPointArray[1].move(f3, f);
            }
        }

        float d(Segment segment, IlvTransformer ilvTransformer) {
            if (!this.e) {
                this.b(segment);
            }
            float f = this.c;
            if (this.a != null) {
                for (int i = 0; i < this.a.length; ++i) {
                    float f2 = this.b(segment, this.a[i], ilvTransformer);
                    if (!(f2 < f)) continue;
                    f = f2;
                }
            }
            if (f == Float.MAX_VALUE) {
                f = 0.0f;
            }
            return f;
        }

        float e(Segment segment, IlvTransformer ilvTransformer) {
            if (!this.e || this.g) {
                this.b(segment);
            }
            float f = this.d;
            if (this.a != null) {
                for (int i = 0; i < this.a.length; ++i) {
                    float f2 = this.b(segment, this.a[i], ilvTransformer);
                    if (!(f2 > f)) continue;
                    f = f2;
                }
            }
            if (f == -3.4028235E38f) {
                f = 0.0f;
            }
            return f;
        }

        IlvPoint a(Segment segment, Segment segment2, IlvTransformer ilvTransformer) {
            if (segment2.isVariable()) {
                return segment2.f().a(segment2, segment, ilvTransformer);
            }
            return new IlvPoint(IlvSegmentedHyperEdge.e(segment, segment2, ilvTransformer), IlvSegmentedHyperEdge.f(segment, segment2, ilvTransformer));
        }

        float b(Segment segment, Segment segment2, IlvTransformer ilvTransformer) {
            double d;
            if (segment2.isVariable()) {
                return segment2.f().b(segment2, segment, ilvTransformer);
            }
            if (this.o() == segment2.b()) {
                double d2;
                float f = this.a(ilvTransformer);
                float f2 = segment2.a(ilvTransformer);
                double d3 = this.p();
                if (d3 == (d2 = segment2.a())) {
                    return 0.0f;
                }
                return (float)((double)(f2 - f) / (d3 - d2));
            }
            if (segment2.a() == 0.0) {
                return segment2.a(ilvTransformer);
            }
            float f = this.a(ilvTransformer);
            float f3 = segment2.a(ilvTransformer);
            double d4 = this.p();
            if (d4 * (d = segment2.a()) == 1.0) {
                return 0.0f;
            }
            return (float)((d * (double)f + (double)f3) / (1.0 - d4 * d));
        }
    }

    abstract class SegmentInfo {
        private ArrayList a;

        SegmentInfo() {
        }

        void h() {
            this.a = new ArrayList();
        }

        void f(Segment segment) {
            SegmentInfo segmentInfo = segment.f();
            this.a = segmentInfo.a;
            segmentInfo.a = null;
            this.b(segmentInfo.c(segment));
            this.a(segmentInfo.d(segment));
            this.a(segmentInfo.c(segment, null));
            this.g();
            this.n();
        }

        abstract SegmentInfo a(Segment var1, HyperEdgeEnd[] var2);

        abstract boolean e();

        Segment[] i() {
            return e;
        }

        boolean a(Segment segment) {
            return false;
        }

        IlvPoint g(Segment segment) {
            return new IlvPoint();
        }

        boolean f() {
            return false;
        }

        IlvHyperEdgeEnd a() {
            return null;
        }

        IlvHyperEdgeEnd b() {
            return null;
        }

        int j() {
            return this.a == null ? 0 : this.a.size();
        }

        Segment a(int n) {
            return (Segment)this.a.get(n);
        }

        Segment[] k() {
            Segment[] segmentArray = new Segment[this.j()];
            segmentArray = this.a.toArray(segmentArray);
            return segmentArray;
        }

        boolean h(Segment segment) {
            return this.a.contains(segment);
        }

        void a(Segment segment, Segment segment2, boolean bl) {
            this.a.add(segment2);
        }

        void i(Segment segment) {
            this.a.remove(segment);
        }

        boolean l() {
            return this.a != null;
        }

        void m() {
            this.a = null;
        }

        abstract boolean c();

        void n() {
        }

        abstract void g();

        void a(Segment segment, IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        }

        abstract void a(Segment var1, IlvTransformer var2, IlvPoint[] var3);

        abstract void a(Segment var1, Segment var2, float var3, float var4, IlvTransformer var5);

        abstract IlvPoint a(Segment var1, Segment var2, IlvTransformer var3);

        abstract float b(Segment var1, Segment var2, IlvTransformer var3);

        abstract boolean c(Segment var1);

        abstract void b(boolean var1);

        abstract double d(Segment var1);

        abstract void a(double var1);

        abstract float c(Segment var1, IlvTransformer var2);

        abstract void a(float var1);

        abstract float d(Segment var1, IlvTransformer var2);

        abstract float e(Segment var1, IlvTransformer var2);

        abstract void a(SegmentShape var1, HashMap var2);

        void a(SegmentShape segmentShape, ArrayList arrayList) {
            Segment segment = segmentShape.n;
            for (int i = 0; i < segmentShape.a.length; ++i) {
                Segment segment2 = (Segment)arrayList.get(segmentShape.a[i]);
                if (segment.isIncident(segment2)) continue;
                segment.a(segment2, false);
            }
        }

        void a(Segment segment, SegmentInfo segmentInfo, HashMap hashMap) {
        }

        boolean d() {
            return true;
        }

        void a(boolean bl) {
        }
    }

    public final class Segment {
        private Object a;
        private boolean b;
        private SegmentInfo c;

        private Segment() {
        }

        Segment(boolean bl, float f) {
            this.c = new FixedGradientSegmentInfo(0.0, bl, f);
        }

        Segment(boolean bl, HyperEdgeEnd hyperEdgeEnd) {
            this.c = new FixedGradientEndSegmentInfo(this, 0.0, bl, hyperEdgeEnd);
        }

        Segment(double d, float f, float f2) {
            this.c = new FixedGradientSegmentInfo(d, f, f2);
        }

        Segment(double d, HyperEdgeEnd hyperEdgeEnd) {
            this.c = new FixedGradientEndSegmentInfo(this, d, hyperEdgeEnd);
        }

        Segment(IlvPoint ilvPoint, IlvPoint ilvPoint2) {
            this.c = new VariableGradientSegmentInfo(ilvPoint, ilvPoint2, 0.5f, 0.5f);
        }

        Segment(IlvPoint ilvPoint, HyperEdgeEnd hyperEdgeEnd) {
            this.c = new VariableGradientOneEndSegmentInfo(this, ilvPoint, 0.5f, hyperEdgeEnd);
        }

        Segment(HyperEdgeEnd hyperEdgeEnd, HyperEdgeEnd hyperEdgeEnd2) {
            this.c = new VariableGradientTwoEndSegmentInfo(this, hyperEdgeEnd, hyperEdgeEnd2);
        }

        Segment(SegmentShape segmentShape) {
            this.c = segmentShape.b ? (segmentShape.g == null ? new VariableGradientSegmentInfo(segmentShape.k, segmentShape.l, segmentShape.e, segmentShape.f) : (segmentShape.h == null ? new VariableGradientOneEndSegmentInfo(this, segmentShape.k, segmentShape.e, segmentShape.g) : new VariableGradientTwoEndSegmentInfo(this, segmentShape.g, segmentShape.h))) : (segmentShape.g == null ? new FixedGradientSegmentInfo(segmentShape.c, segmentShape.d, segmentShape.e) : new FixedGradientEndSegmentInfo(this, segmentShape.c, segmentShape.d, segmentShape.g));
            this.a = segmentShape.m;
        }

        Segment a(HyperEdgeEnd[] hyperEdgeEndArray) {
            Segment segment = new Segment();
            segment.c = this.c.a(segment, hyperEdgeEndArray);
            return segment;
        }

        public IlvSegmentedHyperEdge getHyperEdge() {
            return IlvSegmentedHyperEdge.this;
        }

        public boolean isVariable() {
            return this.f().e();
        }

        public boolean isFullyTerminated() {
            return this.f().f();
        }

        public Segment[] getTerminatingSegments() {
            return this.f().i();
        }

        public boolean endsAt(Segment segment, IlvTransformer ilvTransformer) {
            if (segment == null) {
                return false;
            }
            if (this.isVariable()) {
                Segment[] segmentArray = this.getTerminatingSegments();
                for (int i = 0; i < segmentArray.length; ++i) {
                    if (segmentArray[i] != segment) continue;
                    return true;
                }
            } else {
                float f;
                IlvPoint ilvPoint;
                int n = this.getIncidentSegmentsCount();
                Segment segment2 = null;
                Segment segment3 = null;
                float f2 = Float.MAX_VALUE;
                float f3 = -3.4028235E38f;
                for (int i = 0; i < n; ++i) {
                    Segment segment4 = this.getIncidentSegment(i);
                    ilvPoint = this.getIntersectionPoint(segment4, ilvTransformer);
                    float f4 = f = this.b() ? ilvPoint.x : ilvPoint.y;
                    if (f < f2) {
                        f2 = f;
                        segment2 = segment4;
                    }
                    if (!(f > f3)) continue;
                    f3 = f;
                    segment3 = segment4;
                }
                IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = this.getEnds();
                for (int i = 0; i < ilvHyperEdgeEndArray.length; ++i) {
                    ilvPoint = ilvHyperEdgeEndArray[i].getPosition(ilvTransformer, true);
                    float f5 = f = this.b() ? ilvPoint.x : ilvPoint.y;
                    if (f < f2) {
                        f2 = f;
                        segment2 = null;
                    }
                    if (!(f > f3)) continue;
                    f3 = f;
                    segment3 = null;
                }
                return segment == segment2 || segment == segment3;
            }
            return false;
        }

        public boolean isSelected() {
            return this.b;
        }

        public void setSelected(boolean bl) {
            this.b = bl;
        }

        public IlvHyperEdgeEnd[] getEnds() {
            int n = 0;
            if (this.f().a() != null) {
                ++n;
            }
            if (this.f().b() != null) {
                ++n;
            }
            if (n == 0) {
                return d;
            }
            IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = new IlvHyperEdgeEnd[n];
            n = 0;
            if (this.f().a() != null) {
                ilvHyperEdgeEndArray[n++] = this.f().a();
            }
            if (this.f().b() != null) {
                ilvHyperEdgeEndArray[n++] = this.f().b();
            }
            return ilvHyperEdgeEndArray;
        }

        public double getAngle() {
            double d;
            if (this.b()) {
                if (this.a() == 0.0) {
                    return 0.0;
                }
                d = 180.0 * Math.atan2(this.a(), 1.0) / Math.PI;
            } else {
                if (this.a() == 0.0) {
                    return 90.0;
                }
                d = 180.0 * Math.atan2(1.0, this.a()) / Math.PI;
            }
            return IlvSegmentedHyperEdge.b(d);
        }

        void a(double d) {
            double d2;
            double d3;
            if ((d = IlvSegmentedHyperEdge.b(d)) == 0.0) {
                d3 = 0.0;
                d2 = 1.0;
            } else if (d == 90.0) {
                d3 = 1.0;
                d2 = 0.0;
            } else {
                double d4 = d / 180.0 * Math.PI;
                d3 = Math.sin(d4);
                d2 = Math.cos(d4);
            }
            if (Math.abs(d2) <= Math.abs(d3)) {
                this.a(false);
                this.b(d2 / d3);
            } else {
                this.a(true);
                this.b(d3 / d2);
            }
        }

        double a() {
            return this.f().d(this);
        }

        void b(double d) {
            this.f().a(d);
        }

        boolean b() {
            return this.f().c(this);
        }

        void a(boolean bl) {
            this.f().b(bl);
        }

        public boolean isColinear(Segment segment) {
            if (this.isVariable()) {
                return false;
            }
            if (segment.isVariable()) {
                return false;
            }
            double d = this.getAngle();
            double d2 = segment.getAngle();
            return IlvSegmentedHyperEdge.b(d, d2);
        }

        public int getIncidentSegmentsCount() {
            return this.f().j();
        }

        public Segment getIncidentSegment(int n) {
            return this.f().a(n);
        }

        public Segment[] getIncidentSegments() {
            return this.f().k();
        }

        public Segment getOtherIncidentSegment(Segment segment) {
            for (int i = 0; i < this.getIncidentSegmentsCount(); ++i) {
                Segment segment2 = this.getIncidentSegment(i);
                if (segment2 == segment) continue;
                return segment2;
            }
            return null;
        }

        public boolean isIncident(Segment segment) {
            if (this.isColinear(segment)) {
                return false;
            }
            if (segment.getIncidentSegmentsCount() < this.getIncidentSegmentsCount()) {
                return segment.f().h(this);
            }
            return this.f().h(segment);
        }

        void a(Segment segment, boolean bl) {
            if (this.isIncident(segment)) {
                return;
            }
            if (segment.getHyperEdge() != this.getHyperEdge()) {
                throw new RuntimeException("Cannot connect two segments that belong to different hyperedges");
            }
            if (this.isColinear(segment)) {
                throw new RuntimeException("Cannot connect two colinear segments");
            }
            this.f().a(this, segment, bl);
            segment.f().a(segment, this, bl);
            this.getHyperEdge().clearBoundingBoxCache();
        }

        void a(Segment segment) {
            this.f().i(segment);
            segment.f().i(this);
            this.getHyperEdge().clearBoundingBoxCache();
        }

        void c() {
            Segment[] segmentArray = this.getIncidentSegments();
            int n = segmentArray.length;
            for (int i = 0; i < n; ++i) {
                segmentArray[i].a(this);
            }
        }

        boolean d() {
            return this.f().l();
        }

        void e() {
            this.f().m();
        }

        void a(Segment segment, float f, float f2, IlvTransformer ilvTransformer) {
            this.f().a(this, segment, f, f2, ilvTransformer);
            this.getHyperEdge().clearBoundingBoxCache();
        }

        void a(float f) {
            this.f().a(f);
            this.getHyperEdge().clearBoundingBoxCache();
        }

        float a(IlvTransformer ilvTransformer) {
            return this.f().c(this, ilvTransformer);
        }

        public IlvPoint[] getPoints(IlvTransformer ilvTransformer, IlvPoint[] ilvPointArray) {
            ilvPointArray = this.a(ilvTransformer, ilvPointArray);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.apply(ilvPointArray[0]);
                ilvTransformer.apply(ilvPointArray[1]);
            }
            return ilvPointArray;
        }

        public IlvPoint getIntersectionPoint(Segment segment, IlvTransformer ilvTransformer) {
            if (!this.isIncident(segment)) {
                return null;
            }
            IlvPoint ilvPoint = this.f().a(this, segment, ilvTransformer);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.apply(ilvPoint);
            }
            return ilvPoint;
        }

        IlvPoint[] a(IlvTransformer ilvTransformer, IlvPoint[] ilvPointArray) {
            if (ilvPointArray == null || ilvPointArray.length < 2) {
                ilvPointArray = new IlvPoint[2];
            }
            if (ilvPointArray[0] == null) {
                ilvPointArray[0] = new IlvPoint();
            }
            if (ilvPointArray[1] == null) {
                ilvPointArray[1] = new IlvPoint();
            }
            this.f().a(this, ilvTransformer, ilvPointArray);
            return ilvPointArray;
        }

        void b(IlvTransformer ilvTransformer, IlvPoint[] ilvPointArray) {
            this.f().a(this, ilvTransformer, ilvPointArray);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.apply(ilvPointArray[0]);
                ilvTransformer.apply(ilvPointArray[1]);
            }
        }

        float b(IlvTransformer ilvTransformer) {
            return this.f().d(this, ilvTransformer);
        }

        float c(IlvTransformer ilvTransformer) {
            return this.f().e(this, ilvTransformer);
        }

        void a(IlvPoint ilvPoint, IlvPoint ilvPoint2) {
            this.f().a(this, ilvPoint, ilvPoint2);
        }

        public void setExtension(Object object) {
            this.a = object;
        }

        public Object getExtension() {
            return this.a;
        }

        SegmentInfo f() {
            return this.c;
        }
    }

    static class UndoChangeShape
    extends AbstractUndoableEdit {
        private IlvSegmentedHyperEdge a;
        private IlvPersistentObject[] b;
        private IlvPersistentObject[] c;

        UndoChangeShape() {
        }

        void a(IlvSegmentedHyperEdge ilvSegmentedHyperEdge) {
            this.a = ilvSegmentedHyperEdge;
            this.b = this.a.c();
        }

        void b(IlvSegmentedHyperEdge ilvSegmentedHyperEdge) {
            if (ilvSegmentedHyperEdge != this.a) {
                throw new IllegalArgumentException("Different graphic object in before and after");
            }
            this.c = this.a.c();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.a == null) {
                return;
            }
            if (this.a.getGraphicBag() == null) {
                this.a();
            } else {
                this.a.getGraphicBag().applyToObject((IlvGraphic)this.a, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        UndoChangeShape.this.a();
                    }
                }, null, true);
            }
        }

        private void a() {
            this.a.removeAllSegments();
            if (this.b != null) {
                this.a.a(this.b, null);
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (this.a == null) {
                return;
            }
            if (this.a.getGraphicBag() == null) {
                this.redoImpl();
            } else {
                this.a.getGraphicBag().applyToObject((IlvGraphic)this.a, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        UndoChangeShape.this.redoImpl();
                    }
                }, null, true);
            }
        }

        public void redoImpl() {
            this.a.removeAllSegments();
            if (this.c != null) {
                this.a.a(this.c, null);
            }
        }
    }
}

