/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.beans.editor;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvTexture;
import ilog.views.io.IlvOutputStream;
import ilog.views.sdm.beans.editor.EnumPropertyEditor;
import ilog.views.util.beans.editor.IlvArrayPropertyEditor;
import ilog.views.util.beans.editor.IlvTaggedIntValueEditor;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class GeneralLinkEditors {
    static /* synthetic */ Class a;
    static /* synthetic */ Class b;

    static class DecoAttChooser
    extends JPanel
    implements ActionListener {
        DecoAttEditor a;
        JCheckBox b;
        JCheckBox c;
        JCheckBox d;
        JCheckBox e;
        JCheckBox f;
        JCheckBox g;
        JCheckBox h;
        JCheckBox i;
        int j;

        public DecoAttChooser(DecoAttEditor decoAttEditor) {
            this.setLayout(new GridLayout(5, 5, 4, 4));
            this.a = decoAttEditor;
            this.b = new JCheckBox("Animate");
            this.b.setActionCommand(String.valueOf(1));
            this.b.addActionListener(this);
            this.add(this.b);
            this.c = new JCheckBox("Rotate");
            this.c.setActionCommand(String.valueOf(2));
            this.c.addActionListener(this);
            this.add(this.c);
            this.d = new JCheckBox("Fixed Size");
            this.d.setActionCommand(String.valueOf(4));
            this.d.addActionListener(this);
            this.add(this.d);
            this.e = new JCheckBox("Anchor Top");
            this.e.setActionCommand(String.valueOf(8));
            this.e.addActionListener(this);
            this.add(this.e);
            this.f = new JCheckBox("Anchor Bottom");
            this.f.setActionCommand(String.valueOf(16));
            this.f.addActionListener(this);
            this.add(this.f);
            this.g = new JCheckBox("Anchor Left");
            this.g.setActionCommand(String.valueOf(32));
            this.g.addActionListener(this);
            this.add(this.g);
            this.h = new JCheckBox("Anchor Right");
            this.h.setActionCommand(String.valueOf(64));
            this.h.addActionListener(this);
            this.add(this.h);
            this.i = new JCheckBox("Over");
            this.i.setActionCommand(String.valueOf(128));
            this.i.addActionListener(this);
            this.add(this.i);
        }

        public void updateValue(int n) {
            this.b.setSelected((n & 1) != 0);
            this.c.setSelected((n & 2) != 0);
            this.g.setSelected((n & 0x20) != 0);
            this.d.setSelected((n & 4) != 0);
            this.e.setSelected((n & 8) != 0);
            this.i.setSelected((n & 0x80) != 0);
            this.h.setSelected((n & 0x40) != 0);
            this.f.setSelected((n & 0x10) != 0);
            this.j = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
            int n = Integer.parseInt(actionEvent.getActionCommand());
            this.j = bl ? this.j | n : this.j & ~n;
            this.a.firePropertyChange();
        }
    }

    public static class DecoAttEditor
    extends PropertyEditorSupport {
        private DecoAttChooser a = null;

        int a() {
            return super.getValue() != null ? (Integer)super.getValue() : 0;
        }

        public String getAsText() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.a();
            if ((n & 1) != 0) {
                stringBuffer.append("|DECORATION_ANIMATE");
            }
            if ((n & 2) != 0) {
                stringBuffer.append("|DECORATION_ROTATE");
            }
            if ((n & 0x20) != 0) {
                stringBuffer.append("|DECORATION_ANCHOR_LEFT");
            }
            if ((n & 4) != 0) {
                stringBuffer.append("|DECORATION_FIXED_SIZE");
            }
            if ((n & 8) != 0) {
                stringBuffer.append("|DECORATION_ANCHOR_TOP");
            }
            if ((n & 0x10) != 0) {
                stringBuffer.append("|DECORATION_ANCHOR_BOTTOM");
            }
            if ((n & 0x40) != 0) {
                stringBuffer.append("|DECORATION_ANCHOR_RIGHT");
            }
            if ((n & 0x80) != 0) {
                stringBuffer.append("|DECORATION_OVER");
            }
            if ((n & 0x100) != 0) {
                stringBuffer.append("|DECORATION_ABSOLUTE");
            }
            return stringBuffer.length() > 0 ? stringBuffer.substring(1) : "";
        }

        public Object getValue() {
            if (this.a != null) {
                return new Integer(this.a.j);
            }
            return super.getValue();
        }

        public void setValue(Object object) {
            super.setValue(object);
            if (this.a != null) {
                this.a.updateValue(this.a());
            }
        }

        public Component getCustomEditor() {
            if (this.a == null) {
                this.a = new DecoAttChooser(this);
                this.a.updateValue(this.a());
            }
            return this.a;
        }

        public boolean supportsCustomEditor() {
            return true;
        }
    }

    public static class DecoAttArrayPropertyEditor
    extends IlvArrayPropertyEditor {
        public DecoAttArrayPropertyEditor() {
            this.setPropertyEditorClass(b == null ? (b = GeneralLinkEditors.class$("ilog.views.sdm.beans.editor.GeneralLinkEditors$DecoAttEditor")) : b);
        }

        public String getJavaInitializationString() {
            return "new int[] {" + this.getAsText() + "}";
        }

        protected Object objectArrayFrom(String[] stringArray) {
            int[] nArray = new int[stringArray.length];
            block2: for (int i = 0; i < stringArray.length; ++i) {
                try {
                    nArray[i] = Integer.parseInt(stringArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    while (true) {
                        if (stringArray[i].startsWith("DECORATION_ANIMATE")) {
                            int n = i;
                            nArray[n] = nArray[n] | 1;
                        } else if (stringArray[i].startsWith("DECORATION_ROTATE")) {
                            int n = i;
                            nArray[n] = nArray[n] | 2;
                        } else if (stringArray[i].startsWith("DECORATION_FIXED_SIZE")) {
                            int n = i;
                            nArray[n] = nArray[n] | 4;
                        } else if (stringArray[i].startsWith("DECORATION_ANCHOR_TOP")) {
                            int n = i;
                            nArray[n] = nArray[n] | 8;
                        } else if (stringArray[i].startsWith("DECORATION_ANCHOR_BOTTOM")) {
                            int n = i;
                            nArray[n] = nArray[n] | 0x10;
                        } else if (stringArray[i].startsWith("DECORATION_ANCHOR_LEFT")) {
                            int n = i;
                            nArray[n] = nArray[n] | 0x20;
                        } else if (stringArray[i].startsWith("DECORATION_ANCHOR_RIGHT")) {
                            int n = i;
                            nArray[n] = nArray[n] | 0x40;
                        } else if (stringArray[i].startsWith("DECORATION_OVER")) {
                            int n = i;
                            nArray[n] = nArray[n] | 0x80;
                        } else if (stringArray[i].startsWith("DECORATION_ABSOLUTE")) {
                            int n = i;
                            nArray[n] = nArray[n] | 0x100;
                        } else if (stringArray[i].startsWith("DECORATION_FULL_RETRACT_AT_END")) {
                            int n = i;
                            nArray[n] = nArray[n] | 0x200;
                        } else if (stringArray[i].startsWith("DECORATION_HALF_RETRACT_AT_END")) {
                            int n = i;
                            nArray[n] = nArray[n] | 0x400;
                        } else {
                            if (!stringArray[i].startsWith("DECORATION_NO_RETRACT_AT_END")) continue block2;
                            int n = i;
                            nArray[n] = nArray[n] | 0x800;
                        }
                        int n = stringArray[i].indexOf("|");
                        if (n == -1) continue block2;
                        stringArray[i] = stringArray[i].substring(n + 1).trim();
                    }
                }
            }
            return nArray;
        }
    }

    public static class PointArrayPropertyEditor
    extends IlvArrayPropertyEditor {
        public String getJavaInitializationString() {
            StringBuffer stringBuffer = new StringBuffer("new IlvPoint[] {");
            IlvPoint[] ilvPointArray = (IlvPoint[])this.getValue();
            for (int i = 0; i < ilvPointArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("new IlvPoint(").append(ilvPointArray[i].x).append(",").append(ilvPointArray[i].y).append(")");
            }
            stringBuffer.append("};");
            return stringBuffer.toString();
        }

        protected Object objectArrayFrom(String[] stringArray) {
            if (stringArray.length % 2 == 1) {
                throw new IllegalArgumentException("odd number of float");
            }
            IlvPoint[] ilvPointArray = new IlvPoint[stringArray.length / 2];
            for (int i = 0; i < ilvPointArray.length; ++i) {
                ilvPointArray[i] = new IlvPoint(Float.parseFloat(stringArray[2 * i]), Float.parseFloat(stringArray[2 * i + 1]));
            }
            return ilvPointArray;
        }
    }

    public static class GraphicArrayPropertyEditor
    extends PropertyEditorSupport
    implements Serializable {
        public String getJavaInitializationString() {
            return "too complex";
        }

        public String getAsText() {
            if (this.getValue() == null) {
                return "";
            }
            try {
                IlvGraphic[] ilvGraphicArray = (IlvGraphic[])this.getValue();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IlvOutputStream ilvOutputStream = new IlvOutputStream((OutputStream)byteArrayOutputStream);
                IlvManager ilvManager = new IlvManager();
                for (int i = 0; i < ilvGraphicArray.length; ++i) {
                    ilvManager.addObject(ilvGraphicArray[i], false);
                }
                ilvManager.write(ilvOutputStream);
                ilvOutputStream.flush();
                return byteArrayOutputStream.toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "Error";
            }
        }

        public void setAsText(String string) throws IllegalArgumentException {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                IlvManager ilvManager = new IlvManager();
                ilvManager.read((InputStream)byteArrayInputStream);
                IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getObjects();
                int n = 0;
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    ++n;
                    ilvGraphicEnumeration.nextElement();
                }
                IlvGraphic[] ilvGraphicArray = new IlvGraphic[n];
                ilvGraphicEnumeration = ilvManager.getObjects();
                n = 0;
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    ilvGraphicArray[n++] = ilvGraphicEnumeration.nextElement();
                }
                this.setValue(ilvGraphicArray);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    public static class TexturePropertyEditor
    extends PropertyEditorSupport
    implements Serializable {
        public String getJavaInitializationString() {
            return "new ilog.views.IlvTexture(new java.net.URL(\"" + this.getAsText() + "\"))";
        }

        public String getAsText() {
            if (this.getValue() == null) {
                return "";
            }
            try {
                return ((IlvTexture)this.getValue()).getImageURL().toString();
            }
            catch (Exception exception) {
                return "Error";
            }
        }

        public void setAsText(String string) throws IllegalArgumentException {
            try {
                this.setValue(new IlvTexture(new URL(string)));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    public static class LineJoinPropertyEditor
    extends IlvTaggedIntValueEditor {
        protected String[] createTags() {
            return new String[]{"JOIN_BEVEL", "JOIN_MITER", "JOIN_ROUND"};
        }

        protected String[] createStringValues() {
            return new String[]{"ilog.views.IlvStroke.JOIN_BEVEL", "ilog.views.IlvStroke.JOIN_MITER", "ilog.views.IlvStroke.JOIN_ROUND"};
        }

        protected int[] createIntValues() {
            return new int[]{0, 1, 2};
        }
    }

    public static class ModePropertyEditor
    extends EnumPropertyEditor {
        public ModePropertyEditor() {
            super(a == null ? (a = GeneralLinkEditors.class$("ilog.views.sdm.graphic.IlvGeneralLink")) : a, new String[]{"MODE_TEXTURE", "MODE_UNICOLOR", "MODE_GRADIENT", "MODE_NEON"});
        }
    }

    public static class ArrowModePropertyEditor
    extends EnumPropertyEditor {
        public ArrowModePropertyEditor() {
            super(a == null ? (a = GeneralLinkEditors.class$("ilog.views.sdm.graphic.IlvGeneralLink")) : a, new String[]{"ARROW_FILL", "ARROW_OPEN", "ARROW_GRADIENT", "ARROW_DECORATION"});
        }
    }
}

