/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.renderer;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.sdm.IlvSDMEngine;
import java.io.IOException;

public class IlvSDMLinkConnector
extends IlvLinkConnector {
    private IlvSDMEngine a;
    boolean b;

    public IlvSDMLinkConnector(IlvSDMEngine ilvSDMEngine, boolean bl) {
        this.a = ilvSDMEngine;
        this.b = bl;
    }

    public IlvSDMLinkConnector(IlvGraphic ilvGraphic, IlvSDMEngine ilvSDMEngine, boolean bl) {
        super(ilvGraphic);
        this.a = ilvSDMEngine;
        this.b = bl;
    }

    public IlvSDMLinkConnector(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        IlvGraphicBag ilvGraphicBag = ilvInputStream.getGraphicBag();
        if (ilvGraphicBag instanceof IlvGrapher) {
            this.a = IlvSDMEngine.getSDMEngine((IlvGrapher)ilvGraphicBag);
        }
        this.b = ilvInputStream.readBoolean("center");
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("center", this.b);
    }

    public boolean isPersistent() {
        return true;
    }

    public IlvPoint getConnectionPoint(IlvLinkImage ilvLinkImage, boolean bl, IlvTransformer ilvTransformer) {
        return IlvSDMLinkConnector.a(this.a, this.getNode(), ilvLinkImage, bl, ilvTransformer, this.b);
    }

    static IlvPoint a(IlvSDMEngine ilvSDMEngine, IlvGraphic ilvGraphic, IlvLinkImage ilvLinkImage, boolean bl, IlvTransformer ilvTransformer, boolean bl2) {
        return IlvSDMLinkConnector.a(ilvSDMEngine, ilvGraphic, ilvLinkImage.getConnectionReferencePoint(bl, ilvTransformer), ilvTransformer, bl2);
    }

    public IlvPoint getClosestConnectionPoint(IlvPoint ilvPoint, Object object, Object object2, Object object3, boolean bl, IlvTransformer ilvTransformer) {
        return IlvSDMLinkConnector.a(this.a, this.getNode(), ilvPoint, ilvTransformer, this.b);
    }

    static IlvPoint a(IlvSDMEngine ilvSDMEngine, IlvGraphic ilvGraphic, IlvPoint ilvPoint, Object object, Object object2, Object object3, boolean bl, IlvTransformer ilvTransformer, boolean bl2) {
        return IlvSDMLinkConnector.a(ilvSDMEngine, ilvGraphic, ilvPoint, ilvTransformer, bl2);
    }

    private static IlvPoint a(IlvSDMEngine ilvSDMEngine, IlvGraphic ilvGraphic, IlvPoint ilvPoint, IlvTransformer ilvTransformer, boolean bl) {
        IlvRect ilvRect = ilvSDMEngine != null ? ilvSDMEngine.getRenderer().getLinkConnectionRectangle(ilvSDMEngine, ilvGraphic, ilvTransformer) : ilvGraphic.boundingBox(ilvTransformer);
        if (bl) {
            return new IlvPoint(ilvRect.x + ilvRect.width * 0.5f, ilvRect.y + ilvRect.height * 0.5f);
        }
        float[] fArray = new float[]{ilvRect.x + ilvRect.width / 2.0f, ilvRect.y, ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height, ilvRect.x + ilvRect.width, ilvRect.y + ilvRect.height / 2.0f, ilvRect.x, ilvRect.y + ilvRect.height / 2.0f};
        double d = Double.MAX_VALUE;
        int n = -1;
        for (int i = 0; i < 8; i += 2) {
            double d2 = (ilvPoint.x - fArray[i]) * (ilvPoint.x - fArray[i]) + (ilvPoint.y - fArray[i + 1]) * (ilvPoint.y - fArray[i + 1]);
            if (!(d2 < d)) continue;
            n = i;
            d = d2;
        }
        if (n >= 0) {
            return new IlvPoint(fArray[n], fArray[n + 1]);
        }
        return new IlvPoint(ilvRect.x + ilvRect.width * 0.5f, ilvRect.y + ilvRect.height * 0.5f);
    }

    public void connectLink(IlvLinkImage ilvLinkImage, IlvPoint ilvPoint, boolean bl, IlvTransformer ilvTransformer) {
    }

    protected boolean zoomable() {
        return true;
    }

    public IlvRect getGhostBoundingBox(IlvTransformer ilvTransformer) {
        return new IlvRect();
    }
}

