/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

final class BasePath
implements Shape,
Serializable,
Cloneable {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private static final byte SEG_MOVETO = 0;
    private static final byte SEG_LINETO = 1;
    private static final byte SEG_QUADTO = 2;
    private static final byte SEG_CUBICTO = 3;
    private static final byte SEG_CLOSE = 4;
    byte[] pointTypes;
    float[] pointCoords;
    int numTypes;
    int numCoords;
    int windingRule;
    static final int INIT_SIZE = 2;
    static final int EXPAND_MAX = 10;

    public BasePath() {
        this(1, 2, 2);
    }

    public BasePath(int n) {
        this(n, 2, 2);
    }

    public BasePath(int n, int n2) {
        this(n, n2, n2);
    }

    BasePath(int n, int n2, int n3) {
        this.setWindingRule(n);
        this.pointTypes = new byte[n2];
        this.pointCoords = new float[n3 * 2];
    }

    public BasePath(Shape shape) {
        this(1, 2, 2);
        PathIterator pathIterator = shape.getPathIterator(null);
        this.setWindingRule(pathIterator.getWindingRule());
        this.append(pathIterator, false);
    }

    private void needRoom(int n, int n2, boolean bl) {
        Object[] objectArray;
        int n3;
        if (bl && this.numTypes == 0) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        int n4 = this.pointCoords.length;
        if (this.numCoords + n2 > n4) {
            n3 = n4;
            if (n3 > 20) {
                n3 = 20;
            }
            if (n3 < n2) {
                n3 = n2;
            }
            objectArray = new float[n4 + n3];
            System.arraycopy(this.pointCoords, 0, objectArray, 0, this.numCoords);
            this.pointCoords = objectArray;
        }
        if (this.numTypes + n > (n4 = this.pointTypes.length)) {
            n3 = n4;
            if (n3 > 10) {
                n3 = 10;
            }
            if (n3 < n) {
                n3 = n;
            }
            objectArray = new byte[n4 + n3];
            System.arraycopy(this.pointTypes, 0, objectArray, 0, this.numTypes);
            this.pointTypes = (byte[])objectArray;
        }
    }

    public synchronized void moveTo(float f, float f2) {
        if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
            this.pointCoords[this.numCoords - 2] = f;
            this.pointCoords[this.numCoords - 1] = f2;
        } else {
            this.needRoom(1, 2, false);
            this.pointTypes[this.numTypes++] = 0;
            this.pointCoords[this.numCoords++] = f;
            this.pointCoords[this.numCoords++] = f2;
        }
    }

    public synchronized void lineTo(float f, float f2) {
        this.needRoom(1, 2, true);
        this.pointTypes[this.numTypes++] = 1;
        this.pointCoords[this.numCoords++] = f;
        this.pointCoords[this.numCoords++] = f2;
    }

    public synchronized void quadTo(float f, float f2, float f3, float f4) {
        this.needRoom(1, 4, true);
        this.pointTypes[this.numTypes++] = 2;
        this.pointCoords[this.numCoords++] = f;
        this.pointCoords[this.numCoords++] = f2;
        this.pointCoords[this.numCoords++] = f3;
        this.pointCoords[this.numCoords++] = f4;
    }

    public synchronized void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.needRoom(1, 6, true);
        this.pointTypes[this.numTypes++] = 3;
        this.pointCoords[this.numCoords++] = f;
        this.pointCoords[this.numCoords++] = f2;
        this.pointCoords[this.numCoords++] = f3;
        this.pointCoords[this.numCoords++] = f4;
        this.pointCoords[this.numCoords++] = f5;
        this.pointCoords[this.numCoords++] = f6;
    }

    public synchronized void closePath() {
        if (this.numTypes == 0 || this.pointTypes[this.numTypes - 1] != 4) {
            this.needRoom(1, 0, true);
            this.pointTypes[this.numTypes++] = 4;
        }
    }

    public void append(Shape shape, boolean bl) {
        PathIterator pathIterator = shape.getPathIterator(null);
        this.append(pathIterator, bl);
    }

    public void append(PathIterator pathIterator, boolean bl) {
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    if (!bl || this.numTypes < 1 || this.numCoords < 2) {
                        this.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    if (this.pointTypes[this.numTypes - 1] != 4 && this.pointCoords[this.numCoords - 2] == fArray[0] && this.pointCoords[this.numCoords - 1] == fArray[1]) break;
                }
                case 1: {
                    this.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    this.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    this.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    this.closePath();
                }
            }
            pathIterator.next();
            bl = false;
        }
    }

    public synchronized int getWindingRule() {
        return this.windingRule;
    }

    public void setWindingRule(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("winding rule must be WIND_EVEN_ODD or WIND_NON_ZERO");
        }
        this.windingRule = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized Point2D getCurrentPoint() {
        if (this.numTypes < 1) return null;
        if (this.numCoords < 2) {
            return null;
        }
        int n = this.numCoords;
        if (this.pointTypes[this.numTypes - 1] != 4) return new Point2D.Float(this.pointCoords[n - 2], this.pointCoords[n - 1]);
        int n2 = this.numTypes - 2;
        while (n2 > 0) {
            switch (this.pointTypes[n2]) {
                case 0: {
                    return new Point2D.Float(this.pointCoords[n - 2], this.pointCoords[n - 1]);
                }
                case 1: {
                    n -= 2;
                    break;
                }
                case 2: {
                    n -= 4;
                    break;
                }
                case 3: {
                    n -= 6;
                }
            }
            --n2;
        }
        return new Point2D.Float(this.pointCoords[n - 2], this.pointCoords[n - 1]);
    }

    public synchronized void reset() {
        this.numCoords = 0;
        this.numTypes = 0;
    }

    public void transform(AffineTransform affineTransform) {
        affineTransform.transform(this.pointCoords, 0, this.pointCoords, 0, this.numCoords / 2);
    }

    public synchronized Shape createTransformedShape(AffineTransform affineTransform) {
        BasePath basePath = (BasePath)this.clone();
        if (affineTransform != null) {
            basePath.transform(affineTransform);
        }
        return basePath;
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public synchronized Rectangle2D getBounds2D() {
        float f;
        float f2;
        float f3;
        float f4;
        int n = this.numCoords;
        if (n > 0) {
            f3 = f4 = this.pointCoords[--n];
            f = f2 = this.pointCoords[--n];
            while (n > 0) {
                float f5;
                float f6 = this.pointCoords[--n];
                if ((f5 = this.pointCoords[--n]) < f) {
                    f = f5;
                }
                if (f6 < f3) {
                    f3 = f6;
                }
                if (f5 > f2) {
                    f2 = f5;
                }
                if (!(f6 > f4)) continue;
                f4 = f6;
            }
        } else {
            f4 = 0.0f;
            f2 = 0.0f;
            f3 = 0.0f;
            f = 0.0f;
        }
        return new Rectangle2D.Float(f, f3, f2 - f, f4 - f3);
    }

    public boolean contains(double d, double d2) {
        return new Area(this).contains(d, d2);
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return new Area(this).contains(d, d2, d3, d4);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return new Area(this).intersects(d, d2, d3, d4);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new BasePathIterator(this, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }

    public Object clone() {
        try {
            BasePath basePath = (BasePath)super.clone();
            basePath.pointTypes = (byte[])this.pointTypes.clone();
            basePath.pointCoords = (float[])this.pointCoords.clone();
            return basePath;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private static final class BasePathIterator
    implements PathIterator,
    Serializable {
        private static final int[] CURVE_SIZE = new int[]{2, 2, 4, 6, 0};
        private int _type_id_x = 0;
        private int _point_id_x = 0;
        private BasePath _path;
        private AffineTransform _affine;

        BasePathIterator(BasePath basePath) {
            this(basePath, null);
        }

        BasePathIterator(BasePath basePath, AffineTransform affineTransform) {
            this._path = basePath;
            this._affine = affineTransform;
        }

        public int currentSegment(float[] fArray) {
            byte by = this._path.pointTypes[this._type_id_x];
            int n = CURVE_SIZE[by];
            if (n > 0 && this._affine != null) {
                this._affine.transform(this._path.pointCoords, this._point_id_x, fArray, 0, n / 2);
            } else {
                int n2 = 0;
                while (n2 < n) {
                    fArray[n2] = this._path.pointCoords[this._point_id_x + n2];
                    ++n2;
                }
            }
            return by;
        }

        public int currentSegment(double[] dArray) {
            byte by = this._path.pointTypes[this._type_id_x];
            int n = CURVE_SIZE[by];
            if (n > 0 && this._affine != null) {
                this._affine.transform(this._path.pointCoords, this._point_id_x, dArray, 0, n / 2);
            } else {
                int n2 = 0;
                while (n2 < n) {
                    dArray[n2] = this._path.pointCoords[this._point_id_x + n2];
                    ++n2;
                }
            }
            return by;
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            return this._type_id_x >= this._path.numTypes;
        }

        public void next() {
            this._point_id_x += CURVE_SIZE[this._path.pointTypes[this._type_id_x++]];
        }
    }
}

