/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.BasePath;
import com.loox.jloox.Lx;
import com.loox.jloox.LxSaveUtils;
import com.loox.jloox.Rectangle2DDouble;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

class CustomDrawInfo
implements Serializable {
    int _nbLinks = 0;
    Rectangle2DDouble _customDrawBounds = null;
    double _customLinkJoinOffset = 0.0;
    double _cornerOffsetX = 0.0;
    double _cornerOffsetY = 0.0;
    double _attachmentOffsetX = 0.0;
    double _attachmentOffsetY = 0.0;
    BasePath _gpb = new BasePath();
    AffineTransform _atgpb = new AffineTransform();
    transient GeneralPath[] _shapes = new GeneralPath[]{null, null, null, null, null, null, null};
    Paint[] _linePaint = new Paint[]{null, null, null, null, null, null, null};
    Paint[] _fillPaint = new Paint[]{null, null, null, null, null, null, null};

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._shapes.length);
        int n = 0;
        while (n < this._shapes.length) {
            BasePath basePath = new BasePath(this._shapes[n]);
            objectOutputStream.writeObject(basePath);
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this._shapes = new GeneralPath[objectInputStream.readInt()];
        int n = 0;
        while (n < this._shapes.length) {
            this._shapes[n] = new GeneralPath((BasePath)objectInputStream.readObject());
            ++n;
        }
    }

    public boolean equals(CustomDrawInfo customDrawInfo) {
        if (customDrawInfo == null) {
            return false;
        }
        if (this._customLinkJoinOffset != customDrawInfo._customLinkJoinOffset) {
            return false;
        }
        if (this._cornerOffsetX != customDrawInfo._cornerOffsetX) {
            return false;
        }
        if (this._cornerOffsetY != customDrawInfo._cornerOffsetY) {
            return false;
        }
        if (this._attachmentOffsetX != customDrawInfo._attachmentOffsetX) {
            return false;
        }
        if (this._attachmentOffsetY != customDrawInfo._attachmentOffsetY) {
            return false;
        }
        return this.graphicallyEquals(customDrawInfo);
    }

    public boolean graphicallyEquals(CustomDrawInfo customDrawInfo) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (customDrawInfo == null) {
            return false;
        }
        if (customDrawInfo._shapes == null) {
            return false;
        }
        int n = 0;
        while (n < this._shapes.length) {
            if (this._shapes[n] == null && customDrawInfo._shapes[n] != null || this._shapes[n] != null && customDrawInfo._shapes[n] == null) {
                return false;
            }
            object4 = this._shapes[n].getPathIterator(null);
            object3 = customDrawInfo._shapes[n].getPathIterator(null);
            if (object4 == null && object3 != null || object4 != null && object3 == null) {
                return false;
            }
            object2 = new double[6];
            object = new double[6];
            while (!object4.isDone()) {
                int n2;
                if (object3.isDone()) {
                    return false;
                }
                int n3 = object4.currentSegment((double[])object2);
                if (n3 != (n2 = object3.currentSegment((double[])object))) {
                    return false;
                }
                int n4 = 0;
                while (n4 < ((Object)object2).length) {
                    if (Math.abs((double)(object2[n4] - object[n4])) > 0.001) {
                        return false;
                    }
                    ++n4;
                }
                object4.next();
                object3.next();
            }
            ++n;
        }
        if (customDrawInfo._linePaint == null) {
            return false;
        }
        n = 0;
        while (n < this._linePaint.length) {
            object4 = this._linePaint[n];
            object3 = customDrawInfo._linePaint[n];
            if (object4 == null && object3 != null || object4 != null && object3 == null) {
                return false;
            }
            if (object4.getClass() != object3.getClass()) {
                return false;
            }
            if (object4 instanceof Color && (!((Color)(object2 = (Object)((Color)object4))).equals(object = (Object)((Color)object3)) || ((Color)object2).getAlpha() != ((Color)object).getAlpha())) {
                return false;
            }
            ++n;
        }
        if (customDrawInfo._fillPaint == null) {
            return false;
        }
        n = 0;
        while (n < this._fillPaint.length) {
            object4 = this._fillPaint[n];
            object3 = customDrawInfo._fillPaint[n];
            if (object4 == null && object3 != null || object4 != null && object3 == null) {
                return false;
            }
            if (object4.getClass() != object3.getClass()) {
                return false;
            }
            if (object4 instanceof Color && (!((Color)(object2 = (Color)object4)).equals(object = (Color)object3) || ((Color)object2).getAlpha() != ((Color)object).getAlpha())) {
                return false;
            }
            if (object4 instanceof Lx.JLooxGradientPaint || object4 instanceof Lx.JLooxRadialGradientPaint) {
                object2 = null;
                object = null;
                if (object4 instanceof Lx.JLooxGradientPaint) {
                    object2 = ((Lx.JLooxGradientPaint)object4)._info;
                } else if (object4 instanceof Lx.JLooxRadialGradientPaint) {
                    object2 = ((Lx.JLooxRadialGradientPaint)object4)._info;
                }
                if (object3 instanceof Lx.JLooxGradientPaint) {
                    object = ((Lx.JLooxGradientPaint)object3)._info;
                } else if (object3 instanceof Lx.JLooxRadialGradientPaint) {
                    object = ((Lx.JLooxRadialGradientPaint)object3)._info;
                }
                if (((Lx.GradientInfo)object2)._type != ((Lx.GradientInfo)object)._type) {
                    return false;
                }
                if (!((Lx.GradientInfo)object2)._line_color.equals(((Lx.GradientInfo)object)._line_color)) {
                    return false;
                }
                if (!((Lx.GradientInfo)object2)._fill_color.equals(((Lx.GradientInfo)object)._fill_color)) {
                    return false;
                }
                if (((Lx.GradientInfo)object2)._transparent != ((Lx.GradientInfo)object)._transparent) {
                    return false;
                }
                if (((Lx.GradientInfo)object2)._cyclic != ((Lx.GradientInfo)object)._cyclic) {
                    return false;
                }
                double d = ((Lx.GradientInfo)object2)._start_x;
                double d2 = ((Lx.GradientInfo)object2)._start_y;
                double d3 = ((Lx.GradientInfo)object)._start_x;
                double d4 = ((Lx.GradientInfo)object)._start_y;
                if (Math.abs(d - d3) > 0.001 && Math.abs(d2 - d4) > 0.001) {
                    return false;
                }
                d = ((Lx.GradientInfo)object2)._end_x;
                d2 = ((Lx.GradientInfo)object2)._end_y;
                d3 = ((Lx.GradientInfo)object)._end_x;
                d4 = ((Lx.GradientInfo)object)._end_y;
                if (Math.abs(d - d3) > 0.001 && Math.abs(d2 - d4) > 0.001) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public void save(OutputStream outputStream) throws IOException {
        if (this._shapes != null) {
            int n;
            LxSaveUtils.writeDouble(outputStream, this._cornerOffsetX);
            LxSaveUtils.writeDouble(outputStream, this._cornerOffsetY);
            LxSaveUtils.writeDouble(outputStream, this._attachmentOffsetX);
            LxSaveUtils.writeDouble(outputStream, this._attachmentOffsetY);
            LxSaveUtils.writeDouble(outputStream, this._customLinkJoinOffset);
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            int n2 = 0;
            int n3 = 0;
            LxSaveUtils.writeInt(outputStream, this._shapes.length);
            int n4 = 0;
            while (n4 < this._shapes.length) {
                if (this._shapes[n4] != null) {
                    PathIterator pathIterator = this._shapes[n4].getPathIterator(null);
                    n = 0;
                    while (!pathIterator.isDone()) {
                        ++n;
                        pathIterator.next();
                    }
                    LxSaveUtils.writeInt(outputStream, n);
                    pathIterator = this._shapes[n4].getPathIterator(null);
                    while (!pathIterator.isDone()) {
                        n2 = pathIterator.currentSegment(fArray);
                        LxSaveUtils.writeInt(outputStream, n2);
                        switch (n2) {
                            case 0: 
                            case 1: 
                            case 4: {
                                n3 = 2;
                                break;
                            }
                            case 2: {
                                n3 = 4;
                                break;
                            }
                            case 3: {
                                n3 = 6;
                            }
                        }
                        LxSaveUtils.writeFloatArray(outputStream, fArray, n3);
                        LxSaveUtils.writeEndOfPart(outputStream);
                        pathIterator.next();
                    }
                } else {
                    LxSaveUtils.writeInt(outputStream, 0);
                }
                ++n4;
            }
            LxSaveUtils.writeInt(outputStream, this._linePaint.length);
            int n5 = 0;
            while (n5 < this._linePaint.length) {
                LxSaveUtils.writeColor(outputStream, (Color)this._linePaint[n5]);
                ++n5;
            }
            LxSaveUtils.writeInt(outputStream, this._fillPaint.length);
            n = 0;
            while (n < this._fillPaint.length) {
                Paint paint = this._fillPaint[n];
                if (paint instanceof Color) {
                    LxSaveUtils.write(outputStream, "C");
                    LxSaveUtils.writeColor(outputStream, (Color)paint);
                } else if (paint instanceof Lx.JLooxGradientPaint || paint instanceof Lx.JLooxRadialGradientPaint) {
                    LxSaveUtils.write(outputStream, "G");
                    Lx.GradientInfo gradientInfo = paint instanceof Lx.JLooxGradientPaint ? ((Lx.JLooxGradientPaint)paint)._info : (paint instanceof Lx.JLooxRadialGradientPaint ? ((Lx.JLooxRadialGradientPaint)paint)._info : null);
                    LxSaveUtils.writeInt(outputStream, gradientInfo._type);
                    float[] fArray2 = new float[]{gradientInfo._start_x, gradientInfo._start_y, gradientInfo._end_x, gradientInfo._end_y};
                    LxSaveUtils.writeFloatArray(outputStream, fArray2);
                    boolean[] blArray = new boolean[]{gradientInfo._cyclic, gradientInfo._transparent};
                    LxSaveUtils.writeBooleanArray(outputStream, blArray);
                    LxSaveUtils.writeColor(outputStream, gradientInfo._fill_color);
                    LxSaveUtils.writeColor(outputStream, gradientInfo._line_color);
                }
                ++n;
            }
        }
    }

    public void read(InputStream inputStream, String string) throws IOException {
        int n;
        int n2;
        this._cornerOffsetX = LxSaveUtils.readDouble(inputStream);
        this._cornerOffsetY = LxSaveUtils.readDouble(inputStream);
        this._attachmentOffsetX = LxSaveUtils.readDouble(inputStream);
        this._attachmentOffsetY = LxSaveUtils.readDouble(inputStream);
        this._customLinkJoinOffset = LxSaveUtils.readDouble(inputStream);
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        int n3 = 0;
        int n4 = 0;
        int n5 = LxSaveUtils.readInt(inputStream);
        int n6 = 0;
        while (n6 < n5) {
            n2 = LxSaveUtils.readInt(inputStream);
            if (n2 > 0) {
                GeneralPath generalPath = new GeneralPath();
                n = 0;
                while (n < n2) {
                    n3 = LxSaveUtils.readInt(inputStream);
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 4: {
                            n4 = 2;
                            break;
                        }
                        case 2: {
                            n4 = 4;
                            break;
                        }
                        case 3: {
                            n4 = 6;
                        }
                    }
                    fArray = LxSaveUtils.readFloatArray(inputStream, n4);
                    LxSaveUtils.readEndOfPart(inputStream);
                    try {
                        switch (n3) {
                            case 0: {
                                generalPath.moveTo(fArray[0], fArray[1]);
                                break;
                            }
                            case 1: {
                                generalPath.lineTo(fArray[0], fArray[1]);
                                break;
                            }
                            case 4: {
                                generalPath.closePath();
                                break;
                            }
                            case 2: {
                                generalPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                                break;
                            }
                            case 3: {
                                generalPath.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this._shapes[n6] = generalPath;
                    ++n;
                }
            } else {
                this._shapes[n6] = null;
            }
            ++n6;
        }
        n2 = LxSaveUtils.readInt(inputStream);
        int n7 = 0;
        while (n7 < n2) {
            this._linePaint[n7] = LxSaveUtils.readColor(inputStream);
            ++n7;
        }
        n = LxSaveUtils.readInt(inputStream);
        int n8 = 0;
        while (n8 < n) {
            Paint paint = null;
            String string2 = LxSaveUtils.read(inputStream);
            if (string2.equals("C")) {
                paint = LxSaveUtils.readColor(inputStream);
            } else if (string2.equals("G")) {
                int n9 = 0;
                if (string.compareTo("2.0.2") >= 0) {
                    n9 = LxSaveUtils.readInt(inputStream);
                }
                float[] fArray2 = LxSaveUtils.readFloatArray(inputStream, 4);
                boolean[] blArray = LxSaveUtils.readBooleanArray(inputStream, 2);
                Color color = LxSaveUtils.readColor(inputStream);
                Color color2 = LxSaveUtils.readColor(inputStream);
                paint = n9 == 0 ? Lx.getGradientPaint(fArray2[0], fArray2[1], color, fArray2[2], fArray2[3], color2, blArray[0]) : Lx.getRadialGradientPaint(fArray2[0], fArray2[1], color, fArray2[2], fArray2[3], color2);
            }
            this._fillPaint[n8] = paint;
            ++n8;
        }
    }

    public static CustomDrawInfo readTheme(InputStream inputStream, String string) throws IOException {
        CustomDrawInfo customDrawInfo = new CustomDrawInfo();
        customDrawInfo.read(inputStream, string);
        return customDrawInfo;
    }
}

