/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.Lx;
import com.loox.jloox.LxConstants;
import com.loox.jloox.Resources;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public abstract class LxAbstractAction
extends AbstractAction
implements Serializable,
LxConstants {
    private static final String COMMAND_NAME = "CommandName";
    private static final String ORIGINAL_LABEL = "OriginalLabel";
    private static final String ORIGINAL_ICON = "OriginalIcon";
    private static final String ORIGINAL_TIP = "OriginalTooltip";
    private boolean _enabled;
    private boolean _always_disabled;

    public LxAbstractAction(String string, String string2, String string3, String string4, boolean bl) {
        super(Resources.get(string + "Label", string2 != null ? string2 : "???"));
        this._enabled = bl;
        this._always_disabled = false;
        this.setActionName(string);
        this.setOriginalLabel(this.getLabel());
        String string5 = Resources.get(string + "Tooltip", string3);
        if (string5 != null) {
            this.setOriginalTooltip(string5);
        }
        if (string4 != null) {
            this.setOriginalIcon(Resources.getURL(string4));
        }
        this.setEnabled(bl);
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        Lx.ActionProcessor actionProcessor = Lx.getActionProcessor();
        Class<?> clazz = this.getClass().getDeclaringClass();
        if (actionProcessor == null || actionProcessor.preprocessing(this, clazz, actionEvent)) {
            this.processAction(actionEvent);
            if (actionProcessor != null) {
                actionProcessor.postprocessing(this, clazz, actionEvent);
            }
        }
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
        super.setEnabled(bl && !this._always_disabled);
    }

    public static final LxAbstractAction[] augmentList(LxAbstractAction[] lxAbstractActionArray, LxAbstractAction[] lxAbstractActionArray2) {
        Object object;
        int n;
        LxAbstractAction[] lxAbstractActionArray3;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        LxAbstractAction[][] lxAbstractActionArrayArray = new LxAbstractAction[][]{lxAbstractActionArray, lxAbstractActionArray2};
        int n2 = 0;
        while (n2 < lxAbstractActionArrayArray.length) {
            lxAbstractActionArray3 = lxAbstractActionArrayArray[n2];
            n = 0;
            while (n < lxAbstractActionArray3.length) {
                object = lxAbstractActionArray3[n];
                String string = ((LxAbstractAction)object).getActionName();
                hashtable.put(string != null ? string : "", object);
                ++n;
            }
            ++n2;
        }
        lxAbstractActionArray3 = new LxAbstractAction[hashtable.size()];
        n = 0;
        object = hashtable.elements();
        while (object.hasMoreElements()) {
            lxAbstractActionArray3[n++] = (LxAbstractAction)object.nextElement();
        }
        return lxAbstractActionArray3;
    }

    public final AbstractButton addTo(JComponent jComponent) {
        if (jComponent instanceof JMenu || jComponent instanceof JPopupMenu) {
            return this._addTo(jComponent);
        }
        if (jComponent instanceof JToolBar) {
            AbstractButton abstractButton = this._getButton(jComponent);
            ((JToolBar)jComponent).add(abstractButton);
            this.addPropertyChangeListener(new ToolBarListener(abstractButton));
            abstractButton.setToolTipText(this.getTooltip());
            abstractButton.setHorizontalTextPosition(4);
            abstractButton.setVerticalTextPosition(0);
            abstractButton.setEnabled(this.isEnabled());
            abstractButton.addActionListener(this);
            return abstractButton;
        }
        throw new IllegalArgumentException("unknown parent type");
    }

    public final String getActionName() {
        return (String)this.getValue(COMMAND_NAME);
    }

    public final Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public final String getLabel() {
        return (String)this.getValue("Name");
    }

    public Icon getOriginalIcon() {
        return (Icon)this.getValue(ORIGINAL_ICON);
    }

    public String getOriginalLabel() {
        return (String)this.getValue(ORIGINAL_LABEL);
    }

    public String getOriginalTooltip() {
        return (String)this.getValue(ORIGINAL_TIP);
    }

    public final String getTooltip() {
        return (String)this.getValue("ShortDescription");
    }

    public boolean isAlwaysDisabled() {
        return this._always_disabled;
    }

    public abstract void processAction(ActionEvent var1);

    public final void setActionName(String string) {
        this.putValue(COMMAND_NAME, string);
    }

    public void setAlwaysDisabled(boolean bl) {
        this._always_disabled = bl;
        this.setEnabled(this._enabled);
    }

    public final void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public final void setLabel(String string) {
        this.putValue("Name", string);
    }

    public void setOriginalIcon(URL uRL) {
        ImageIcon imageIcon;
        if (uRL != null && (imageIcon = new ImageIcon(uRL)) != null) {
            this.setOriginalIcon(imageIcon);
        }
    }

    public void setOriginalIcon(Icon icon) {
        if (icon == null) {
            return;
        }
        this.putValue(ORIGINAL_ICON, icon);
        this.setIcon(icon);
    }

    public void setOriginalLabel(String string) {
        this.putValue(ORIGINAL_LABEL, string);
        this.setLabel(string);
    }

    public void setOriginalTooltip(String string) {
        this.putValue(ORIGINAL_TIP, string);
        this.setTooltip(string);
    }

    public final void setTooltip(String string) {
        this.putValue("ShortDescription", string);
    }

    AbstractButton _getButton(JComponent jComponent) {
        AbstractButton abstractButton = jComponent instanceof JMenu || jComponent instanceof JPopupMenu ? new JMenuItem(this.getLabel(), this.getIcon()) : new JButton(this.getLabel(), this.getIcon());
        return abstractButton;
    }

    private final AbstractButton _addTo(JComponent jComponent) {
        JMenuItem jMenuItem = (JMenuItem)this._getButton(jComponent);
        this.addPropertyChangeListener(new ToolTipListener(jMenuItem));
        if (jComponent instanceof JMenu) {
            ((JMenu)jComponent).add(jMenuItem);
        } else {
            ((JPopupMenu)jComponent).add(jMenuItem);
        }
        jMenuItem.setToolTipText(this.getTooltip());
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setVerticalTextPosition(0);
        jMenuItem.setEnabled(this.isEnabled());
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    private static final class ToolTipListener
    implements PropertyChangeListener {
        private final JMenuItem _item;

        public ToolTipListener(JMenuItem jMenuItem) {
            this._item = jMenuItem;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this._item.setText(string2);
                this._item.repaint();
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this._item.setEnabled(bl);
                this._item.repaint();
            } else if (string.equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this._item.setIcon(icon);
                this._item.invalidate();
                this._item.repaint();
            } else if (string.equals("ShortDescription")) {
                String string3 = (String)propertyChangeEvent.getNewValue();
                this._item.setToolTipText(string3);
            } else if (string.equals("state")) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                ((JCheckBoxMenuItem)this._item).setState(bl);
                this._item.repaint();
            }
        }
    }

    private static final class ToolBarListener
    implements PropertyChangeListener {
        private final AbstractButton _button;

        public ToolBarListener(AbstractButton abstractButton) {
            this._button = abstractButton;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("Name")) {
                if (this._button.getIcon() == null) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    this._button.setText(string2);
                    this._button.repaint();
                }
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this._button.setEnabled(bl);
                this._button.repaint();
            } else if (string.equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this._button.setIcon(icon);
                this._button.invalidate();
                this._button.repaint();
            } else if (string.equals("ShortDescription")) {
                String string3 = (String)propertyChangeEvent.getNewValue();
                this._button.setToolTipText(string3);
            } else if (string.equals("state")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this._button.setSelected(bl);
            }
        }
    }
}

