/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.LxAbstractVariable;
import java.io.Serializable;

public abstract class LxAbstractDiscrete
extends LxAbstractVariable
implements Serializable {
    private int _min;
    private int _max;
    private int _value;

    LxAbstractDiscrete(int n, int n2, int n3) {
        this.setAll(n, n2, n3);
    }

    public double toPercent() {
        return (double)(this._value - this._min) / (double)(this._max - this._min);
    }

    public int toInt() {
        return this._value;
    }

    protected int getMaximum() {
        return this._max;
    }

    protected int getMinimum() {
        return this._min;
    }

    protected void setValue(int n) {
        if (n < this._min || n > this._max) {
            throw new IllegalArgumentException("value outside range");
        }
        if (n == this._value) {
            return;
        }
        this._value = n;
        this.fireChanged();
    }

    protected void setAll(int n, int n2, int n3) {
        if (n == this._min && n2 == this._max && n3 == this._value) {
            return;
        }
        if (n > n2) {
            throw new IllegalArgumentException("min greater than max");
        }
        if (n3 < n || n3 > n2) {
            throw new IllegalArgumentException("value outside range");
        }
        boolean bl = this._value != n3;
        this._min = n;
        this._max = n2;
        this._value = n3;
        if (bl) {
            this.fireChanged();
        }
    }
}

