/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.LxAbstractDyno;
import com.loox.jloox.LxAbstractPolyline;
import com.loox.jloox.LxAbstractValueDyno;
import com.loox.jloox.LxAbstractView;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxContainerAdapter;
import com.loox.jloox.LxContainerEvent;
import com.loox.jloox.LxDouble;
import com.loox.jloox.LxMouseAdapter;
import com.loox.jloox.LxMouseEvent;
import com.loox.jloox.LxMouseMotionListener;
import com.loox.jloox.LxRotatable;
import com.loox.jloox.LxSaveUtils;
import com.loox.jloox.LxVariableEvent;
import com.loox.jloox.LxVariableListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public abstract class LxAbstractKnob
extends LxAbstractValueDyno
implements Serializable {
    static final String CLASS_NAME = "LxAbstractKnob";
    private Box _box = null;
    private Indicator _indicator = null;
    private Angles _angles = null;

    public LxAbstractKnob() {
        this(CLASS_NAME, null);
    }

    public LxAbstractKnob(LxContainer lxContainer) {
        this(CLASS_NAME, lxContainer);
    }

    LxAbstractKnob(String string, LxContainer lxContainer) {
        super(string, lxContainer);
        this._initObjectVariables();
        this._postInitialize();
    }

    public Object clone() {
        LxAbstractKnob lxAbstractKnob = (LxAbstractKnob)super.clone();
        if (lxAbstractKnob == null) {
            return null;
        }
        lxAbstractKnob._initObjectVariables();
        lxAbstractKnob.setMinimumAngle(this.getMinimumAngle());
        lxAbstractKnob.setMaximumAngle(this.getMaximumAngle());
        lxAbstractKnob.adjust();
        return lxAbstractKnob;
    }

    public void readFromJLX(InputStream inputStream, String string) throws IOException {
        super.readFromJLX(inputStream, string);
        this.setMinimumAngle(LxSaveUtils.readDouble(inputStream));
        this.setMaximumAngle(LxSaveUtils.readDouble(inputStream));
        LxSaveUtils.readEndOfPart(inputStream);
        this.adjust();
    }

    public void saveAsJLX(OutputStream outputStream) throws IOException {
        super.saveAsJLX(outputStream);
        LxSaveUtils.writeDouble(outputStream, this.getMinimumAngle());
        LxSaveUtils.writeDouble(outputStream, this.getMaximumAngle());
        LxSaveUtils.writeEndOfPart(outputStream);
    }

    public void ungroup() {
        this.adjust();
        super.ungroup();
    }

    public double getMaximumAngle() {
        return this._angles.getMax();
    }

    public double getMinimumAngle() {
        return this._angles.getMin();
    }

    public void setMaximumAngle(double d) {
        this._angles.setMax(d);
    }

    public void setMinimumAngle(double d) {
        this._angles.setMin(d);
    }

    void adjust() {
        this._indicator._lastAngle = Math.PI * this._box.valToAngle(this._variable.get()) / 180.0;
        Point2D point2D = this._box.getCenter();
        if (point2D == null) {
            return;
        }
        LxComponent[] lxComponentArray = this.getChildren(2);
        int n = 0;
        while (n < lxComponentArray.length) {
            this._indicator._rotateOne(lxComponentArray[n], point2D, this._indicator._lastAngle);
            ++n;
        }
    }

    private void _initObjectVariables() {
        this._box = new Box();
        this._indicator = new Indicator();
        this._angles = new Angles();
        final LxMouseAdapter lxMouseAdapter = new LxMouseAdapter(){

            public void mousePressed(LxMouseEvent lxMouseEvent) {
                if (((LxAbstractView)lxMouseEvent.getSource()).getEditMode() == 1 && LxAbstractKnob.this.isInteractive() && (lxMouseEvent.getModifiers() & 0x10) != 0 && (lxMouseEvent.getModifiers() & 8) == 0 && (lxMouseEvent.getModifiers() & 4) == 0 && (lxMouseEvent.getModifiers() & 2) == 0) {
                    LxAbstractKnob.this.startUndoEdit("throw me away!");
                    LxAbstractKnob.this._variable.set(LxAbstractKnob.this._box.locToVal(lxMouseEvent.getX2D() - LxAbstractKnob.this.getX(), lxMouseEvent.getY2D() - LxAbstractKnob.this.getY()));
                    LxAbstractKnob.this.cancelUndoEdit();
                }
            }
        };
        this.addMouseListener(lxMouseAdapter);
        this.addMouseMotionListener(new LxMouseMotionListener(){

            public void mouseDragged(LxMouseEvent lxMouseEvent) {
                lxMouseAdapter.mousePressed(lxMouseEvent);
            }
        });
    }

    private final class Indicator
    implements Serializable {
        private double _lastAngle = 0.0;

        Indicator() {
            LxAbstractKnob.this.addContainerListener(new LxContainerAdapter(this){
                private final /* synthetic */ Indicator this$1;
                {
                    this.this$1 = indicator;
                }

                public void componentAdded(LxContainerEvent lxContainerEvent) {
                    LxComponent lxComponent = lxContainerEvent.getComponent();
                    if (lxComponent.getName().equals(LxAbstractDyno.getPartLabel(2))) {
                        Indicator.access$100(this.this$1, Indicator.access$500((Indicator)this.this$1)._variable.get());
                    }
                }
            });
            LxAbstractKnob.this._variable.addVariableListener(new LxVariableListener(this){
                private final /* synthetic */ Indicator this$1;
                {
                    this.this$1 = indicator;
                }

                public void valueChanged(LxVariableEvent lxVariableEvent) {
                    Indicator.access$100(this.this$1, ((LxDouble)lxVariableEvent.getVariable()).toDouble());
                }
            });
        }

        private void _reshape(double d) {
            LxComponent lxComponent = LxAbstractKnob.this._box.getBox();
            if (lxComponent == null) {
                return;
            }
            Point2D point2D = LxAbstractKnob.this._box.getCenter();
            if (point2D == null) {
                return;
            }
            double d2 = Math.PI * LxAbstractKnob.this._box.valToAngle(d) / 180.0;
            LxComponent[] lxComponentArray = LxAbstractKnob.this.getChildren(2);
            int n = 0;
            while (n < lxComponentArray.length) {
                this._rotateOne(lxComponentArray[n], LxAbstractKnob.this._box.getCenter(), this._lastAngle - d2);
                ++n;
            }
            this._lastAngle = d2;
        }

        private void _rotateOne(LxComponent lxComponent, Point2D point2D, double d) {
            if (lxComponent instanceof LxContainer) {
                double d2 = lxComponent.getX();
                double d3 = lxComponent.getY();
                int n = 0;
                while (n < ((LxContainer)((Object)lxComponent)).getComponentCount()) {
                    this._rotateOne(((LxContainer)((Object)lxComponent)).getComponent(n), new Point2D.Double(point2D.getX() - lxComponent.getX(), point2D.getY() - lxComponent.getY()), d);
                    ++n;
                }
            } else if (lxComponent instanceof LxAbstractPolyline) {
                LxAbstractPolyline lxAbstractPolyline = (LxAbstractPolyline)lxComponent;
                double[] dArray = new double[lxAbstractPolyline.getPointCount() * 2];
                AffineTransform affineTransform = AffineTransform.getRotateInstance(d, point2D.getX(), point2D.getY());
                Point2D.Double double_ = new Point2D.Double();
                int n = 0;
                while (n < lxAbstractPolyline.getPointCount()) {
                    Point2D point2D2 = lxAbstractPolyline.getPoint(n);
                    affineTransform.transform(point2D2, double_);
                    dArray[2 * n] = ((Point2D)double_).getX();
                    dArray[2 * n + 1] = ((Point2D)double_).getY();
                    ++n;
                }
                lxAbstractPolyline.setPoints(dArray);
            } else {
                if (lxComponent instanceof LxRotatable) {
                    ((LxRotatable)((Object)lxComponent)).rotate(d);
                }
                lxComponent.rotateCenter(d, point2D);
            }
        }

        static /* synthetic */ LxAbstractKnob access$500(Indicator indicator) {
            return indicator.LxAbstractKnob.this;
        }
    }

    private final class Box
    implements Serializable {
        Box() {
            LxAbstractKnob.this.addContainerListener(new LxContainerAdapter(){

                public void componentAdded(LxContainerEvent lxContainerEvent) {
                    LxComponent lxComponent = this.getBox();
                    if (lxComponent == null) {
                        return;
                    }
                    LxComponent lxComponent2 = lxContainerEvent.getComponent();
                    if (lxComponent2.getName().equals(LxAbstractDyno.getPartLabel(1))) {
                        LxAbstractKnob.this._indicator._reshape(((Box)this).LxAbstractKnob.this._variable.toDouble());
                    }
                }
            });
        }

        public LxComponent getBox() {
            LxComponent lxComponent = LxAbstractKnob.this.getFirstChild(1);
            if (lxComponent != null) {
                return lxComponent;
            }
            return LxAbstractKnob.this;
        }

        public double locToVal(double d, double d2) {
            LxComponent lxComponent = this.getBox();
            if (lxComponent == null) {
                return LxAbstractKnob.this._variable.toDouble();
            }
            Point2D point2D = LxAbstractKnob.this._box.getCenter();
            double d3 = 180.0 * Math.atan2(point2D.getY() - d2 - 1.0E-10, d - point2D.getX()) / Math.PI;
            double d4 = this.angleToVal(d3);
            double d5 = LxAbstractKnob.this.getIncrement();
            if (d5 > 0.0) {
                int n = (int)Math.round(d4 / d5);
                return (double)n * d5;
            }
            return d4;
        }

        public double angleToVal(double d) {
            double d2 = LxAbstractKnob.this._angles.getMax();
            double d3 = LxAbstractKnob.this._angles.getMin();
            double d4 = LxAbstractKnob.this._variable.getMinimum();
            double d5 = LxAbstractKnob.this._variable.getMaximum();
            double d6 = d;
            if (d < 0.0 && d < Math.min(d3, d2)) {
                d6 = 360.0 + d;
            } else if (d > 0.0 && d > Math.max(d3, d2)) {
                d6 = d - 360.0;
            }
            double d7 = d5 - (d2 - d6) * (d5 - d4) / (d2 - d3);
            if (d7 < d4 || d7 > d5) {
                double d8 = Math.min(Math.abs(d6 - d2), Math.abs(d - d2));
                d8 = Math.min(d8, Math.abs(d2 - d6 - 360.0));
                double d9 = Math.min(Math.abs(d3 - d6), Math.abs(d - d3));
                d7 = (d9 = Math.min(d9, Math.abs(d3 - d6 - 360.0))) < d8 ? d4 : d5;
            }
            return d7;
        }

        public double valToAngle(double d) {
            LxComponent lxComponent = this.getBox();
            if (lxComponent == null) {
                return LxAbstractKnob.this._angles.getMin();
            }
            double d2 = LxAbstractKnob.this._angles.getMax();
            double d3 = LxAbstractKnob.this._angles.getMin();
            double d4 = LxAbstractKnob.this._variable.getMinimum();
            double d5 = LxAbstractKnob.this._variable.getMaximum();
            double d6 = d;
            if (d < d4) {
                d6 = d4;
            } else if (d > d5) {
                d6 = d5;
            }
            double d7 = d2 - (d2 - d3) * (d5 - d6) / (d5 - d4);
            return d7;
        }

        public Point2D getCenter() {
            LxComponent lxComponent = LxAbstractKnob.this.getFirstChild(1);
            if (lxComponent != null) {
                return lxComponent.getCenter();
            }
            return new Point2D.Double(LxAbstractKnob.this.getCenterX() - LxAbstractKnob.this.getX(), LxAbstractKnob.this.getCenterY() - LxAbstractKnob.this.getY());
        }
    }

    private final class Angles
    implements Serializable {
        private double _min = 0.0;
        private double _max = 90.0;

        private Angles() {
        }

        public double getMax() {
            return this._max;
        }

        public double getMin() {
            return this._min;
        }

        public void setMax(double d) {
            if (this._max != d) {
                this._max = d;
                LxAbstractKnob.this._indicator._reshape(LxAbstractKnob.this._variable.toDouble());
            }
        }

        public void setMin(double d) {
            if (this._min != d) {
                this._min = d;
                LxAbstractKnob.this._indicator._reshape(LxAbstractKnob.this._variable.toDouble());
            }
        }
    }
}

