/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.Arrow;
import com.loox.jloox.Lx;
import com.loox.jloox.LxAbstractCircle;
import com.loox.jloox.LxAbstractGraph;
import com.loox.jloox.LxAbstractPolyline;
import com.loox.jloox.LxAbstractRectangle;
import com.loox.jloox.LxAbstractView;
import com.loox.jloox.LxArrowElement;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxElement;
import com.loox.jloox.LxHandle;
import com.loox.jloox.LxPathElement;
import com.loox.jloox.LxSaveUtils;
import com.loox.jloox.LxShadowElement;
import com.loox.jloox.LxSymmetrical;
import com.loox.jloox.Point2DDouble;
import com.loox.jloox.Shadow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Vector;

public abstract class LxAbstractPolyline
extends LxPathElement
implements Serializable,
LxShadowElement,
LxArrowElement,
LxSymmetrical {
    static final String CLASS_NAME = "LxAbstractPolyline";
    private static boolean actions_inited = false;
    private int _connection;
    private Shadow _shadow;
    private Arrow _arrow;
    static /* synthetic */ Class class$com$loox$jloox$LxPathElement$OpenCloseAction;
    static /* synthetic */ Class class$com$loox$jloox$LxAbstractPolyline;

    public LxAbstractPolyline() {
        this(CLASS_NAME, (LxContainer)null, (double[])null, true);
    }

    public LxAbstractPolyline(LxContainer lxContainer) {
        this(CLASS_NAME, lxContainer, (double[])null, true);
    }

    public LxAbstractPolyline(double[] dArray) {
        this(CLASS_NAME, null, dArray, true);
    }

    public LxAbstractPolyline(LxContainer lxContainer, double[] dArray) {
        this(CLASS_NAME, lxContainer, dArray, true);
    }

    public LxAbstractPolyline(LxAbstractCircle lxAbstractCircle, double d) {
        this(CLASS_NAME, null, lxAbstractCircle, d);
    }

    LxAbstractPolyline(String string, LxContainer lxContainer, double[] dArray, boolean bl) {
        super(string, lxContainer, false);
        if (!actions_inited) {
            actions_inited = true;
            LxComponent.registerActionClass("toggle-open-polyline", class$com$loox$jloox$LxPathElement$OpenCloseAction == null ? (class$com$loox$jloox$LxPathElement$OpenCloseAction = LxAbstractPolyline.class$("com.loox.jloox.LxPathElement$OpenCloseAction")) : class$com$loox$jloox$LxPathElement$OpenCloseAction, class$com$loox$jloox$LxAbstractPolyline == null ? (class$com$loox$jloox$LxAbstractPolyline = LxAbstractPolyline.class$("com.loox.jloox.LxAbstractPolyline")) : class$com$loox$jloox$LxAbstractPolyline);
        }
        this._connection = 0;
        this._shadow = null;
        this._arrow = null;
        this._initObjectVariables();
        LxAbstractGraph lxAbstractGraph = this.getGraph();
        if (lxAbstractGraph != null) {
            this.setLineArrow(lxAbstractGraph.getDefaultLineArrow());
        } else {
            this.setLineArrow(Lx.getDefaultLineArrow());
        }
        if (dArray != null) {
            this.setPoints(dArray);
        }
        if (bl) {
            this._postInitialize();
        }
    }

    LxAbstractPolyline(String string, LxContainer lxContainer, LxComponent lxComponent, double d) {
        super(string, lxContainer, false);
        if (!actions_inited) {
            actions_inited = true;
            LxComponent.registerActionClass("toggle-open-polyline", class$com$loox$jloox$LxPathElement$OpenCloseAction == null ? (class$com$loox$jloox$LxPathElement$OpenCloseAction = LxAbstractPolyline.class$("com.loox.jloox.LxPathElement$OpenCloseAction")) : class$com$loox$jloox$LxPathElement$OpenCloseAction, class$com$loox$jloox$LxAbstractPolyline == null ? (class$com$loox$jloox$LxAbstractPolyline = LxAbstractPolyline.class$("com.loox.jloox.LxAbstractPolyline")) : class$com$loox$jloox$LxAbstractPolyline);
        }
        this._connection = 0;
        this._shadow = null;
        this._arrow = null;
        this._initObjectVariables();
        if (lxComponent instanceof LxAbstractCircle) {
            LxAbstractCircle lxAbstractCircle = (LxAbstractCircle)lxComponent;
            double[] dArray = LxAbstractPolyline._createPolygon(lxAbstractCircle.getWidth() / 2.0, lxAbstractCircle.getHeight() / 2.0, lxAbstractCircle.getCenterX(), lxAbstractCircle.getCenterY(), lxAbstractCircle.getAngleStart(), lxAbstractCircle.getAngleExtent(), d, !lxAbstractCircle.isChordClosed() && lxAbstractCircle.getPaint() != null);
            this.setPoints(dArray);
            this._copyAttributes(lxAbstractCircle);
        } else if (lxComponent instanceof LxAbstractRectangle) {
            LxAbstractRectangle lxAbstractRectangle = (LxAbstractRectangle)lxComponent;
            double d2 = lxAbstractRectangle.getArcWidth() / 2.0;
            double d3 = lxAbstractRectangle.getArcHeight() / 2.0;
            double d4 = lxAbstractRectangle.getX();
            double d5 = lxAbstractRectangle.getY();
            double d6 = lxAbstractRectangle.getWidth();
            double d7 = lxAbstractRectangle.getHeight();
            if (lxAbstractRectangle.isRounded() && d2 > 0.0 && d3 > 0.0) {
                double[] dArray = LxAbstractPolyline._createPolygon(d2, d3, d4 + d2, d5 + d3, 90.0, 90.0, d, false);
                double[] dArray2 = LxAbstractPolyline._createPolygon(d2, d3, d4 + d2, d5 + d7 - d3, 180.0, 90.0, d, false);
                double[] dArray3 = LxAbstractPolyline._createPolygon(d2, d3, d4 + d6 - d2, d5 + d7 - d3, 270.0, 90.0, d, false);
                double[] dArray4 = LxAbstractPolyline._createPolygon(d2, d3, d4 + d6 - d2, d5 + d3, 0.0, 90.0, d, false);
                double[] dArray5 = new double[dArray.length + dArray2.length + dArray3.length + dArray.length];
                int n = 0;
                System.arraycopy(dArray, 0, dArray5, 0, dArray.length);
                System.arraycopy(dArray2, 0, dArray5, n += dArray.length, dArray2.length);
                System.arraycopy(dArray3, 0, dArray5, n += dArray2.length, dArray3.length);
                System.arraycopy(dArray4, 0, dArray5, n += dArray3.length, dArray4.length);
                this.setPoints(dArray5);
                this.setClosed(true);
                this._copyAttributes(lxAbstractRectangle);
            } else {
                double[] dArray = new double[]{d4, d5, d4, d5 + d7, d4 + d6, d5 + d7, d4 + d6, d5};
                this.setPoints(dArray);
                this.setClosed(true);
                this._copyAttributes(lxAbstractRectangle);
            }
        }
        this._postInitialize();
    }

    public Object clone() {
        LxAbstractPolyline lxAbstractPolyline = (LxAbstractPolyline)super.clone();
        if (lxAbstractPolyline == null) {
            return null;
        }
        lxAbstractPolyline._initObjectVariables();
        lxAbstractPolyline.setShadowThickness(this.getShadowThickness());
        lxAbstractPolyline.setInverted(this.isInverted());
        lxAbstractPolyline.setLineArrow(this.getLineArrow());
        return lxAbstractPolyline;
    }

    void _addHandle(LxHandle lxHandle, boolean bl) {
        if (this.getHandleCount() == 0) {
            LxHandle lxHandle2 = new LxHandle(new Point2DDouble());
            lxHandle2.setResizes(false);
            lxHandle2.setVisible(false);
            super._addHandle(lxHandle2, false);
        }
        super._addHandle(lxHandle, bl);
    }

    public void readFromJLX(InputStream inputStream, String string) throws IOException {
        super.readFromJLX(inputStream, string);
        this.setConnectionType(LxSaveUtils.readInt(inputStream));
        LxSaveUtils.readEndOfPart(inputStream);
    }

    public void saveAsJLX(OutputStream outputStream) throws IOException {
        super.saveAsJLX(outputStream);
        LxSaveUtils.writeInt(outputStream, this.getConnectionType());
        LxSaveUtils.writeEndOfPart(outputStream);
    }

    protected void applyAttributes(LxAbstractGraph lxAbstractGraph) {
        super.applyAttributes(lxAbstractGraph);
        this.setLineArrow(lxAbstractGraph.getDefaultLineArrow());
    }

    protected static void createInteractively(Class clazz, LxAbstractView lxAbstractView) {
        lxAbstractView._createInteractively(new PolylineCreation(clazz, lxAbstractView));
    }

    public void setClosed(boolean bl) {
        super.setClosed(bl);
    }

    public void addPoint(Point2D point2D) {
        this.addPoint(point2D.getX(), point2D.getY());
    }

    public void addPoint(double d, double d2) {
        this.addPath(d, d2);
    }

    public int getConnectionType() {
        return this._connection;
    }

    public Point2D getPoint(int n) {
        return this.getPathPoint(n);
    }

    public int getPointCount() {
        return this.getPathPointCount();
    }

    public Point2D[] getPoints() {
        Point2D[] point2DArray = new Point2D[this.getPointCount()];
        int n = 0;
        while (n < point2DArray.length) {
            point2DArray[n] = this.getPoint(n);
            ++n;
        }
        return point2DArray;
    }

    public void insertPoint(Point2D point2D, int n) {
        this.insertPoint(point2D.getX(), point2D.getY(), n);
    }

    public void insertPoint(double d, double d2, int n) {
        this.insertPath(d, d2, n);
    }

    public void removePoint(int n) {
        this.removePath(n);
    }

    public void replacePoint(Point2D point2D, int n) {
        this.replacePoint(point2D.getX(), point2D.getY(), n);
    }

    public void replacePoint(double d, double d2, int n) {
        this.replacePath(d, d2, n);
    }

    public void setPoints(double[] dArray) {
        this.setPath(dArray);
    }

    public void setConnectionType(int n) {
        this._connection = n;
    }

    private void _initObjectVariables() {
        this._shadow = null;
        this._arrow = null;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static double[] _createPolygon(double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl) {
        boolean bl2;
        double d8 = d7 <= 0.0 ? 5.0 : (d7 > 90.0 ? 90.0 : d7);
        double d9 = d5 + d6;
        double[] dArray = new double[740];
        int n = 0;
        int n2 = 0;
        if (bl && d6 != 360.0) {
            dArray[0] = d3;
            dArray[1] = d4;
            n2 = 2;
        }
        double d10 = d3;
        double d11 = d4;
        n = n2;
        double d12 = d5;
        boolean bl3 = true;
        do {
            if (!bl3 || (bl3 = false) || !true) {
                double d13 = d3 + d * Math.cos(Math.toRadians(d12));
                double d14 = d4 - d2 * Math.sin(Math.toRadians(d12));
                if (d13 != d10 || d14 != d11) {
                    dArray[n++] = d13;
                    dArray[n++] = d14;
                    d10 = d13;
                    d11 = d14;
                }
                d12 += d8;
            }
            if (d5 + 360.0 != d9) {
                if (d12 <= d9) {
                    bl2 = true;
                    continue;
                }
                bl2 = false;
                continue;
            }
            bl2 = d12 < d9;
        } while (bl2);
        if (d12 - d8 != d9 && (d5 != 0.0 || d9 != 360.0)) {
            dArray[n++] = d3 + d * Math.cos(Math.toRadians(d9));
            dArray[n++] = d4 - d2 * Math.sin(Math.toRadians(d9));
        }
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        return dArray2;
    }

    private void _copyAttributes(LxElement lxElement) {
        this.setLineColor(lxElement.getLineColor());
        this.setPaint(lxElement.getPaint());
        this.setLineThickness(lxElement.getLineThickness());
        this.setLineDashes(lxElement.getLineDashes());
        this.setLayers(lxElement.getLayers());
        this.setTransparency(lxElement.getTransparency());
        this.setName(lxElement.getName());
        this.setSelectable(lxElement.isSelectable());
        this.setZoomable(lxElement.isZoomable());
        this.setSensitive(lxElement.isSensitive());
        this.setUserMovable(lxElement.isUserMovable());
        this.setUserResizable(lxElement.isUserResizable());
        this.setTrajectory(lxElement.getTrajectory());
        this.setTrajectoryIncrement(lxElement.getTrajectoryIncrement());
        this.setTrajectoryOffset(lxElement.getTrajectoryOffset());
        this.setBlinkingEnabled(lxElement.isBlinkingEnabled());
        this.setVisible(lxElement.isVisible());
        if (lxElement instanceof LxShadowElement) {
            this.setShadowThickness(((LxShadowElement)((Object)lxElement)).getShadowThickness());
            this.setInverted(((LxShadowElement)((Object)lxElement)).isInverted());
        }
    }

    public int getLineArrow() {
        if (this._arrow == null) {
            return 0;
        }
        return this._arrow.getLineArrow();
    }

    public void setLineArrow(int n) {
        if (n == this.getLineArrow()) {
            return;
        }
        if (this._arrow == null) {
            this._arrow = new Arrow(this);
        }
        this._arrow.setLineArrow(n);
        if (this.getLineArrow() == 0) {
            this._arrow = null;
        }
    }

    public double getShadowThickness() {
        if (this._shadow == null) {
            return 0.0;
        }
        return this._shadow.getShadowThickness();
    }

    public boolean isInverted() {
        if (this._shadow == null) {
            return false;
        }
        return this._shadow.isInverted();
    }

    public void setInverted(boolean bl) {
        if (bl == this.isInverted()) {
            return;
        }
        if (this._shadow == null) {
            this._shadow = new Shadow(this);
        }
        this._shadow.setInverted(bl);
        if (!this.isInverted() && this.getShadowThickness() == 0.0) {
            this._shadow = null;
        }
    }

    public void setShadowThickness(double d) {
        if (d == this.getShadowThickness()) {
            return;
        }
        if (this._shadow == null) {
            this._shadow = new Shadow(this);
        }
        this._shadow.setShadowThickness(d);
        if (!this.isInverted() && this.getShadowThickness() == 0.0) {
            this._shadow = null;
        }
    }

    public void flip() {
        super.flip();
    }

    public void mirror() {
        super.mirror();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class PolylineCreation
    extends MouseAdapter
    implements LxElement.InteractiveCreation {
        private MouseListener _current_lstnr = null;
        private MouseMotionListener _motion_lstnr = null;
        private LxAbstractView _view = null;
        private Class _target = null;
        private final Vector _pts = new Vector();
        private final MouseListener _stop_lstnr = new MouseAdapter(this){
            static /* synthetic */ Class class$com$loox$jloox$LxContainer;
            static /* synthetic */ Class array$D;
            private final /* synthetic */ PolylineCreation this$0;
            {
                this.this$0 = polylineCreation;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 4) == 0) {
                    Point2D point2D = PolylineCreation.access$000(this.this$0).applyMagneticGrid(mouseEvent.getPoint());
                    Point point = new Point((int)point2D.getX(), (int)point2D.getY());
                    PolylineCreation.access$100(this.this$0).addElement(point);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 4) != 0) {
                    LxAbstractPolyline lxAbstractPolyline;
                    try {
                        Object object;
                        int n = PolylineCreation.access$100(this.this$0).size();
                        double[] dArray = new double[n * 2];
                        double d = PolylineCreation.access$000(this.this$0).getZoomFactor();
                        int n2 = 0;
                        int n3 = 0;
                        while (n2 < n) {
                            object = (Point2D)PolylineCreation.access$100(this.this$0).elementAt(n2);
                            dArray[n3++] = ((Point2D)object).getX() / d;
                            dArray[n3++] = ((Point2D)object).getY() / d;
                            ++n2;
                        }
                        PolylineCreation.access$100(this.this$0).removeAllElements();
                        object = PolylineCreation.access$200(this.this$0).getConstructor(class$com$loox$jloox$LxContainer == null ? (class$com$loox$jloox$LxContainer = 1.class$("com.loox.jloox.LxContainer")) : class$com$loox$jloox$LxContainer, array$D == null ? (array$D = 1.class$("[D")) : array$D);
                        lxAbstractPolyline = (LxAbstractPolyline)((Constructor)object).newInstance(PolylineCreation.access$000(this.this$0).getGraph(), dArray);
                    }
                    catch (Exception exception) {
                        PolylineCreation.access$000(this.this$0)._finishCreation(null);
                        return;
                    }
                    lxAbstractPolyline.setClosed(true);
                    PolylineCreation.access$000(this.this$0)._finishCreation(lxAbstractPolyline);
                    return;
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        };
        private final MouseMotionListener _drag_lstnr = new MouseMotionAdapter(this){
            private final /* synthetic */ PolylineCreation this$0;
            {
                this.this$0 = polylineCreation;
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                this.mouseDragged(mouseEvent);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                PolylineCreation.access$300(this.this$0);
                PolylineCreation.access$100(this.this$0).removeElementAt(PolylineCreation.access$100(this.this$0).size() - 1);
                Point2D point2D = PolylineCreation.access$000(this.this$0).applyMagneticGrid(mouseEvent.getPoint());
                Point point = new Point((int)point2D.getX(), (int)point2D.getY());
                PolylineCreation.access$100(this.this$0).addElement(point);
                PolylineCreation.access$300(this.this$0);
            }
        };

        PolylineCreation(Class clazz, LxAbstractView lxAbstractView) {
            this._target = clazz;
            this._view = lxAbstractView;
        }

        private void _draw() {
            Graphics graphics = this._view.getGraphics();
            int n = this._pts.size() - 1;
            Point point = (Point)this._pts.elementAt(n - 1);
            Point point2 = (Point)this._pts.elementAt(n);
            graphics.setColor(Color.black);
            Lx.setXORMode(graphics, this._view.getBackground());
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point2D point2D = this._view.applyMagneticGrid(mouseEvent.getPoint());
            Point point = new Point((int)point2D.getX(), (int)point2D.getY());
            this._pts.addElement(point);
            this._pts.addElement(point);
            this._view.removeMouseListener(this._current_lstnr);
            this._current_lstnr = this._stop_lstnr;
            this._view.addMouseListener(this._current_lstnr);
            this._motion_lstnr = this._drag_lstnr;
            this._view.addMouseMotionListener(this._motion_lstnr);
            this._draw();
        }

        public void start() {
            this._current_lstnr = this;
            this._view.addMouseListener(this._current_lstnr);
        }

        public void stop() {
            this._view.removeMouseListener(this._current_lstnr);
            this._current_lstnr = null;
            if (this._motion_lstnr != null) {
                this._view.removeMouseMotionListener(this._motion_lstnr);
                this._motion_lstnr = null;
            }
            int n = this._pts.size() - 1;
            while (n > 0) {
                this._draw();
                this._pts.remove(n);
                --n;
            }
            this._pts.removeAllElements();
        }

        static /* synthetic */ LxAbstractView access$000(PolylineCreation polylineCreation) {
            return polylineCreation._view;
        }

        static /* synthetic */ Vector access$100(PolylineCreation polylineCreation) {
            return polylineCreation._pts;
        }

        static /* synthetic */ Class access$200(PolylineCreation polylineCreation) {
            return polylineCreation._target;
        }

        static /* synthetic */ void access$300(PolylineCreation polylineCreation) {
            polylineCreation._draw();
        }
    }
}

