/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.DialogFrame;
import com.loox.jloox.LxAbstractAction;
import com.loox.jloox.LxAbstractGraph;
import com.loox.jloox.LxAbstractGroup;
import com.loox.jloox.LxAbstractView;
import com.loox.jloox.LxAppearanceEvent;
import com.loox.jloox.LxAppearanceListener;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxComponentAdapter;
import com.loox.jloox.LxComponentEvent;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxContainerEvent;
import com.loox.jloox.LxContainerListener;
import com.loox.jloox.LxElement;
import com.loox.jloox.LxGraph;
import com.loox.jloox.LxLayers;
import com.loox.jloox.LxSaveUtils;
import com.loox.jloox.Resources;
import com.loox.jloox.Util;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class LxAbstractReference
extends LxElement
implements Serializable {
    static final String CLASS_NAME = "LxAbstractReference";
    public static final String SELECT_MODEL_ACTION = "select-model";
    private static Vector _references = null;
    private static boolean actions_inited = false;
    transient LxComponent _ref;
    private transient RefListener _listener;
    static /* synthetic */ Class class$com$loox$jloox$LxAbstractReference$SelectModelAction;
    static /* synthetic */ Class class$com$loox$jloox$LxAbstractReference;

    public LxAbstractReference() {
        this(CLASS_NAME, null, null);
    }

    public LxAbstractReference(LxContainer lxContainer) {
        this(CLASS_NAME, lxContainer, null);
    }

    public LxAbstractReference(LxComponent lxComponent) {
        this(CLASS_NAME, null, lxComponent);
    }

    LxAbstractReference(String string, LxContainer lxContainer, LxComponent lxComponent) {
        super(string, lxContainer, lxComponent != null ? lxComponent.getBounds() : null, false);
        if (!actions_inited) {
            actions_inited = true;
            LxComponent.registerActionClass(SELECT_MODEL_ACTION, class$com$loox$jloox$LxAbstractReference$SelectModelAction == null ? (class$com$loox$jloox$LxAbstractReference$SelectModelAction = LxAbstractReference.class$("com.loox.jloox.LxAbstractReference$SelectModelAction")) : class$com$loox$jloox$LxAbstractReference$SelectModelAction, class$com$loox$jloox$LxAbstractReference == null ? (class$com$loox$jloox$LxAbstractReference = LxAbstractReference.class$("com.loox.jloox.LxAbstractReference")) : class$com$loox$jloox$LxAbstractReference);
        }
        this._ref = null;
        this._listener = null;
        this._initObjectVariables();
        if (lxComponent != null) {
            this._setRef(lxComponent);
        }
        this._postInitialize();
    }

    public Rectangle2D getStrokedBounds2D(Rectangle2D rectangle2D) {
        if (this._ref != null) {
            Rectangle2D rectangle2D2 = this._ref.getStrokedBounds2D();
            double d = this.getCenterX() - this._ref.getCenterX();
            double d2 = this.getCenterY() - this._ref.getCenterY();
            rectangle2D2.setRect(rectangle2D2.getX() + d, rectangle2D2.getY() + d2, rectangle2D2.getWidth(), rectangle2D2.getHeight());
            rectangle2D.setRect(rectangle2D2);
        } else {
            rectangle2D.setRect(0.0, 0.0, 0.0, 0.0);
        }
        return rectangle2D;
    }

    void _paint(Graphics2D graphics2D, AffineTransform affineTransform, LxLayers lxLayers, double d, boolean bl) {
        LxComponent lxComponent = this._ref;
        while (lxComponent instanceof LxAbstractReference) {
            lxComponent = ((LxAbstractReference)lxComponent).getModel();
        }
        if (lxComponent instanceof LxAbstractGroup) {
            AffineTransform affineTransform2 = graphics2D.getTransform();
            graphics2D.transform(affineTransform);
            if (this.prepaint(graphics2D)) {
                double d2;
                double d3;
                graphics2D.setTransform(affineTransform2);
                if (bl) {
                    d3 = this.getX();
                    d2 = this.getY();
                } else if (this.getParent() instanceof LxAbstractGroup) {
                    d3 = (this.getCenterX() - this.getWidth() / 2.0) / d;
                    d2 = (this.getCenterY() - this.getHeight() / 2.0) / d;
                } else {
                    d3 = (this.getCenterX() * d - this.getWidth() / 2.0) / d;
                    d2 = (this.getCenterY() * d - this.getHeight() / 2.0) / d;
                }
                graphics2D.translate(d3, d2);
                LxAbstractView._paintElements((LxAbstractGroup)lxComponent, graphics2D, null, d, true, bl);
                graphics2D.translate(-d3, -d2);
                graphics2D.transform(affineTransform);
            }
            this.postpaint(graphics2D);
            graphics2D.setTransform(affineTransform2);
        } else {
            AffineTransform affineTransform3 = graphics2D.getTransform();
            if (this.prepaint(graphics2D) && lxComponent != null) {
                lxComponent._paint(graphics2D, affineTransform, lxLayers, d, bl);
            }
            this.postpaint(graphics2D);
            graphics2D.setTransform(affineTransform3);
        }
    }

    protected void paintElement(Graphics2D graphics2D) {
    }

    boolean _intersects(double d, double d2, double d3, double d4, LxLayers lxLayers, boolean bl, double d5) {
        if (lxLayers != null && !lxLayers.intersects(this._getLayers())) {
            return false;
        }
        double d6 = this.getCenterX() - this._ref.getCenterX();
        double d7 = this.getCenterY() - this._ref.getCenterY();
        Rectangle2D rectangle2D = this._ref.getBounds2D();
        return this._ref._intersects(d - d6, d2 - d7, d3, d4, null, bl, d5);
    }

    public Object clone() {
        LxAbstractReference lxAbstractReference = (LxAbstractReference)super.clone();
        if (lxAbstractReference == null) {
            return null;
        }
        lxAbstractReference._initObjectVariables();
        lxAbstractReference._setRef(this._ref);
        return lxAbstractReference;
    }

    public void saveAsJLX(OutputStream outputStream) throws IOException {
        super.saveAsJLX(outputStream);
        if (this._ref.getGraph() == this.getGraph()) {
            LxSaveUtils.writeBoolean(outputStream, true);
            LxSaveUtils.writeReference(outputStream, this._ref);
            LxSaveUtils.writeEndOfPart(outputStream);
        } else {
            LxSaveUtils.writeBoolean(outputStream, false);
            LxGraph lxGraph = new LxGraph();
            boolean bl = false;
            if (this._ref.getGraph() == null) {
                lxGraph.add(this._ref);
            } else {
                bl = true;
                LxComponent lxComponent = (LxComponent)this._ref.clone();
                lxGraph.add(lxComponent);
            }
            LxSaveUtils.writeEndOfPart(outputStream);
            LxSaveUtils.writeGroup(outputStream, lxGraph);
            if (!bl) {
                lxGraph.remove(this._ref);
            }
        }
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        if (this._ref != null) {
            super.setBounds(d, d2, this._ref.getWidth(), this._ref.getHeight());
        } else {
            super.setBounds(d, d2, d3, d4);
        }
    }

    public void setSize(double d, double d2) {
        if (this._ref != null) {
            super.setSize(this._ref.getWidth(), this._ref.getHeight());
        } else {
            super.setSize(d, d2);
        }
    }

    public void readFromJLX(InputStream inputStream, String string) throws IOException {
        super.readFromJLX(inputStream, string);
        boolean bl = LxSaveUtils.readBoolean(inputStream);
        if (bl) {
            final String string2 = LxSaveUtils.readReference(inputStream);
            LxSaveUtils.readEndOfPart(inputStream);
            LxSaveUtils.addPostProcessing(new LxSaveUtils.PostProcessing(){
                final LxAbstractReference refObj;
                {
                    this.refObj = LxAbstractReference.this;
                }

                public void run() throws IOException {
                    LxAbstractGraph lxAbstractGraph = this.refObj.getGraph();
                    if (string2.equals("!")) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$100(this.this$1).getParent().remove(this.this$1.refObj);
                            }
                        });
                        return;
                    }
                    LxAbstractReference.this._setRef(LxSaveUtils.getComponentByReference(lxAbstractGraph, string2));
                }

                static /* synthetic */ LxAbstractReference access$100(1 var0) {
                    return var0.LxAbstractReference.this;
                }
            });
        } else {
            LxGraph lxGraph = new LxGraph();
            LxSaveUtils.readEndOfPart(inputStream);
            LxSaveUtils.readContainer(inputStream, lxGraph, string);
            LxComponent lxComponent = lxGraph.getComponent(0);
            lxGraph.remove(0);
            lxGraph = null;
            this._setRef(lxComponent);
        }
    }

    void _attachListeners() {
        if (this._ref != null) {
            if (this._ref instanceof LxElement) {
                ((LxElement)this._ref).addVisualListener(this._listener);
            } else if (this._ref instanceof LxContainer) {
                ((LxContainer)((Object)this._ref)).addAppearanceListener(this._listener);
                ((LxContainer)((Object)this._ref)).addContainerListener(this._listener);
            }
            this._ref.addComponentListener(this._listener);
        }
    }

    void _detachListeners() {
        if (this._ref != null) {
            if (this._ref instanceof LxElement) {
                ((LxElement)this._ref).removeVisualListener(this._listener);
            } else if (this._ref instanceof LxContainer) {
                ((LxContainer)((Object)this._ref)).removeAppearanceListener(this._listener);
                ((LxContainer)((Object)this._ref)).removeContainerListener(this._listener);
            }
            this._ref.removeComponentListener(this._listener);
        }
    }

    void _setRef(LxComponent lxComponent) {
        if (lxComponent != this._ref) {
            if (this._ref != null && this.getParent() != null) {
                this._detachListeners();
            }
            this._ref = lxComponent;
            if (this._ref != null) {
                super.setSize(this._ref.getSize());
                if (this.getParent() != null) {
                    this._attachListeners();
                }
            }
        }
    }

    public void setModel(LxComponent lxComponent) {
        this._setRef(lxComponent);
        this.fireVisualChanged();
    }

    public LxComponent getModel() {
        return this._ref;
    }

    private void _initObjectVariables() {
        this._ref = null;
        this._listener = new RefListener();
        super.setUserResizable(false);
        this.removeDefaultDoubleClickBehavior();
    }

    static void _prepareDnD(LxComponent lxComponent) {
        if (lxComponent instanceof LxContainer) {
            LxContainer lxContainer = (LxContainer)((Object)lxComponent);
            int n = 0;
            while (n < lxContainer.getComponentCount()) {
                LxAbstractReference._prepareDnD(lxContainer.getComponent(n));
                ++n;
            }
        } else if (lxComponent instanceof LxAbstractReference) {
            LxAbstractReference._addReference((LxAbstractReference)lxComponent);
        }
    }

    static void _addReference(LxAbstractReference lxAbstractReference) {
        if (_references == null) {
            _references = new Vector();
        }
        int n = 0;
        while (n < _references.size()) {
            if (_references.get(n) == lxAbstractReference._ref) {
                return;
            }
            ++n;
        }
        _references.add(lxAbstractReference._ref);
    }

    static int _getReferenceIndex(LxAbstractReference lxAbstractReference) {
        if (_references == null) {
            return -1;
        }
        int n = 0;
        while (n < _references.size()) {
            if (_references.get(n) == lxAbstractReference._ref) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static LxComponent _getReference(int n) {
        if (_references == null || n >= _references.size()) {
            return null;
        }
        return (LxComponent)_references.get(n);
    }

    static void _endDnd() {
        if (_references != null) {
            _references.removeAllElements();
            _references = null;
        }
    }

    public void setUserResizable(boolean bl) {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = LxAbstractReference._getReferenceIndex(this);
        if (n == -1) {
            objectOutputStream.writeBoolean(false);
        } else {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeInt(n);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this._initObjectVariables();
        objectInputStream.defaultReadObject();
        boolean bl = objectInputStream.readBoolean();
        if (bl) {
            int n = objectInputStream.readInt();
            this._setRef(LxAbstractReference._getReference(n));
        }
    }

    void _notifyParentChanged(LxContainer lxContainer) {
        if (this.getParent() == null) {
            this._detachListeners();
        } else {
            this._attachListeners();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SelectModelAction
    extends LxAbstractAction
    implements Serializable {
        private static final String ACTION = "select-model";
        private static final String DIALOG_TITLE = "select-modelTitle";
        private static final String DIALOG_QUESTION1_STR = "select-modelQuestion1Label";
        private static final String DIALOG_QUESTION2_STR = "select-modelQuestion2Label";

        SelectModelAction() {
            super("select-model", "Select model", "Select the model component", null, true);
        }

        public void processAction(ActionEvent actionEvent) {
            LxAbstractGraph lxAbstractGraph = LxAbstractReference.this.getGraph();
            if (lxAbstractGraph != null && LxAbstractReference.this._ref.getGraph() == lxAbstractGraph) {
                if (LxAbstractReference.this._ref.getParent() == lxAbstractGraph) {
                    lxAbstractGraph.unselectAll();
                    LxAbstractReference.this._ref.setSelected(true);
                }
            } else {
                String string = Resources.get(DIALOG_TITLE, "Select model");
                if (LxAbstractReference.this._ref.getGraph() == null) {
                    String string2 = Resources.get(DIALOG_QUESTION1_STR, "The model component is not attached to any graph.\nTo you want to attach it to the current graph ?");
                    int n = DialogFrame.showConfirmDialog(Util.getFrame(LxAbstractReference.this.getGraph()), string2, string, 0, 3);
                    if (n == 1) {
                        return;
                    }
                    LxAbstractReference.this.getGraph().add(LxAbstractReference.this._ref);
                    lxAbstractGraph.unselectAll();
                    LxAbstractReference.this._ref.setSelected(true);
                } else {
                    String string3 = Resources.get(DIALOG_QUESTION2_STR, "The model component is not present in the current graph.\nTo you want to create a new copy ?");
                    int n = DialogFrame.showConfirmDialog(Util.getFrame(LxAbstractReference.this.getGraph()), string3, string, 0, 3);
                    if (n == 1) {
                        return;
                    }
                    LxComponent lxComponent = (LxComponent)LxAbstractReference.this._ref.clone();
                    lxAbstractGraph.unselectAll();
                    lxAbstractGraph.add(lxComponent);
                    LxAbstractReference.this._setRef(lxComponent);
                    lxComponent.setSelected(true);
                }
            }
        }
    }

    private class RefListener
    extends LxComponentAdapter
    implements ChangeListener,
    LxAppearanceListener,
    LxContainerListener {
        private RefListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            LxAbstractReference.this.fireVisualChanged();
        }

        public void componentResized(LxComponentEvent lxComponentEvent) {
            LxAbstractReference.super.setSize(((LxComponent)lxComponentEvent.getSource()).getSize());
        }

        public void componentMorphed(LxComponentEvent lxComponentEvent) {
            Rectangle2D rectangle2D = LxAbstractReference.this.getStrokedBounds2D();
            LxAbstractReference.this.fireComponentMorphed(rectangle2D);
        }

        public void componentLayerChanged(LxAppearanceEvent lxAppearanceEvent) {
            LxAbstractReference.this.fireVisualChanged();
        }

        public void componentLocationChanged(LxAppearanceEvent lxAppearanceEvent) {
            LxAbstractReference.this.fireVisualChanged();
        }

        public void componentShapeChanged(LxAppearanceEvent lxAppearanceEvent) {
            LxAbstractReference.this.fireVisualChanged();
        }

        public void componentVisibilityChanged(LxAppearanceEvent lxAppearanceEvent) {
            LxAbstractReference.this.fireVisualChanged();
        }

        public void componentVisualChanged(LxAppearanceEvent lxAppearanceEvent) {
            LxAbstractReference.this.fireVisualChanged();
        }

        public void componentZoomableChanged(LxAppearanceEvent lxAppearanceEvent) {
        }

        public void componentAdded(LxContainerEvent lxContainerEvent) {
            LxAbstractReference.this.fireVisualChanged();
        }

        public void componentRemoved(LxContainerEvent lxContainerEvent) {
            LxAbstractReference.this.fireVisualChanged();
        }

        public void componentRestacked(LxContainerEvent lxContainerEvent) {
            LxAbstractReference.this.fireVisualChanged();
        }
    }
}

