/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.LxAbstractDyno;
import com.loox.jloox.LxAbstractValueDyno;
import com.loox.jloox.LxAbstractView;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxContainerAdapter;
import com.loox.jloox.LxContainerEvent;
import com.loox.jloox.LxMouseAdapter;
import com.loox.jloox.LxMouseEvent;
import com.loox.jloox.LxMouseMotionListener;
import com.loox.jloox.LxSaveUtils;
import com.loox.jloox.LxVariableEvent;
import com.loox.jloox.LxVariableListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public abstract class LxAbstractSlider
extends LxAbstractValueDyno
implements Serializable {
    static final String CLASS_NAME = "LxAbstractSlider";
    private Anchor _anchor = null;
    private Orientation _orientation = null;
    private Box _box = null;
    private Indicator _indicator = null;

    public LxAbstractSlider() {
        this(CLASS_NAME, null, true, true, false);
    }

    public LxAbstractSlider(LxContainer lxContainer) {
        this(CLASS_NAME, lxContainer, true, true, false);
    }

    public LxAbstractSlider(boolean bl, boolean bl2) {
        this(CLASS_NAME, null, bl, bl2, true);
    }

    public LxAbstractSlider(LxContainer lxContainer, boolean bl, boolean bl2) {
        this(CLASS_NAME, lxContainer, bl, bl2, true);
    }

    LxAbstractSlider(String string, LxContainer lxContainer, boolean bl, boolean bl2, boolean bl3) {
        super(string, lxContainer);
        this._initObjectVariables();
        if (bl3) {
            this._orientation.set(bl);
        }
        this._anchor.set(bl2);
        this._postInitialize();
    }

    public Object clone() {
        LxAbstractSlider lxAbstractSlider = (LxAbstractSlider)super.clone();
        if (lxAbstractSlider == null) {
            return null;
        }
        lxAbstractSlider._initObjectVariables();
        lxAbstractSlider.setAnchorTopLeft(this.isAnchorTopLeft());
        lxAbstractSlider._orientation.set(this.isHorizontalSlider());
        return lxAbstractSlider;
    }

    public void readFromJLX(InputStream inputStream, String string) throws IOException {
        super.readFromJLX(inputStream, string);
        boolean[] blArray = LxSaveUtils.readBooleanArray(inputStream, 2);
        this.setAnchorTopLeft(blArray[0]);
        this._orientation.set(blArray[1]);
        LxSaveUtils.readEndOfPart(inputStream);
    }

    public void saveAsJLX(OutputStream outputStream) throws IOException {
        super.saveAsJLX(outputStream);
        boolean[] blArray = new boolean[]{this.isAnchorTopLeft(), this.isHorizontalSlider()};
        LxSaveUtils.writeBooleanArray(outputStream, blArray);
        LxSaveUtils.writeEndOfPart(outputStream);
    }

    public boolean isAnchorTopLeft() {
        return this._anchor._val;
    }

    public boolean isHorizontalSlider() {
        return this._orientation._val;
    }

    public void setAnchorTopLeft(boolean bl) {
        this._anchor.set(bl);
    }

    public void setHorizontalSlider(boolean bl) {
        this._orientation.set(bl);
    }

    private void _initObjectVariables() {
        this._anchor = new Anchor();
        this._orientation = new Orientation();
        this._box = new Box();
        this._indicator = new Indicator();
        final LxMouseAdapter lxMouseAdapter = new LxMouseAdapter(){

            public void mousePressed(LxMouseEvent lxMouseEvent) {
                if (((LxAbstractView)lxMouseEvent.getSource()).getEditMode() == 1 && LxAbstractSlider.this.isInteractive() && (lxMouseEvent.getModifiers() & 0x10) != 0 && (lxMouseEvent.getModifiers() & 8) == 0 && (lxMouseEvent.getModifiers() & 4) == 0 && (lxMouseEvent.getModifiers() & 2) == 0) {
                    LxAbstractSlider.this.startUndoEdit("throw me away!");
                    if (LxAbstractSlider.this.isHorizontalSlider()) {
                        LxAbstractSlider.this._variable.set(LxAbstractSlider.this._box.locToVal(lxMouseEvent.getX2D() - LxAbstractSlider.this.getX()));
                    } else {
                        LxAbstractSlider.this._variable.set(LxAbstractSlider.this._box.locToVal(lxMouseEvent.getY2D() - LxAbstractSlider.this.getY()));
                    }
                    LxAbstractSlider.this.cancelUndoEdit();
                }
            }
        };
        this.addMouseListener(lxMouseAdapter);
        this.addMouseMotionListener(new LxMouseMotionListener(){

            public void mouseDragged(LxMouseEvent lxMouseEvent) {
                lxMouseAdapter.mousePressed(lxMouseEvent);
            }
        });
    }

    private final class Orientation
    implements Serializable {
        private boolean _val = false;
        private boolean _set = false;

        private Orientation() {
        }

        public void set(boolean bl) {
            double d;
            if (this._set && bl == this._val) {
                return;
            }
            this._val = bl;
            if (!this._set && !Double.isNaN(d = LxAbstractSlider.this._indicator._getIndicatorSize())) {
                LxComponent[] lxComponentArray = LxAbstractSlider.this.getChildren(2);
                int n = 0;
                while (n < lxComponentArray.length) {
                    LxAbstractSlider.this._indicator._setBounds(lxComponentArray[n], d);
                    ++n;
                }
            }
            this._set = true;
        }
    }

    private final class Indicator
    implements Serializable {
        Indicator() {
            LxAbstractSlider.this.addContainerListener(new LxContainerAdapter(this){
                private final /* synthetic */ Indicator this$1;
                {
                    this.this$1 = indicator;
                }

                public void componentAdded(LxContainerEvent lxContainerEvent) {
                    if (!Orientation.access$200(LxAbstractSlider.access$100(Indicator.access$300(this.this$1)))) {
                        return;
                    }
                    LxComponent lxComponent = lxContainerEvent.getComponent();
                    if (lxComponent.getName().equals(LxAbstractDyno.getPartLabel(2))) {
                        double d = Indicator.access$400(this.this$1);
                        if (Double.isNaN(d)) {
                            return;
                        }
                        Indicator.access$500(this.this$1, lxComponent, d);
                    }
                }
            });
            LxAbstractSlider.this._variable.addVariableListener(new LxVariableListener(this){
                private final /* synthetic */ Indicator this$1;
                {
                    this.this$1 = indicator;
                }

                public void valueChanged(LxVariableEvent lxVariableEvent) {
                    if (!Orientation.access$200(LxAbstractSlider.access$100(Indicator.access$300(this.this$1)))) {
                        return;
                    }
                    double d = Indicator.access$400(this.this$1);
                    if (Double.isNaN(d)) {
                        return;
                    }
                    LxComponent[] lxComponentArray = Indicator.access$300(this.this$1).getChildren(2);
                    int n = 0;
                    while (n < lxComponentArray.length) {
                        Indicator.access$500(this.this$1, lxComponentArray[n], d);
                        ++n;
                    }
                }
            });
        }

        private double _getIndicatorSize() {
            LxComponent lxComponent = LxAbstractSlider.this._box.getBox();
            if (lxComponent == null) {
                return Double.NaN;
            }
            if (LxAbstractSlider.this.isHorizontalSlider()) {
                return lxComponent.getWidth() * LxAbstractSlider.this._variable.toPercent();
            }
            return lxComponent.getHeight() * LxAbstractSlider.this._variable.toPercent();
        }

        private void _setBounds(LxComponent lxComponent, double d) {
            if (LxAbstractSlider.this.isHorizontalSlider()) {
                double d2 = lxComponent.getX();
                if (!LxAbstractSlider.this.isAnchorTopLeft()) {
                    d2 -= d - lxComponent.getWidth();
                }
                lxComponent.setBounds(d2, lxComponent.getY(), d, lxComponent.getHeight());
            } else {
                double d3 = lxComponent.getY();
                if (!LxAbstractSlider.this.isAnchorTopLeft()) {
                    d3 -= d - lxComponent.getHeight();
                }
                lxComponent.setBounds(lxComponent.getX(), d3, lxComponent.getWidth(), d);
            }
        }

        static /* synthetic */ LxAbstractSlider access$300(Indicator indicator) {
            return indicator.LxAbstractSlider.this;
        }
    }

    private final class Box
    implements Serializable {
        Box() {
            LxAbstractSlider.this.addContainerListener(new LxContainerAdapter(){

                public void componentAdded(LxContainerEvent lxContainerEvent) {
                    if (!LxAbstractSlider.this._orientation._set) {
                        return;
                    }
                    LxComponent lxComponent = this.getBox();
                    if (lxComponent == null) {
                        return;
                    }
                    LxComponent lxComponent2 = lxContainerEvent.getComponent();
                    if (lxComponent2.getName().equals(LxAbstractDyno.getPartLabel(2))) {
                        if (LxAbstractSlider.this.isHorizontalSlider()) {
                            if (LxAbstractSlider.this.isAnchorTopLeft()) {
                                lxComponent2.setX(lxComponent.getX());
                            } else {
                                lxComponent2.setX(lxComponent.getX() + lxComponent.getWidth() - lxComponent2.getWidth());
                            }
                        } else if (LxAbstractSlider.this.isAnchorTopLeft()) {
                            lxComponent2.setY(lxComponent.getY());
                        } else {
                            lxComponent2.setY(lxComponent.getY() + lxComponent.getHeight() - lxComponent2.getHeight());
                        }
                    }
                }
            });
        }

        public LxComponent getBox() {
            return LxAbstractSlider.this.getFirstChild(1);
        }

        public double locToVal(double d) {
            double d2;
            LxComponent lxComponent = this.getBox();
            if (lxComponent == null) {
                return LxAbstractSlider.this._variable.toDouble();
            }
            double d3 = LxAbstractSlider.this._variable.getMinimum();
            double d4 = LxAbstractSlider.this._variable.getMaximum();
            double d5 = LxAbstractSlider.this.isHorizontalSlider() ? (d - lxComponent.getX()) / lxComponent.getWidth() * (d4 - d3) + d3 : (d - lxComponent.getY()) / lxComponent.getHeight() * (d4 - d3) + d3;
            if (d5 < d3) {
                d5 = d3;
            } else if (d5 > d4) {
                d5 = d4;
            }
            if (!LxAbstractSlider.this.isAnchorTopLeft()) {
                d5 = d4 - d5 + d3;
            }
            if ((d2 = LxAbstractSlider.this.getIncrement()) > 0.0) {
                int n = (int)Math.round(d5 / d2);
                return (double)n * d2;
            }
            return d5;
        }
    }

    private final class Anchor
    implements Serializable {
        private boolean _val = true;

        private Anchor() {
        }

        public void set(boolean bl) {
            if (bl == this._val) {
                return;
            }
            this._val = bl;
        }
    }
}

