/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.AnimationListeners;
import com.loox.jloox.CurrentEdit;
import com.loox.jloox.DialogFrame;
import com.loox.jloox.Dimension2DDouble;
import com.loox.jloox.ItemListeners;
import com.loox.jloox.Listener;
import com.loox.jloox.LooxCollapsableEdit;
import com.loox.jloox.LooxUndoableEdit;
import com.loox.jloox.Lx;
import com.loox.jloox.LxAbstractAction;
import com.loox.jloox.LxAbstractGraph;
import com.loox.jloox.LxAbstractToggleAction;
import com.loox.jloox.LxAbstractView;
import com.loox.jloox.LxAncestorAdapter;
import com.loox.jloox.LxAncestorEvent;
import com.loox.jloox.LxAncestorListener;
import com.loox.jloox.LxAnimationListener;
import com.loox.jloox.LxComponentAdapter;
import com.loox.jloox.LxComponentEvent;
import com.loox.jloox.LxComponentListener;
import com.loox.jloox.LxConstants;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxEnterLeaveListener;
import com.loox.jloox.LxHandle;
import com.loox.jloox.LxHandleAdapter;
import com.loox.jloox.LxHandleEvent;
import com.loox.jloox.LxHandleListener;
import com.loox.jloox.LxLayers;
import com.loox.jloox.LxMouseAdapter;
import com.loox.jloox.LxMouseEvent;
import com.loox.jloox.LxMouseListener;
import com.loox.jloox.LxMouseMotionListener;
import com.loox.jloox.LxSaveUtils;
import com.loox.jloox.Point2DDouble;
import com.loox.jloox.Rectangle2DDouble;
import com.loox.jloox.Resources;
import com.loox.jloox.Storage;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;

public abstract class LxComponent
implements ItemSelectable,
Cloneable,
LxConstants,
Serializable {
    static final boolean FINAL_CLASS = true;
    static final boolean SUPER_CLASS = false;
    static final String CLASS_NAME = "LxComponent";
    public static final String BLINK_ACTION = "toggle-blink-enable";
    public static final String MOVABLE_ACTION = "toggle-movable";
    public static final String OPAQUE_ACTION = "toggle-opaque";
    public static final String RESIZABLE_ACTION = "toggle-resizable";
    public static final String LOCK_ACTION = "toggle-lock";
    public static final String SENSITIVE_ACTION = "toggle-sensitive";
    public static final String ZOOMABLE_ACTION = "toggle-zoomable";
    public static final String EDIT_NAME_ACTION = "edit-name";
    public static final String HIDE_ACTION = "hide";
    protected static final String ATTRIBUTES_UNDO = "component-attributesUndo";
    protected static final String BLINK_UNDO = "toggle-blink-enableUndo";
    protected static final String RESHAPE_UNDO = "reshapeUndo";
    protected static final String MOVE_UNDO = "moveUndo";
    protected static final String LOCK_UNDO = "toggle-lockUndo";
    protected static final String MOVABLE_UNDO = "toggle-movableUndo";
    protected static final String NAME_CHANGE_UNDO = "edit-nameUndo";
    protected static final String RESIZABLE_UNDO = "toggle-resizableUndo";
    protected static final String SENSITIVE_UNDO = "toggle-sensitiveUndo";
    protected static final String RESIZE_UNDO = "resizeUndo";
    protected static final String HIDE_UNDO = "hideUndo";
    protected static final String ZOOMABLE_UNDO = "toggle-zoomableUndo";
    private static boolean _keepStandardHandleListener = false;
    private static final LxHandleListener NW_HANDLE_LSTNR = new LxHandleAdapter(){

        public void handleDragged(LxHandleEvent lxHandleEvent) {
            LxComponent lxComponent = lxHandleEvent.getHandle().getComponent();
            double d = lxComponent.getWidth() - lxHandleEvent.getDeltaX();
            double d2 = lxComponent.getHeight() - lxHandleEvent.getDeltaY();
            if (lxComponent.isGhost()) {
                return;
            }
            if (d > 0.0 && d2 > 0.0) {
                lxComponent.setBounds(lxComponent.getX() + lxHandleEvent.getDeltaX(), lxComponent.getY() + lxHandleEvent.getDeltaY(), d, d2);
            }
        }

        public void handleRemoved(LxHandleEvent lxHandleEvent) {
            if (!_keepStandardHandleListener) {
                lxHandleEvent.getHandle().removeHandleListener(this);
            }
        }
    };
    private static final LxHandleListener W_HANDLE_LSTNR = new LxHandleAdapter(){

        public void handleDragged(LxHandleEvent lxHandleEvent) {
            LxComponent lxComponent = lxHandleEvent.getHandle().getComponent();
            double d = lxComponent.getWidth() - lxHandleEvent.getDeltaX();
            if (lxComponent.isGhost()) {
                return;
            }
            if (d > 0.0) {
                lxComponent.setBounds(lxComponent.getX() + lxHandleEvent.getDeltaX(), lxComponent.getY(), d, lxComponent.getHeight());
            }
        }

        public void handleRemoved(LxHandleEvent lxHandleEvent) {
            if (!_keepStandardHandleListener) {
                lxHandleEvent.getHandle().removeHandleListener(this);
            }
        }
    };
    private static final LxHandleListener SW_HANDLE_LSTNR = new LxHandleAdapter(){

        public void handleDragged(LxHandleEvent lxHandleEvent) {
            LxComponent lxComponent = lxHandleEvent.getHandle().getComponent();
            double d = lxComponent.getWidth() - lxHandleEvent.getDeltaX();
            double d2 = lxComponent.getHeight() + lxHandleEvent.getDeltaY();
            if (lxComponent.isGhost()) {
                return;
            }
            if (d > 0.0 && d2 > 0.0) {
                lxComponent.setBounds(lxComponent.getX() + lxHandleEvent.getDeltaX(), lxComponent.getY(), d, d2);
            }
        }

        public void handleRemoved(LxHandleEvent lxHandleEvent) {
            if (!_keepStandardHandleListener) {
                lxHandleEvent.getHandle().removeHandleListener(this);
            }
        }
    };
    private static final LxHandleListener S_HANDLE_LSTNR = new LxHandleAdapter(){

        public void handleDragged(LxHandleEvent lxHandleEvent) {
            LxComponent lxComponent = lxHandleEvent.getHandle().getComponent();
            double d = lxComponent.getHeight() + lxHandleEvent.getDeltaY();
            if (lxComponent.isGhost()) {
                return;
            }
            if (d > 0.0) {
                lxComponent.setHeight(d);
            }
        }

        public void handleRemoved(LxHandleEvent lxHandleEvent) {
            if (!_keepStandardHandleListener) {
                lxHandleEvent.getHandle().removeHandleListener(this);
            }
        }
    };
    private static final LxHandleListener SE_HANDLE_LSTNR = new LxHandleAdapter(){

        public void handleDragged(LxHandleEvent lxHandleEvent) {
            LxComponent lxComponent = lxHandleEvent.getHandle().getComponent();
            double d = lxComponent.getWidth() + lxHandleEvent.getDeltaX();
            double d2 = lxComponent.getHeight() + lxHandleEvent.getDeltaY();
            if (lxComponent.isGhost()) {
                return;
            }
            if (d > 0.0 && d2 > 0.0) {
                lxComponent.setSize(d, d2);
            }
        }

        public void handleRemoved(LxHandleEvent lxHandleEvent) {
            if (!_keepStandardHandleListener) {
                lxHandleEvent.getHandle().removeHandleListener(this);
            }
        }
    };
    private static final LxHandleListener E_HANDLE_LSTNR = new LxHandleAdapter(){

        public void handleDragged(LxHandleEvent lxHandleEvent) {
            LxComponent lxComponent = lxHandleEvent.getHandle().getComponent();
            double d = lxComponent.getWidth() + lxHandleEvent.getDeltaX();
            if (lxComponent.isGhost()) {
                return;
            }
            if (d >= 0.0) {
                lxComponent.setWidth(lxComponent.getWidth() + lxHandleEvent.getDeltaX());
            }
        }

        public void handleRemoved(LxHandleEvent lxHandleEvent) {
            if (!_keepStandardHandleListener) {
                lxHandleEvent.getHandle().removeHandleListener(this);
            }
        }
    };
    private static final LxHandleListener NE_HANDLE_LSTNR = new LxHandleAdapter(){

        public void handleDragged(LxHandleEvent lxHandleEvent) {
            LxComponent lxComponent = lxHandleEvent.getHandle().getComponent();
            double d = lxComponent.getWidth() + lxHandleEvent.getDeltaX();
            double d2 = lxComponent.getHeight() - lxHandleEvent.getDeltaY();
            if (lxComponent.isGhost()) {
                return;
            }
            if (d > 0.0 && d2 > 0.0) {
                lxComponent.setBounds(lxComponent.getX(), lxComponent.getY() + lxHandleEvent.getDeltaY(), d, d2);
            }
        }

        public void handleRemoved(LxHandleEvent lxHandleEvent) {
            if (!_keepStandardHandleListener) {
                lxHandleEvent.getHandle().removeHandleListener(this);
            }
        }
    };
    private static final LxHandleListener N_HANDLE_LSTNR = new LxHandleAdapter(){

        public void handleDragged(LxHandleEvent lxHandleEvent) {
            LxComponent lxComponent = lxHandleEvent.getHandle().getComponent();
            double d = lxComponent.getHeight() - lxHandleEvent.getDeltaY();
            if (lxComponent.isGhost()) {
                return;
            }
            if (d > 0.0) {
                lxComponent.setBounds(lxComponent.getX(), lxComponent.getY() + lxHandleEvent.getDeltaY(), lxComponent.getWidth(), d);
            }
        }

        public void handleRemoved(LxHandleEvent lxHandleEvent) {
            if (!_keepStandardHandleListener) {
                lxHandleEvent.getHandle().removeHandleListener(this);
            }
        }
    };
    private static final LxMouseAdapter POPUP_LSTNR = new LxMouseAdapter(){

        public void mousePopup(LxMouseEvent lxMouseEvent) {
            JPopupMenu jPopupMenu = lxMouseEvent.getLxComponent().getPopupMenu();
            if (jPopupMenu != null) {
                Lx.showPopupMenu(jPopupMenu, lxMouseEvent);
            }
        }
    };
    private static final LxHandleListener HANDLE_LSTNR = new LxHandleAdapter(){

        public void handleMorphed(LxHandleEvent lxHandleEvent) {
            LxComponent lxComponent = lxHandleEvent.getHandle().getComponent();
            if (lxComponent._handles != null && lxHandleEvent.getHandle().getSize() >= lxComponent._handles._max_size) {
                lxComponent._handles._calcMaxSize();
            }
        }

        public void handleRemoved(LxHandleEvent lxHandleEvent) {
            lxHandleEvent.getHandle().removeHandleListener(this);
        }
    };
    private static final LxMouseListener DOUBLE_CLICK_LSTNR = new LxMouseAdapter(){

        public void mouseDoubleClicked(LxMouseEvent lxMouseEvent) {
            Object object = lxMouseEvent.getSource();
            if (object instanceof LxAbstractView && ((LxAbstractView)object).getEditMode() == 1) {
                return;
            }
            LxComponent lxComponent = lxMouseEvent.getLxComponent();
            LxAbstractGraph lxAbstractGraph = lxComponent.getGraph();
            if (lxAbstractGraph != null) {
                lxAbstractGraph.showAttributesDialog(lxComponent);
            }
        }
    };
    private static final PropertyChangeListener LOCK_LSTNR = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("lock")) {
                LxComponent lxComponent = (LxComponent)propertyChangeEvent.getSource();
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                Iterator iterator = lxComponent._actions._list.values().iterator();
                while (iterator.hasNext()) {
                    LxAbstractAction lxAbstractAction = (LxAbstractAction)iterator.next();
                    lxAbstractAction.setAlwaysDisabled(bl);
                }
            }
        }
    };
    private static final LxComponentListener TRAJ_LSTNR = new LxComponentAdapter(){

        public void componentMorphed(LxComponentEvent lxComponentEvent) {
            LxComponent lxComponent = lxComponentEvent.getComponent();
            lxComponent._trajectory._num_segs = 0;
        }
    };
    private static final int ANCS_EV_COUNT = 6;
    private static LxComponentEvent COMP_EV = null;
    private static LxAncestorEvent[] ANCS_EV = new LxAncestorEvent[6];
    private static final Hashtable _registry = new Hashtable();
    private static boolean _comp_ev_used = false;
    private static boolean[] _ancs_ev_used = new boolean[6];
    private static boolean acions_inited = false;
    private boolean _sensitive;
    private boolean _visible;
    private boolean _res_lock;
    private boolean _resizable;
    private boolean _opaque;
    private boolean _blink;
    private boolean _movable;
    private boolean _zoomable;
    private boolean _writable;
    private boolean _ghost;
    private double _center_x;
    private double _center_y;
    private double _width;
    private double _height;
    private String _name;
    private Object _user_data;
    private Properties _properties;
    private Parent _parent;
    private Actions _actions;
    private Selection _selection;
    private ComponentListeners _comp_lstnrs;
    private MouseListeners _mouse_lstnrs;
    private MotionListeners _motion_lstnrs;
    protected Handles _handles;
    private Animation _animation;
    private Popup _popup;
    private CurrentEdit _current_edit;
    private Trajectory _trajectory;
    private Clip _clip;
    private Vector _enterLeaveListeners;
    static /* synthetic */ Class class$com$loox$jloox$LxComponent$BlinkAction;
    static /* synthetic */ Class class$com$loox$jloox$LxComponent;
    static /* synthetic */ Class class$com$loox$jloox$LxComponent$MovableAction;
    static /* synthetic */ Class class$com$loox$jloox$LxComponent$EditNameAction;
    static /* synthetic */ Class class$com$loox$jloox$LxComponent$OpaqueAction;
    static /* synthetic */ Class class$com$loox$jloox$LxComponent$ResizableAction;
    static /* synthetic */ Class class$com$loox$jloox$LxComponent$LockUnlockAction;
    static /* synthetic */ Class class$com$loox$jloox$LxComponent$SensitiveAction;
    static /* synthetic */ Class class$com$loox$jloox$LxComponent$HideAction;
    static /* synthetic */ Class class$com$loox$jloox$LxComponent$ZoomableAction;

    public LxComponent() {
        this(CLASS_NAME, null, null, true);
    }

    LxComponent(String string, LxContainer lxContainer, Rectangle2D rectangle2D, boolean bl) {
        if (!acions_inited) {
            acions_inited = true;
            LxComponent.registerActionClass(BLINK_ACTION, class$com$loox$jloox$LxComponent$BlinkAction == null ? (class$com$loox$jloox$LxComponent$BlinkAction = LxComponent.class$("com.loox.jloox.LxComponent$BlinkAction")) : class$com$loox$jloox$LxComponent$BlinkAction, class$com$loox$jloox$LxComponent == null ? (class$com$loox$jloox$LxComponent = LxComponent.class$("com.loox.jloox.LxComponent")) : class$com$loox$jloox$LxComponent);
            LxComponent.registerActionClass(MOVABLE_ACTION, class$com$loox$jloox$LxComponent$MovableAction == null ? (class$com$loox$jloox$LxComponent$MovableAction = LxComponent.class$("com.loox.jloox.LxComponent$MovableAction")) : class$com$loox$jloox$LxComponent$MovableAction, class$com$loox$jloox$LxComponent == null ? (class$com$loox$jloox$LxComponent = LxComponent.class$("com.loox.jloox.LxComponent")) : class$com$loox$jloox$LxComponent);
            LxComponent.registerActionClass(EDIT_NAME_ACTION, class$com$loox$jloox$LxComponent$EditNameAction == null ? (class$com$loox$jloox$LxComponent$EditNameAction = LxComponent.class$("com.loox.jloox.LxComponent$EditNameAction")) : class$com$loox$jloox$LxComponent$EditNameAction, class$com$loox$jloox$LxComponent == null ? (class$com$loox$jloox$LxComponent = LxComponent.class$("com.loox.jloox.LxComponent")) : class$com$loox$jloox$LxComponent);
            LxComponent.registerActionClass(OPAQUE_ACTION, class$com$loox$jloox$LxComponent$OpaqueAction == null ? (class$com$loox$jloox$LxComponent$OpaqueAction = LxComponent.class$("com.loox.jloox.LxComponent$OpaqueAction")) : class$com$loox$jloox$LxComponent$OpaqueAction, class$com$loox$jloox$LxComponent == null ? (class$com$loox$jloox$LxComponent = LxComponent.class$("com.loox.jloox.LxComponent")) : class$com$loox$jloox$LxComponent);
            LxComponent.registerActionClass(RESIZABLE_ACTION, class$com$loox$jloox$LxComponent$ResizableAction == null ? (class$com$loox$jloox$LxComponent$ResizableAction = LxComponent.class$("com.loox.jloox.LxComponent$ResizableAction")) : class$com$loox$jloox$LxComponent$ResizableAction, class$com$loox$jloox$LxComponent == null ? (class$com$loox$jloox$LxComponent = LxComponent.class$("com.loox.jloox.LxComponent")) : class$com$loox$jloox$LxComponent);
            LxComponent.registerActionClass(LOCK_ACTION, class$com$loox$jloox$LxComponent$LockUnlockAction == null ? (class$com$loox$jloox$LxComponent$LockUnlockAction = LxComponent.class$("com.loox.jloox.LxComponent$LockUnlockAction")) : class$com$loox$jloox$LxComponent$LockUnlockAction, class$com$loox$jloox$LxComponent == null ? (class$com$loox$jloox$LxComponent = LxComponent.class$("com.loox.jloox.LxComponent")) : class$com$loox$jloox$LxComponent);
            LxComponent.registerActionClass(SENSITIVE_ACTION, class$com$loox$jloox$LxComponent$SensitiveAction == null ? (class$com$loox$jloox$LxComponent$SensitiveAction = LxComponent.class$("com.loox.jloox.LxComponent$SensitiveAction")) : class$com$loox$jloox$LxComponent$SensitiveAction, class$com$loox$jloox$LxComponent == null ? (class$com$loox$jloox$LxComponent = LxComponent.class$("com.loox.jloox.LxComponent")) : class$com$loox$jloox$LxComponent);
            LxComponent.registerActionClass(HIDE_ACTION, class$com$loox$jloox$LxComponent$HideAction == null ? (class$com$loox$jloox$LxComponent$HideAction = LxComponent.class$("com.loox.jloox.LxComponent$HideAction")) : class$com$loox$jloox$LxComponent$HideAction, class$com$loox$jloox$LxComponent == null ? (class$com$loox$jloox$LxComponent = LxComponent.class$("com.loox.jloox.LxComponent")) : class$com$loox$jloox$LxComponent);
            LxComponent.registerActionClass(ZOOMABLE_ACTION, class$com$loox$jloox$LxComponent$ZoomableAction == null ? (class$com$loox$jloox$LxComponent$ZoomableAction = LxComponent.class$("com.loox.jloox.LxComponent$ZoomableAction")) : class$com$loox$jloox$LxComponent$ZoomableAction, class$com$loox$jloox$LxComponent == null ? (class$com$loox$jloox$LxComponent = LxComponent.class$("com.loox.jloox.LxComponent")) : class$com$loox$jloox$LxComponent);
        }
        this._sensitive = true;
        this._visible = true;
        this._res_lock = false;
        this._resizable = true;
        this._opaque = false;
        this._blink = false;
        this._movable = true;
        this._zoomable = true;
        this._writable = true;
        this._ghost = false;
        this._center_x = 0.0;
        this._center_y = 0.0;
        this._width = 0.0;
        this._height = 0.0;
        this._name = "???";
        this._user_data = null;
        this._properties = null;
        this._parent = null;
        this._actions = null;
        this._selection = null;
        this._comp_lstnrs = null;
        this._mouse_lstnrs = null;
        this._motion_lstnrs = null;
        this._handles = null;
        this._animation = null;
        this._popup = null;
        this._current_edit = null;
        this._trajectory = null;
        this._clip = null;
        this._enterLeaveListeners = null;
        this._name = string;
        this._initObjectVariables();
        if (rectangle2D != null) {
            this.setBounds(rectangle2D);
        }
        if (lxContainer != null) {
            this._parent.set(lxContainer);
        }
        if (bl) {
            this._postInitialize();
        }
    }

    public Object clone() {
        try {
            LxComponent lxComponent = (LxComponent)super.clone();
            lxComponent._initObjectVariables();
            lxComponent.setSelectable(this.isSelectable());
            lxComponent.setBounds(this.getBounds2D());
            lxComponent.setZoomable(this.isZoomable());
            lxComponent.setLocked(false);
            lxComponent.setSelected(false);
            lxComponent.setTrajectoryIncrement(this.getTrajectoryIncrement());
            lxComponent.setTrajectoryOffset(this.getTrajectoryOffset());
            lxComponent.setTrajectory(this.getTrajectory());
            lxComponent.doTrajectoryStep(this.getTrajectoryStep());
            lxComponent.setClipComponent(this.getClipComponent());
            return lxComponent;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return this.getName();
    }

    protected static Class getActionClass(String string, Class clazz) {
        Class clazz2 = clazz;
        while (clazz2 != null) {
            Class clazz3;
            Hashtable hashtable = (Hashtable)_registry.get(clazz2);
            if (hashtable != null && (clazz3 = (Class)hashtable.get(string)) != null) {
                return clazz3;
            }
            clazz2 = clazz2.getSuperclass();
        }
        return null;
    }

    protected static void registerActionClass(String string, Class clazz, Class clazz2) {
        Hashtable<String, Class> hashtable = (Hashtable<String, Class>)_registry.get(clazz2);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Class>();
            _registry.put(clazz2, hashtable);
        }
        hashtable.put(string, clazz);
    }

    public void addAncestorListener(LxAncestorListener lxAncestorListener) {
        this._parent.addListener(lxAncestorListener);
    }

    public void addAnimationListener(LxAnimationListener lxAnimationListener) {
        if (this._animation == null) {
            this._animation = new Animation();
        }
        this._animation.add(lxAnimationListener);
    }

    public void addComponentListener(LxComponentListener lxComponentListener) {
        this._comp_lstnrs.add(lxComponentListener);
    }

    public void addHandle(LxHandle lxHandle) {
        this._addHandle(lxHandle, true);
    }

    public void addMouseListener(LxMouseListener lxMouseListener) {
        if (this._mouse_lstnrs == null) {
            this._mouse_lstnrs = new MouseListeners();
        }
        this._mouse_lstnrs.add(lxMouseListener);
    }

    public void addMouseMotionListener(LxMouseMotionListener lxMouseMotionListener) {
        if (this._motion_lstnrs == null) {
            this._motion_lstnrs = new MotionListeners();
        }
        this._motion_lstnrs.add(lxMouseMotionListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._properties == null) {
            this._properties = new Properties();
        }
        this._properties.addListener(propertyChangeListener);
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        if (this._current_edit == null) {
            this._current_edit = new CurrentEdit(this);
        }
        this._current_edit.addUndoableEditListener(undoableEditListener);
    }

    public final void applyAttributesToSelection(LxAbstractGraph lxAbstractGraph) {
        this.startUndoEdit(Resources.get(ATTRIBUTES_UNDO, "component attributes"));
        this.applyAttributes(lxAbstractGraph);
        this.finishUndoEdit();
    }

    public boolean contains(double d, double d2) {
        return this.intersects(d - 0.5, d2 - 0.5, 1.0, 1.0);
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public void doNextTrajectoryStep() {
        if (this._animation == null) {
            return;
        }
        this._animation.nextStep();
    }

    public void doTrajectoryStep(double d) {
        if (this._animation == null) {
            return;
        }
        this._animation.doStep(d);
    }

    public LxAbstractAction getAction(String string) {
        if (this._actions == null) {
            this._actions = new Actions();
        }
        return this._actions.get(string, this.getClass());
    }

    public LxAbstractAction[] getActions() {
        if (this._actions == null) {
            this._actions = new Actions();
        }
        return this._actions.toArray(this.getClass());
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public Rectangle2D getBounds2D() {
        return this.getBounds2D(new Rectangle2DDouble());
    }

    public Rectangle2D getBounds2D(Rectangle2D rectangle2D) {
        rectangle2D.setRect(this._center_x - this._width / 2.0, this._center_y - this._height / 2.0, this._width, this._height);
        return rectangle2D;
    }

    public Point2D getCenter() {
        return this.getCenter(new Point2DDouble());
    }

    public Point2D getCenter(Point2D point2D) {
        point2D.setLocation(this.getCenterX(), this.getCenterY());
        return point2D;
    }

    public double getCenterX() {
        return this._center_x;
    }

    public double getCenterY() {
        return this._center_y;
    }

    public LxComponent getClipComponent() {
        if (this._clip == null) {
            return null;
        }
        return this._clip._val;
    }

    public LxAbstractGraph getGraph() {
        LxContainer lxContainer = this.getParent();
        while (lxContainer != null && !(lxContainer instanceof LxAbstractGraph)) {
            lxContainer = ((LxComponent)((Object)lxContainer)).getParent();
        }
        return (LxAbstractGraph)lxContainer;
    }

    public LxHandle getHandle(int n) {
        if (this._handles == null) {
            this._handles = new Handles();
        }
        return this._handles.get(n);
    }

    public int getHandleCount() {
        if (this._handles == null) {
            this._handles = new Handles();
        }
        return this._handles.getCount();
    }

    public int getHandleIndex(LxHandle lxHandle) {
        if (this._handles == null) {
            this._handles = new Handles();
        }
        return this._handles.getIndex(lxHandle);
    }

    public LxHandle[] getHandles() {
        if (this._handles == null) {
            this._handles = new Handles();
        }
        return this._handles.toArray();
    }

    public double getHeight() {
        return this._height;
    }

    public abstract boolean getLayer(int var1);

    public abstract LxLayers getLayers();

    public Point2D getLocation() {
        return this.getLocation(new Point2DDouble());
    }

    public Point2D getLocation(Point2D point2D) {
        point2D.setLocation(this.getX(), this.getY());
        return point2D;
    }

    public int getMaxHandleSize() {
        if (this._handles == null) {
            this._handles = new Handles();
        }
        return this._handles.getMaxSize();
    }

    public String getName() {
        return this._name;
    }

    public LxContainer getParent() {
        return this._parent._val;
    }

    public JPopupMenu getPopupMenu() {
        if (this._popup == null) {
            return null;
        }
        return this._popup._value;
    }

    public Dimension2D getSize() {
        return this.getSize(new Dimension2DDouble(0.0, 0.0));
    }

    public Dimension2D getSize(Dimension2D dimension2D) {
        dimension2D.setSize(this.getWidth(), this.getHeight());
        return dimension2D;
    }

    public Rectangle2D getStrokedBounds2D() {
        return this.getStrokedBounds2D(new Rectangle2DDouble());
    }

    public abstract Rectangle2D getStrokedBounds2D(Rectangle2D var1);

    public LxContainer getTopLevelAncestor() {
        LxContainer lxContainer;
        LxContainer lxContainer2 = lxContainer = this.getParent();
        while (lxContainer2 != null) {
            lxContainer = lxContainer2;
            lxContainer2 = lxContainer2 instanceof LxComponent ? ((LxComponent)((Object)lxContainer2)).getParent() : null;
        }
        return lxContainer;
    }

    public LxComponent getTrajectory() {
        if (this._animation == null) {
            return null;
        }
        return this._animation._traj;
    }

    public Point2D getTrajectoryLocation(double d) {
        return this.getTrajectoryLocation(d, new Point2DDouble());
    }

    public Point2D getTrajectoryLocation(double d, Point2D point2D) {
        if (this._trajectory == null) {
            this._trajectory = new Trajectory();
        }
        return this._trajectory.get(this.getTrajectoryShape(), d, point2D);
    }

    public double getTrajectoryIncrement() {
        if (this._animation == null) {
            return 0.05;
        }
        return this._animation._inc;
    }

    public Point2D getTrajectoryOffset() {
        return this.getTrajectoryOffset(new Point2DDouble());
    }

    public Point2D getTrajectoryOffset(Point2D point2D) {
        if (this._animation == null) {
            point2D.setLocation(0.0, 0.0);
            return point2D;
        }
        point2D.setLocation(this._animation._offset_x, this._animation._offset_y);
        return point2D;
    }

    public double getTrajectoryStep() {
        if (this._animation == null) {
            return 0.0;
        }
        return this._animation._step;
    }

    public Object getUserData() {
        return this._user_data;
    }

    public double getWidth() {
        return this._width;
    }

    public double getX() {
        return this._center_x - this._width / 2.0;
    }

    public double getY() {
        return this._center_y - this._height / 2.0;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.intersects(d, d2, d3, d4, null);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), null);
    }

    public boolean intersects(Rectangle2D rectangle2D, LxAbstractView lxAbstractView) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), lxAbstractView);
    }

    public boolean intersects(double d, double d2, double d3, double d4, LxAbstractView lxAbstractView) {
        LxLayers lxLayers = lxAbstractView != null ? lxAbstractView.getLayers() : null;
        boolean bl = lxAbstractView != null ? lxAbstractView.getZoomLines() : false;
        double d5 = lxAbstractView != null ? lxAbstractView.getZoomFactor() : 1.0;
        return this._intersects(d, d2, d3, d4, lxLayers, bl, d5);
    }

    public boolean isBlinkingEnabled() {
        return this._blink;
    }

    public boolean isDefaultDoubleClickBehaviorEnabled() {
        if (this._mouse_lstnrs == null) {
            this._mouse_lstnrs = new MouseListeners();
        }
        return this._mouse_lstnrs._double_click != null;
    }

    public boolean isLocked() {
        return this._res_lock;
    }

    public abstract boolean isOnLayer(LxLayers var1);

    public boolean isOpaque() {
        return this._opaque;
    }

    public boolean isSelectable() {
        return this._selection._selectable;
    }

    public boolean isSelected() {
        return this._selection._val;
    }

    public boolean isSensitive() {
        return this._sensitive;
    }

    public boolean isUserMovable() {
        return this._movable;
    }

    public boolean isUserResizable() {
        return this._resizable;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public boolean isZoomable() {
        return this._zoomable;
    }

    public boolean isWritable() {
        return this._writable;
    }

    public void paintHandles(Graphics2D graphics2D) {
        this.paintHandles(graphics2D, this.getCenterX(), this.getCenterY(), this.getWidth(), this.getHeight());
    }

    public void paintHandles(Graphics2D graphics2D, double d, double d2, double d3, double d4) {
        this.paintStandardHandles(graphics2D, d, d2, d3, d4);
    }

    public void paintStandardHandles(Graphics2D graphics2D, double d, double d2, double d3, double d4) {
        int n = this.getHandleCount();
        AffineTransform affineTransform = new AffineTransform();
        AffineTransform affineTransform2 = graphics2D.getTransform();
        Point2DDouble point2DDouble = new Point2DDouble();
        int n2 = 0;
        while (n2 < n) {
            LxHandle lxHandle = this.getHandle(n2);
            if (lxHandle._isCurrentlyVisible()) {
                lxHandle.getCenter(point2DDouble);
                ((Point2D)point2DDouble).setLocation(((Point2D)point2DDouble).getX() * d3, ((Point2D)point2DDouble).getY() * d4);
                affineTransform.translate((int)(d + ((Point2D)point2DDouble).getX() + 0.5), (int)(d2 + ((Point2D)point2DDouble).getY() + 0.5));
                graphics2D.transform(affineTransform);
                lxHandle._paint(graphics2D);
                graphics2D.setTransform(affineTransform2);
                affineTransform.setToIdentity();
            }
            ++n2;
        }
    }

    public void readFromJLX(InputStream inputStream, String string) throws IOException {
        String string2 = LxSaveUtils.readName(inputStream);
        if (string2 != null) {
            this.setName(string2);
        }
        boolean[] blArray = LxSaveUtils.readBooleanArray(inputStream, 9);
        this.setVisible(blArray[0]);
        this.setZoomable(blArray[1]);
        this.setUserResizable(blArray[2]);
        this.setUserMovable(blArray[3]);
        this.setLocked(blArray[4]);
        this.setSensitive(blArray[5]);
        this.setSelectable(blArray[6]);
        this.setBlinkingEnabled(blArray[7]);
        this.setOpaque(blArray[8]);
        this.setBounds(LxSaveUtils.readRectangle2D(inputStream));
        this.setTrajectoryIncrement(0.01 * LxSaveUtils.readDouble(inputStream));
        final double d = 0.01 * LxSaveUtils.readDouble(inputStream);
        this.setTrajectoryOffset(LxSaveUtils.readPoint2D(inputStream));
        final String string3 = LxSaveUtils.readReference(inputStream);
        final String string4 = string.compareTo("1.1.1") >= 0 ? LxSaveUtils.readReference(inputStream) : null;
        if (string3 != null || string4 != null) {
            LxSaveUtils.addPostProcessing(new LxSaveUtils.PostProcessing(){
                private final LxComponent comp;
                {
                    this.comp = LxComponent.this;
                }

                public void run() throws IOException {
                    if (string3 != null) {
                        this.comp.setTrajectory(LxSaveUtils.getComponentByReference(this.comp.getGraph(), string3));
                        this.comp.doTrajectoryStep(d);
                    }
                    if (string4 != null) {
                        this.comp.setClipComponent(LxSaveUtils.getComponentByReference(this.comp.getGraph(), string4));
                    }
                }
            });
        }
        boolean bl = false;
        bl = string.compareTo("2.0.0") >= 0 ? LxSaveUtils.readBoolean(inputStream) : false;
        this.setGhost(bl);
        LxSaveUtils.readEndOfPart(inputStream);
    }

    public void removeAncestorListener(LxAncestorListener lxAncestorListener) {
        if (this._parent != null) {
            this._parent.removeListener(lxAncestorListener);
        }
    }

    public void removeAnimationListener(LxAnimationListener lxAnimationListener) {
        this._animation.remove(lxAnimationListener);
    }

    public void removeComponentListener(LxComponentListener lxComponentListener) {
        this._comp_lstnrs.remove(lxComponentListener);
    }

    public void removeDefaultDoubleClickBehavior() {
        if (this._mouse_lstnrs == null) {
            this._mouse_lstnrs = new MouseListeners();
        }
        this._mouse_lstnrs.removeDoubleClick();
    }

    public void removeDefaultPopupBehavior() {
        if (this._popup == null) {
            this._popup = new Popup();
        }
        this._popup.removeListener();
    }

    public void removeAllHandles() {
        this.removeAllHandles(false);
    }

    public void removeAllHandles(boolean bl) {
        if (this._handles == null) {
            this._handles = new Handles();
        }
        _keepStandardHandleListener = bl;
        this._handles.removeAll();
    }

    public void removeHandle(LxHandle lxHandle) {
        this.removeHandle(lxHandle, false);
    }

    public void removeHandle(LxHandle lxHandle, boolean bl) {
        if (this._handles == null) {
            throw new IllegalArgumentException("handle doesn't exists");
        }
        _keepStandardHandleListener = bl;
        this._handles.remove(lxHandle);
    }

    public void removeMouseListener(LxMouseListener lxMouseListener) {
        if (this._mouse_lstnrs == null) {
            throw new IllegalArgumentException("listener doesn't exists");
        }
        this._mouse_lstnrs.remove(lxMouseListener);
    }

    public void removeMouseMotionListener(LxMouseMotionListener lxMouseMotionListener) {
        if (this._motion_lstnrs == null) {
            throw new IllegalArgumentException("listener doesn't exists");
        }
        this._motion_lstnrs.remove(lxMouseMotionListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._properties == null) {
            throw new IllegalArgumentException("listener doesn't exists");
        }
        this._properties.removeListener(propertyChangeListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        if (this._current_edit != null) {
            this._current_edit.removeUndoableEditListener(undoableEditListener);
            if (this._getUndoListenerCount() == 0) {
                this._current_edit = null;
            }
        }
    }

    public void rotateCenter(double d, Point2D point2D) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d, point2D.getX(), point2D.getY());
        this.setCenter(affineTransform.transform(this.getCenter(), null));
    }

    public void saveAsJLX(OutputStream outputStream) throws IOException {
        LxSaveUtils.writeName(outputStream, this);
        boolean[] blArray = new boolean[]{this.isVisible(), this.isZoomable(), this.isUserResizable(), this.isUserMovable(), this.isLocked(), this.isSensitive(), this.isSelectable(), this.isBlinkingEnabled(), this.isOpaque()};
        LxSaveUtils.writeBooleanArray(outputStream, blArray);
        LxSaveUtils.writeRectangle2D(outputStream, this.getBounds2D());
        LxSaveUtils.writeDouble(outputStream, 100.0 * this.getTrajectoryIncrement());
        LxSaveUtils.writeDouble(outputStream, 100.0 * this.getTrajectoryStep());
        LxSaveUtils.writePoint2D(outputStream, this.getTrajectoryOffset());
        LxSaveUtils.writeReference(outputStream, this.getTrajectory());
        LxSaveUtils.writeReference(outputStream, this.getClipComponent());
        LxSaveUtils.writeBoolean(outputStream, this.isGhost());
        LxSaveUtils.writeEndOfPart(outputStream);
    }

    public void setBounds(Rectangle2D rectangle2D) {
        this.setBounds(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this._setBounds(d, d2, d3, d4, true);
    }

    public void setBlinkingEnabled(boolean bl) {
        this._setBlinkingEnabled(bl, true);
    }

    public void setCenter(Point2D point2D) {
        this.setCenter(point2D.getX(), point2D.getY());
    }

    public void setCenter(double d, double d2) {
        this._setCenter(d, d2, true);
    }

    public void setCenterX(double d) {
        this.setCenter(d, this.getCenterY());
    }

    public void setCenterY(double d) {
        this.setCenter(this.getCenterX(), d);
    }

    public void setClipComponent(LxComponent lxComponent) {
        if (lxComponent == this.getClipComponent()) {
            return;
        }
        if (this._clip == null) {
            this._clip = new Clip();
        }
        this._clip.set(lxComponent);
        if (this._clip._val == null) {
            this._clip = null;
        }
    }

    public void setHeight(double d) {
        this.setSize(this.getWidth(), d);
    }

    public abstract void setLayer(int var1, boolean var2);

    public abstract void setLayers(LxLayers var1);

    public void setLocation(Point2D point2D) {
        this.setLocation(point2D.getX(), point2D.getY());
    }

    public void setLocation(double d, double d2) {
        this.setCenter(d + this.getWidth() / 2.0, d2 + this.getHeight() / 2.0);
    }

    public void setLocked(boolean bl) {
        this._setLocked(bl, true);
    }

    public void setName(String string) {
        this._setName(string, true);
    }

    public void setOpaque(boolean bl) {
        if (bl == this._opaque) {
            return;
        }
        this._opaque = bl;
        this._setActionState(OPAQUE_ACTION, bl);
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        if (jPopupMenu == this.getPopupMenu()) {
            return;
        }
        if (this._popup == null) {
            this._popup = new Popup();
        }
        this._popup.set(jPopupMenu);
    }

    public void setSize(Dimension2D dimension2D) {
        this.setSize(dimension2D.getWidth(), dimension2D.getHeight());
    }

    public void setSize(double d, double d2) {
        this._setSize(d, d2, true);
    }

    public void setSelectable(boolean bl) {
        this._selection.setSelectable(bl);
    }

    public void setSelected(boolean bl) {
        this._selection.set(bl);
    }

    public void setSensitive(boolean bl) {
        this._setSensitive(bl, true);
    }

    public void setTrajectory(LxComponent lxComponent) {
        if (lxComponent == this.getTrajectory()) {
            return;
        }
        if (this._animation == null) {
            this._animation = new Animation();
        }
        this._animation.setTarget(lxComponent);
    }

    public void setTrajectoryIncrement(double d) {
        if (d == this.getTrajectoryIncrement()) {
            return;
        }
        if (this._animation == null) {
            this._animation = new Animation();
        }
        this._animation.setIncrement(d);
    }

    public void setTrajectoryOffset(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException("bad trajectory offset");
        }
        this.setTrajectoryOffset(point2D.getX(), point2D.getY());
    }

    public void setTrajectoryOffset(double d, double d2) {
        Point2D point2D = this.getTrajectoryOffset();
        if (d == point2D.getX() && d2 == point2D.getY()) {
            return;
        }
        if (this._animation == null) {
            this._animation = new Animation();
        }
        this._animation.setOffset(d, d2);
    }

    public void setUserData(Object object) {
        Object object2 = this._user_data;
        if (object == object2) {
            return;
        }
        this._user_data = object;
        this._firePropertyChanged("userData", object2, object);
    }

    public void setUserMovable(boolean bl) {
        this._setUserMovable(bl, true);
    }

    public void setUserResizable(boolean bl) {
        this._setUserResizable(bl, true);
    }

    public void setVisible(boolean bl) {
        this._setVisible(bl, true);
    }

    public void setWidth(double d) {
        this.setSize(d, this.getHeight());
    }

    public void setX(double d) {
        this.setCenter(d + this.getWidth() / 2.0, this.getCenterY());
    }

    public void setY(double d) {
        this.setCenter(this.getCenterX(), d + this.getHeight() / 2.0);
    }

    public void setZoomable(boolean bl) {
        this._setZoomable(bl, true);
    }

    public void setWritable(boolean bl) {
        this._writable = bl;
    }

    public void setGhost(boolean bl) {
        this._ghost = bl;
    }

    public boolean isGhost() {
        return this._ghost;
    }

    void _addHandle(LxHandle lxHandle) {
        this._addHandle(lxHandle, false);
    }

    void _addHandle(LxHandle lxHandle, boolean bl) {
        if (this._handles == null) {
            this._handles = new Handles();
        }
        this._handles.add(lxHandle, bl);
    }

    void _addNotify(LxContainer lxContainer) {
        this._parent.set(lxContainer);
    }

    boolean _intersects(double d, double d2, double d3, double d4, LxLayers lxLayers, boolean bl, double d5) {
        if (this.isGhost()) {
            return false;
        }
        if (this.isOpaque()) {
            return this.getBounds2D().intersects(d, d2, d3, d4);
        }
        return false;
    }

    abstract void _paint(Graphics2D var1, AffineTransform var2, LxLayers var3, double var4, boolean var6);

    void _fireBlinkStateChanged(LxComponent lxComponent) {
        Boolean bl;
        Boolean bl2;
        if (this.isBlinkingEnabled()) {
            bl2 = Boolean.FALSE;
            bl = Boolean.TRUE;
        } else {
            bl2 = Boolean.TRUE;
            bl = Boolean.FALSE;
        }
        this._firePropertyChanged("blink", lxComponent, bl2, bl);
    }

    void _fireImagePostAnimation() {
        if (this._animation != null && this._animation._lstnrs != null) {
            this._animation._lstnrs.fireImagePostAnimation(this);
        }
    }

    void _fireImagePreAnimation() {
        if (this._animation != null && this._animation._lstnrs != null) {
            this._animation._lstnrs.fireImagePreAnimation(this);
        }
    }

    void _fireMouseDoubleClicked(MouseEvent mouseEvent, double d, double d2) {
        if (this._mouse_lstnrs == null) {
            this._mouse_lstnrs = new MouseListeners();
        }
        this._mouse_lstnrs.fireDoubleClicked(mouseEvent, d, d2);
    }

    void _fireMouseDragged(MouseEvent mouseEvent, double d, double d2, double d3, double d4) {
        if (this._motion_lstnrs == null) {
            return;
        }
        this._motion_lstnrs.fireDragged(mouseEvent, d, d2, d3, d4);
    }

    void _fireMousePopup(MouseEvent mouseEvent, double d, double d2) {
        if (this._mouse_lstnrs == null) {
            return;
        }
        this._mouse_lstnrs.firePopup(mouseEvent, d, d2);
    }

    void _fireMousePressed(MouseEvent mouseEvent, double d, double d2) {
        if (this._mouse_lstnrs == null) {
            return;
        }
        this._mouse_lstnrs.firePressed(mouseEvent, d, d2);
    }

    void _fireMouseReleased(MouseEvent mouseEvent, double d, double d2) {
        if (this._mouse_lstnrs == null) {
            return;
        }
        this._mouse_lstnrs.fireReleased(mouseEvent, d, d2);
    }

    void _firePostBlink() {
        if (this._animation != null && this._animation._lstnrs != null) {
            this._animation._lstnrs.firePostBlink(this);
        }
    }

    void _firePreBlink() {
        if (this._animation != null && this._animation._lstnrs != null) {
            this._animation._lstnrs.firePreBlink(this);
        }
    }

    void _firePropertyChanged(String string, Object object, Object object2) {
        this._firePropertyChanged(string, this, object, object2);
    }

    int _getInitialHandleCount() {
        return 9;
    }

    abstract LxLayers _getLayers();

    Rectangle2D _getStrokedBounds2D() {
        return this.getStrokedBounds2D();
    }

    int _getUndoListenerCount() {
        if (this._current_edit == null) {
            return 0;
        }
        return this._current_edit.getListenerCount();
    }

    boolean _handlesCreated() {
        return this._handles != null && this._handles._list != null;
    }

    void _postInitialize() {
        LxContainer lxContainer = this.getParent();
        if (lxContainer != null) {
            this._parent._val = null;
            lxContainer.add(this);
        }
    }

    void _removeNotify() {
        this._parent.set(null);
    }

    void _setActionEnabled(String string, boolean bl) {
        if (this._actions == null) {
            return;
        }
        this._actions.setActionEnabled(string, bl);
    }

    void _setActionState(String string, boolean bl) {
        if (this._actions == null) {
            return;
        }
        this._actions.setActionState(string, bl);
    }

    boolean _undoOn() {
        return this._getUndoListenerCount() > 0;
    }

    protected void addStandardHandles() {
        Point2DDouble point2DDouble = new Point2DDouble();
        ((Point2D)point2DDouble).setLocation(0.0, 0.0);
        LxHandle lxHandle = new LxHandle(point2DDouble);
        lxHandle.setVisible(false);
        lxHandle.setResizes(false);
        lxHandle.setLinkable(true);
        this._addHandle(lxHandle);
        ((Point2D)point2DDouble).setLocation(-0.5, -0.5);
        lxHandle = new LxHandle(point2DDouble);
        lxHandle.setFlyoverCursor(Cursor.getPredefinedCursor(6));
        lxHandle.addHandleListener(NW_HANDLE_LSTNR);
        this._addHandle(lxHandle);
        ((Point2D)point2DDouble).setLocation(-0.5, 0.0);
        lxHandle = new LxHandle(point2DDouble);
        lxHandle.setFlyoverCursor(Cursor.getPredefinedCursor(10));
        lxHandle.addHandleListener(W_HANDLE_LSTNR);
        this._addHandle(lxHandle);
        ((Point2D)point2DDouble).setLocation(-0.5, 0.5);
        lxHandle = new LxHandle(point2DDouble);
        lxHandle.setFlyoverCursor(Cursor.getPredefinedCursor(4));
        lxHandle.addHandleListener(SW_HANDLE_LSTNR);
        this._addHandle(lxHandle);
        ((Point2D)point2DDouble).setLocation(0.0, 0.5);
        lxHandle = new LxHandle(point2DDouble);
        lxHandle.setFlyoverCursor(Cursor.getPredefinedCursor(9));
        lxHandle.addHandleListener(S_HANDLE_LSTNR);
        this._addHandle(lxHandle);
        ((Point2D)point2DDouble).setLocation(0.5, 0.5);
        lxHandle = new LxHandle(point2DDouble);
        lxHandle.setFlyoverCursor(Cursor.getPredefinedCursor(5));
        lxHandle.addHandleListener(SE_HANDLE_LSTNR);
        this._addHandle(lxHandle);
        ((Point2D)point2DDouble).setLocation(0.5, 0.0);
        lxHandle = new LxHandle(point2DDouble);
        lxHandle.setFlyoverCursor(Cursor.getPredefinedCursor(11));
        lxHandle.addHandleListener(E_HANDLE_LSTNR);
        this._addHandle(lxHandle);
        ((Point2D)point2DDouble).setLocation(0.5, -0.5);
        lxHandle = new LxHandle(point2DDouble);
        lxHandle.setFlyoverCursor(Cursor.getPredefinedCursor(7));
        lxHandle.addHandleListener(NE_HANDLE_LSTNR);
        this._addHandle(lxHandle);
        ((Point2D)point2DDouble).setLocation(0.0, -0.5);
        lxHandle = new LxHandle(point2DDouble);
        lxHandle.setFlyoverCursor(Cursor.getPredefinedCursor(8));
        lxHandle.addHandleListener(N_HANDLE_LSTNR);
        this._addHandle(lxHandle);
    }

    protected void addUndoEdit(UndoableEdit undoableEdit) {
        if (this._current_edit != null) {
            this._current_edit.add(undoableEdit);
        }
    }

    protected void cancelUndoEdit() {
        if (this._current_edit != null) {
            this._current_edit.cancel();
        }
    }

    protected abstract void applyAttributes(LxAbstractGraph var1);

    protected void createHandles() {
        this.addStandardHandles();
    }

    protected void fireComponentMorphed(Rectangle2D rectangle2D) {
        this._comp_lstnrs.fireMorphed(rectangle2D);
    }

    protected void fireComponentMoved(Point2D point2D) {
        this._comp_lstnrs.fireMoved(point2D);
    }

    protected void finishUndoEdit() {
        if (this._current_edit != null) {
            this._current_edit.finish();
        }
    }

    protected Shape getTrajectoryShape() {
        Rectangle2D rectangle2D = this.getBounds2D();
        rectangle2D.setRect(rectangle2D.getX() - this.getCenterX(), rectangle2D.getY() - this.getCenterY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        return rectangle2D;
    }

    protected void postpaint(Graphics2D graphics2D) {
    }

    protected boolean prepaint(Graphics2D graphics2D) {
        return true;
    }

    protected void startUndoEdit(String string) {
        if (this._current_edit != null) {
            this._current_edit.start(string);
        }
    }

    private void _firePropertyChanged(String string, LxComponent lxComponent, Object object, Object object2) {
        if (this._properties == null) {
            return;
        }
        this._properties.fire(string, lxComponent, object, object2);
    }

    private void _initObjectVariables() {
        this._properties = null;
        this._parent = new Parent();
        this._actions = null;
        this._selection = new Selection();
        this._comp_lstnrs = new ComponentListeners(this);
        this._mouse_lstnrs = null;
        this._motion_lstnrs = null;
        this._handles = null;
        this._animation = null;
        this._popup = null;
        this._current_edit = null;
        this._trajectory = null;
        this._clip = null;
    }

    private void _setBlinkingEnabled(boolean bl, boolean bl2) {
        boolean bl3 = this._blink;
        if (bl == bl3) {
            return;
        }
        this._blink = bl;
        if (bl2 && this._undoOn()) {
            this.addUndoEdit(new BlinkEdit(this, bl3));
        }
        this._setActionState(BLINK_ACTION, bl);
        this._fireBlinkStateChanged(this);
    }

    private void _setBounds(double d, double d2, double d3, double d4, boolean bl) {
        boolean bl2;
        Rectangle2D rectangle2D;
        Rectangle2D rectangle2D2;
        if (d3 < 0.0 || d4 < 0.0) {
            throw new IllegalArgumentException("negative width/height");
        }
        if (d == this.getX() && d2 == this.getY() && d3 == this.getWidth() && d4 == this.getHeight()) {
            return;
        }
        if (this._comp_lstnrs.getSize() > 0) {
            rectangle2D2 = this.getBounds2D();
            rectangle2D = this._getStrokedBounds2D();
        } else {
            rectangle2D2 = this._undoOn() ? this.getBounds2D() : null;
            rectangle2D = null;
        }
        boolean bl3 = d != this.getX() || d2 != this.getY();
        boolean bl4 = bl2 = d3 != this.getWidth() || d4 != this.getHeight();
        if (bl && this._undoOn()) {
            this.startUndoEdit(Resources.get(RESHAPE_UNDO, "reshape"));
            this.addUndoEdit(new BoundsEdit(this, rectangle2D2));
        }
        if (bl2) {
            this._center_x += (d3 - this._width) / 2.0;
            this._center_y += (d4 - this._height) / 2.0;
            this._width = d3;
            this._height = d4;
            this._comp_lstnrs.fireResized(rectangle2D2, rectangle2D, bl);
        }
        this._center_x = d + d3 / 2.0;
        this._center_y = d2 + d4 / 2.0;
        if (bl3 && this._comp_lstnrs.getSize() > 0) {
            this.fireComponentMoved(new Point2DDouble(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0, rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0));
        }
        if (bl && this._undoOn()) {
            this.finishUndoEdit();
        }
    }

    private void _setCenter(double d, double d2, boolean bl) {
        if (d == this._center_x && d2 == this._center_y) {
            return;
        }
        Point2D point2D = this._comp_lstnrs.getSize() > 0 || this._undoOn() ? this.getCenter() : null;
        this._center_x = d;
        this._center_y = d2;
        if (bl && this._undoOn()) {
            this.addUndoEdit(new CenterEdit(this, point2D));
        }
        this.fireComponentMoved(point2D);
    }

    private void _setLocked(boolean bl, boolean bl2) {
        boolean bl3 = this._res_lock;
        if (bl == bl3) {
            return;
        }
        this._res_lock = bl;
        if (bl2 && this._undoOn()) {
            this.addUndoEdit(new LockEdit(this, bl3));
        }
        this._firePropertyChanged("lock", bl3 ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
        this._setActionState(LOCK_ACTION, bl);
    }

    private void _setName(String string, boolean bl) {
        String string2 = this._name;
        if (string == null) {
            string = "";
        }
        if (string == string2 || string.equals(string2)) {
            return;
        }
        this._name = string;
        if (bl && this._undoOn()) {
            this.addUndoEdit(new NameEdit(this, string2));
        }
    }

    private void _setSensitive(boolean bl, boolean bl2) {
        boolean bl3 = this._sensitive;
        if (bl == bl3) {
            return;
        }
        this._sensitive = bl;
        if (bl2 && this._undoOn()) {
            this.addUndoEdit(new SensitiveEdit(this, bl3));
        }
        this._setActionState(SENSITIVE_ACTION, bl);
    }

    private void _setSize(double d, double d2, boolean bl) {
        Rectangle2D rectangle2D;
        Rectangle2D rectangle2D2;
        if (d < 0.0 || d2 < 0.0) {
            throw new IllegalArgumentException("negative width/height");
        }
        if (d == this._width && d2 == this._height) {
            return;
        }
        Dimension2D dimension2D = this._undoOn() ? this.getSize() : null;
        if (this._comp_lstnrs.getSize() > 0) {
            rectangle2D2 = this.getBounds2D();
            rectangle2D = this._getStrokedBounds2D();
        } else {
            rectangle2D = null;
            rectangle2D2 = null;
        }
        this._center_x += (d - this._width) / 2.0;
        this._center_y += (d2 - this._height) / 2.0;
        this._width = d;
        this._height = d2;
        if (bl && this._undoOn()) {
            this.addUndoEdit(new SizeEdit(this, dimension2D));
        }
        this._comp_lstnrs.fireResized(rectangle2D2, rectangle2D, bl);
    }

    private void _setUserMovable(boolean bl, boolean bl2) {
        boolean bl3 = this._movable;
        if (bl == bl3) {
            return;
        }
        this._movable = bl;
        if (bl2 && this._undoOn()) {
            this.addUndoEdit(new MovableEdit(this, bl3));
        }
        this._setActionState(MOVABLE_ACTION, bl);
    }

    private void _setUserResizable(boolean bl, boolean bl2) {
        boolean bl3 = this._resizable;
        if (bl == bl3) {
            return;
        }
        this._resizable = bl;
        if (bl2 && this._undoOn()) {
            this.addUndoEdit(new ResizableEdit(this, bl3));
        }
        this._setActionState(RESIZABLE_ACTION, bl);
    }

    private void _setVisible(boolean bl, boolean bl2) {
        boolean bl3 = this._visible;
        if (bl == bl3) {
            return;
        }
        this._visible = bl;
        if (bl2 && this._undoOn()) {
            this.addUndoEdit(new VisibleEdit(this, bl3));
        }
        if (bl) {
            this._comp_lstnrs.fireShown();
        } else {
            this._comp_lstnrs.fireHidden(bl2);
        }
    }

    private void _setZoomable(boolean bl, boolean bl2) {
        boolean bl3 = this._zoomable;
        if (bl == bl3) {
            return;
        }
        this._zoomable = bl;
        if (bl2 && this._undoOn()) {
            this.addUndoEdit(new ZoomableEdit(this, bl3));
        }
        this._setActionState(ZOOMABLE_ACTION, bl);
        this._comp_lstnrs.fireZoomableChanged();
    }

    public void addItemListener(ItemListener itemListener) {
        this._selection._item_lstnrs.add(itemListener);
    }

    public Object[] getSelectedObjects() {
        return this._selection.getSelectedObjects();
    }

    public void removeItemListener(ItemListener itemListener) {
        this._selection._item_lstnrs.remove(itemListener);
    }

    void _notifyParentChanged(LxContainer lxContainer) {
    }

    public void addEnterLeaveListener(LxEnterLeaveListener lxEnterLeaveListener) {
        if (this._enterLeaveListeners == null) {
            this._enterLeaveListeners = new Vector();
        }
        this._enterLeaveListeners.add(lxEnterLeaveListener);
    }

    public void removeEnterLeaveListener(LxEnterLeaveListener lxEnterLeaveListener) {
        this._enterLeaveListeners.remove(lxEnterLeaveListener);
        if (this._enterLeaveListeners.size() == 0) {
            this._enterLeaveListeners = null;
        }
    }

    public void fireEntered(LxMouseEvent lxMouseEvent) {
        if (this._enterLeaveListeners == null || this._enterLeaveListeners.size() == 0) {
            return;
        }
        int n = this._enterLeaveListeners.size();
        int n2 = 0;
        while (n2 < n) {
            LxEnterLeaveListener lxEnterLeaveListener = (LxEnterLeaveListener)this._enterLeaveListeners.get(n2);
            lxEnterLeaveListener.mouseEntered(lxMouseEvent);
            ++n2;
        }
    }

    public void fireExited(LxMouseEvent lxMouseEvent) {
        if (this._enterLeaveListeners == null || this._enterLeaveListeners.size() == 0) {
            return;
        }
        int n = this._enterLeaveListeners.size();
        int n2 = 0;
        while (n2 < n) {
            LxEnterLeaveListener lxEnterLeaveListener = (LxEnterLeaveListener)this._enterLeaveListeners.get(n2);
            lxEnterLeaveListener.mouseExited(lxMouseEvent);
            ++n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ LxMouseAdapter access$3700() {
        return POPUP_LSTNR;
    }

    private static final class ZoomableEdit
    extends LooxUndoableEdit {
        public ZoomableEdit(LxComponent lxComponent, boolean bl) {
            super(lxComponent, Resources.get(LxComponent.ZOOMABLE_UNDO, "zoomable"), bl);
        }

        void _undoEdit(boolean bl) {
            LxComponent lxComponent = (LxComponent)this._getHost();
            lxComponent._setZoomable(bl, false);
        }
    }

    private final class ZoomableAction
    extends LxAbstractToggleAction
    implements Serializable {
        ZoomableAction() {
            super(LxComponent.ZOOMABLE_ACTION, "Zoomable", "Component not zoomable", null, "Zoomable", "Component zoomable", null, true, true);
            this.setState(LxComponent.this.isZoomable());
        }

        public void processAction(ActionEvent actionEvent) {
            LxComponent.this.setZoomable(!LxComponent.this.isZoomable());
            this.setState(LxComponent.this.isZoomable());
        }
    }

    private static final class VisibleEdit
    extends LooxUndoableEdit {
        public VisibleEdit(LxComponent lxComponent, boolean bl) {
            super(lxComponent, Resources.get(LxComponent.HIDE_UNDO, LxComponent.HIDE_ACTION), bl);
        }

        void _undoEdit(boolean bl) {
            LxComponent lxComponent = (LxComponent)this._getHost();
            lxComponent._setVisible(bl, false);
        }
    }

    private final class Trajectory
    implements Serializable {
        private transient int _num_segs = 0;
        private final Point2D _first = new Point2DDouble(0.0, 0.0);
        private final Point2D _p1 = new Point2DDouble(0.0, 0.0);
        private final Point2D _p2 = new Point2DDouble(0.0, 0.0);

        public Trajectory() {
            LxComponent.this.addComponentListener(TRAJ_LSTNR);
        }

        private Point2D _calc(int n, Point2D point2D, Point2D point2D2, double[] dArray, double d, Point2D point2D3) {
            double[] dArray2;
            int n2;
            double[][][] dArray3 = new double[n + 1][n + 1][2];
            dArray3[0][0][0] = point2D.getX();
            dArray3[0][0][1] = point2D.getY();
            dArray3[0][n][0] = point2D2.getX();
            dArray3[0][n][1] = point2D2.getY();
            int n3 = 1;
            while (n3 < n) {
                n2 = (n3 - 1) * 2;
                dArray2 = dArray3[0][n3];
                dArray2[0] = dArray[n2];
                dArray2[1] = dArray[n2 + 1];
                ++n3;
            }
            n2 = 1;
            while (n2 <= n) {
                int n4 = 0;
                while (n4 <= n - n2) {
                    double[][] dArray4 = dArray3[n2 - 1];
                    double[] dArray5 = dArray4[n4 + 1];
                    dArray2 = dArray3[n2][n4];
                    dArray2[0] = (1.0 - d) * dArray4[n4][0] + d * dArray5[0];
                    dArray2[1] = (1.0 - d) * dArray3[n2 - 1][n4][1] + d * dArray5[1];
                    ++n4;
                }
                ++n2;
            }
            dArray2 = dArray3[n][0];
            point2D3.setLocation(dArray2[0] + LxComponent.this.getCenterX(), dArray2[1] + LxComponent.this.getCenterY());
            return point2D3;
        }

        private int _getSegment(PathIterator pathIterator, double[] dArray) {
            int n = 0;
            switch (pathIterator.currentSegment(dArray)) {
                case 4: {
                    if (this._p2.equals(this._first)) break;
                    this._p1.setLocation(this._p2.getX(), this._p2.getY());
                    this._p2.setLocation(this._first.getX(), this._first.getY());
                    n = 1;
                    break;
                }
                case 0: {
                    this._first.setLocation(dArray[0], dArray[1]);
                    this._p1.setLocation(dArray[0], dArray[1]);
                    this._p2.setLocation(dArray[0], dArray[1]);
                    break;
                }
                case 1: {
                    this._p1.setLocation(this._p2.getX(), this._p2.getY());
                    this._p2.setLocation(dArray[0], dArray[1]);
                    n = 1;
                    break;
                }
                case 2: {
                    this._p1.setLocation(this._p2.getX(), this._p2.getY());
                    this._p2.setLocation(dArray[2], dArray[3]);
                    n = 2;
                    break;
                }
                case 3: {
                    this._p1.setLocation(this._p2.getX(), this._p2.getY());
                    this._p2.setLocation(dArray[4], dArray[5]);
                    n = 3;
                }
            }
            return n;
        }

        public Point2D get(Shape shape, double d, Point2D point2D) {
            int n;
            if (d < -1.0 || d > 1.0) {
                throw new IllegalArgumentException("bad percent");
            }
            boolean bl = false;
            PathIterator pathIterator = null;
            double[] dArray = new double[6];
            pathIterator = shape.getPathIterator(null);
            if (this._num_segs == 0) {
                while (!pathIterator.isDone()) {
                    if (this._getSegment(pathIterator, dArray) > 0) {
                        ++this._num_segs;
                    }
                    pathIterator.next();
                }
                pathIterator = shape.getPathIterator(null);
            }
            if (d < 0.0) {
                d += 1.0;
            }
            int n2 = (int)(d / (1.001 / (double)this._num_segs));
            d -= (double)n2 / (double)this._num_segs;
            d *= (double)this._num_segs;
            while (n2 > 0) {
                if (this._getSegment(pathIterator, dArray) > 0) {
                    --n2;
                }
                pathIterator.next();
            }
            while ((n = this._getSegment(pathIterator, dArray)) == 0) {
                pathIterator.next();
            }
            return this._calc(n, this._p1, this._p2, dArray, d, point2D);
        }
    }

    private static final class SizeEdit
    extends LooxCollapsableEdit {
        private Dimension2D _value;

        public SizeEdit(LxComponent lxComponent, Dimension2D dimension2D) {
            super(lxComponent, Resources.get(LxComponent.RESIZE_UNDO, "resize"));
            this._value = dimension2D;
        }

        void _setValue(LooxCollapsableEdit looxCollapsableEdit) {
            this._value = ((SizeEdit)looxCollapsableEdit)._value;
        }

        void _undoEdit(boolean bl) {
            LxComponent lxComponent = (LxComponent)this._getHost();
            Dimension2D dimension2D = lxComponent.getSize();
            lxComponent._setSize(this._value.getWidth(), this._value.getHeight(), false);
            this._value = dimension2D;
        }
    }

    private static final class SensitiveEdit
    extends LooxUndoableEdit {
        public SensitiveEdit(LxComponent lxComponent, boolean bl) {
            super(lxComponent, Resources.get(LxComponent.SENSITIVE_UNDO, "sensitive"), bl);
        }

        void _undoEdit(boolean bl) {
            LxComponent lxComponent = (LxComponent)this._getHost();
            lxComponent._setSensitive(bl, false);
        }
    }

    private final class SensitiveAction
    extends LxAbstractToggleAction
    implements Serializable {
        SensitiveAction() {
            super(LxComponent.SENSITIVE_ACTION, "Sensitive", "Component not sensitive", null, "Sensitive", "Component sensitive", null, true, true);
            this.setState(LxComponent.this.isSensitive());
        }

        public void processAction(ActionEvent actionEvent) {
            LxComponent.this.setSensitive(!LxComponent.this.isSensitive());
            this.setState(LxComponent.this.isSensitive());
        }
    }

    private final class Selection
    implements Serializable {
        private final ItemListeners _item_lstnrs = new ItemListeners();
        private boolean _val = false;
        private boolean _selectable = true;

        private Selection() {
        }

        public Object[] getSelectedObjects() {
            if (this._val) {
                Object[] objectArray = new Object[]{LxComponent.this};
                return objectArray;
            }
            return null;
        }

        public void set(boolean bl) {
            boolean bl2 = this._val;
            if (bl == bl2 || !this._selectable) {
                return;
            }
            this._val = bl;
            this._item_lstnrs.fireStateChanged(LxComponent.this, LxComponent.this, LxComponent.this.isSelected());
        }

        public void setSelectable(boolean bl) {
            if (bl == this._selectable) {
                return;
            }
            if (bl || this._val) {
                // empty if block
            }
            this._selectable = bl;
        }
    }

    private static final class ResizableEdit
    extends LooxUndoableEdit {
        public ResizableEdit(LxComponent lxComponent, boolean bl) {
            super(lxComponent, Resources.get(LxComponent.RESIZABLE_UNDO, "resizable"), bl);
        }

        void _undoEdit(boolean bl) {
            LxComponent lxComponent = (LxComponent)this._getHost();
            lxComponent._setUserResizable(bl, false);
        }
    }

    private final class ResizableAction
    extends LxAbstractToggleAction
    implements Serializable {
        ResizableAction() {
            super(LxComponent.RESIZABLE_ACTION, "Resizable", "Component not user resizable", null, "Resizable", "Component user resizable", null, true, true);
            this.setState(LxComponent.this.isUserResizable());
        }

        public void processAction(ActionEvent actionEvent) {
            LxComponent.this.setUserResizable(!LxComponent.this.isUserResizable());
            this.setState(LxComponent.this.isUserResizable());
        }
    }

    private final class Properties
    implements Serializable {
        private SwingPropertyChangeSupport _lstnrs;

        private Properties() {
        }

        public void addListener(PropertyChangeListener propertyChangeListener) {
            if (this._lstnrs == null) {
                this._lstnrs = new SwingPropertyChangeSupport(LxComponent.this);
            }
            this._lstnrs.addPropertyChangeListener(propertyChangeListener);
        }

        public void fire(String string, LxComponent lxComponent, Object object, Object object2) {
            if (this._lstnrs == null) {
                return;
            }
            this._lstnrs.firePropertyChange(new PropertyChangeEvent(lxComponent, string, object, object2));
        }

        public void removeListener(PropertyChangeListener propertyChangeListener) {
            this._lstnrs.removePropertyChangeListener(propertyChangeListener);
            if (!this._lstnrs.hasListeners(null)) {
                this._lstnrs = null;
            }
        }
    }

    private final class Popup
    implements Serializable {
        private transient JPopupMenu _value = null;
        private boolean _added = false;
        private LxMouseListener _lstnr = LxComponent.access$3700();

        private Popup() {
        }

        public void set(JPopupMenu jPopupMenu) {
            if (this._value == jPopupMenu) {
                return;
            }
            if (!this._added && this._lstnr != null) {
                this._added = true;
                LxComponent.this.addMouseListener(this._lstnr);
            }
            this._value = jPopupMenu;
        }

        public void removeListener() {
            if (this._lstnr != null) {
                if (this._added) {
                    LxComponent.this.removeMouseListener(this._lstnr);
                    this._added = false;
                }
                this._lstnr = null;
            }
        }
    }

    private final class Parent
    implements Serializable {
        private LxContainer _val = null;
        private LxAncestorListener _ancestor_lstnr = null;
        private LxComponentAdapter _component_lstnr = null;
        private AncestorListeners _ancst_lstnrs = null;

        private Parent() {
        }

        public void set(LxContainer lxContainer) {
            if (lxContainer == this._val) {
                return;
            }
            LxContainer lxContainer2 = this._val;
            this._val = lxContainer;
            if (this._ancst_lstnrs != null) {
                if (lxContainer2 instanceof LxComponent) {
                    this._detachListeners((LxComponent)((Object)lxContainer2));
                }
                if (lxContainer != null && this._component_lstnr == null && this._ancestor_lstnr == null) {
                    this._createListeners();
                }
                if (lxContainer != null) {
                    this._ancst_lstnrs.fireAdded(LxComponent.this, lxContainer);
                } else {
                    this._ancst_lstnrs.fireRemoved(LxComponent.this, lxContainer2);
                }
                if (lxContainer instanceof LxComponent) {
                    this._attachListeners((LxComponent)((Object)lxContainer));
                }
            }
            LxComponent.this._notifyParentChanged(lxContainer2);
        }

        private void _attachListeners(LxComponent lxComponent) {
            lxComponent.addAncestorListener(this._ancestor_lstnr);
            lxComponent.addComponentListener(this._component_lstnr);
        }

        private void _detachListeners(LxComponent lxComponent) {
            lxComponent.removeAncestorListener(this._ancestor_lstnr);
            lxComponent.removeComponentListener(this._component_lstnr);
        }

        private void _createListeners() {
            this._component_lstnr = new LxComponentAdapter(this){
                private final /* synthetic */ Parent this$1;
                {
                    this.this$1 = parent;
                }

                public void componentHidden(LxComponentEvent lxComponentEvent) {
                    Parent.access$3600(this.this$1).fireRemoved(lxComponentEvent.getComponent(), lxComponentEvent.getComponent().getParent());
                }

                public void componentMoved(LxComponentEvent lxComponentEvent) {
                    Parent.access$3600(this.this$1).fireMoved(lxComponentEvent.getComponent(), lxComponentEvent.getComponent().getParent());
                }

                public void componentShown(LxComponentEvent lxComponentEvent) {
                    Parent.access$3600(this.this$1).fireAdded(lxComponentEvent.getComponent(), lxComponentEvent.getComponent().getParent());
                }
            };
            this._ancestor_lstnr = new LxAncestorListener(this){
                private final /* synthetic */ Parent this$1;
                {
                    this.this$1 = parent;
                }

                public void ancestorAdded(LxAncestorEvent lxAncestorEvent) {
                    Parent.access$3600(this.this$1).fireAdded(lxAncestorEvent.getAncestor(), lxAncestorEvent.getAncestorParent());
                }

                public void ancestorMoved(LxAncestorEvent lxAncestorEvent) {
                    Parent.access$3600(this.this$1).fireMoved(lxAncestorEvent.getAncestor(), lxAncestorEvent.getAncestorParent());
                }

                public void ancestorRemoved(LxAncestorEvent lxAncestorEvent) {
                    Parent.access$3600(this.this$1).fireRemoved(lxAncestorEvent.getAncestor(), lxAncestorEvent.getAncestorParent());
                }
            };
        }

        public void addListener(LxAncestorListener lxAncestorListener) {
            if (this._ancst_lstnrs == null) {
                this._ancst_lstnrs = new AncestorListeners(LxComponent.this);
            }
            this._ancst_lstnrs.add(lxAncestorListener);
            if (this._val != null && this._val instanceof LxComponent && this._ancst_lstnrs.getSize() == 1) {
                this._createListeners();
                this._attachListeners((LxComponent)((Object)this._val));
            }
        }

        public void removeListener(LxAncestorListener lxAncestorListener) {
            if (this._ancst_lstnrs == null) {
                return;
            }
            this._ancst_lstnrs.remove(lxAncestorListener);
            if (this._ancst_lstnrs.getSize() == 0) {
                if (this._val != null && this._val instanceof LxComponent) {
                    this._detachListeners((LxComponent)((Object)this._val));
                }
                this._ancst_lstnrs = null;
                this._ancestor_lstnr = null;
                this._component_lstnr = null;
            }
        }

        static /* synthetic */ AncestorListeners access$3600(Parent parent) {
            return parent._ancst_lstnrs;
        }
    }

    private final class OpaqueAction
    extends LxAbstractToggleAction
    implements Serializable {
        OpaqueAction() {
            super(LxComponent.OPAQUE_ACTION, "Opaque", "Component not opaque", null, "Opaque", "Component opaque", null, true, true);
            this.setState(LxComponent.this.isOpaque());
        }

        public void processAction(ActionEvent actionEvent) {
            LxComponent.this.setOpaque(!LxComponent.this.isOpaque());
            this.setState(LxComponent.this.isOpaque());
        }
    }

    private static final class NameEdit
    extends LooxUndoableEdit {
        private String _value;

        public NameEdit(LxComponent lxComponent, String string) {
            super(lxComponent, Resources.get(LxComponent.NAME_CHANGE_UNDO, "name change"));
            this._value = string;
        }

        void _undoEdit(boolean bl) {
            LxComponent lxComponent = (LxComponent)this._getHost();
            String string = lxComponent.getName();
            lxComponent._setName(this._value, false);
            this._value = string;
        }
    }

    private static final class MovableEdit
    extends LooxUndoableEdit {
        public MovableEdit(LxComponent lxComponent, boolean bl) {
            super(lxComponent, Resources.get(LxComponent.MOVABLE_UNDO, "movable"), bl);
        }

        void _undoEdit(boolean bl) {
            LxComponent lxComponent = (LxComponent)this._getHost();
            lxComponent._setUserMovable(bl, false);
        }
    }

    private final class MovableAction
    extends LxAbstractToggleAction
    implements Serializable {
        MovableAction() {
            super(LxComponent.MOVABLE_ACTION, "Movable", "Component not user movable", null, "Movable", "Component user movable", null, true, true);
            this.setState(LxComponent.this.isUserMovable());
        }

        public void processAction(ActionEvent actionEvent) {
            LxComponent.this.setUserMovable(!LxComponent.this.isUserMovable());
            this.setState(LxComponent.this.isUserMovable());
        }
    }

    private final class MouseListeners
    extends Listener
    implements Serializable {
        private LxMouseListener _double_click = null;

        public MouseListeners() {
            LxAbstractGraph lxAbstractGraph = LxComponent.this.getGraph();
            if (lxAbstractGraph != null && lxAbstractGraph.getDefaultDoubleClickActionActive() || lxAbstractGraph == null && Lx.getDefaultDoubleClickActionActive()) {
                this._double_click = DOUBLE_CLICK_LSTNR;
                this.add(this._double_click);
            } else {
                this._double_click = null;
            }
        }

        public void fireDoubleClicked(MouseEvent mouseEvent, double d, double d2) {
            this.fire(new Listener.Feeder(this, mouseEvent, d, d2){
                private final /* synthetic */ MouseEvent val$orig_event;
                private final /* synthetic */ double val$x;
                private final /* synthetic */ double val$y;
                private final /* synthetic */ MouseListeners this$1;
                {
                    this.this$1 = mouseListeners;
                    this.val$orig_event = mouseEvent;
                    this.val$x = d;
                    this.val$y = d2;
                }

                public Object getEvent(Object object) {
                    return new LxMouseEvent(this.val$orig_event, 507, MouseListeners.access$3300(this.this$1), this.val$x, this.val$y, 0.0, 0.0);
                }

                public void fire(Object object, Object object2) {
                    ((LxMouseListener)object).mouseDoubleClicked((LxMouseEvent)object2);
                }
            });
        }

        public void firePopup(MouseEvent mouseEvent, double d, double d2) {
            this.fire(new Listener.Feeder(this, mouseEvent, d, d2){
                private final /* synthetic */ MouseEvent val$orig_event;
                private final /* synthetic */ double val$x;
                private final /* synthetic */ double val$y;
                private final /* synthetic */ MouseListeners this$1;
                {
                    this.this$1 = mouseListeners;
                    this.val$orig_event = mouseEvent;
                    this.val$x = d;
                    this.val$y = d2;
                }

                public Object getEvent(Object object) {
                    return new LxMouseEvent(this.val$orig_event, 508, MouseListeners.access$3300(this.this$1), this.val$x, this.val$y, 0.0, 0.0);
                }

                public void fire(Object object, Object object2) {
                    ((LxMouseListener)object).mousePopup((LxMouseEvent)object2);
                }
            });
        }

        public void firePressed(MouseEvent mouseEvent, double d, double d2) {
            this.fire(new Listener.Feeder(this, mouseEvent, d, d2){
                private final /* synthetic */ MouseEvent val$orig_event;
                private final /* synthetic */ double val$x;
                private final /* synthetic */ double val$y;
                private final /* synthetic */ MouseListeners this$1;
                {
                    this.this$1 = mouseListeners;
                    this.val$orig_event = mouseEvent;
                    this.val$x = d;
                    this.val$y = d2;
                }

                public Object getEvent(Object object) {
                    return new LxMouseEvent(this.val$orig_event, 501, MouseListeners.access$3300(this.this$1), this.val$x, this.val$y, 0.0, 0.0);
                }

                public void fire(Object object, Object object2) {
                    ((LxMouseListener)object).mousePressed((LxMouseEvent)object2);
                }
            });
        }

        public void fireReleased(MouseEvent mouseEvent, double d, double d2) {
            this.fire(new Listener.Feeder(this, mouseEvent, d, d2){
                private final /* synthetic */ MouseEvent val$orig_event;
                private final /* synthetic */ double val$x;
                private final /* synthetic */ double val$y;
                private final /* synthetic */ MouseListeners this$1;
                {
                    this.this$1 = mouseListeners;
                    this.val$orig_event = mouseEvent;
                    this.val$x = d;
                    this.val$y = d2;
                }

                public Object getEvent(Object object) {
                    return new LxMouseEvent(this.val$orig_event, 502, MouseListeners.access$3300(this.this$1), this.val$x, this.val$y, 0.0, 0.0);
                }

                public void fire(Object object, Object object2) {
                    ((LxMouseListener)object).mouseReleased((LxMouseEvent)object2);
                }
            });
        }

        public void removeDoubleClick() {
            if (this._double_click != null) {
                this.remove(this._double_click);
                this._double_click = null;
            }
        }

        static /* synthetic */ LxComponent access$3300(MouseListeners mouseListeners) {
            return mouseListeners.LxComponent.this;
        }
    }

    private final class MotionListeners
    extends Listener
    implements Serializable {
        private MotionListeners() {
        }

        public void fireDragged(MouseEvent mouseEvent, double d, double d2, double d3, double d4) {
            this.fire(new Listener.Feeder(this, mouseEvent, d, d2, d3, d4){
                private final /* synthetic */ MouseEvent val$orig_event;
                private final /* synthetic */ double val$x;
                private final /* synthetic */ double val$y;
                private final /* synthetic */ double val$delta_x;
                private final /* synthetic */ double val$delta_y;
                private final /* synthetic */ MotionListeners this$1;
                {
                    this.this$1 = motionListeners;
                    this.val$orig_event = mouseEvent;
                    this.val$x = d;
                    this.val$y = d2;
                    this.val$delta_x = d3;
                    this.val$delta_y = d4;
                }

                public Object getEvent(Object object) {
                    return new LxMouseEvent(this.val$orig_event, 506, MotionListeners.access$3100(this.this$1), this.val$x, this.val$y, this.val$delta_x, this.val$delta_y);
                }

                public void fire(Object object, Object object2) {
                    ((LxMouseMotionListener)object).mouseDragged((LxMouseEvent)object2);
                }
            });
        }

        static /* synthetic */ LxComponent access$3100(MotionListeners motionListeners) {
            return motionListeners.LxComponent.this;
        }
    }

    private final class LockUnlockAction
    extends LxAbstractToggleAction
    implements Serializable {
        LockUnlockAction() {
            super(LxComponent.LOCK_ACTION, "Locked", "Unlock the component", null, "Locked", "Lock the component", null, false, true);
            this.setState(LxComponent.this.isLocked());
        }

        public void processAction(ActionEvent actionEvent) {
            LxComponent.this.setLocked(!LxComponent.this.isLocked());
            this.setState(LxComponent.this.isLocked());
        }

        public void setAlwaysDisabled(boolean bl) {
        }
    }

    private static final class LockEdit
    extends LooxUndoableEdit {
        public LockEdit(LxComponent lxComponent, boolean bl) {
            super(lxComponent, Resources.get(LxComponent.LOCK_UNDO, "lock"), bl);
        }

        void _undoEdit(boolean bl) {
            LxComponent lxComponent = (LxComponent)this._getHost();
            lxComponent._setLocked(bl, false);
        }
    }

    private final class HideAction
    extends LxAbstractAction
    implements Serializable {
        HideAction() {
            super(LxComponent.HIDE_ACTION, "Hide", "Hide the component", null, true);
        }

        public void processAction(ActionEvent actionEvent) {
            LxComponent.this.setVisible(false);
        }
    }

    private final class Handles
    implements Serializable {
        private Storage _list = null;
        private int _max_size = 0;

        private Handles() {
        }

        public void add(LxHandle lxHandle, boolean bl) {
            this._init();
            if (bl && this._list.contains(lxHandle)) {
                throw new IllegalArgumentException("handle already exists");
            }
            if (lxHandle.getComponent() != null) {
                lxHandle._addNotify(null);
            }
            lxHandle.addHandleListener(HANDLE_LSTNR);
            if (lxHandle.getSize() > this._max_size) {
                this._calcMaxSize();
            }
            this._list.addElement(lxHandle);
            lxHandle._addNotify(LxComponent.this);
            if (LxComponent.this.isSelected()) {
                // empty if block
            }
        }

        private void _calcMaxSize() {
            if (this._list == null) {
                this._max_size = 0;
                return;
            }
            int n = this._list.size();
            int n2 = 0;
            while (n2 < n) {
                LxHandle lxHandle = (LxHandle)this._list.elementAt(n2);
                this._max_size = Math.max(this._max_size, lxHandle.getSize());
                ++n2;
            }
        }

        public LxHandle get(int n) {
            this._init();
            return (LxHandle)this._list.elementAt(n);
        }

        public int getCount() {
            this._init();
            if (this._list == null) {
                return 0;
            }
            return this._list.size();
        }

        public int getIndex(LxHandle lxHandle) {
            this._init();
            if (this._list == null) {
                return -1;
            }
            return this._list.indexOf(lxHandle);
        }

        public int getMaxSize() {
            this._init();
            return this._max_size;
        }

        private void _init() {
            if (this._list == null) {
                this._list = new Storage(LxComponent.this._getInitialHandleCount(), 1);
                LxComponent.this.createHandles();
            }
        }

        public void remove(LxHandle lxHandle) {
            if (this._list == null || !this._list.contains(lxHandle)) {
                throw new IllegalArgumentException("handle doesn't exists");
            }
            this._list.removeElement(lxHandle);
            if (lxHandle.getSize() == this._max_size) {
                this._calcMaxSize();
            }
            lxHandle._addNotify(null);
            if (LxComponent.this.isSelected()) {
                // empty if block
            }
        }

        /*
         * Unable to fully structure code
         */
        public void removeAll() {
            if (this._list != null) ** GOTO lbl8
            this._list = new Storage(LxComponent.this._getInitialHandleCount(), 1);
            return;
lbl-1000:
            // 1 sources

            {
                var1_1 = (LxHandle)this._list.elementAt(0);
                this._list.removeElementAt(0);
                var1_1._addNotify(null);
                if (!LxComponent.this.isSelected()) continue;
lbl8:
                // 3 sources

                ** while (this._list.size() > 0)
            }
lbl9:
            // 1 sources

            this._max_size = 0;
        }

        public LxHandle[] toArray() {
            this._init();
            if (this._list == null) {
                return new LxHandle[0];
            }
            Object[] objectArray = new LxHandle[this._list.size()];
            this._list.copyInto(objectArray);
            return objectArray;
        }
    }

    private final class EditNameAction
    extends LxAbstractAction
    implements Serializable {
        EditNameAction() {
            super(LxComponent.EDIT_NAME_ACTION, "Name...", "Edit the name of this object.", null, true);
        }

        public void processAction(ActionEvent actionEvent) {
            Object var2_2 = null;
            String string = Resources.get("edit-name-dialogTitle", "Name Input");
            Component component = (Component)actionEvent.getSource();
            if (component == null) {
                return;
            }
            Object object = DialogFrame.showInputDialog(component, var2_2, string, 3, null, null, LxComponent.this.getName());
            if (object != null) {
                LxComponent.this.setName((String)object);
            }
        }
    }

    private static final class ComponentListeners
    extends Listener
    implements Serializable {
        private static boolean _undoable;
        private static Point2D _old;
        private static Rectangle2D _old_bounds;
        private static Rectangle2D _old_stroke;
        private static final Listener.Feeder2 HIDDEN;
        private static final Listener.Feeder2 MORPHED;
        private static final Listener.Feeder2 MOVED;
        private static final Listener.Feeder2 RESIZED;
        private static final Listener.Feeder2 SHOWN;
        private static final Listener.Feeder2 ZOOMABLE;
        private final LxComponent _host;

        public ComponentListeners(LxComponent lxComponent) {
            this._host = lxComponent;
        }

        private LxComponentEvent _getEvent(int n) {
            if (_comp_ev_used) {
                return new LxComponentEvent(this._host, n);
            }
            if (COMP_EV == null) {
                COMP_EV = new LxComponentEvent(this._host, n);
            } else {
                COMP_EV._reset(this._host, n);
            }
            _comp_ev_used = true;
            return COMP_EV;
        }

        private void _releaseEvent(LxComponentEvent lxComponentEvent) {
            if (lxComponentEvent == COMP_EV) {
                _comp_ev_used = false;
                lxComponentEvent._reset(null, 0);
            }
        }

        public void fireHidden(boolean bl) {
            _undoable = bl;
            this.fire(HIDDEN, this);
        }

        public void fireMorphed(Rectangle2D rectangle2D) {
            _old_stroke = rectangle2D;
            this.fire(MORPHED, this);
            _old_stroke = null;
        }

        public void fireMoved(Point2D point2D) {
            _old = point2D;
            this.fire(MOVED, this);
            _old = null;
        }

        public void fireResized(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
            _old_bounds = rectangle2D;
            _old_stroke = rectangle2D2;
            _undoable = bl;
            this.fire(RESIZED, this);
            _old_bounds = null;
            _old_stroke = null;
        }

        public void fireShown() {
            this.fire(SHOWN, this);
        }

        public void fireZoomableChanged() {
            this.fire(ZOOMABLE, this);
        }

        static /* synthetic */ LxComponentEvent access$2100(ComponentListeners componentListeners, int n) {
            return componentListeners._getEvent(n);
        }

        static /* synthetic */ boolean access$2200() {
            return _undoable;
        }

        static /* synthetic */ void access$2300(ComponentListeners componentListeners, LxComponentEvent lxComponentEvent) {
            componentListeners._releaseEvent(lxComponentEvent);
        }

        static /* synthetic */ Rectangle2D access$2400() {
            return _old_bounds;
        }

        static /* synthetic */ Rectangle2D access$2500() {
            return _old_stroke;
        }

        static /* synthetic */ Point2D access$2600() {
            return _old;
        }

        static {
            HIDDEN = new Listener.Feeder2(){

                public Object getEvent(Object object) {
                    ComponentListeners componentListeners = (ComponentListeners)object;
                    LxComponentEvent lxComponentEvent = ComponentListeners.access$2100(componentListeners, 103);
                    if (!ComponentListeners.access$2200()) {
                        lxComponentEvent._setNotUndoable();
                    }
                    return lxComponentEvent;
                }

                public void fire(Object object, Object object2) {
                    ((LxComponentListener)object).componentHidden((LxComponentEvent)object2);
                }

                public void releaseEvent(Object object, Object object2) {
                    ComponentListeners componentListeners = (ComponentListeners)object2;
                    ComponentListeners.access$2300(componentListeners, (LxComponentEvent)object);
                }
            };
            MORPHED = new Listener.Feeder2(){

                public Object getEvent(Object object) {
                    ComponentListeners componentListeners = (ComponentListeners)object;
                    LxComponentEvent lxComponentEvent = ComponentListeners.access$2100(componentListeners, 679);
                    lxComponentEvent._resetBounds(ComponentListeners.access$2400(), ComponentListeners.access$2500());
                    return lxComponentEvent;
                }

                public void fire(Object object, Object object2) {
                    ((LxComponentListener)object).componentMorphed((LxComponentEvent)object2);
                }

                public void releaseEvent(Object object, Object object2) {
                    ComponentListeners componentListeners = (ComponentListeners)object2;
                    ComponentListeners.access$2300(componentListeners, (LxComponentEvent)object);
                }
            };
            MOVED = new Listener.Feeder2(){

                public Object getEvent(Object object) {
                    ComponentListeners componentListeners = (ComponentListeners)object;
                    LxComponentEvent lxComponentEvent = ComponentListeners.access$2100(componentListeners, 100);
                    lxComponentEvent._resetCenter(ComponentListeners.access$2600());
                    lxComponentEvent._resetBounds(ComponentListeners.access$2400(), ComponentListeners.access$2500());
                    return lxComponentEvent;
                }

                public void fire(Object object, Object object2) {
                    ((LxComponentListener)object).componentMoved((LxComponentEvent)object2);
                }

                public void releaseEvent(Object object, Object object2) {
                    ComponentListeners componentListeners = (ComponentListeners)object2;
                    ComponentListeners.access$2300(componentListeners, (LxComponentEvent)object);
                }
            };
            RESIZED = new Listener.Feeder2(){

                public Object getEvent(Object object) {
                    ComponentListeners componentListeners = (ComponentListeners)object;
                    LxComponentEvent lxComponentEvent = ComponentListeners.access$2100(componentListeners, 101);
                    lxComponentEvent._resetBounds(ComponentListeners.access$2400(), ComponentListeners.access$2500());
                    if (!ComponentListeners.access$2200()) {
                        lxComponentEvent._setNotUndoable();
                    }
                    return lxComponentEvent;
                }

                public void fire(Object object, Object object2) {
                    ((LxComponentListener)object).componentResized((LxComponentEvent)object2);
                }

                public void releaseEvent(Object object, Object object2) {
                    ComponentListeners componentListeners = (ComponentListeners)object2;
                    ComponentListeners.access$2300(componentListeners, (LxComponentEvent)object);
                }
            };
            SHOWN = new Listener.Feeder2(){

                public Object getEvent(Object object) {
                    ComponentListeners componentListeners = (ComponentListeners)object;
                    return ComponentListeners.access$2100(componentListeners, 102);
                }

                public void fire(Object object, Object object2) {
                    ((LxComponentListener)object).componentShown((LxComponentEvent)object2);
                }

                public void releaseEvent(Object object, Object object2) {
                    ComponentListeners componentListeners = (ComponentListeners)object2;
                    ComponentListeners.access$2300(componentListeners, (LxComponentEvent)object);
                }
            };
            ZOOMABLE = new Listener.Feeder2(){

                public Object getEvent(Object object) {
                    ComponentListeners componentListeners = (ComponentListeners)object;
                    return ComponentListeners.access$2100(componentListeners, 678);
                }

                public void fire(Object object, Object object2) {
                    ((LxComponentListener)object).componentZoomableChanged((LxComponentEvent)object2);
                }

                public void releaseEvent(Object object, Object object2) {
                    ComponentListeners componentListeners = (ComponentListeners)object2;
                    ComponentListeners.access$2300(componentListeners, (LxComponentEvent)object);
                }
            };
        }
    }

    private static final class ClipEdit
    extends LooxUndoableEdit {
        private static final String CLIP_UNDO = "clipUndo";
        private LxComponent _value;

        public ClipEdit(LxComponent lxComponent, LxComponent lxComponent2) {
            super(lxComponent, Resources.get(CLIP_UNDO, "clip"));
            this._value = lxComponent2;
        }

        void _undoEdit(boolean bl) {
            LxComponent lxComponent = (LxComponent)this._getHost();
            LxComponent lxComponent2 = lxComponent.getClipComponent();
            if (lxComponent._clip == null) {
                lxComponent._clip = lxComponent.new Clip();
            }
            lxComponent._clip.set(this._value, false);
            this._value = lxComponent2;
        }
    }

    private final class Clip
    implements Serializable {
        private transient LxComponent _val;
        private transient LxAncestorListener _lstnr;

        private Clip() {
        }

        public void set(LxComponent lxComponent) {
            this.set(lxComponent, true);
        }

        public void set(LxComponent lxComponent, boolean bl) {
            LxComponent lxComponent2 = this._val;
            if (lxComponent == lxComponent2) {
                return;
            }
            if (lxComponent2 != null) {
                lxComponent2.removeAncestorListener(this._lstnr);
            }
            this._val = lxComponent;
            if (lxComponent != null) {
                if (this._lstnr == null) {
                    this._lstnr = new LxAncestorAdapter(this){
                        private final /* synthetic */ Clip this$1;
                        {
                            this.this$1 = clip;
                        }

                        public void ancestorRemoved(LxAncestorEvent lxAncestorEvent) {
                            this.this$1.set(null);
                        }
                    };
                }
                lxComponent.addAncestorListener(this._lstnr);
            } else {
                this._lstnr = null;
            }
            if (bl && LxComponent.this._undoOn()) {
                LxComponent.this.addUndoEdit(new ClipEdit(LxComponent.this, lxComponent2));
            }
            LxComponent.this._comp_lstnrs.fireShown();
        }
    }

    private static final class CenterEdit
    extends LooxCollapsableEdit {
        private Point2D _value;

        public CenterEdit(LxComponent lxComponent, Point2D point2D) {
            super(lxComponent, Resources.get(LxComponent.MOVE_UNDO, "move"));
            this._value = point2D;
        }

        void _setValue(LooxCollapsableEdit looxCollapsableEdit) {
            this._value = ((CenterEdit)looxCollapsableEdit)._value;
        }

        void _undoEdit(boolean bl) {
            LxComponent lxComponent = (LxComponent)this._getHost();
            Point2D point2D = lxComponent.getCenter();
            lxComponent._setCenter(this._value.getX(), this._value.getY(), false);
            this._value = point2D;
        }
    }

    private static final class BoundsEdit
    extends LooxCollapsableEdit {
        private Rectangle2D _value;

        public BoundsEdit(LxComponent lxComponent, Rectangle2D rectangle2D) {
            super(lxComponent, Resources.get(LxComponent.RESHAPE_UNDO, "reshape"));
            this._value = rectangle2D;
        }

        void _setValue(LooxCollapsableEdit looxCollapsableEdit) {
            this._value = ((BoundsEdit)looxCollapsableEdit)._value;
        }

        void _undoEdit(boolean bl) {
            LxComponent lxComponent = (LxComponent)this._getHost();
            Rectangle2D rectangle2D = lxComponent.getBounds2D();
            lxComponent._setBounds(this._value.getX(), this._value.getY(), this._value.getWidth(), this._value.getHeight(), false);
            this._value = rectangle2D;
        }
    }

    private static final class BlinkEdit
    extends LooxUndoableEdit {
        public BlinkEdit(LxComponent lxComponent, boolean bl) {
            super(lxComponent, Resources.get(LxComponent.BLINK_UNDO, "blink"), bl);
        }

        void _undoEdit(boolean bl) {
            LxComponent lxComponent = (LxComponent)this._getHost();
            lxComponent._setBlinkingEnabled(bl, false);
        }
    }

    private final class BlinkAction
    extends LxAbstractToggleAction
    implements Serializable {
        BlinkAction() {
            super(LxComponent.BLINK_ACTION, "Blink", "Component does not blink", null, "Blink", "Component blinks", null, false, true);
            this.setState(LxComponent.this.isBlinkingEnabled());
        }

        public void processAction(ActionEvent actionEvent) {
            LxComponent.this.setBlinkingEnabled(!LxComponent.this.isBlinkingEnabled());
            this.setState(LxComponent.this.isBlinkingEnabled());
        }
    }

    private final class Animation
    implements Serializable {
        private LxComponent _traj = null;
        private double _step = 0.0;
        private double _inc = 0.05;
        private double _offset_x = 0.0;
        private double _offset_y = 0.0;
        private LxAncestorListener _lstnr = null;
        private AnimationListeners _lstnrs = null;

        private Animation() {
        }

        public void add(LxAnimationListener lxAnimationListener) {
            if (this._lstnrs == null) {
                this._lstnrs = new AnimationListeners();
            }
            this._lstnrs.add(lxAnimationListener);
        }

        public void doStep(double d) {
            if (this._lstnrs != null) {
                this._lstnrs.firePreAnimation(LxComponent.this);
            }
            this._step = d - (double)((int)d);
            if (this._traj == null) {
                if (this._lstnrs != null) {
                    this._lstnrs.firePostAnimation(LxComponent.this);
                }
                return;
            }
            Point2D point2D = this._traj.getTrajectoryLocation(this._step);
            point2D.setLocation(point2D.getX() + this._offset_x, point2D.getY() + this._offset_y);
            LxComponent.this.startUndoEdit("throw me away!");
            LxComponent.this.setCenter(point2D);
            LxComponent.this.cancelUndoEdit();
            if (this._lstnrs != null) {
                this._lstnrs.firePostAnimation(LxComponent.this);
            }
            int n = 0;
            LxAbstractGraph lxAbstractGraph = LxComponent.this.getGraph();
            n = 0;
            while (lxAbstractGraph != null && n < lxAbstractGraph.getViewCount()) {
                if (lxAbstractGraph.getView(n).isAnimationOptimized()) {
                    lxAbstractGraph.getView(n).paintImmediately();
                }
                ++n;
            }
        }

        public void nextStep() {
            this.doStep(this._step + this._inc);
        }

        public void remove(LxAnimationListener lxAnimationListener) {
            this._lstnrs.remove(lxAnimationListener);
            if (this._lstnrs.getSize() == 0) {
                this._lstnrs = null;
            }
        }

        public void setIncrement(double d) {
            if (this._inc == d) {
                return;
            }
            if (d < -1.0 || d > 1.0) {
                throw new IllegalArgumentException("bad trajectory increment");
            }
            this._inc = d;
        }

        public void setOffset(double d, double d2) {
            if (this._offset_x == d && this._offset_y == d2) {
                return;
            }
            this._offset_x = d;
            this._offset_y = d2;
            this.doStep(this._step);
        }

        public void setTarget(LxComponent lxComponent) {
            if (lxComponent == this._traj) {
                return;
            }
            if (this._traj != null) {
                this._traj.removeAncestorListener(this._lstnr);
                this._lstnr = null;
            }
            this._traj = lxComponent;
            if (this._traj != null) {
                this._lstnr = new LxAncestorAdapter(this){
                    private final /* synthetic */ Animation this$1;
                    {
                        this.this$1 = animation;
                    }

                    public void ancestorRemoved(LxAncestorEvent lxAncestorEvent) {
                        this.this$1.setTarget(null);
                    }
                };
                this._traj.addAncestorListener(this._lstnr);
                this.doStep(0.0);
            }
        }
    }

    private static final class AncestorListeners
    extends Listener
    implements Serializable {
        private static LxComponent _ancestor;
        private static LxContainer _ancestor_parent;
        private static final Listener.Feeder2 ADDED_LSTNR;
        private static final Listener.Feeder2 MOVED_LSTNR;
        private static final Listener.Feeder2 REMOVED_LSTNR;
        private final LxComponent _host;

        public AncestorListeners(LxComponent lxComponent) {
            this._host = lxComponent;
        }

        private LxAncestorEvent _getEvent(int n, LxComponent lxComponent, LxContainer lxContainer) {
            int n2 = 0;
            while (n2 < 6) {
                if (!_ancs_ev_used[n2]) {
                    if (ANCS_EV[n2] == null) {
                        ANCS_EV[n2] = new LxAncestorEvent(this._host, n, lxComponent, lxContainer);
                    } else {
                        ANCS_EV[n2]._reset(this._host, n, lxComponent, lxContainer);
                    }
                    _ancs_ev_used[n2] = true;
                    return ANCS_EV[n2];
                }
                ++n2;
            }
            return new LxAncestorEvent(this._host, n, lxComponent, lxContainer);
        }

        private void _releaseEvent(LxAncestorEvent lxAncestorEvent) {
            int n = 0;
            while (n < 6) {
                if (lxAncestorEvent == ANCS_EV[n]) {
                    _ancs_ev_used[n] = false;
                    lxAncestorEvent._reset(null, 0, null, null);
                    break;
                }
                ++n;
            }
        }

        public void fireAdded(LxComponent lxComponent, LxContainer lxContainer) {
            _ancestor = lxComponent;
            _ancestor_parent = lxContainer;
            this.fire(ADDED_LSTNR, this);
            _ancestor = null;
            _ancestor_parent = null;
        }

        public void fireMoved(LxComponent lxComponent, LxContainer lxContainer) {
            _ancestor = lxComponent;
            _ancestor_parent = lxContainer;
            this.fire(MOVED_LSTNR, this);
            _ancestor = null;
            _ancestor_parent = null;
        }

        public void fireRemoved(LxComponent lxComponent, LxContainer lxContainer) {
            _ancestor = lxComponent;
            _ancestor_parent = lxContainer;
            this.fire(REMOVED_LSTNR, this);
            _ancestor = null;
            _ancestor_parent = null;
        }

        static /* synthetic */ LxComponent access$900() {
            return _ancestor;
        }

        static /* synthetic */ LxContainer access$1000() {
            return _ancestor_parent;
        }

        static /* synthetic */ LxAncestorEvent access$1100(AncestorListeners ancestorListeners, int n, LxComponent lxComponent, LxContainer lxContainer) {
            return ancestorListeners._getEvent(n, lxComponent, lxContainer);
        }

        static /* synthetic */ void access$1200(AncestorListeners ancestorListeners, LxAncestorEvent lxAncestorEvent) {
            ancestorListeners._releaseEvent(lxAncestorEvent);
        }

        static {
            ADDED_LSTNR = new Listener.Feeder2(){

                public Object getEvent(Object object) {
                    AncestorListeners ancestorListeners = (AncestorListeners)object;
                    return AncestorListeners.access$1100(ancestorListeners, 1, AncestorListeners.access$900(), AncestorListeners.access$1000());
                }

                public void fire(Object object, Object object2) {
                    ((LxAncestorListener)object).ancestorAdded((LxAncestorEvent)object2);
                }

                public void releaseEvent(Object object, Object object2) {
                    AncestorListeners ancestorListeners = (AncestorListeners)object2;
                    AncestorListeners.access$1200(ancestorListeners, (LxAncestorEvent)object);
                }
            };
            MOVED_LSTNR = new Listener.Feeder2(){

                public Object getEvent(Object object) {
                    AncestorListeners ancestorListeners = (AncestorListeners)object;
                    return AncestorListeners.access$1100(ancestorListeners, 3, AncestorListeners.access$900(), AncestorListeners.access$1000());
                }

                public void fire(Object object, Object object2) {
                    ((LxAncestorListener)object).ancestorMoved((LxAncestorEvent)object2);
                }

                public void releaseEvent(Object object, Object object2) {
                    AncestorListeners ancestorListeners = (AncestorListeners)object2;
                    AncestorListeners.access$1200(ancestorListeners, (LxAncestorEvent)object);
                }
            };
            REMOVED_LSTNR = new Listener.Feeder2(){

                public Object getEvent(Object object) {
                    AncestorListeners ancestorListeners = (AncestorListeners)object;
                    return AncestorListeners.access$1100(ancestorListeners, 2, AncestorListeners.access$900(), AncestorListeners.access$1000());
                }

                public void fire(Object object, Object object2) {
                    ((LxAncestorListener)object).ancestorRemoved((LxAncestorEvent)object2);
                }

                public void releaseEvent(Object object, Object object2) {
                    AncestorListeners ancestorListeners = (AncestorListeners)object2;
                    AncestorListeners.access$1200(ancestorListeners, (LxAncestorEvent)object);
                }
            };
        }
    }

    private final class Actions
    implements Serializable {
        private Hashtable _list = null;

        private Actions() {
        }

        public LxAbstractAction get(String string, Class clazz) {
            Serializable serializable;
            if (this._list == null) {
                this._list = new Hashtable();
                LxComponent.this.addPropertyChangeListener(LOCK_LSTNR);
            } else {
                serializable = (LxAbstractAction)this._list.get(string);
                if (serializable != null) {
                    return serializable;
                }
            }
            serializable = LxComponent.getActionClass(string, clazz);
            if (serializable == null) {
                System.err.println("no registered class: " + string);
                return null;
            }
            try {
                Constructor constructor = ((Class)serializable).getDeclaredConstructor(((Class)serializable).getDeclaringClass());
                LxAbstractAction lxAbstractAction = (LxAbstractAction)constructor.newInstance(LxComponent.this);
                this._list.put(lxAbstractAction.getActionName(), lxAbstractAction);
                return lxAbstractAction;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void setActionEnabled(String string, boolean bl) {
            if (this._list == null) {
                return;
            }
            LxAbstractAction lxAbstractAction = LxComponent.this.getAction(string);
            if (lxAbstractAction != null) {
                lxAbstractAction.setEnabled(bl);
            }
        }

        public void setActionState(String string, boolean bl) {
            if (this._list == null) {
                return;
            }
            LxAbstractToggleAction lxAbstractToggleAction = (LxAbstractToggleAction)LxComponent.this.getAction(string);
            if (lxAbstractToggleAction != null) {
                lxAbstractToggleAction.setState(bl);
            }
        }

        public LxAbstractAction[] toArray(Class clazz) {
            Object object;
            while (clazz != null) {
                Object var6_5;
                try {
                    object = (Hashtable)_registry.get(clazz);
                    if (object == null) {
                        var6_5 = null;
                        clazz = clazz.getSuperclass();
                        continue;
                    }
                    Enumeration enumeration = ((Hashtable)object).keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        if (this._list != null && this._list.containsKey(string)) continue;
                        this.get(string, clazz);
                    }
                }
                catch (Throwable throwable) {
                    var6_5 = null;
                    clazz = clazz.getSuperclass();
                    throw throwable;
                }
                var6_5 = null;
                clazz = clazz.getSuperclass();
                {
                }
            }
            object = new LxAbstractAction[this._list.size()];
            return this._list.values().toArray((T[])object);
        }
    }
}

