/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;

public final class LxLayers
implements Cloneable,
Serializable {
    private static final BitSet EMPTY_BITS = new BitSet();
    private static final int HIGH_BIT = 63;
    private static final int MAX_BITS = 64;
    private HashMap _names = null;
    private BitSet _bits = null;
    private long _mask = 1L;

    public LxLayers() {
    }

    public LxLayers(boolean bl) {
        if (bl) {
            this.reset();
        }
    }

    public Object clone() {
        try {
            LxLayers lxLayers = (LxLayers)super.clone();
            lxLayers._names = null;
            lxLayers._bits = null;
            lxLayers.setLayers(this);
            return lxLayers;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LxLayers)) {
            return false;
        }
        LxLayers lxLayers = (LxLayers)object;
        int n = this.getLayerCount();
        int n2 = 0;
        while (n2 < n) {
            String string = this.getLayerName(n2);
            String string2 = lxLayers.getLayerName(n2);
            if (string != null && string2 != null && !string.equals(string2)) {
                return false;
            }
            ++n2;
        }
        return this._mask == lxLayers._mask && (this._bits == null && lxLayers._bits == null || this._bits != null && lxLayers._bits != null && this._bits.equals(lxLayers._bits));
    }

    public int hashCode() {
        if (this._bits != null) {
            return this._bits.hashCode() + (this._names != null ? this._names.hashCode() : 0);
        }
        return (int)this._mask;
    }

    public String toString() {
        if (this._bits != null) {
            return this._bits.toString();
        }
        int n = this.getLayerCount();
        StringBuffer stringBuffer = new StringBuffer(8 * n + 2);
        String string = "";
        stringBuffer.append('{');
        int n2 = 0;
        while (n2 < n) {
            if (this.getLayer(n2)) {
                stringBuffer.append(string);
                string = ", ";
                stringBuffer.append(n2);
            }
            ++n2;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private static boolean _bitOn(long l, int n) {
        return (l & 1L << n) != 0L;
    }

    private static String _getKey(int n) {
        return Integer.toString(n);
    }

    private static long _toMask(int n) {
        return 1L << n;
    }

    public void and(LxLayers lxLayers) {
        if (this._bits != null && lxLayers._bits != null) {
            this._bits.and(lxLayers._bits);
            this._contract();
        } else {
            this._mask = this._toMask() & lxLayers._toMask();
            this._bits = null;
        }
    }

    public int getFirstVisible() {
        if (this._bits != null) {
            int n = this._bits.length();
            int n2 = 0;
            while (n2 < n) {
                if (this._bits.get(n2)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
        if (this._mask == 0L) {
            return -1;
        }
        long l = this._mask;
        int n = 0;
        while ((l & 1L) == 0L) {
            ++n;
            l >>= 1;
        }
        return n;
    }

    public boolean getLayer(int n) {
        if (this._bits != null) {
            return this._bits.get(n);
        }
        if (n <= 63) {
            return (this._mask & LxLayers._toMask(n)) != 0L;
        }
        return false;
    }

    public String getLayerName(int n) {
        String string = LxLayers._getKey(n);
        String string2 = this._names != null ? this._names.get(string) : null;
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public int getLayerCount() {
        int n;
        int n2 = 0;
        int n3 = this._names != null ? this._names.size() : 0;
        while (n3 > 0) {
            if (this._names.containsKey(LxLayers._getKey(n2))) {
                --n3;
            }
            ++n2;
        }
        if (this._bits != null) {
            n = this._bits.length();
        } else {
            int n4 = 0;
            long l = this._mask;
            while (l > 0L) {
                ++n4;
                l >>= 1;
            }
            n = n4;
        }
        return Math.max(n2, n);
    }

    public boolean intersects(LxLayers lxLayers) {
        long l;
        if (lxLayers == null) {
            return false;
        }
        if (this._bits != null && lxLayers._bits != null) {
            BitSet bitSet = (BitSet)this._bits.clone();
            bitSet.and(lxLayers._bits);
            return !bitSet.equals(EMPTY_BITS);
        }
        long l2 = this._toMask();
        return (l2 & (l = lxLayers._toMask())) != 0L;
    }

    public boolean isEmpty() {
        if (this._bits != null) {
            return false;
        }
        return this._mask == 0L;
    }

    public void or(LxLayers lxLayers) {
        if (this._bits != null || lxLayers._bits != null) {
            this._expand();
            this._bits.or(lxLayers._toBitSet());
        } else {
            this._mask |= lxLayers._mask;
        }
    }

    public void reset() {
        if (this._bits != null) {
            int n = this._bits.length();
            int n2 = 0;
            while (n2 < n) {
                this._bits.clear(n2);
                ++n2;
            }
        } else {
            this._mask = 0L;
        }
    }

    public void setLayer(int n, boolean bl) {
        if (this.getLayer(n) == bl) {
            return;
        }
        if (this._bits == null && n > 63 && bl) {
            this._expand();
        }
        if (this._bits != null) {
            if (bl) {
                this._bits.set(n);
            } else {
                this._bits.clear(n);
                this._contract();
            }
        } else {
            this._mask = bl ? (this._mask |= LxLayers._toMask(n)) : (this._mask &= Long.MAX_VALUE - LxLayers._toMask(n));
        }
    }

    public void setLayerName(int n, String string) {
        if (this._names == null) {
            this._names = new HashMap();
        }
        String string2 = LxLayers._getKey(n);
        if (string != null && !string.equals(string2)) {
            this._names.put(string2, string);
        } else {
            this._names.remove(string2);
            if (this._names.size() == 0) {
                this._names = null;
            }
        }
    }

    public void setLayers(LxLayers lxLayers) {
        if (this._names == null && lxLayers._names != null) {
            this._names = new HashMap();
        } else if (this._names != null && lxLayers._names == null) {
            this._names.clear();
            this._names = null;
        }
        if (this._names != null && lxLayers._names != null && !this._names.equals(lxLayers._names)) {
            this._names.clear();
            this._names.putAll(lxLayers._names);
        }
        if (this.equals(lxLayers)) {
            return;
        }
        if (lxLayers._bits != null) {
            this._mask = 0L;
            this._bits = (BitSet)lxLayers._bits.clone();
        } else {
            this._mask = lxLayers._mask;
            this._bits = null;
        }
    }

    public void xor(LxLayers lxLayers) {
        if (lxLayers._bits != null) {
            this._expand();
        }
        if (this._bits != null) {
            this._bits.xor(lxLayers._toBitSet());
            this._contract();
        } else {
            long l = lxLayers._toMask();
            this._mask = (this._mask | l) - (this._mask & l);
        }
    }

    private void _contract() {
        if (this._bits != null && this._bits.length() <= 64) {
            this._mask = this._toMask();
            this._bits = null;
        }
    }

    private void _expand() {
        if (this._bits == null) {
            this._bits = this._toBitSet();
            this._mask = 0L;
        }
    }

    private BitSet _toBitSet() {
        BitSet bitSet = this._bits;
        if (bitSet == null) {
            bitSet = new BitSet();
            int n = 0;
            while (n < 64) {
                if (LxLayers._bitOn(this._mask, n)) {
                    bitSet.set(n);
                }
                ++n;
            }
        }
        return bitSet;
    }

    private long _toMask() {
        if (this._bits == null) {
            return this._mask;
        }
        int n = Math.min(this.getLayerCount(), 64);
        long l = 0L;
        int n2 = n;
        while (n2 >= 0) {
            l <<= 1;
            l += this.getLayer(n2) ? 1L : 0L;
            --n2;
        }
        return l;
    }
}

